/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.taglibsig;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.taglibsig.AttributeEntry;
import com.sun.ts.tests.common.taglibsig.BuildException;
import com.sun.ts.tests.common.taglibsig.FunctionEntry;
import com.sun.ts.tests.common.taglibsig.TagEntry;
import com.sun.ts.tests.common.taglibsig.ValidatorEntry;
import com.sun.ts.tests.common.taglibsig.VariableEntry;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TagLibraryDescriptor {
    private static final String ONE_DOT_TWO_CONTAINER = "1.2";
    private static final String TWO_DOT_ZERO_CONTAINER = "2.0";
    private static final String DEFAULT_TAGLIB_VERSION = "1.0";
    private static final HashMap TAGLIB_CACHE = new HashMap();
    private static final TagEntry[] EMPTY_TAG_ENTRIES = new TagEntry[0];
    private static final FunctionEntry[] EMPTY_FUNCTION_ENTRIES = new FunctionEntry[0];
    private static final ValidatorEntry[] EMPTY_VALIDATOR_ENTRIES = new ValidatorEntry[0];
    private String _containerVersion = "1.2";
    private String _taglibVersion = "1.0";
    private String _uri;
    private List _tagEntries;
    private List _functionEntries;
    private List _validatorEntries;

    private TagLibraryDescriptor() {
    }

    public static TagLibraryDescriptor getInstance(String jarUrl, String taglibUri) {
        TagLibraryDescriptor tld = (TagLibraryDescriptor)TAGLIB_CACHE.get(taglibUri);
        if (tld == null) {
            URL url = null;
            jarUrl = "jar:" + (String)jarUrl + "!/";
            try {
                url = new URL((String)jarUrl);
            }
            catch (MalformedURLException e) {
                TestUtil.logErr("Malformed URL: " + (String)jarUrl, e);
            }
            TestUtil.logTrace("<<<<<<BUILDING CACHE>>>>>>");
            try {
                TldBuilder builder = new TldBuilder(new TldLocator(url));
                builder.build();
            }
            catch (BuildException be) {
                TestUtil.logErr(be.getMessage(), be);
            }
            tld = (TagLibraryDescriptor)TAGLIB_CACHE.get(taglibUri);
        }
        return tld;
    }

    public TagEntry[] getTagEntries() {
        if (this._tagEntries == null || this._tagEntries.isEmpty()) {
            return EMPTY_TAG_ENTRIES;
        }
        return this._tagEntries.toArray(new TagEntry[this._tagEntries.size()]);
    }

    public FunctionEntry[] getFunctionEntries() {
        if (this._functionEntries == null || this._functionEntries.isEmpty()) {
            return EMPTY_FUNCTION_ENTRIES;
        }
        return this._functionEntries.toArray(new FunctionEntry[this._functionEntries.size()]);
    }

    public ValidatorEntry[] getValidatorEntries() {
        if (this._validatorEntries == null || this._validatorEntries.isEmpty()) {
            return EMPTY_VALIDATOR_ENTRIES;
        }
        return this._validatorEntries.toArray(new ValidatorEntry[this._validatorEntries.size()]);
    }

    public String getRequiredContainerVersion() {
        return this._containerVersion;
    }

    public String getTaglibraryVersion() {
        return this._taglibVersion;
    }

    public String getURI() {
        return this._uri;
    }

    private void addTagEntry(TagEntry entry) {
        if (this._tagEntries == null) {
            this._tagEntries = new ArrayList();
        }
        this._tagEntries.add(entry);
    }

    private void addFunctionEntry(FunctionEntry entry) {
        if (this._functionEntries == null) {
            this._functionEntries = new ArrayList();
        }
        this._functionEntries.add(entry);
    }

    private void addValidatorEntry(ValidatorEntry entry) {
        if (this._validatorEntries == null) {
            this._validatorEntries = new ArrayList();
        }
        this._validatorEntries.add(entry);
    }

    private void setRequiredContainerVersion(String version) {
        this._containerVersion = version;
    }

    private void setTaglibraryVersion(String version) {
        this._taglibVersion = version;
    }

    private void setURI(String uri) {
        this._uri = uri;
    }

    private static class TldBuilder {
        private static final String TLIB_VERSION_ELEMENT = "tlib-version";
        private static final String JSP_VERSION_ELEMENT = "jsp-version";
        private static final String VALIDATOR_ELEMENT = "validator";
        private static final String FUNCTION_ELEMENT = "function";
        private static final String TAG_ELEMENT = "tag";
        private static final String NAME_ELEMENT = "name";
        private static final String ATTRIBUTE_ELEMENT = "attribute";
        private static final String TYPE_ELEMENT = "type";
        private static final String VARIABLE_ELEMENT = "variable";
        private static final String BODY_ELEMENT = "body-content";
        private static final String URI_ELEMENT = "uri";
        private static final String RTEXPR_ELEMENT = "rtexprvalue";
        private static final String REQUIRED_ELEMENT = "required";
        private static final String NAME_GIVEN_ELEMENT = "name-given";
        private static final String SCOPE_ELEMENT = "scope";
        private static final String DECLARE_ELEMENT = "declare";
        private static final String VARIABLE_CLASS_ELEMENT = "variable-class";
        private static final String FUNCTION_SIGNATURE_ELEMENT = "function-signature";
        TldLocator _locator;

        public TldBuilder(TldLocator locator) {
            this._locator = locator;
        }

        public void build() throws BuildException {
            try {
                this.processTlds(this._locator.getTldsAsStreams());
            }
            catch (Throwable t) {
                throw new BuildException("Unexpected Exception building TLDs: " + t.toString());
            }
        }

        private DocumentBuilder getDocumentBuilder() {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                TestUtil.logErr(e.getMessage(), e);
            }
            return builder;
        }

        private void processDocument(Document doc) {
            TagLibraryDescriptor tld = new TagLibraryDescriptor();
            Element taglib = doc.getDocumentElement();
            this.processTopLevelElements(taglib, tld);
            this.processTagEntries(taglib.getElementsByTagName(TAG_ELEMENT), tld);
            this.processFunctionEntries(taglib.getElementsByTagName(FUNCTION_ELEMENT), tld);
        }

        private void processTopLevelElements(Element taglib, TagLibraryDescriptor des) {
            des.setTaglibraryVersion(this.getNodeText(taglib, TLIB_VERSION_ELEMENT));
            des.setRequiredContainerVersion(this.getNodeText(taglib, JSP_VERSION_ELEMENT));
            String uri = this.getNodeText(taglib, URI_ELEMENT);
            des.setURI(uri);
            this.addCacheEntry(uri, des);
        }

        private void processFunctionEntries(NodeList functionNodes, TagLibraryDescriptor des) {
            int size = functionNodes.getLength();
            for (int i = 0; i < size; ++i) {
                Element functionElement = (Element)functionNodes.item(i);
                FunctionEntry funcEntry = new FunctionEntry();
                funcEntry.setName(this.getNodeText(functionElement, NAME_ELEMENT));
                funcEntry.setFunctionSignature(this.getNodeText(functionElement, FUNCTION_SIGNATURE_ELEMENT));
            }
        }

        private void processTagEntries(NodeList tagNodes, TagLibraryDescriptor des) {
            int size = tagNodes.getLength();
            for (int i = 0; i < size; ++i) {
                Element tagElement = (Element)tagNodes.item(i);
                TagEntry tagEntry = new TagEntry();
                tagEntry.setName(this.getNodeText(tagElement, NAME_ELEMENT));
                tagEntry.setBody(this.getNodeText(tagElement, BODY_ELEMENT));
                this.processTagAttributes(tagElement.getElementsByTagName(ATTRIBUTE_ELEMENT), tagEntry);
                this.processTagVariables(tagElement.getElementsByTagName(VARIABLE_ELEMENT), tagEntry);
                des.addTagEntry(tagEntry);
            }
        }

        private void processTagAttributes(NodeList attrNodes, TagEntry tag) {
            int size = attrNodes.getLength();
            for (int i = 0; i < size; ++i) {
                Element attrElement = (Element)attrNodes.item(i);
                AttributeEntry attrEntry = new AttributeEntry();
                attrEntry.setName(this.getNodeText(attrElement, NAME_ELEMENT));
                attrEntry.setType(this.getNodeText(attrElement, TYPE_ELEMENT));
                attrEntry.setRtexpr(this.getNodeText(attrElement, RTEXPR_ELEMENT));
                attrEntry.setRequired(this.getNodeText(attrElement, REQUIRED_ELEMENT));
                tag.addAttribute(attrEntry);
            }
        }

        private void processTagVariables(NodeList varNodes, TagEntry tag) {
            int size = varNodes.getLength();
            for (int i = 0; i < size; ++i) {
                Element varElement = (Element)varNodes.item(i);
                VariableEntry varEntry = new VariableEntry();
                varEntry.setNameGiven(this.getNodeText(varElement, NAME_GIVEN_ELEMENT));
                varEntry.setVariableClass(this.getNodeText(varElement, VARIABLE_CLASS_ELEMENT));
                varEntry.setScope(this.getNodeText(varElement, SCOPE_ELEMENT));
                varEntry.setDeclare(this.getNodeText(varElement, DECLARE_ELEMENT));
                tag.addVariable(varEntry);
            }
        }

        private String getNodeText(Element parent, String nodeName) {
            String nodeText = null;
            NodeList list = parent.getElementsByTagName(nodeName);
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = list.item(0).getFirstChild();
                if (node.getNodeType() != 3) continue;
                nodeText = node.getNodeValue();
                break;
            }
            return nodeText;
        }

        private void addCacheEntry(String key, Object value) {
            TAGLIB_CACHE.put(key, value);
        }

        private void processTlds(InputStream[] inStreams) throws SAXException, IOException {
            DocumentBuilder builder = this.getDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new CharArrayReader(new char[0]));
                }
            });
            for (int i = 0; i < inStreams.length; ++i) {
                Document doc = builder.parse(inStreams[i]);
                this.processDocument(doc);
            }
        }
    }

    private static class TldLocator {
        private static final String META_INF = "META-INF/";
        private static final String TLD_EXTENSION = ".tld";
        private URL _url;

        public TldLocator(URL url) {
            this._url = url;
        }

        public InputStream[] getTldsAsStreams() throws IOException {
            JarURLConnection jarCon = (JarURLConnection)this._url.openConnection();
            JarFile jar = jarCon.getJarFile();
            ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (!name.startsWith(META_INF) || !name.endsWith(TLD_EXTENSION)) continue;
                inputStreams.add(jar.getInputStream(entry));
            }
            return inputStreams.toArray(new InputStream[inputStreams.size()]);
        }
    }
}

