/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.entitylistener;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.entitylistener.NoEntityListener;
import ee.jakarta.tck.persistence.core.override.entitylistener.NoListener;
import ee.jakarta.tck.persistence.core.override.entitylistener.OverridenListener;
import ee.jakarta.tck.persistence.core.override.util.CallBackCounts;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final Long ID = 1L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void testOverrideEntityListener() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CallBackCounts.clearCountsMap();
        OverridenListener entity = new OverridenListener();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        this.getEntityManager().flush();
        this.logTrace("persisted entity" + entity);
        this.getEntityManager().remove((Object)entity);
        this.getEntityManager().flush();
        this.logTrace("Removed entity" + entity);
        this.getEntityTransaction().commit();
        try {
            pass1 = this.checkPersistCallBacks();
            pass2 = this.checkRemoveCallBacks();
            if (pass1 && pass2) {
                this.logTrace("testOverrideEntityListener Passed");
            } else {
                if (pass1) {
                    throw new Exception("Test failed while testing preremove and postremove methods in testOverrideEntityListener ");
                }
                if (pass2) {
                    throw new Exception("Test failed while testing prepersist and postpersist methods in testOverrideEntityListener ");
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Exception thrown while testing testOverrideEntityListener" + e);
        }
    }

    public void testEntityListenerXML() throws Exception {
        block6: {
            boolean pass = false;
            CallBackCounts.clearCountsMap();
            NoEntityListener entity = new NoEntityListener();
            entity.setId(ID);
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)entity);
            this.getEntityManager().flush();
            this.logTrace("persisted entity" + entity);
            try {
                pass = this.checkPersistCallBacks();
                if (pass) {
                    this.logTrace("Test Passed");
                    break block6;
                }
                throw new Exception("TestEntityListenerXML method failed");
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testEntityListenerXML" + e);
            }
            finally {
                this.getEntityManager().remove((Object)entity);
                this.getEntityTransaction().commit();
            }
        }
    }

    public void testNoEntityListener() throws Exception {
        block6: {
            boolean pass = false;
            CallBackCounts.clearCountsMap();
            NoListener entity = new NoListener();
            entity.setId(ID);
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)entity);
            this.getEntityManager().flush();
            this.logTrace("persisted entity" + entity);
            try {
                pass = this.checkPersistCallBacks();
                if (pass) {
                    this.logTrace("Test Passed");
                    break block6;
                }
                throw new Exception("TestNoEntityListener method failed");
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testNoEntityListener" + e);
            }
            finally {
                this.getEntityManager().remove((Object)entity);
                this.getEntityTransaction().commit();
            }
        }
    }

    private boolean checkPersistCallBacks() throws Exception {
        boolean result = false;
        if (this.test("prePersist", 1) && this.test("postPersist", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkRemoveCallBacks() throws Exception {
        boolean result = false;
        if (this.test("preRemove", 1) && this.test("preRemove", 1)) {
            result = true;
        }
        return result;
    }

    private boolean test(String callBackName, int expectedCount) throws Exception {
        int count = CallBackCounts.getCount(callBackName);
        boolean result = false;
        if (count == expectedCount) {
            this.logTrace("test passed" + callBackName);
            result = true;
        } else {
            this.logErr("test failed" + callBackName);
        }
        return result;
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYLISTENER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

