/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.managedtype;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.A;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.B;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Project;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Department;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Order;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMPerson;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.ZipCode;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void managedtype() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    pass = true;
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("managedtype failed");
        }
    }

    public void getAttributes() throws Exception {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("total");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    Set attribSet = mTypeOrder.getAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            this.logErr("Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            this.logTrace("attribute Name = " + attrib.getName());
                            if (expected.contains(attrib.getName())) {
                                this.logTrace("Received expected:" + attrib.getName());
                                continue;
                            }
                            this.logErr("Received unexpected result" + attrib.getName());
                            pass = false;
                        }
                    } else {
                        pass = false;
                        this.logErr("getAttributes() returned null");
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getAttributes failed");
        }
    }

    public void getDeclaredAttributes() throws Exception {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("total");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    Set attribSet = mTypeOrder.getDeclaredAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            this.logErr("Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            this.logTrace("attribute Name = " + attrib.getName());
                            if (expected.contains(attrib.getName())) {
                                this.logTrace("Received expected:" + attrib.getName());
                                continue;
                            }
                            this.logErr("Received unexpected result" + attrib.getName());
                            pass = false;
                        }
                    } else {
                        pass = false;
                        this.logErr("getAttributes() returned null");
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredAttributes failed");
        }
    }

    public void getSingularAttributeStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    SingularAttribute singAttrib = mTypeB.getSingularAttribute("address", Address.class);
                    Class addrClass = singAttrib.getType().getJavaType();
                    if (addrClass.getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                        this.logTrace("address class getName =" + addrClass.getName());
                        pass = true;
                    } else {
                        this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + addrClass.getName());
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getSingularAttributeStringClassTest failed");
        }
    }

    public void getSingularAttributeStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mTypeB.getSingularAttribute("doesnotexist", Address.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                    this.logMsg("Testing invalid type");
                    try {
                        mTypeB.getSingularAttribute("addreess", ZipCode.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getSingularAttributeStringClassIllegalArgumentExceptionTest failed");
        }
    }

    public void getSingularAttributeStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    SingularAttribute singAttrib = mTypeB.getSingularAttribute("address");
                    this.logTrace("singAttrib Type = " + singAttrib.getType());
                    this.logTrace("singAttrib Java Type = " + singAttrib.getJavaType());
                    if (singAttrib.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                        pass = true;
                    } else {
                        this.logErr("Expected: address, actual:" + singAttrib.getJavaType().getName());
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getSingularAttributeStringTest failed");
        }
    }

    public void getSingularAttributeStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mTypeB.getSingularAttribute("doesnotexist");
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getSingularAttributeStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getDeclaredSingularAttributeStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                    Class addrClass = singAttrib.getType().getJavaType();
                    if (addrClass.getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                        this.logTrace("address class getName =" + addrClass.getName());
                        pass = true;
                    } else {
                        this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + addrClass.getName());
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringClassTest failed");
        }
    }

    public void getDeclaredSingularAttributeStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mTypeB.getDeclaredSingularAttribute("doesnotexist", Address.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                    this.logMsg("Testing invalid type");
                    try {
                        mTypeB.getDeclaredSingularAttribute("address", ZipCode.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringClassIllegalArgumentExceptionTest failed");
        }
    }

    public void getDeclaredSingularAttributeStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address");
                    this.logTrace("singAttrib Type = " + singAttrib.getType());
                    this.logTrace("singAttrib Java Type = " + singAttrib.getJavaType());
                    if (singAttrib.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                        pass = true;
                    } else {
                        this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + singAttrib.getJavaType().getName());
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringTest failed");
        }
    }

    public void getDeclaredSingularAttributeStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    try {
                        mTypeB.getDeclaredSingularAttribute("doesnotexist");
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getDeclaredSingularAttributes() throws Exception {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("address");
        expected.add("name");
        expected.add("value");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    Set attribSet = mTypeB.getDeclaredSingularAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            this.logErr("Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            this.logTrace("attribute Name = " + attrib.getName());
                            if (expected.contains(attrib.getName())) {
                                this.logTrace("Received expected:" + attrib.getName());
                                continue;
                            }
                            this.logErr("Received unexpected result" + attrib.getName());
                            pass = false;
                        }
                    } else {
                        pass = false;
                        this.logErr("getDeclaredSingularAttributes() returned null");
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributes failed");
        }
    }

    public void getSingularAttributes() throws Exception {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("address");
        expected.add("name");
        expected.add("value");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    Set attribSet = mTypeB.getSingularAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            this.logErr("Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            this.logTrace("attribute Name = " + attrib.getName());
                            if (expected.contains(attrib.getName())) {
                                this.logTrace("Received expected:" + attrib.getName());
                                continue;
                            }
                            this.logErr("Received unexpected result" + attrib.getName());
                            pass = false;
                        }
                    } else {
                        pass = false;
                        this.logErr("getSingularAttributes() returned null");
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getSingularAttributes failed");
        }
    }

    public void getCollectionStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    CollectionAttribute colAttrib = mType.getCollection("projects");
                    Type t = colAttrib.getElementType();
                    if (t != null) {
                        this.logTrace("element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject")) {
                            this.logTrace("Received expected ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject");
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getCollectionStringTest failed");
        }
    }

    public void getCollectionStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getCollection("doesnotexist");
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getCollectionStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getCollectionStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    CollectionAttribute colAttrib = mType.getCollection("projects", Uni1XMProject.class);
                    Type t = colAttrib.getElementType();
                    if (t != null) {
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject")) {
                            this.logTrace("Received expected ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject");
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getCollectionStringClassTest failed");
        }
    }

    public void getCollectionStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getCollection("doesnotexist", Uni1XMProject.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                    this.logMsg("Testing invalid type");
                    try {
                        mType.getCollection("projects", ZipCode.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getCollectionStringClassIllegalArgumentExceptionTest failed");
        }
    }

    public void getSetStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    SetAttribute setAttrib = mType.getSet("address", Address.class);
                    Type t = setAttrib.getElementType();
                    if (t != null) {
                        this.logTrace("element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getSetStringClassTest failed");
        }
    }

    public void getSetStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getSet("doesnotexist", Address.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                    this.logMsg("Testing invalid type");
                    try {
                        mType.getCollection("address", ZipCode.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getSetStringClassIllegalArgumentExceptionTest failed");
        }
    }

    public void getSetStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    SetAttribute setAttrib = mType.getSet("address");
                    Type t = setAttrib.getElementType();
                    this.logTrace("element Type  = " + setAttrib.getElementType());
                    if (t != null) {
                        this.logTrace("java Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getSetStringTest failed");
        }
    }

    public void getSetStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getSet("doesnotexist");
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getSetStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getListStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    ListAttribute listAttrib = mType.getList("biDirMX1Persons", BiDirMX1Person.class);
                    Type t = listAttrib.getElementType();
                    if (t != null) {
                        this.logTrace("element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getListStringClassTest failed");
        }
    }

    public void getListStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getList("doesnotexist", BiDirMX1Person.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                    this.logMsg("Testing invalid type");
                    try {
                        mType.getCollection("biDirMX1Persons", ZipCode.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getListStringClassIllegalArgumentExceptionTest failed");
        }
    }

    public void getListStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    ListAttribute listAttrib = mType.getList("biDirMX1Persons");
                    Type t = listAttrib.getElementType();
                    if (t != null) {
                        this.logTrace("element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getListStringTest failed");
        }
    }

    public void getListStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getList("doesnotexist");
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getListStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getMapStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    MapAttribute mapAttrib = mType.getMap("lastNameEmployees", String.class, Employee.class);
                    Type t = mapAttrib.getElementType();
                    if (t != null) {
                        this.logTrace("element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getMapStringClassTest failed");
        }
    }

    public void getMapStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getMap("doesnotexist", String.class, Employee.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                    this.logMsg("Testing invalid type");
                    try {
                        mType.getMap("lastNameEmployees", String.class, Client.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getMapStringClassIllegalArgumentExceptionTest failed");
        }
    }

    public void getMapStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    MapAttribute mapAttrib = mType.getMap("lastNameEmployees");
                    Type t = mapAttrib.getElementType();
                    if (t != null) {
                        this.logTrace("element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getMapStringTest failed");
        }
    }

    public void getMapStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getMap("doesnotexist");
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getMapStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getDeclaredCollectionStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    CollectionAttribute colAttrib = mType.getDeclaredCollection("projects", Uni1XMProject.class);
                    Type t = colAttrib.getElementType();
                    if (t != null) {
                        String type = t.getJavaType().getName();
                        this.logTrace("element Type  = " + type);
                        if (type.equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject, actual:" + type);
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringClassTest failed");
        }
    }

    public void getDeclaredCollectionStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getDeclaredCollection("doesnotexist", Uni1XMProject.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                    this.logMsg("Testing invalid type");
                    try {
                        mType.getCollection("projects", ZipCode.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringClassIllegalArgumentExceptionTest failed");
        }
    }

    public void getDeclaredCollectionStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    CollectionAttribute colAttrib = mType.getDeclaredCollection("projects");
                    Type t = colAttrib.getElementType();
                    if (t != null) {
                        String type = t.getJavaType().getName();
                        this.logTrace("element Type  = " + type);
                        if (type.equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject, actual:" + type);
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringTest failed");
        }
    }

    public void getDeclaredCollectionStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getDeclaredCollection("doesnotexist");
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getDeclaredSetStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    SetAttribute setAttrib = mType.getDeclaredSet("address", Address.class);
                    Type t = setAttrib.getElementType();
                    if (t != null) {
                        this.logTrace("element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSetStringClassTest failed");
        }
    }

    public void getDeclaredSetStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getDeclaredSet("doesnotexist", Address.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                    this.logMsg("Testing invalid type");
                    try {
                        mType.getCollection("address", ZipCode.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredSetStringClassIllegalArgumentExceptionTest failed");
        }
    }

    public void getDeclaredSetStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    SetAttribute setAttrib = mType.getDeclaredSet("address");
                    this.logTrace("element Type  = " + setAttrib.getElementType());
                    Type t = setAttrib.getElementType();
                    if (t != null) {
                        this.logTrace("element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSetStringTest failed");
        }
    }

    public void getDeclaredSetStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getDeclaredSet("doesnotexist");
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSetStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getDeclaredListStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    ListAttribute listAttrib = mType.getDeclaredList("biDirMX1Persons", BiDirMX1Person.class);
                    Type t = listAttrib.getElementType();
                    if (t != null) {
                        this.logTrace("element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredListStringClassTest failed");
        }
    }

    public void getDeclaredListStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getDeclaredList("doesnotexist", BiDirMX1Person.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                    this.logMsg("Testing invalid type");
                    try {
                        mType.getCollection("biDirMX1Persons", ZipCode.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredListStringClassIllegalArgumentExceptionTest failed");
        }
    }

    public void getDeclaredListStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    ListAttribute listAttrib = mType.getDeclaredList("biDirMX1Persons");
                    Type t = listAttrib.getElementType();
                    if (t != null) {
                        this.logTrace("element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredListStringTest failed");
        }
    }

    public void getDeclaredListStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getDeclaredList("doesnotexist");
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredListStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getDeclaredMapStringClassClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    MapAttribute mapAttrib = mType.getDeclaredMap("lastNameEmployees", String.class, Employee.class);
                    Type t = mapAttrib.getElementType();
                    if (t != null) {
                        this.logTrace("element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredMapStringClassClassTest failed");
        }
    }

    public void getDeclaredMapStringClassClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getDeclaredMap("doesnotexist", String.class, Employee.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                    this.logMsg("Testing invalid type");
                    try {
                        mType.getDeclaredMap("lastNameEmployees", String.class, Client.class);
                        pass = false;
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredMapStringClassClassIllegalArgumentExceptionTest failed");
        }
    }

    public void getDeclaredMapStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    MapAttribute mapAttrib = mType.getDeclaredMap("lastNameEmployees");
                    Type t = mapAttrib.getElementType();
                    if (t != null) {
                        this.logTrace("element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        this.logErr("getElementType() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredMapStringTest failed");
        }
    }

    public void getDeclaredMapStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    this.logMsg("Testing invalid name");
                    try {
                        mType.getDeclaredMap("doesnotexist");
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredMapStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getPluralAttributes() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    Set pluralAttribSet = mType.getPluralAttributes();
                    if (pluralAttribSet != null) {
                        if (pluralAttribSet.size() != 1) {
                            pass = false;
                            this.logErr("Expected size:1, actual:" + pluralAttribSet.size());
                        }
                        for (Attribute attrib : pluralAttribSet) {
                            if (attrib.getName().equals("projects")) {
                                this.logTrace("attribute Name = " + attrib.getName());
                                continue;
                            }
                            pass = false;
                            this.logErr("Expected: projects, actual:" + attrib.getName());
                        }
                    } else {
                        pass = false;
                        this.logErr("getPluralAttributes() returned null");
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getPluralAttributes failed");
        }
    }

    public void getDeclaredPluralAttributes() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    Set pluralAttribSet = mType.getDeclaredPluralAttributes();
                    if (pluralAttribSet != null) {
                        if (pluralAttribSet.size() != 1) {
                            pass = false;
                            this.logErr("Expected size:1, actual:" + pluralAttribSet.size());
                        }
                        for (Attribute attrib : pluralAttribSet) {
                            if (attrib.getName().equals("projects")) {
                                this.logTrace("attribute Name = " + attrib.getName());
                                continue;
                            }
                            pass = false;
                            this.logErr("Expected: projects, actual:" + attrib.getName());
                        }
                    } else {
                        pass = false;
                        this.logErr("getPluralAttributes() returned null");
                    }
                } else {
                    pass = false;
                    this.logErr("managedType() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredPluralAttributes failed");
        }
    }

    public void getAttribute() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    Attribute attrib = mTypeOrder.getAttribute("total");
                    if (attrib != null) {
                        this.logTrace("attribute Name = " + attrib.getName());
                        this.logTrace("attribute Java Type =" + attrib.getJavaType());
                        String name = attrib.getName();
                        String type = attrib.getJavaType().getSimpleName();
                        if (name.equals("total") && type.equals("int")) {
                            pass = true;
                        } else {
                            this.logErr("Did not get either:");
                            this.logErr("Expected name:total, actual:" + name);
                            this.logErr("Expected type:int, actual:" + type);
                        }
                    } else {
                        this.logErr("getAttribute return null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getAttribute failed");
        }
    }

    public void getAttributeIllegalArgumentException() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    try {
                        mTypeOrder.getAttribute("doesnotexist");
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getAttributeIllegalArgumentException failed");
        }
    }

    public void getDeclaredAttribute() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                    if (attrib != null) {
                        String name = attrib.getName();
                        String type = attrib.getJavaType().getSimpleName();
                        this.logTrace("attribute Name = " + name);
                        this.logTrace("attribute Java Type =" + type);
                        if (name.equals("total") && type.equals("int")) {
                            pass = true;
                        } else {
                            this.logErr("Expected: total/int, actual:" + name + "/" + type);
                        }
                    } else {
                        this.logErr("getDeclaredAttribute() returned null");
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredAttribute failed");
        }
    }

    public void getDeclaredAttributeIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    this.logTrace("Obtained Non-null ManagedType");
                    try {
                        mTypeOrder.getDeclaredAttribute("doesnotexist");
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("managedType() returned null");
                }
            } else {
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("getDeclaredAttributeIllegalArgumentExceptionTest failed");
        }
    }

    public void getPersistenceType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                Type.PersistenceType type = mTypeOrder.getPersistenceType();
                this.logTrace("Obtained Non-null ManagedType");
                if (type.equals((Object)Type.PersistenceType.ENTITY)) {
                    pass = true;
                } else {
                    this.logTrace("Persistence type = " + type.name());
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPersistenceType Test  failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

