/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.parameter;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.criteriaapi.parameter.Employee;
import java.sql.Date;
import java.util.Properties;

public abstract class Client
extends PMClientBase {
    Employee[] empRef = new Employee[5];
    final Date d1 = this.getSQLDate("2000-02-14");

    public void cleanup() throws Exception {
        this.logTrace("calling super.cleanup");
        this.removeTestData();
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTestData() {
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Creating Employees");
            Date d2 = this.getSQLDate("2001-06-27");
            Date d3 = this.getSQLDate("2002-07-07");
            Date d4 = this.getSQLDate("2003-03-03");
            Date d5 = this.getSQLDate();
            this.empRef[0] = new Employee(1, "Alan", "Frechette", this.d1, 35000.0f);
            this.empRef[1] = new Employee(2, "Arthur", "Frechette", d2, 35000.0f);
            this.empRef[2] = new Employee(3, "Shelly", "McGowan", d3, 50000.0f);
            this.empRef[3] = new Employee(4, "Robert", "Bissett", d4, 55000.0f);
            this.empRef[4] = new Employee(5, "Stephen", "DMilla", d5, 25000.0f);
            for (Employee e : this.empRef) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                this.logTrace("persisted employee:" + String.valueOf(e));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
    }

    public void setupEmployee(String[] args, Properties p) throws Exception {
        this.logTrace("setupEmployee");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("setupEmployee failed:", e);
        }
    }

    protected void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

