/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.ejb;

import jakarta.decorator.Decorator;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.ejb.Delta;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.ejb.VerifyingExtension;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.Alpha;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.Bravo;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.BravoDecorator;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.BravoInterceptor;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.BravoInterface;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.BravoProducer;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.BravoQualifier;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.CharlieInterface;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.CharlieProducer;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
@SpecVersion(spec="cdi", version="2.0")
public class VerifyValuesTest
extends AbstractTest {
    @Inject
    private VerifyingExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(VerifyValuesTest.class)).withClasses(new Class[]{Alpha.class, Bravo.class, BravoDecorator.class, BravoInterceptor.class, BravoInterface.class, BravoProducer.class, BravoQualifier.class, CharlieInterface.class, CharlieProducer.class})).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL).alternatives(new Class[]{Alpha.class, BravoProducer.class, CharlieProducer.class}).interceptors(new Class[]{BravoInterceptor.class}).decorators(new Class[]{BravoDecorator.class}))).withExtension(VerifyingExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes_ee", id="bab")})
    public void testSessionBeanAnnotated() {
        Annotated deltaAnnotated = this.extension.getAnnotatedMap().get(Delta.class);
        Assert.assertNotNull((Object)deltaAnnotated);
        Assert.assertTrue((boolean)(deltaAnnotated instanceof AnnotatedType));
        AnnotatedType deltaAnnotatedType = (AnnotatedType)deltaAnnotated;
        Assert.assertEquals((Object)deltaAnnotatedType.getJavaClass(), Delta.class);
        Assert.assertEquals((int)deltaAnnotatedType.getMethods().size(), (int)1);
        Assert.assertEquals((String)((AnnotatedMethod)deltaAnnotatedType.getMethods().iterator().next()).getJavaMember().getName(), (String)"foo");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="aa"), @SpecAssertion(section="process_bean_attributes_ee", id="bab"), @SpecAssertion(section="process_bean_attributes", id="bb")})
    public void testSessionBeanAttributes() {
        BeanAttributes<Delta> deltaAttributes = this.extension.getDeltaAttributes();
        Assert.assertNotNull(deltaAttributes);
        Assert.assertEquals((Object)deltaAttributes.getScope(), Dependent.class);
        this.verifyName(deltaAttributes, "delta");
        Assert.assertFalse((boolean)deltaAttributes.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(deltaAttributes.getTypes(), new Type[]{Object.class, Delta.class}));
        Assert.assertTrue((boolean)deltaAttributes.getStereotypes().isEmpty());
        Assert.assertTrue((boolean)this.annotationSetMatches(deltaAttributes.getQualifiers(), new Class[]{Named.class, Any.class, Default.class}));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="bac")})
    public void testProducerMethodAnnotated() {
        Annotated bravoAnnotated = this.extension.getAnnotatedMap().get(Bravo.class);
        Assert.assertNotNull((Object)bravoAnnotated);
        Assert.assertTrue((boolean)(bravoAnnotated instanceof AnnotatedMethod));
        AnnotatedMethod bravoAnnotatedMethod = (AnnotatedMethod)bravoAnnotated;
        Assert.assertEquals((String)bravoAnnotatedMethod.getJavaMember().getName(), (String)"createBravo");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="ab"), @SpecAssertion(section="process_bean_attributes", id="bb")})
    public void testInterceptorBeanAttributes() {
        BeanAttributes<BravoInterceptor> attributes = this.extension.getBravoInterceptorAttributes();
        Assert.assertNotNull(attributes);
        Assert.assertEquals(Dependent.class, (Object)attributes.getScope());
        Assert.assertFalse((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Object.class, BravoInterceptor.class}));
        Assert.assertTrue((boolean)attributes.getStereotypes().isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="ac"), @SpecAssertion(section="process_bean_attributes", id="bb")})
    public void testDecoratorBeanAttributes() {
        BeanAttributes<BravoDecorator> attributes = this.extension.getBravoDecoratorAttributes();
        Assert.assertNotNull(attributes);
        Assert.assertEquals(Dependent.class, (Object)attributes.getScope());
        Assert.assertFalse((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Object.class, BravoDecorator.class, BravoInterface.class}));
        Assert.assertTrue((attributes.getStereotypes().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Class)attributes.getStereotypes().iterator().next()).equals(Decorator.class));
    }

    private void verifyName(BeanAttributes<?> attributes, String name) {
        Assert.assertEquals((String)name, (String)attributes.getName());
        for (Annotation qualifier : attributes.getQualifiers()) {
            if (!Named.class.equals(qualifier.annotationType())) continue;
            Assert.assertEquals((String)name, (String)((Named)qualifier).value());
            return;
        }
        Assert.fail((String)"@Named qualifier not found.");
    }
}

