/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.impl.objects.OntPropertyImpl;
import org.apache.jena.ontapi.impl.objects.OntStatementImpl;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDFS;

public class OntAnnotationPropertyImpl
extends OntPropertyImpl
implements OntAnnotationProperty {
    public OntAnnotationPropertyImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public Class<OntAnnotationProperty> objectType() {
        return OntAnnotationProperty.class;
    }

    @Override
    public Stream<OntAnnotationProperty> superProperties(boolean direct) {
        return OntAnnotationPropertyImpl.superProperties(this, OntAnnotationProperty.class, direct);
    }

    @Override
    public Stream<OntAnnotationProperty> subProperties(boolean direct) {
        return OntAnnotationPropertyImpl.subProperties(this, OntAnnotationProperty.class, direct);
    }

    @Override
    public OntStatement addDomainStatement(Resource domain) {
        return this.addStatement(RDFS.domain, OntAnnotationPropertyImpl.checkNamed(domain));
    }

    @Override
    public OntStatement addRangeStatement(Resource range) {
        return this.addStatement(RDFS.range, OntAnnotationPropertyImpl.checkNamed(range));
    }

    @Override
    public Stream<Resource> domains() {
        return this.objects(RDFS.domain, Resource.class).filter(RDFNode::isURIResource);
    }

    @Override
    public Stream<Resource> ranges() {
        return this.objects(RDFS.range, Resource.class).filter(RDFNode::isURIResource);
    }

    @Override
    public Stream<OntClass> declaringClasses(boolean direct) {
        return OntAnnotationPropertyImpl.declaringClasses(this, direct);
    }

    @Override
    public boolean hasSuperProperty(OntProperty property, boolean direct) {
        return property.canAs(OntAnnotationProperty.class) && OntPropertyImpl.hasSuperProperty(this, property.as(OntAnnotationProperty.class), OntAnnotationProperty.class, direct);
    }

    @Override
    public boolean isBuiltIn() {
        return this.getModel().isBuiltIn(this);
    }

    @Override
    public Property inModel(Model m) {
        return this.getModel() == m ? this : m.createProperty(this.getURI());
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntAnnotationPropertyImpl.getOptionalRootStatement(this, OWL2.AnnotationProperty);
    }

    @Override
    public int getOrdinal() {
        return OntStatementImpl.createProperty(this.node, this.enhGraph).getOrdinal();
    }
}

