/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator.java;

import org.eclipse.equinox.p2.internal.repository.comparator.java.CharOperation;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFileAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPoolEntry;
import org.eclipse.equinox.p2.internal.repository.comparator.java.Utility;

public class ExceptionAttribute
extends ClassFileAttribute {
    private final int exceptionsNumber;
    private char[][] exceptionNames;
    private int[] exceptionIndexes;

    ExceptionAttribute(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int exceptionLength = this.exceptionsNumber = this.u2At(classFileBytes, 6, offset);
        this.exceptionNames = CharOperation.NO_CHAR_CHAR;
        this.exceptionIndexes = Utility.EMPTY_INT_ARRAY;
        if (exceptionLength != 0) {
            this.exceptionNames = new char[exceptionLength][];
            this.exceptionIndexes = new int[exceptionLength];
        }
        int readOffset = 8;
        int i = 0;
        while (i < exceptionLength) {
            this.exceptionIndexes[i] = this.u2At(classFileBytes, readOffset, offset);
            ConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.exceptionIndexes[i]);
            if (constantPoolEntry.getKind() != 7) {
                throw new ClassFormatException(3);
            }
            this.exceptionNames[i] = constantPoolEntry.getClassInfoName();
            readOffset += 2;
            ++i;
        }
    }

    public int[] getExceptionIndexes() {
        return this.exceptionIndexes;
    }

    public char[][] getExceptionNames() {
        return this.exceptionNames;
    }

    public int getExceptionsNumber() {
        return this.exceptionsNumber;
    }
}

