/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import org.sat4j.core.Vec;
import org.sat4j.pb.tools.DependencyHelper;
import org.sat4j.pb.tools.ImplicationAnd;
import org.sat4j.pb.tools.ImplicationNamer;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class ImplicationRHS<T, C> {
    private final IVecInt clause;
    private final DependencyHelper<T, C> helper;
    private final IVec<IConstr> toName = new Vec();

    public ImplicationRHS(DependencyHelper<T, C> helper, IVecInt clause) {
        this.clause = clause;
        this.helper = helper;
    }

    public ImplicationAnd<T, C> implies(T thing) throws ContradictionException {
        ImplicationAnd<T, C> and = new ImplicationAnd<T, C>(this.helper, this.clause);
        and.and(thing);
        return and;
    }

    public ImplicationNamer<T, C> implies(T ... things) throws ContradictionException {
        for (T t : things) {
            this.clause.push(this.helper.getIntValue(t));
        }
        this.toName.push((Object)this.helper.solver.addClause(this.clause));
        return new ImplicationNamer<T, C>(this.helper, this.toName);
    }

    public ImplicationAnd<T, C> impliesNot(T thing) throws ContradictionException {
        ImplicationAnd<T, C> and = new ImplicationAnd<T, C>(this.helper, this.clause);
        and.andNot(thing);
        return and;
    }
}

