/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region.management;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.management.ManageableRegion;
import org.eclipse.equinox.region.management.ManageableRegionDigraph;

public class StandardManageableRegion
implements ManageableRegion {
    private final Region region;
    private final ManageableRegionDigraph manageableRegionDigraph;
    private final RegionDigraph regionDigraph;

    public StandardManageableRegion(Region region, ManageableRegionDigraph manageableRegionDigraph, RegionDigraph regionDigraph) {
        this.region = region;
        this.manageableRegionDigraph = manageableRegionDigraph;
        this.regionDigraph = regionDigraph;
    }

    @Override
    public String getName() {
        return this.region.getName();
    }

    @Override
    public ManageableRegion[] getDependencies() {
        Set<RegionDigraph.FilteredRegion> edges = this.regionDigraph.getEdges(this.region);
        ArrayList<ManageableRegion> dependencies = new ArrayList<ManageableRegion>();
        for (RegionDigraph.FilteredRegion edge : edges) {
            ManageableRegion manageableRegion = this.manageableRegionDigraph.getRegion(edge.getRegion().getName());
            if (manageableRegion == null) continue;
            dependencies.add(manageableRegion);
        }
        return dependencies.toArray(new ManageableRegion[dependencies.size()]);
    }

    @Override
    public long[] getBundleIds() {
        Set<Long> bundleIds = this.region.getBundleIds();
        long[] result = new long[bundleIds.size()];
        int i = 0;
        for (Long bundleId : bundleIds) {
            result[i++] = bundleId;
        }
        return result;
    }
}

