/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.io;

import java.io.IOException;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class EclipseConsoleAppStream
extends AppStream {
    private final IOConsoleOutputStream stream;

    public EclipseConsoleAppStream(IOConsoleOutputStream stream) {
        this.stream = stream;
    }

    @Override
    protected void writeImpl(byte b) {
        try {
            this.stream.write((int)b);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to write to an Eclipse console.", (Object[])new Object[0]);
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    @Override
    protected void writeImpl(byte[] bytes, int offset, int length) {
        try {
            this.stream.write(bytes, offset, length);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to write to an Eclipse console.", (Object[])new Object[0]);
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    @Override
    protected void flushImpl() {
        try {
            this.stream.flush();
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to flush an Eclipse console stream.", (Object[])new Object[0]);
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    @Override
    protected void closeImpl() {
        try {
            this.stream.close();
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to close an Eclipse console stream.", (Object[])new Object[0]);
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }
}

