/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.io;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.escet.cif.common.CifRelativePathUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.prettyprinter.CifPrettyPrinter;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.OutputStreamCodeBox;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.emf.ecore.xmi.RealXMIResource;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;

public class CifWriter {
    private CifWriter() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeCifSpec(Specification spec, PathPair filePaths, String specPath) {
        String absDirPath = Paths.getAbsFilePathDir((String)filePaths.systemPath);
        CifRelativePathUtils.adaptRelativePaths((ComplexComponent)spec, (String)specPath, (String)absDirPath);
        if (filePaths.systemPath.toLowerCase(Locale.US).endsWith(".cifx")) {
            URI resourceUri = Paths.createEmfURI((String)filePaths.systemPath);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            RealXMIResource resource = (RealXMIResource)resourceSet.createResource(resourceUri);
            resource.getContents().add((Object)spec);
            EMFHelper.normalizeXmiIds((XMLResource)resource);
            try {
                resource.save(null);
            }
            catch (IOException e) {
                throw new InvalidInputException(Strings.fmt((String)"Failed to save CIF file \"%s\".", (Object[])new Object[]{filePaths.userPath}), (Throwable)e);
            }
            resource.getContents().remove((Object)spec);
            return;
        }
        try {
            Throwable resourceUri = null;
            Object var5_9 = null;
            try {
                BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePaths.systemPath));
                try {
                    try (OutputStreamCodeBox code = new OutputStreamCodeBox((OutputStream)stream, Strings.fmt((String)"\"%s\"", (Object[])new Object[]{filePaths.userPath}), 2);){
                        CifPrettyPrinter.boxSpec((Specification)spec, (CodeBox)code);
                    }
                    if (stream == null) return;
                }
                catch (Throwable throwable) {
                    if (resourceUri == null) {
                        resourceUri = throwable;
                    } else if (resourceUri != throwable) {
                        resourceUri.addSuppressed(throwable);
                    }
                    if (stream == null) throw resourceUri;
                    ((OutputStream)stream).close();
                    throw resourceUri;
                }
                ((OutputStream)stream).close();
                return;
            }
            catch (Throwable throwable) {
                if (resourceUri == null) {
                    resourceUri = throwable;
                    throw resourceUri;
                } else {
                    if (resourceUri == throwable) throw resourceUri;
                    resourceUri.addSuppressed(throwable);
                }
                throw resourceUri;
            }
        }
        catch (IOException ex) {
            throw new InputOutputException(Strings.fmt((String)"Failed to write CIF file \"%s\".", (Object[])new Object[]{filePaths.userPath}), (Throwable)ex);
        }
    }
}

