/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.conversion.expressions;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.plcgen.conversion.ModelTextGenerator;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenerator;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public abstract class ExprGenResult<E extends PlcExpression, R extends ExprGenResult<E, R>> {
    private final ExprGenerator generator;
    public Set<PlcBasicVariable> codeVariables = Sets.set();
    public List<PlcStatement> code = Lists.list();
    public Set<PlcBasicVariable> valueVariables = Sets.set();
    public E value = null;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ModelTextGenerator tg = new ModelTextGenerator(this.generator.target);
        if (!this.code.isEmpty()) {
            sb.append("code:\n");
            for (PlcStatement s : this.code) {
                sb.append(tg.toString(s, "noPou") + "\n");
            }
        }
        if (!this.codeVariables.isEmpty()) {
            sb.append("code-variables:");
            for (PlcBasicVariable v : this.codeVariables) {
                sb.append(" " + v.varName);
            }
            sb.append("\n");
        }
        if (this.value != null) {
            sb.append("value: " + tg.toString((PlcExpression)this.value) + "\n");
        } else {
            sb.append("value: <NULL>\n");
        }
        if (!this.valueVariables.isEmpty()) {
            sb.append("value-variables:");
            for (PlcBasicVariable v : this.valueVariables) {
                sb.append(" " + v.varName);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected ExprGenResult(ExprGenerator generator, ExprGenResult<?, ?> ... parentResults) {
        this.generator = generator;
        ExprGenResult<?, ?>[] exprGenResultArray = parentResults;
        int n = parentResults.length;
        int n2 = 0;
        while (n2 < n) {
            ExprGenResult<?, ?> parentResult = exprGenResultArray[n2];
            this.mergeCodeAndVariables(parentResult);
            ++n2;
        }
    }

    public void mergeCodeAndVariables(ExprGenResult<?, ?> parentResult) {
        this.mergeCodeVariables(parentResult);
        this.mergeCode(parentResult);
        this.mergeValueVariables(parentResult);
    }

    public void mergeCodeVariables(ExprGenResult<?, ?> parentResult) {
        this.codeVariables.addAll(parentResult.codeVariables);
    }

    public void mergeCode(ExprGenResult<?, ?> parentResult) {
        this.code.addAll(PlcStatement.copy(parentResult.code));
    }

    public void mergeValueVariables(ExprGenResult<?, ?> parentResult) {
        this.valueVariables.addAll(parentResult.valueVariables);
    }

    public boolean hasCode() {
        Assert.implies((boolean)this.code.isEmpty(), (boolean)this.codeVariables.isEmpty());
        return !this.code.isEmpty();
    }

    public boolean hasCodeVariables() {
        Assert.implies((boolean)this.code.isEmpty(), (boolean)this.codeVariables.isEmpty());
        return !this.codeVariables.isEmpty();
    }

    public R setValue(E plcExpr) {
        this.value = plcExpr;
        return (R)this;
    }

    public void releaseCodeVariables() {
        this.generator.releaseScratchVariables(this.codeVariables);
        this.codeVariables.clear();
    }

    public boolean hasValueVariables() {
        Assert.implies((this.value == null ? 1 : 0) != 0, (boolean)this.valueVariables.isEmpty());
        return !this.valueVariables.isEmpty();
    }

    public void releaseValueVariables() {
        this.generator.releaseScratchVariables(this.valueVariables);
        this.valueVariables.clear();
    }
}

