/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.settings;

import java.util.Set;
import org.eclipse.escet.cif.bdd.settings.CifBddSettings;
import org.eclipse.escet.cif.common.CifValidationUtils;
import org.eclipse.escet.cif.datasynth.settings.BddOutputMode;
import org.eclipse.escet.cif.datasynth.settings.BddSimplify;
import org.eclipse.escet.cif.datasynth.settings.CifDataSynthesisFree;
import org.eclipse.escet.cif.datasynth.settings.CifDataSynthesisSettingsDefaults;
import org.eclipse.escet.cif.datasynth.settings.FixedPointComputationsOrder;
import org.eclipse.escet.cif.datasynth.settings.StateReqInvEnforceMode;
import org.eclipse.escet.cif.datasynth.settings.SynthesisStatistics;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public class CifDataSynthesisSettings
extends CifBddSettings {
    private boolean doNeverEnabledEventsWarn = true;
    private StateReqInvEnforceMode stateReqInvEnforceMode = CifDataSynthesisSettingsDefaults.STATE_REQ_INV_ENFORCE_MODE_DEFAULT;
    private FixedPointComputationsOrder fixedPointComputationsOrder = CifDataSynthesisSettingsDefaults.FIXED_POINT_COMPUTATIONS_ORDER_DEFAULT;
    private boolean doForwardReach = false;
    private String supervisorName = "sup";
    private String supervisorNamespace = CifDataSynthesisSettingsDefaults.SUPERVISOR_NAMESPACE_DEFAULT;
    private BddOutputMode bddOutputMode = CifDataSynthesisSettingsDefaults.BDD_OUTPUT_MODE_DEFAULT;
    private String bddOutputNamePrefix = "bdd";
    private Set<BddSimplify> bddSimplifications = CifDataSynthesisSettingsDefaults.BDD_SIMPLIFICATIONS_DEFAULT.clone();
    private Set<SynthesisStatistics> synthesisStatistics = CifDataSynthesisSettingsDefaults.SYNTHESIS_STATISTICS_DEFAULT.clone();
    private String continuousPerformanceStatisticsFilePath = null;
    private String continuousPerformanceStatisticsFileAbsPath = null;
    private Set<CifDataSynthesisFree> synthesisFrees = CifDataSynthesisSettingsDefaults.SYNTHESIS_FREES_DEFAULT.clone();

    public CifDataSynthesisSettings() {
        this.checkSettings();
    }

    public boolean getDoNeverEnabledEventsWarn() {
        return this.doNeverEnabledEventsWarn;
    }

    public void setDoNeverEnabledEventsWarn(boolean doNeverEnabledEventsWarn) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.doNeverEnabledEventsWarn = doNeverEnabledEventsWarn;
        this.checkSettings();
    }

    public StateReqInvEnforceMode getStateReqInvEnforceMode() {
        return this.stateReqInvEnforceMode;
    }

    public void setStateReqInvEnforceMode(StateReqInvEnforceMode stateReqInvEnforceMode) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.stateReqInvEnforceMode = stateReqInvEnforceMode;
        this.checkSettings();
    }

    public FixedPointComputationsOrder getFixedPointComputationsOrder() {
        return this.fixedPointComputationsOrder;
    }

    public void setFixedPointComputationsOrder(FixedPointComputationsOrder fixedPointComputationsOrder) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.fixedPointComputationsOrder = fixedPointComputationsOrder;
        this.checkSettings();
    }

    public boolean getDoForwardReach() {
        return this.doForwardReach;
    }

    public void setDoForwardReach(boolean doForwardReach) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.doForwardReach = doForwardReach;
        this.checkSettings();
    }

    public String getSupervisorName() {
        return this.supervisorName;
    }

    public void setSupervisorName(String supervisorName) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.supervisorName = supervisorName;
        this.checkSettings();
    }

    public String getSupervisorNamespace() {
        return this.supervisorNamespace;
    }

    public void setSupervisorNamespace(String supervisorNamespace) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.supervisorNamespace = supervisorNamespace;
        this.checkSettings();
    }

    public BddOutputMode getBddOutputMode() {
        return this.bddOutputMode;
    }

    public void setBddOutputMode(BddOutputMode bddOutputMode) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddOutputMode = bddOutputMode;
        this.checkSettings();
    }

    public String getBddOutputNamePrefix() {
        return this.bddOutputNamePrefix;
    }

    public void setBddOutputNamePrefix(String bddOutputNamePrefix) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddOutputNamePrefix = bddOutputNamePrefix;
        this.checkSettings();
    }

    public Set<BddSimplify> getBddSimplifications() {
        return this.bddSimplifications;
    }

    public void setBddSimplifications(Set<BddSimplify> bddSimplifications) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddSimplifications = bddSimplifications;
        this.checkSettings();
    }

    public Set<SynthesisStatistics> getSynthesisStatistics() {
        return this.synthesisStatistics;
    }

    public void setSynthesisStatistics(Set<SynthesisStatistics> synthesisStatistics) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.synthesisStatistics = synthesisStatistics;
        this.checkSettings();
    }

    public String getContinuousPerformanceStatisticsFilePath() {
        return this.continuousPerformanceStatisticsFilePath;
    }

    public void setContinuousPerformanceStatisticsFilePath(String continuousPerformanceStatisticsFilePath) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.continuousPerformanceStatisticsFilePath = continuousPerformanceStatisticsFilePath;
        this.checkSettings();
    }

    public String getContinuousPerformanceStatisticsFileAbsPath() {
        return this.continuousPerformanceStatisticsFileAbsPath;
    }

    public void setContinuousPerformanceStatisticsFileAbsPath(String continuousPerformanceStatisticsFileAbsPath) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.continuousPerformanceStatisticsFileAbsPath = continuousPerformanceStatisticsFileAbsPath;
        this.checkSettings();
    }

    public boolean doFree(CifDataSynthesisFree free) {
        return this.synthesisFrees.contains((Object)free);
    }

    public boolean doKeep(CifDataSynthesisFree free) {
        return !this.doFree(free);
    }

    public Set<CifDataSynthesisFree> getSynthesisFrees() {
        return this.synthesisFrees;
    }

    public void setSynthesisFrees(Set<CifDataSynthesisFree> synthesisFrees) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.synthesisFrees = synthesisFrees;
        this.checkSettings();
    }

    private void checkSettings() {
        if (!CifValidationUtils.isValidIdentifier((String)this.bddOutputNamePrefix)) {
            String msg = Strings.fmt((String)"BDD output name prefix \"%s\" is not a valid CIF identifier.", (Object[])new Object[]{this.bddOutputNamePrefix});
            throw new InvalidOptionException(msg);
        }
        if (!CifValidationUtils.isValidIdentifier((String)this.supervisorName)) {
            String msg = Strings.fmt((String)"Supervisor name \"%s\" is not a valid CIF identifier.", (Object[])new Object[]{this.supervisorName});
            throw new InvalidOptionException(msg);
        }
        if (this.supervisorNamespace != null && !CifValidationUtils.isValidName((String)this.supervisorNamespace)) {
            String msg = Strings.fmt((String)"Supervisor namespace \"%s\" is invalid.", (Object[])new Object[]{this.supervisorNamespace});
            throw new InvalidOptionException(msg);
        }
    }
}

