/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.model;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.simulator.options.CifSpecInitOption;
import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateObjectMeta;
import org.eclipse.escet.cif.simulator.runtime.meta.StateObjectType;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeAutomaton;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSpec;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public abstract class RuntimeStateInit {
    protected Object[] optionVarValues;
    protected Integer[] optionLocIndices;

    protected void processInitOption(RuntimeSpec<?> spec, RuntimeState state) {
        this.optionVarValues = new Object[state.getStateVarCount()];
        this.optionLocIndices = new Integer[state.getAutCount()];
        int metaCount = this.optionVarValues.length + this.optionLocIndices.length;
        Map metaMap = Maps.mapc((int)metaCount);
        for (RuntimeStateObjectMeta meta : spec.stateObjectsMeta) {
            switch (meta.type) {
                case TIME: 
                case CONTINUOUS: 
                case DERIVATIVE: 
                case ALGEBRAIC: {
                    break;
                }
                case AUTOMATON: 
                case DISCRETE: 
                case INPUT: {
                    metaMap.put(meta.plainName, meta);
                }
            }
        }
        List<String> inits = CifSpecInitOption.getInits();
        for (String init : inits) {
            Object value;
            int colonIdx = init.indexOf(58);
            if (colonIdx == -1) {
                String msg = Strings.fmt((String)"Missing \":\" in initialization \"%s\".", (Object[])new Object[]{init});
                throw new InvalidOptionException(msg);
            }
            String name = init.substring(0, colonIdx);
            String valueTxt = init.substring(colonIdx + 1);
            RuntimeStateObjectMeta obj = (RuntimeStateObjectMeta)metaMap.get(name);
            if (obj == null) {
                String msg = Strings.fmt((String)"Could not find a discrete variable, input variable or automaton with name \"%s\" for initialization \"%s\".", (Object[])new Object[]{name, init});
                throw new InvalidOptionException(msg);
            }
            if (obj.type == StateObjectType.AUTOMATON) {
                RuntimeAutomaton aut = spec.automata.get(obj.idx);
                int foundIdx = -1;
                int i = 0;
                while (i < aut.getLocCount()) {
                    String locName = aut.getLocName(i);
                    if (locName.equals("*")) {
                        locName = null;
                    }
                    if (valueTxt.equals(locName)) {
                        foundIdx = i;
                        break;
                    }
                    ++i;
                }
                if (foundIdx == -1) {
                    String msg = Strings.fmt((String)"Could not find a location named \"%s\" in automaton \"%s\" for initialization \"%s\".", (Object[])new Object[]{valueTxt, name, init});
                    throw new InvalidOptionException(msg);
                }
                if (this.optionLocIndices[obj.idx] != null) {
                    String msg = Strings.fmt((String)"Duplicate initialization provided for automaton \"%s\".", (Object[])new Object[]{name});
                    throw new InvalidOptionException(msg);
                }
                this.optionLocIndices[obj.idx] = foundIdx;
                continue;
            }
            Assert.check((obj.type == StateObjectType.DISCRETE || obj.type == StateObjectType.INPUT ? 1 : 0) != 0);
            String objectType = obj.type == StateObjectType.DISCRETE ? "discrete" : "input";
            try {
                value = this.processVarValue(obj, valueTxt);
            }
            catch (InputOutputException ex) {
                String msg = Strings.fmt((String)"Initial value \"%s\" for %s variable \"%s\" is invalid, for initialization \"%s\".", (Object[])new Object[]{valueTxt, objectType, name, init});
                throw new InvalidOptionException(msg, (Throwable)ex);
            }
            if (this.optionVarValues[obj.idx] != null) {
                String msg = Strings.fmt((String)"Duplicate initialization provided for %s variable \"%s\".", (Object[])new Object[]{objectType, name});
                throw new InvalidOptionException(msg);
            }
            this.optionVarValues[obj.idx] = value;
        }
    }

    protected abstract Object processVarValue(RuntimeStateObjectMeta var1, String var2);
}

