/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.config;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.ConfigStandaloneSetup;
import org.eclipse.etrice.core.common.base.BooleanLiteral;
import org.eclipse.etrice.core.common.base.IntLiteral;
import org.eclipse.etrice.core.common.base.Literal;
import org.eclipse.etrice.core.common.base.NumberLiteral;
import org.eclipse.etrice.core.common.base.RealLiteral;
import org.eclipse.etrice.core.common.base.StringLiteral;
import org.eclipse.etrice.core.config.AttrClassConfig;
import org.eclipse.etrice.core.config.AttrInstanceConfig;
import org.eclipse.etrice.core.config.ConfigValue;
import org.eclipse.etrice.core.config.ConfigValueArray;
import org.eclipse.etrice.core.config.DynamicConfig;
import org.eclipse.etrice.core.config.EnumConfigValue;
import org.eclipse.etrice.core.config.LiteralConfigValue;
import org.eclipse.etrice.core.config.SubSystemConfig;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.config.util.DataConfigurationHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DataConfiguration
implements IDataConfiguration {
    @Inject
    @Extension
    protected DataConfigurationHelper _dataConfigurationHelper;
    @Inject
    protected ILogger logger;

    public void doSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            ConfigStandaloneSetup.doSetup();
        }
    }

    public boolean setResources(ResourceSet resource, ILogger logger) {
        return this._dataConfigurationHelper.setConfigModels(resource, logger);
    }

    public String getAttrClassConfigValue(ActorClass actor, List<Attribute> path) {
        AttrClassConfig attrClassConfig = this.getAttrClassConfig(actor, path);
        ConfigValueArray configValueArray = null;
        if (attrClassConfig != null) {
            configValueArray = attrClassConfig.getValue();
        }
        String string = null;
        if (configValueArray != null) {
            string = this.toStringExpr(configValueArray);
        }
        return string;
    }

    public String getAttrClassConfigMaxValue(ActorClass actor, List<Attribute> path) {
        AttrClassConfig attrClassConfig = this.getAttrClassConfig(actor, path);
        NumberLiteral numberLiteral = null;
        if (attrClassConfig != null) {
            numberLiteral = attrClassConfig.getMax();
        }
        String string = null;
        if (numberLiteral != null) {
            string = this.toStringExpr((Literal)numberLiteral);
        }
        return string;
    }

    public String getAttrClassConfigMinValue(ActorClass actor, List<Attribute> path) {
        AttrClassConfig attrClassConfig = this.getAttrClassConfig(actor, path);
        NumberLiteral numberLiteral = null;
        if (attrClassConfig != null) {
            numberLiteral = attrClassConfig.getMin();
        }
        String string = null;
        if (numberLiteral != null) {
            string = this.toStringExpr((Literal)numberLiteral);
        }
        return string;
    }

    private AttrClassConfig getAttrClassConfig(ActorClass actor, List<Attribute> path) {
        AttrClassConfig attrClassConfig = null;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/");
        String string = actor.getName();
        stringConcatenation.append(string);
        stringConcatenation.append("/");
        String string2 = this.toStringPath(path);
        stringConcatenation.append(string2);
        String id = stringConcatenation.toString();
        attrClassConfig = this._dataConfigurationHelper.actorClassAttrMap.get(id);
        return attrClassConfig;
    }

    public String getAttrClassConfigValue(ProtocolClass pc, boolean regular, List<Attribute> path) {
        String string = null;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/");
        String string2 = pc.getName();
        stringConcatenation.append(string2);
        stringConcatenation.append("/");
        if (regular) {
            stringConcatenation.append("regular");
        } else {
            stringConcatenation.append("conjugated");
        }
        stringConcatenation.append("/");
        String string3 = this.toStringPath(path);
        stringConcatenation.append(string3);
        String id = stringConcatenation.toString();
        AttrClassConfig attrClassConfig = this._dataConfigurationHelper.protocolClassAttrMap.get(id);
        ConfigValueArray configValueArray = null;
        if (attrClassConfig != null) {
            configValueArray = attrClassConfig.getValue();
        }
        String string4 = null;
        if (configValueArray != null) {
            string4 = this.toStringExpr(configValueArray);
        }
        string = string4;
        return string;
    }

    private String toStringPath(List<Attribute> path) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        boolean bl = false;
        for (Attribute a : path) {
            if (!bl) {
                bl = true;
            } else {
                stringConcatenation.appendImmediate((Object)"/", "");
            }
            String string = a.getName();
            stringConcatenation.append(string);
        }
        return stringConcatenation.toString();
    }

    public String getAttrInstanceConfigValue(ActorInstance ai, List<Attribute> path) {
        String string = null;
        String string2 = ai.getPath();
        String string3 = string2 + "/";
        String string4 = this.toStringPath(path);
        String id = string3 + string4;
        AttrInstanceConfig attrInstanceConfig = this._dataConfigurationHelper.actorInstanceAttrMap.get(id);
        ConfigValueArray configValueArray = null;
        if (attrInstanceConfig != null) {
            configValueArray = attrInstanceConfig.getValue();
        }
        String string5 = null;
        if (configValueArray != null) {
            string5 = this.toStringExpr(configValueArray);
        }
        string = string5;
        return string;
    }

    public String getAttrInstanceConfigValue(InterfaceItemInstance item, List<Attribute> path) {
        String string = item.getPath();
        String string2 = string + "/";
        String string3 = this.toStringPath(path);
        String string4 = string2 + string3;
        AttrInstanceConfig attrInstanceConfig = this._dataConfigurationHelper.actorInstanceAttrMap.get(string4);
        ConfigValueArray configValueArray = null;
        if (attrInstanceConfig != null) {
            configValueArray = attrInstanceConfig.getValue();
        }
        String string5 = null;
        if (configValueArray != null) {
            string5 = this.toStringExpr(configValueArray);
        }
        return string5;
    }

    public long getPollingTimerUser(SubSystemInstance subsystem) {
        long l = 0L;
        SubSystemConfig subSystemConfig = this.getConfig(subsystem);
        DynamicConfig dynamicConfig = null;
        if (subSystemConfig != null) {
            dynamicConfig = subSystemConfig.getDynConfig();
        }
        DynamicConfig dynConf = dynamicConfig;
        long l2 = 0L;
        l2 = dynConf == null ? 0L : dynConf.getPolling();
        l = l2;
        return l;
    }

    public String getUserCode1(SubSystemInstance subsystem) {
        boolean bl;
        SubSystemConfig subSystemConfig = this.getConfig(subsystem);
        DynamicConfig dynamicConfig = null;
        if (subSystemConfig != null) {
            dynamicConfig = subSystemConfig.getDynConfig();
        }
        DynamicConfig dynConfig = dynamicConfig;
        String string = null;
        String string2 = null;
        if (dynConfig != null) {
            string2 = dynConfig.getFilePath();
        }
        boolean bl2 = bl = string2 != null;
        if (bl) {
            string = "import org.eclipse.etrice.runtime.java.config.ConfigSourceFile;";
        } else {
            String string3 = null;
            if (dynConfig != null) {
                string3 = dynConfig.getUserCode1();
            }
            string = string3;
        }
        return string;
    }

    public String getUserCode2(SubSystemInstance subsystem) {
        boolean bl;
        SubSystemConfig subSystemConfig = this.getConfig(subsystem);
        DynamicConfig dynamicConfig = null;
        if (subSystemConfig != null) {
            dynamicConfig = subSystemConfig.getDynConfig();
        }
        DynamicConfig dynConfig = dynamicConfig;
        String string = null;
        String string2 = null;
        if (dynConfig != null) {
            string2 = dynConfig.getFilePath();
        }
        boolean bl2 = bl = string2 != null;
        if (bl) {
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("new ConfigSourceFile(\"");
            String string3 = dynConfig.getFilePath();
            stringConcatenation.append(string3);
            stringConcatenation.append("\")");
            string = stringConcatenation.toString();
        } else {
            String string4 = null;
            if (dynConfig != null) {
                string4 = dynConfig.getUserCode2();
            }
            string = string4;
        }
        return string;
    }

    public List<Attribute> getDynConfigReadAttributes(ActorInstance ai) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        List<AttrInstanceConfig> configs = this._dataConfigurationHelper.dynActorInstanceAttrMap.get(ai.getPath());
        if (configs != null) {
            Consumer<AttrInstanceConfig> consumer = c -> {
                boolean bl = c.isReadOnly();
                if (bl) {
                    result.add(c.getAttribute());
                }
            };
            configs.forEach(consumer);
        }
        return result;
    }

    public List<Attribute> getDynConfigWriteAttributes(ActorInstance ai) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        List<AttrInstanceConfig> configs = this._dataConfigurationHelper.dynActorInstanceAttrMap.get(ai.getPath());
        if (configs != null) {
            Consumer<AttrInstanceConfig> consumer = c -> {
                boolean bl;
                boolean bl2 = c.isReadOnly();
                boolean bl3 = bl = !bl2;
                if (bl) {
                    result.add(c.getAttribute());
                }
            };
            configs.forEach(consumer);
        }
        return result;
    }

    public boolean hasVariableService(SubSystemInstance subsystem) {
        SubSystemConfig subSystemConfig = this.getConfig(subsystem);
        DynamicConfig dynamicConfig = null;
        if (subSystemConfig != null) {
            dynamicConfig = subSystemConfig.getDynConfig();
        }
        return dynamicConfig != null;
    }

    private String toStringExpr(ConfigValueArray literal) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        EList eList = literal.getValues();
        boolean bl = false;
        for (ConfigValue l : eList) {
            if (!bl) {
                bl = true;
            } else {
                stringConcatenation.appendImmediate((Object)",", "");
            }
            String string = this.toStringExpr(l);
            stringConcatenation.append(string);
        }
        return stringConcatenation.toString();
    }

    private String toStringExpr(ConfigValue configValue) {
        String string = null;
        boolean bl = false;
        if (configValue instanceof LiteralConfigValue) {
            bl = true;
            string = this.toStringExpr(((LiteralConfigValue)configValue).getValue());
        }
        if (!bl && configValue instanceof EnumConfigValue) {
            bl = true;
            string = ((EnumConfigValue)configValue).getValue().getFullName();
        }
        return string;
    }

    private String toStringExpr(Literal literal) {
        String string = null;
        boolean bl = false;
        if (literal instanceof BooleanLiteral) {
            bl = true;
            string = Boolean.valueOf(((BooleanLiteral)literal).isIsTrue()).toString();
        }
        if (!bl && literal instanceof IntLiteral) {
            bl = true;
            string = Long.valueOf(((IntLiteral)literal).getValue()).toString();
        }
        if (!bl && literal instanceof RealLiteral) {
            bl = true;
            string = Double.valueOf(((RealLiteral)literal).getValue()).toString();
        }
        if (!bl && literal instanceof StringLiteral) {
            bl = true;
            string = ((StringLiteral)literal).getValue().toString();
        }
        return string;
    }

    private SubSystemConfig getConfig(SubSystemInstance cc) {
        return this._dataConfigurationHelper.subSystemConfigMap.get(cc.getPath());
    }

    public List<Attribute> getDynConfigReadAttributes(ActorClass actor) {
        HashSet result = new HashSet();
        List<AttrInstanceConfig> configs = this._dataConfigurationHelper.dynActorClassAttrMap.get(actor);
        if (configs != null) {
            Consumer<AttrInstanceConfig> consumer = c -> {
                boolean bl = c.isReadOnly();
                if (bl) {
                    result.add(c.getAttribute());
                }
            };
            configs.forEach(consumer);
        }
        return IterableExtensions.toList(result);
    }

    public List<Attribute> getDynConfigWriteAttributes(ActorClass actor) {
        HashSet result = new HashSet();
        List<AttrInstanceConfig> configs = this._dataConfigurationHelper.dynActorClassAttrMap.get(actor);
        if (configs != null) {
            Consumer<AttrInstanceConfig> consumer = c -> {
                boolean bl;
                boolean bl2 = c.isReadOnly();
                boolean bl3 = bl = !bl2;
                if (bl) {
                    result.add(c.getAttribute());
                }
            };
            configs.forEach(consumer);
        }
        return IterableExtensions.toList(result);
    }
}

