/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_zh_Hant extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u963f\u62c9\u4f2f\u6587";
        final String metaValue_bn = "\u5b5f\u52a0\u62c9\u6587";
        final String metaValue_bo = "\u85cf\u6587";
        final String metaValue_el = "\u5e0c\u81d8\u6587";
        final String metaValue_ff = "\u5bcc\u62c9\u6587";
        final String metaValue_gu = "\u53e4\u5409\u62c9\u7279\u6587";
        final String metaValue_he = "\u5e0c\u4f2f\u4f86\u6587";
        final String metaValue_hi = "\u5370\u5730\u6587";
        final String metaValue_hy = "\u4e9e\u7f8e\u5c3c\u4e9e\u6587";
        final String metaValue_ja = "\u65e5\u6587";
        final String metaValue_jv = "\u722a\u54c7\u6587";
        final String metaValue_ka = "\u55ac\u6cbb\u4e9e\u6587";
        final String metaValue_km = "\u9ad8\u68c9\u6587";
        final String metaValue_kn = "\u574e\u90a3\u9054\u6587";
        final String metaValue_ko = "\u97d3\u6587";
        final String metaValue_la = "\u62c9\u4e01\u6587";
        final String metaValue_ml = "\u99ac\u4f86\u4e9e\u62c9\u59c6\u6587";
        final String metaValue_mn = "\u8499\u53e4\u6587";
        final String metaValue_mr = "\u99ac\u62c9\u5730\u6587";
        final String metaValue_my = "\u7dec\u7538\u6587";
        final String metaValue_or = "\u6b50\u8fea\u4e9e\u6587";
        final String metaValue_sa = "\u68b5\u6587";
        final String metaValue_sd = "\u4fe1\u5fb7\u6587";
        final String metaValue_su = "\u5dfd\u4ed6\u6587";
        final String metaValue_ta = "\u5766\u7c73\u723e\u6587";
        final String metaValue_te = "\u6cf0\u76e7\u56fa\u6587";
        final String metaValue_th = "\u6cf0\u6587";
        final String metaValue_ban = "\u5cc7\u91cc\u6587";
        final String metaValue_bas = "\u5df4\u85a9\u6587";
        final String metaValue_bax = "\u5df4\u59c6\u7a46\u6587";
        final String metaValue_bug = "\u5e03\u5409\u65af\u6587";
        final String metaValue_ccp = "\u67e5\u514b\u99ac\u6587";
        final String metaValue_chr = "\u67f4\u7f85\u57fa\u6587";
        final String metaValue_cop = "\u79d1\u666e\u7279\u6587";
        final String metaValue_gon = "\u5ca1\u5fb7\u6587";
        final String metaValue_mai = "\u9081\u8482\u5229\u6587";
        final String metaValue_men = "\u9580\u5fb7\u6587";
        final String metaValue_mni = "\u66fc\u5c3c\u666e\u723e\u6587";
        final String metaValue_osa = "\u6b50\u585e\u5947\u6587";
        final String metaValue_peo = "\u53e4\u6ce2\u65af\u6587";
        final String metaValue_phn = "\u8153\u5c3c\u57fa\u6587";
        final String metaValue_sat = "\u6851\u5854\u5229\u6587";
        final String metaValue_saz = "\u7d22\u62c9\u4ec0\u7279\u62c9\u6587";
        final String metaValue_ssy = "\u85a9\u970d\u6587";
        final String metaValue_uga = "\u70cf\u52a0\u5217\u6587";
        final String metaValue_Zsye = "\u8868\u60c5\u7b26\u865f";
        final String metaValue_key_nu = "\u6578\u5b57";
        final String metaValue_type_nu_taml = "\u5766\u7c73\u723e\u6578\u5b57";
        final Object[][] data = new Object[][] {
            { "ksh", "\u79d1\u9686\u6587" },
            { "Ogam", "\u6b50\u7518\u6587" },
            { "mwl", "\u7c73\u862d\u5fb7\u65af\u6587" },
            { "Zsym", "\u7b26\u865f" },
            { "cch", "\u963f\u71e6\u6587" },
            { "mwr", "\u99ac\u74e6\u91cc\u6587" },
            { "type.nu.lanatham", "\u862d\u7d0d\u6587\u6578\u5b57" },
            { "egl", "\u57c3\u7c73\u5229\u5b89\u6587" },
            { "mwv", "\u660e\u6253\u5a01\u6587" },
            { "Zsye", metaValue_Zsye },
            { "Tagb", "\u5357\u5cf6\u6587" },
            { "%%NJIVA", "\u96f7\u897f\u4e9e\u5c3c\u74e6\u65b9\u8a00" },
            { "xmf", "\u660e\u683c\u5217\u723e\u6587" },
            { "ccp", metaValue_ccp },
            { "egy", "\u53e4\u57c3\u53ca\u6587" },
            { "raj", "\u62c9\u8cc8\u65af\u5766\u8af8\u6587" },
            { "Phag", "\u516b\u601d\u5df4\u6587" },
            { "tem", "\u63d0\u59c6\u6587" },
            { "type.nu.sind", "\u4fe1\u5fb7\u6578\u5b57" },
            { "teo", "\u7279\u7d22\u6587" },
            { "rap", "\u5fa9\u6d3b\u5cf6\u6587" },
            { "ter", "\u6cf0\u96f7\u8afe\u6587" },
            { "AC", "\u963f\u68ee\u677e\u5cf6" },
            { "rar", "\u62c9\u7f85\u901a\u52a0\u6587" },
            { "tet", "\u6cf0\u9813\u6587" },
            { "%%BARLA", "\u5361\u5e03\u4f5b\u5f97\u9c81\u5411\u98a8\u7fa4\u5cf6\u65b9\u8a00" },
            { "type.nu.sinh", "\u50e7\u4f3d\u7f85\u6578\u5b57" },
            { "AD", "\u5b89\u9053\u723e" },
            { "AE", "\u963f\u62c9\u4f2f\u806f\u5408\u5927\u516c\u570b" },
            { "nl_BE", "\u4f5b\u862d\u8292\u6587" },
            { "AF", "\u963f\u5bcc\u6c57" },
            { "AG", "\u5b89\u5730\u5361\u53ca\u5df4\u5e03\u9054" },
            { "type.nu.mroo", "\u9ed8\u6587\u6578\u5b57" },
            { "type.ca.ethiopic", "\u8863\u7d22\u6bd4\u4e9e\u66c6" },
            { "glk", "\u5409\u62c9\u57fa\u6587" },
            { "AI", "\u5b89\u594e\u62c9" },
            { "key.tz", "\u6642\u5340" },
            { "AL", "\u963f\u723e\u5df4\u5c3c\u4e9e" },
            { "AM", "\u4e9e\u7f8e\u5c3c\u4e9e" },
            { "Teng", "\u8ac7\u683c\u74e6\u6587" },
            { "AO", "\u5b89\u54e5\u62c9" },
            { "AQ", "\u5357\u6975\u6d32" },
            { "AR", "\u963f\u6839\u5ef7" },
            { "Prti", "\u5e15\u63d0\u4e9e\u6587\uff08\u7891\u9298\u9ad4\uff09" },
            { "AS", "\u7f8e\u5c6c\u85a9\u6469\u4e9e" },
            { "AT", "\u5967\u5730\u5229" },
            { "AU", "\u6fb3\u6d32" },
            { "AW", "\u8377\u5c6c\u963f\u9b6f\u5df4" },
            { "AX", "\u5967\u862d\u7fa4\u5cf6" },
            { "mye", "\u59c6\u8036\u5167\u6587" },
            { "AZ", "\u4e9e\u585e\u62dc\u7136" },
            { "%%AREVELA", "\u4e9e\u7f8e\u5c3c\u4e9e\u6771\u90e8" },
            { "BA", "\u6ce2\u58eb\u5c3c\u4e9e\u8207\u8d6b\u585e\u54e5\u7dad\u7d0d" },
            { "BB", "\u5df4\u8c9d\u591a" },
            { "ceb", "\u5bbf\u9727\u6587" },
            { "BD", "\u5b5f\u52a0\u62c9" },
            { "kum", "\u5eab\u5bc6\u514b\u6587" },
            { "BE", "\u6bd4\u5229\u6642" },
            { "gmh", "\u4e2d\u53e4\u9ad8\u5730\u5fb7\u6587" },
            { "BF", "\u5e03\u5409\u7d0d\u6cd5\u7d22" },
            { "BG", "\u4fdd\u52a0\u5229\u4e9e" },
            { "BH", "\u5df4\u6797" },
            { "BI", "\u84b2\u9686\u5730" },
            { "BJ", "\u8c9d\u5357" },
            { "BL", "\u8056\u5df4\u745f\u7c73" },
            { "BM", "\u767e\u6155\u9054" },
            { "kut", "\u5eab\u7279\u5948\u6587" },
            { "myv", "\u5384\u723e\u8332\u4e9e\u6587" },
            { "BN", "\u6c76\u840a" },
            { "BO", "\u73bb\u5229\u7dad\u4e9e" },
            { "BQ", "\u8377\u862d\u52a0\u52d2\u6bd4\u5340" },
            { "BR", "\u5df4\u897f" },
            { "BS", "\u5df4\u54c8\u99ac" },
            { "xog", "\u7d22\u52a0\u6587" },
            { "BT", "\u4e0d\u4e39" },
            { "BV", "\u5e03\u5a01\u5cf6" },
            { "BW", "\u6ce2\u672d\u90a3" },
            { "BY", "\u767d\u4fc4\u7f85\u65af" },
            { "BZ", "\u8c9d\u91cc\u65af" },
            { "Visp", "\u8996\u89ba\u8a9e\u97f3\u6587\u5b57" },
            { "type.ca.persian", "\u6ce2\u65af\u66c6" },
            { "type.nu.hebr", "\u5e0c\u4f2f\u4f86\u6578\u5b57" },
            { "CA", "\u52a0\u62ff\u5927" },
            { "CC", "\u79d1\u514b\u65af\uff08\u57fa\u9748\uff09\u7fa4\u5cf6" },
            { "mzn", "\u99ac\u8d0a\u5fb7\u862d\u6587" },
            { "CD", "\u525b\u679c\uff08\u91d1\u590f\u6c99\uff09" },
            { "CF", "\u4e2d\u975e\u5171\u548c\u570b" },
            { "CG", "\u525b\u679c\uff08\u5e03\u62c9\u85a9\uff09" },
            { "CH", "\u745e\u58eb" },
            { "CI", "\u8c61\u7259\u6d77\u5cb8" },
            { "CK", "\u5eab\u514b\u7fa4\u5cf6" },
            { "CL", "\u667a\u5229" },
            { "Kthi", "\u51f1\u63d0\u6587" },
            { "CM", "\u5580\u9ea5\u9686" },
            { "CN", "\u4e2d\u570b" },
            { "CO", "\u54e5\u502b\u6bd4\u4e9e" },
            { "CP", "\u514b\u91cc\u6d3e\u9813\u5cf6" },
            { "CR", "\u54e5\u65af\u5927\u9ece\u52a0" },
            { "CU", "\u53e4\u5df4" },
            { "CV", "\u7dad\u5fb7\u89d2" },
            { "CW", "\u5eab\u62c9\u7d22" },
            { "CX", "\u8056\u8a95\u5cf6" },
            { "CY", "\u8cfd\u666e\u52d2\u65af" },
            { "type.nu.bali", "\u5cc7\u91cc\u6587\u6578\u5b57" },
            { "CZ", "\u6377\u514b" },
            { "eka", "\u827e\u5361\u6731\u514b\u6587" },
            { "Ahom", "\u963f\u6d2a\u59c6\u6587" },
            { "Pauc", "\u9b91\u6b3d\u8c6a\u6587" },
            { "vls", "\u897f\u4f5b\u862d\u5fb7\u6587" },
            { "%%RIGIK", "\u53e4\u5178\u6c83\u62c9\u666e\u514b\u6587" },
            { "DE", "\u5fb7\u570b" },
            { "goh", "\u53e4\u9ad8\u5730\u5fb7\u6587" },
            { "ace", "\u4e9e\u9f4a\u6587" },
            { "cgg", "\u5947\u52a0\u6587" },
            { "DG", "\u8fea\u4e9e\u54e5\u52a0\u897f\u4e9e\u5cf6" },
            { "gom", "\u5b54\u5361\u5c3c\u6587" },
            { "type.nu.deva", "\u68b5\u6587\u6578\u5b57" },
            { "DJ", "\u5409\u5e03\u5730" },
            { "gon", metaValue_gon },
            { "DK", "\u4e39\u9ea5" },
            { "ach", "\u963f\u50d1\u5229\u6587" },
            { "Brai", "\u76f2\u4eba\u7528\u9ede\u5b57" },
            { "Brah", "\u5a46\u7f85\u7c73\u6587" },
            { "DM", "\u591a\u7c73\u5c3c\u514b" },
            { "type.nu.armnlow", "\u5c0f\u5beb\u4e9e\u7f8e\u5c3c\u4e9e\u6578\u5b57" },
            { "DO", "\u591a\u660e\u5c3c\u52a0\u5171\u548c\u570b" },
            { "gor", "\u79d1\u9686\u9054\u7f85\u6587" },
            { "got", "\u54e5\u5fb7\u6587" },
            { "vmf", "\u7f8e\u8335-\u6cd5\u862d\u514b\u5c3c\u4e9e\u6587" },
            { "Mtei", metaValue_mni },
            { "zun", "\u7956\u5c3c\u6587" },
            { "tig", "\u8482\u683c\u96f7\u6587" },
            { "Takr", "\u5854\u5361\u91cc\u6587\u5b57" },
            { "DZ", "\u963f\u723e\u53ca\u5229\u4e9e" },
            { "pag", "\u6f58\u52a0\u8f9b\u6587" },
            { "type.d0.hwidth", "\u534a\u5f62" },
            { "pal", "\u5df4\u5217\u7dad\u6587" },
            { "EA", "\u4f11\u9054\u8207\u6885\u5229\u5229\u4e9e" },
            { "chb", "\u5947\u5e03\u67e5\u6587" },
            { "pam", "\u6f58\u5e15\u5609\u6587" },
            { "EC", "\u5384\u74dc\u591a" },
            { "pap", "\u5e15\u76ae\u963f\u9580\u6258\u6587" },
            { "ada", "\u963f\u7576\u83ab\u6587" },
            { "EE", "\u611b\u6c99\u5c3c\u4e9e" },
            { "tiv", "\u63d0\u592b\u6587" },
            { "EG", "\u57c3\u53ca" },
            { "EH", "\u897f\u6492\u54c8\u62c9" },
            { "chg", "\u67e5\u52a0\u6587" },
            { "pau", "\u5e1b\u7409\u6587" },
            { "chk", "\u8655\u5947\u65af\u6587" },
            { "chn", "\u5951\u5974\u514b\u6587" },
            { "chm", "\u99ac\u91cc\u6587" },
            { "chp", "\u5947\u4f69\u74e6\u63da\u6587" },
            { "cho", "\u55ac\u514b\u6258\u6587" },
            { "type.nu.mathbold", "\u6578\u5b78\u7c97\u9ad4\u6578\u5b57" },
            { "chr", metaValue_chr },
            { "ER", "\u5384\u5229\u5782\u4e9e" },
            { "ES", "\u897f\u73ed\u7259" },
            { "ET", "\u8863\u7d22\u6bd4\u4e9e" },
            { "EU", "\u6b50\u76df" },
            { "elx", "\u57c3\u862d\u6587" },
            { "type.ca.gregorian", "\u516c\u66c6" },
            { "EZ", "\u6b50\u5143\u5340" },
            { "chy", "\u6c99\u4f0a\u5b89\u6587" },
            { "type.nu.gujr", "\u53e4\u5409\u62c9\u7279\u6578\u5b57" },
            { "Inds", "\u5370\u5ea6\u6cb3\u6d41\u57df\uff08\u54c8\u62c9\u5e15\u6587\uff09" },
            { "ady", "\u963f\u8fea\u5404\u6587" },
            { "aeb", "\u7a81\u5c3c\u65af\u963f\u62c9\u4f2f\u6587" },
            { "FI", "\u82ac\u862d" },
            { "FJ", "\u6590\u6fdf" },
            { "FK", "\u798f\u514b\u862d\u7fa4\u5cf6" },
            { "FM", "\u5bc6\u514b\u7f85\u5c3c\u897f\u4e9e" },
            { "key.va", "\u5340\u57df\u8b8a\u7570" },
            { "FO", "\u6cd5\u7f85\u7fa4\u5cf6" },
            { "Taml", metaValue_ta },
            { "FR", "\u6cd5\u570b" },
            { "Kpel", "\u514b\u57f9\u5217\u6587" },
            { "pcd", "\u5e87\u5361\u5e95\u6587" },
            { "tkl", "\u6258\u514b\u52de\u6587" },
            { "grb", "\u683c\u5217\u535a\u6587" },
            { "%%DAJNKO", "\u8b19\u67ef\u5b57\u6bcd" },
            { "type.ca.indian", "\u5370\u5ea6\u570b\u66c6" },
            { "rgn", "\u7f85\u99ac\u683c\u8afe\u91cc\u6587" },
            { "grc", "\u53e4\u5e0c\u81d8\u6587" },
            { "GA", "\u52a0\u5f6d" },
            { "tkr", "\u67e5\u5eab\u723e\u6587" },
            { "vot", "\u6c83\u63d0\u514b\u6587" },
            { "GB", "\u82f1\u570b" },
            { "pcm", "\u5948\u53ca\u5229\u4e9e\u76ae\u6b3d\u6587" },
            { "GD", "\u683c\u745e\u90a3\u9054" },
            { "GE", "\u55ac\u6cbb\u4e9e" },
            { "GF", "\u6cd5\u5c6c\u572d\u4e9e\u90a3" },
            { "GG", "\u6839\u606f" },
            { "GH", "\u8fe6\u7d0d" },
            { "Tale", "\u50a3\u54ea\u6587" },
            { "GI", "\u76f4\u5e03\u7f85\u9640" },
            { "afh", "\u963f\u5f17\u91cc\u5e0c\u5229\u6587" },
            { "GL", "\u683c\u9675\u862d" },
            { "enm", "\u4e2d\u53e4\u82f1\u6587" },
            { "GM", "\u7518\u6bd4\u4e9e" },
            { "GN", "\u5e7e\u5167\u4e9e" },
            { "GP", "\u74dc\u5730\u6d1b\u666e" },
            { "GQ", "\u8d64\u9053\u5e7e\u5167\u4e9e" },
            { "GR", "\u5e0c\u81d8" },
            { "GS", "\u5357\u55ac\u6cbb\u4e9e\u8207\u5357\u4e09\u660e\u6cbb\u7fa4\u5cf6" },
            { "GT", "\u74dc\u5730\u99ac\u62c9" },
            { "GU", "\u95dc\u5cf6" },
            { "pdc", "\u8cd3\u5915\u6cd5\u5c3c\u4e9e\u5fb7\u6587" },
            { "type.nu.mathmono", "\u6578\u5b78\u7b49\u5bec\u6578\u5b57" },
            { "GW", "\u5e7e\u5167\u4e9e\u6bd4\u7d22" },
            { "tli", "\u7279\u6797\u57fa\u7279\u6587" },
            { "tlh", "\u514b\u6797\u8ca2\u6587" },
            { "Talu", "\u897f\u96d9\u7248\u7d0d\u65b0\u50a3\u6587" },
            { "GY", "\u84cb\u4e9e\u90a3" },
            { "ckb", "\u4e2d\u5eab\u5fb7\u6587" },
            { "zxx", "\u7121\u8a9e\u8a00\u5167\u5bb9" },
            { "Jurc", "\u5973\u771f\u6587\u5b57" },
            { "tly", "\u5854\u91cc\u4ec0\u6587" },
            { "pdt", "\u9580\u8afe\u4f4e\u5730\u5fb7\u6587" },
            { "HK", "\u4e2d\u570b\u9999\u6e2f\u7279\u5225\u884c\u653f\u5340" },
            { "Vaii", "\u74e6\u4f9d\u6587" },
            { "HM", "\u8d6b\u5fb7\u5cf6\u53ca\u9ea5\u5510\u7d0d\u7fa4\u5cf6" },
            { "HN", "\u5b8f\u90fd\u62c9\u65af" },
            { "HR", "\u514b\u7f85\u57c3\u897f\u4e9e" },
            { "agq", "\u4e9e\u7f55\u6587" },
            { "gsw", "\u5fb7\u6587\uff08\u745e\u58eb\uff09" },
            { "type.ca.islamic-umalqura", "\u70cf\u59c6\u5eab\u62c9\u66c6" },
            { "HT", "\u6d77\u5730" },
            { "HU", "\u5308\u7259\u5229" },
            { "rif", "\u91cc\u83f2\u4e9e\u8afe\u6587" },
            { "tmh", "\u5854\u99ac\u5947\u514b\u6587" },
            { "IC", "\u52a0\u90a3\u5229\u7fa4\u5cf6" },
            { "nan", "\u95a9\u5357\u8a9e" },
            { "Adlm", metaValue_ff },
            { "peo", metaValue_peo },
            { "ID", "\u5370\u5c3c" },
            { "type.nu.kali", "\u514b\u8036\u6578\u5b57" },
            { "IE", "\u611b\u723e\u862d" },
            { "nap", "\u62ff\u6ce2\u91cc\u6587" },
            { "%%NDYUKA", "\u8607\u5229\u5357\u6069\u90fd\u5361\u65b9\u8a00" },
            { "naq", "\u7d0d\u99ac\u6587" },
            { "type.nu.sora", "\u7d22\u6717\u6851\u670b\u6578\u5b57" },
            { "zza", "\u624e\u624e\u6587" },
            { "Tang", "\u897f\u590f\u6587" },
            { "IL", "\u4ee5\u8272\u5217" },
            { "Nbat", "\u7d0d\u5df4\u6cf0\u6587\u5b57" },
            { "IM", "\u66fc\u5cf6" },
            { "IN", "\u5370\u5ea6" },
            { "type.co.eor", "\u6b50\u6d32\u6392\u5e8f\u898f\u5247" },
            { "IO", "\u82f1\u5c6c\u5370\u5ea6\u6d0b\u9818\u5730" },
            { "IQ", "\u4f0a\u62c9\u514b" },
            { "IR", "\u4f0a\u6717" },
            { "IS", "\u51b0\u5cf6" },
            { "IT", "\u7fa9\u5927\u5229" },
            { "Zmth", "\u6578\u5b78\u7b26\u865f" },
            { "type.nu.thai", "\u6cf0\u6587\u6578\u5b57" },
            { "vro", "\u4f5b\u7f85\u6587" },
            { "guc", "\u74e6\u5c24\u6587" },
            { "%%POSIX", "\u96fb\u8166" },
            { "type.nu.beng", "\u5b5f\u52a0\u62c9\u6578\u5b57" },
            { "pfl", "\u666e\u6cd5\u723e\u8328\u5fb7\u6587" },
            { "type.nu.cyrl", "\u897f\u91cc\u723e\u6578\u5b57" },
            { "JE", "\u6fa4\u897f\u5cf6" },
            { "type.ca.islamic", "\u4f0a\u65af\u862d\u66c6" },
            { "Beng", metaValue_bn },
            { "JM", "\u7259\u8cb7\u52a0" },
            { "%%EKAVSK", "\u6613\u5361\u767c\u97f3\u585e\u723e\u7dad\u4e9e\u6587" },
            { "JO", "\u7d04\u65e6" },
            { "gur", "\u5f17\u62c9\u5f17\u62c9\u6587" },
            { "JP", "\u65e5\u672c" },
            { "%%1606NICT", "\u4e2d\u4e16\u7d00\u665a\u671f\u6cd5\u6587\uff08\u81f31606\u5e74\uff09" },
            { "ain", "\u963f\u4f0a\u52aa\u6587" },
            { "Mend", metaValue_men },
            { "guz", "\u53e4\u897f\u6587" },
            { "tog", "\u6771\u52a0\u6587\uff08\u5c3c\u4e9e\u85a9\uff09" },
            { "type.nu.knda", "\u574e\u90a3\u9054\u6578\u5b57" },
            { "Kali", "\u514b\u8036\u674e\u6587" },
            { "Sidd", "\u6089\u66c7\u6587\u5b57" },
            { "de_CH", "\u9ad8\u5730\u5fb7\u6587\uff08\u745e\u58eb\uff09" },
            { "type.co.phonetic", "\u767c\u97f3\u6392\u5e8f" },
            { "izh", "\u82f1\u683c\u91cc\u4e9e\u6587" },
            { "type.ca.buddhist", "\u4f5b\u66c6" },
            { "KE", "\u80af\u4e9e" },
            { "419", "\u62c9\u4e01\u7f8e\u6d32" },
            { "KG", "\u5409\u723e\u5409\u65af" },
            { "KH", "\u67ec\u57d4\u5be8" },
            { "KI", "\u5409\u91cc\u5df4\u65af" },
            { "KM", "\u845b\u6469" },
            { "Knda", metaValue_kn },
            { "KN", "\u8056\u514b\u91cc\u65af\u591a\u798f\u53ca\u5c3c\u7dad\u65af" },
            { "Zinh", "\u7e7c\u627f\u6587\u5b57\uff08Unicode\uff09" },
            { "KP", "\u5317\u97d3" },
            { "KR", "\u5357\u97d3" },
            { "Plrd", "\u67cf\u683c\u7406\u62fc\u97f3\u7b26" },
            { "KW", "\u79d1\u5a01\u7279" },
            { "tpi", "\u6258\u6bd4\u8f9b\u6587" },
            { "KY", "\u958b\u66fc\u7fa4\u5cf6" },
            { "KZ", "\u54c8\u85a9\u514b" },
            { "Cyrl", "\u65af\u62c9\u592b\u6587" },
            { "LA", "\u5bee\u570b" },
            { "LB", "\u9ece\u5df4\u5ae9" },
            { "phn", metaValue_phn },
            { "LC", "\u8056\u9732\u897f\u4e9e" },
            { "Cyrs", "\u897f\u91cc\u723e\u6587\uff08\u53e4\u6559\u6703\u65af\u62c9\u592b\u6587\u8b8a\u9ad4\uff09" },
            { "gwi", "\u572d\u5951\u6587" },
            { "%%LUNA1918", "\u4fc4\u7f85\u65af\u6587\u62fc\u5b57\uff081917\u5e74\u5f8c\uff09" },
            { "nds", "\u4f4e\u5730\u5fb7\u6587" },
            { "LI", "\u5217\u652f\u6566\u65af\u767b" },
            { "LK", "\u65af\u91cc\u862d\u5361" },
            { "akk", "\u963f\u5361\u5fb7\u6587" },
            { "cop", metaValue_cop },
            { "LR", "\u8cf4\u6bd4\u745e\u4e9e" },
            { "esu", "\u4e2d\u5c24\u76ae\u514b\u6587" },
            { "LS", "\u8cf4\u7d22\u6258" },
            { "Phlv", "\u5df4\u5217\u7dad\u6587\uff08\u66f8\u9ad4\uff09" },
            { "LT", "\u7acb\u9676\u5b9b" },
            { "LU", "\u76e7\u68ee\u5821" },
            { "LV", "\u62c9\u812b\u7dad\u4e9e" },
            { "Kana", "\u7247\u5047\u540d" },
            { "Sora", "\u7d22\u6717\u6851\u670b\u6587\u5b57" },
            { "LY", "\u5229\u6bd4\u4e9e" },
            { "lad", "\u62c9\u8fea\u8afe\u6587" },
            { "vun", "\u6eab\u820a\u6587" },
            { "akz", "\u963f\u62c9\u5df4\u99ac\u6587" },
            { "%%LAUKIKA", "\u50b3\u7d71\u68b5\u6587" },
            { "Mahj", metaValue_hi },
            { "lah", "\u62c9\u4ea8\u9054\u6587" },
            { "lag", "\u6717\u5409\u6587" },
            { "Thaa", "\u5854\u5b89\u90a3\u6587" },
            { "MA", "\u6469\u6d1b\u54e5" },
            { "MC", "\u6469\u7d0d\u54e5" },
            { "MD", "\u6469\u723e\u591a\u74e6" },
            { "Nshu", "\u5973\u66f8\u6587\u5b57" },
            { "ME", "\u8499\u7279\u5167\u54e5\u7f85" },
            { "MF", "\u6cd5\u5c6c\u8056\u99ac\u4e01" },
            { "lam", "\u862d\u5df4\u6587" },
            { "MG", "\u99ac\u9054\u52a0\u65af\u52a0" },
            { "Thai", metaValue_th },
            { "MH", "\u99ac\u7d39\u723e\u7fa4\u5cf6" },
            { "ale", "\u963f\u7559\u7533\u6587" },
            { "type.nu.vaii", "\u74e6\u4f0a\u6587\u6578\u5b57" },
            { "MK", "\u5317\u99ac\u5176\u9813" },
            { "type.nu.mathdbl", "\u6578\u5b78\u96d9\u91cd\u6578\u5b57" },
            { "ML", "\u99ac\u5229" },
            { "MM", "\u7dec\u7538" },
            { "MN", "\u8499\u53e4" },
            { "new", "\u5c3c\u74e6\u723e\u6587" },
            { "MO", "\u4e2d\u570b\u6fb3\u9580\u7279\u5225\u884c\u653f\u5340" },
            { "aln", "\u84cb\u683c\u963f\u723e\u5df4\u5c3c\u4e9e\u6587" },
            { "MP", "\u5317\u99ac\u5229\u5b89\u7d0d\u7fa4\u5cf6" },
            { "MQ", "\u99ac\u4e01\u5c3c\u514b" },
            { "MR", "\u8305\u5229\u5854\u5c3c\u4e9e" },
            { "MS", "\u8499\u54f2\u81d8" },
            { "MT", "\u99ac\u723e\u4ed6" },
            { "cps", "\u5361\u76ae\u8332\u6587" },
            { "type.m0.ungegn", "\u806f\u5408\u570b\u5730\u540d\u5c08\u5bb6\u7d44" },
            { "MU", "\u6a21\u91cc\u897f\u65af" },
            { "alt", "\u5357\u963f\u723e\u6cf0\u6587" },
            { "MV", "\u99ac\u723e\u5730\u592b" },
            { "MW", "\u99ac\u62c9\u5a01" },
            { "MX", "\u58a8\u897f\u54e5" },
            { "type.ca.japanese", "\u65e5\u672c\u66c6" },
            { "MY", "\u99ac\u4f86\u897f\u4e9e" },
            { "MZ", "\u83ab\u4e09\u6bd4\u514b" },
            { "Phli", "\u5df4\u5217\u7dad\u6587\uff08\u7891\u9298\u9ad4\uff09" },
            { "NA", "\u7d0d\u7c73\u6bd4\u4e9e" },
            { "202", "\u6492\u54c8\u62c9\u6492\u6c99\u6f20\u4ee5\u5357\u975e\u6d32" },
            { "type.ca.hebrew", "\u5e0c\u4f2f\u4f86\u66c6" },
            { "type.co.dictionary", "\u5b57\u5178\u6392\u5e8f" },
            { "NC", "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9e" },
            { "%%WADEGILE", "\u5a01\u59a5\u746a\u5f0f\u62fc\u97f3" },
            { "tru", "\u5716\u7f85\u5c24\u6587" },
            { "%%UCRCOR", "\u7d71\u4e00\u5eb7\u6c83\u723e\u6587\u4fee\u8a02\u62fc\u5b57" },
            { "NE", "\u5c3c\u65e5" },
            { "NF", "\u8afe\u798f\u514b\u5cf6" },
            { "NG", "\u5948\u53ca\u5229\u4e9e" },
            { "trv", "\u592a\u9b6f\u95a3\u6587" },
            { "Phlp", "\u5df4\u5217\u7dad\u6587\uff08\u8056\u8a69\u9ad4\uff09" },
            { "NI", "\u5c3c\u52a0\u62c9\u74dc" },
            { "Hmng", "\u694a\u677e\u9304\u82d7\u6587" },
            { "NL", "\u8377\u862d" },
            { "NO", "\u632a\u5a01" },
            { "NP", "\u5c3c\u6cca\u723e" },
            { "NR", "\u8afe\u9b6f" },
            { "tsd", "\u7279\u85a9\u514b\u5c3c\u6069\u6587" },
            { "Phnx", metaValue_phn },
            { "NU", "\u7d10\u57c3\u5cf6" },
            { "rof", "\u862d\u535a\u6587" },
            { "tsi", "\u6b3d\u897f\u5b89\u6587" },
            { "NZ", "\u7d10\u897f\u862d" },
            { "Merc", "\u9ea5\u7f85\u57c3\u6587\uff08\u66f2\u7dda\u5b57\u9ad4\uff09" },
            { "%%COLB1945", "1945 \u5e74\u5df4\u897f\u8461\u8404\u7259\u6587\u62fc\u5b57\u6a19\u6e96" },
            { "rom", "\u5409\u666e\u8cfd\u6587" },
            { "Mero", "\u9ea5\u7f85\u57c3\u6587" },
            { "crh", "\u571f\u8033\u5176\u6587\uff08\u514b\u91cc\u7c73\u4e9e\u534a\u5cf6\uff09" },
            { "ang", "\u53e4\u82f1\u6587" },
            { "OM", "\u963f\u66fc" },
            { "%%PETR1708", "\u4fc4\u7f85\u65af\u6587\u62fc\u5b57\uff081708 \u5e74\uff09" },
            { "anp", "\u6602\u52a0\u6587" },
            { "crs", "\u585e\u5e2d\u723e\u514b\u91cc\u5967\u723e\u6cd5\u6587" },
            { "Xpeo", metaValue_peo },
            { "type.nu.hmng", "\u5e15\u54c8\u82d7\u6578\u5b57" },
            { "PA", "\u5df4\u62ff\u99ac" },
            { "type.ca.islamic-civil", "\u4f0a\u65af\u862d\u6c11\u7528\u66c6" },
            { "csb", "\u5361\u8212\u5e03\u6587" },
            { "PE", "\u79d8\u9b6f" },
            { "ttt", "\u7a46\u65af\u6797\u5854\u7279\u6587" },
            { "PF", "\u6cd5\u5c6c\u73bb\u91cc\u5c3c\u897f\u4e9e" },
            { "PG", "\u5df4\u5e03\u4e9e\u7d10\u5e7e\u5167\u4e9e" },
            { "PH", "\u83f2\u5f8b\u8cd3" },
            { "PK", "\u5df4\u57fa\u65af\u5766" },
            { "PL", "\u6ce2\u862d" },
            { "ewo", "\u4f9d\u6c6a\u90fd\u6587" },
            { "PM", "\u8056\u76ae\u57c3\u8207\u5bc6\u514b\u9686\u7fa4\u5cf6" },
            { "PN", "\u76ae\u7279\u80af\u7fa4\u5cf6" },
            { "PR", "\u6ce2\u591a\u9ece\u5404" },
            { "Bali", metaValue_ban },
            { "PS", "\u5df4\u52d2\u65af\u5766\u81ea\u6cbb\u5340" },
            { "PT", "\u8461\u8404\u7259" },
            { "PW", "\u5e1b\u7409" },
            { "nia", "\u5c3c\u4e9e\u65af\u6587" },
            { "type.nu.greklow", "\u5c0f\u5beb\u5e0c\u81d8\u6578\u5b57" },
            { "PY", "\u5df4\u62c9\u572d" },
            { "tum", "\u5716\u59c6\u5e03\u5361\u6587" },
            { "Hebr", metaValue_he },
            { "QA", "\u5361\u9054" },
            { "%%SCOTLAND", "\u8607\u683c\u862d\u6a19\u6e96\u82f1\u6587" },
            { "jam", "\u7259\u8cb7\u52a0\u514b\u91cc\u5967\u723e\u82f1\u6587" },
            { "pms", "\u76ae\u57c3\u8499\u7279\u6587" },
            { "niu", "\u7d10\u57c3\u6587" },
            { "QO", "\u5927\u6d0b\u6d32\u908a\u7586\u7fa4\u5cf6" },
            { "ext", "\u57c3\u65af\u7279\u96f7\u99ac\u675c\u62c9\u6587" },
            { "lez", "\u5217\u8332\u5e72\u6587" },
            { "type.nu.ahom", "\u963f\u6d2a\u59c6\u6578\u5b57" },
            { "%%FONUPA", "UPA \u62fc\u97f3" },
            { "type.nu.takr", "\u5854\u5361\u91cc\u6578\u5b57" },
            { "tvl", "\u5410\u74e6\u9b6f\u6587" },
            { "Tavt", "\u50a3\u64d4\u6587" },
            { "%%SOTAV", "\u5361\u5e03\u4f5b\u5f97\u9c81\u80cc\u98a8\u7fa4\u5cf6\u65b9\u8a00" },
            { "001", "\u4e16\u754c" },
            { "002", "\u975e\u6d32" },
            { "njo", "\u963f\u6c83\u90a3\u52a0\u6587" },
            { "003", "\u5317\u7f8e\u6d32" },
            { "RE", "\u7559\u5c3c\u65fa" },
            { "005", "\u5357\u7f8e\u6d32" },
            { "lfn", "\u65b0\u5171\u540c\u8a9e\u8a00" },
            { "jbo", "\u908f\u8f2f\u6587" },
            { "pnt", "\u65c1\u72c4\u5e0c\u81d8\u6587" },
            { "Rjng", "\u62c9\u8b93\u6587" },
            { "009", "\u5927\u6d0b\u6d32" },
            { "%%SURSILV", "\u745e\u58eb\u8607\u745f\u74e6\u65b9\u8a00" },
            { "RO", "\u7f85\u99ac\u5c3c\u4e9e" },
            { "RS", "\u585e\u723e\u7dad\u4e9e" },
            { "Mroo", "\u8b2c\u6587" },
            { "RU", "\u4fc4\u7f85\u65af" },
            { "RW", "\u76e7\u5b89\u9054" },
            { "type.nu.talu", "\u65b0\u50a3\u4ec2\u6587\u6578\u5b57" },
            { "%%METELKO", "\u6885\u6cf0\u723e\u79d1\u5b57\u6bcd" },
            { "Ugar", metaValue_uga },
            { "Mani", "\u6469\u5c3c\u6559\u6587" },
            { "Khar", "\u5361\u7f85\u9808\u63d0\u6587" },
            { "SA", "\u6c99\u70cf\u5730\u963f\u62c9\u4f2f" },
            { "pon", "\u6ce2\u90a3\u8c9d\u6587" },
            { "Mand", "\u66fc\u5e95\u5b89\u6587" },
            { "SB", "\u7d22\u7f85\u9580\u7fa4\u5cf6" },
            { "twq", "\u5317\u6851\u6d77\u6587" },
            { "011", "\u897f\u975e" },
            { "SC", "\u585e\u5e2d\u723e" },
            { "SD", "\u8607\u4e39" },
            { "013", "\u4e2d\u7f8e" },
            { "SE", "\u745e\u5178" },
            { "014", "\u6771\u975e" },
            { "arc", "\u963f\u62c9\u7c73\u6587" },
            { "Loma", "\u6d1b\u99ac\u6587" },
            { "015", "\u5317\u975e" },
            { "SG", "\u65b0\u52a0\u5761" },
            { "SH", "\u8056\u8d6b\u52d2\u62ff\u5cf6" },
            { "type.lb.strict", "\u5f37\u5236\u63db\u884c\u6a23\u5f0f" },
            { "017", "\u4e2d\u975e" },
            { "SI", "\u65af\u6d1b\u7dad\u5c3c\u4e9e" },
            { "type.nu.mymrtlng", "\u7dec\u7538\u50a3\u65cf\u6578\u5b57" },
            { "018", "\u975e\u6d32\u5357\u90e8" },
            { "SJ", "\u632a\u5a01\u5c6c\u65af\u74e6\u5df4\u53ca\u5c16\u68c9" },
            { "Bamu", metaValue_bax },
            { "019", "\u7f8e\u6d32" },
            { "SK", "\u65af\u6d1b\u4f10\u514b" },
            { "Wole", "\u6c83\u96f7\u827e\u6587" },
            { "SL", "\u7345\u5b50\u5c71" },
            { "SM", "\u8056\u99ac\u5229\u8afe" },
            { "SN", "\u585e\u5167\u52a0\u723e" },
            { "SO", "\u7d22\u99ac\u5229\u4e9e" },
            { "arn", "\u99ac\u666e\u5207\u6587" },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "arp", "\u963f\u62c9\u5e15\u970d\u6587" },
            { "SR", "\u8607\u5229\u5357" },
            { "aro", "\u963f\u62c9\u5967\u7d0d\u6587" },
            { "SS", "\u5357\u8607\u4e39" },
            { "ST", "\u8056\u591a\u7f8e\u666e\u6797\u897f\u6bd4" },
            { "arq", "\u963f\u723e\u53ca\u5229\u4e9e\u963f\u62c9\u4f2f\u6587" },
            { "SV", "\u85a9\u723e\u74e6\u591a" },
            { "ars", "\u7d0d\u5409\u8fea\u963f\u62c9\u4f2f\u6587" },
            { "SX", "\u8377\u5c6c\u8056\u99ac\u4e01" },
            { "SY", "\u6558\u5229\u4e9e" },
            { "yao", "\u7464\u6587" },
            { "SZ", "\u53f2\u74e6\u5e1d\u5c3c" },
            { "arw", "\u963f\u62c9\u74e6\u514b\u6587" },
            { "arz", "\u57c3\u53ca\u963f\u62c9\u4f2f\u6587" },
            { "ary", "\u6469\u6d1b\u54e5\u963f\u62c9\u4f2f\u6587" },
            { "yap", "\u96c5\u6d66\u6587" },
            { "rtm", "\u7f85\u5716\u99ac\u5cf6\u6587" },
            { "TA", "\u7279\u91cc\u65af\u5766\u9054\u5eab\u5c3c\u4e9e\u7fa4\u5cf6" },
            { "asa", "\u963f\u8607\u6587" },
            { "type.ms.ussystem", "\u7f8e\u5236\u5ea6\u91cf\u55ae\u4f4d\u7cfb\u7d71" },
            { "021", "\u5317\u7f8e" },
            { "TC", "\u571f\u514b\u65af\u53ca\u958b\u79d1\u65af\u7fa4\u5cf6" },
            { "yav", "\u6d0b\u535e\u6587" },
            { "TD", "\u67e5\u5fb7" },
            { "Qaag", "\u4f50\u57fa\u6587" },
            { "TF", "\u6cd5\u5c6c\u5357\u90e8\u5c6c\u5730" },
            { "ase", "\u7f8e\u570b\u624b\u8a9e" },
            { "TG", "\u591a\u54e5" },
            { "TH", "\u6cf0\u570b" },
            { "TJ", "\u5854\u5409\u514b" },
            { "029", "\u52a0\u52d2\u6bd4\u6d77" },
            { "TK", "\u6258\u514b\u52de\u7fa4\u5cf6" },
            { "TL", "\u6771\u5e1d\u6c76" },
            { "ybb", "\u8036\u59c6\u5df4\u6587" },
            { "type.co.searchjl", "\u97d3\u6587\u5b50\u97f3\u6392\u5e8f" },
            { "TM", "\u571f\u5eab\u66fc" },
            { "%%BOONT", "\u5e03\u6069\u7279\u6797\u65b9\u8a00" },
            { "TN", "\u7a81\u5c3c\u897f\u4e9e" },
            { "TO", "\u6771\u52a0" },
            { "%%NULIK", "\u73fe\u4ee3\u6c83\u62c9\u666e\u514b\u6587" },
            { "TR", "\u571f\u8033\u5176" },
            { "TT", "\u5343\u91cc\u9054\u53ca\u6258\u5df4\u54e5" },
            { "TV", "\u5410\u74e6\u9b6f" },
            { "TW", "\u53f0\u7063" },
            { "ast", "\u963f\u65af\u5716\u91cc\u4e9e\u6587" },
            { "rue", "\u76e7\u68ee\u5c3c\u4e9e\u6587" },
            { "rug", "\u7f85\u7dad\u963f\u7d0d\u6587" },
            { "Orkh", "\u9102\u723e\u6e3e\u6587" },
            { "TZ", "\u5766\u5c1a\u5c3c\u4e9e" },
            { "nmg", "\u5938\u897f\u5967\u6587" },
            { "Zzzz", "\u672a\u77e5\u6587\u5b57" },
            { "Sind", metaValue_sd },
            { "UA", "\u70cf\u514b\u862d" },
            { "lij", "\u5229\u53e4\u91cc\u4e9e\u6587" },
            { "rup", "\u7f85\u99ac\u5c3c\u4e9e\u8a9e\u7cfb" },
            { "030", "\u6771\u4e9e" },
            { "tyv", "\u5716\u74e6\u6587" },
            { "sw_CD", "\u53f2\u74e6\u5e0c\u91cc\u6587\uff08\u525b\u679c\uff09" },
            { "034", "\u5357\u4e9e" },
            { "hai", "\u6d77\u9054\u6587" },
            { "035", "\u6771\u5357\u4e9e" },
            { "UG", "\u70cf\u5e72\u9054" },
            { "hak", "\u5ba2\u5bb6\u8a71" },
            { "type.co.pinyin", "\u62fc\u97f3\u6392\u5e8f" },
            { "039", "\u5357\u6b50" },
            { "Sinh", "\u932b\u862d\u6587" },
            { "UM", "\u7f8e\u570b\u672c\u571f\u5916\u5c0f\u5cf6\u5dbc" },
            { "liv", "\u5229\u4f0f\u5c3c\u4e9e\u6587" },
            { "UN", "\u806f\u5408\u570b" },
            { "US", "\u7f8e\u570b" },
            { "haw", "\u590f\u5a01\u5937\u6587" },
            { "%%1959ACAD", "\u767d\u4fc4\u7f85\u65af\u6587\uff08\u5b78\u8853\uff09" },
            { "type.co.gb2312han", "\u7c21\u9ad4\u4e2d\u6587\u6392\u5e8f - GB2312" },
            { "UY", "\u70cf\u62c9\u572d" },
            { "prg", "\u666e\u9b6f\u58eb\u6587" },
            { "UZ", "\u70cf\u8332\u5225\u514b" },
            { "tzm", "\u4e2d\u963f\u7279\u62c9\u65af\u5854\u99ac\u585e\u7279\u6587" },
            { "type.co.stroke", "\u7b46\u756b\u6392\u5e8f" },
            { "nnh", "\u6069\u7518\u6f8e\u6587" },
            { "VA", "\u68b5\u8482\u5ca1" },
            { "pro", "\u53e4\u666e\u7f85\u65fa\u65af\u6587" },
            { "VC", "\u8056\u6587\u68ee\u53ca\u683c\u745e\u90a3\u4e01" },
            { "VE", "\u59d4\u5167\u745e\u62c9" },
            { "VG", "\u82f1\u5c6c\u7dad\u4eac\u7fa4\u5cf6" },
            { "VI", "\u7f8e\u5c6c\u7dad\u4eac\u7fa4\u5cf6" },
            { "Soyo", "\u7d22\u6c38\u5e03\u6587\u5b57" },
            { "VN", "\u8d8a\u5357" },
            { "VU", "\u842c\u90a3\u675c" },
            { "Marc", metaValue_bo },
            { "nog", "\u8afe\u84cb\u6587" },
            { "rwk", "\u7f85\u74e6\u6587" },
            { "non", "\u53e4\u8afe\u723e\u65af\u6587" },
            { "053", "\u6fb3\u6d32\u8207\u7d10\u897f\u862d" },
            { "%%AREVMDA", "\u4e9e\u7f8e\u5c3c\u4e9e\u897f\u90e8" },
            { "054", "\u7f8e\u62c9\u5c3c\u897f\u4e9e" },
            { "WF", "\u74e6\u5229\u65af\u7fa4\u5cf6\u548c\u5bcc\u5716\u90a3\u7fa4\u5cf6" },
            { "type.co.traditional", "\u50b3\u7d71\u6392\u5e8f" },
            { "057", "\u5bc6\u514b\u7f85\u5c3c\u897f\u4e9e\u7fa4\u5cf6" },
            { "jgo", "\u6069\u683c\u59c6\u5df4\u6587" },
            { "lkt", "\u62c9\u79d1\u5854\u6587" },
            { "nov", "\u8afe\u7dad\u4e9e\u6587" },
            { "type.nu.finance", "\u91d1\u878d\u6578\u5b57" },
            { "avk", "\u79d1\u5854\u74e6\u6587" },
            { "%%HEPBURN", "\u5e73\u6587\u5f0f\u7f85\u99ac\u5b57" },
            { "type.co.compat", "\u820a\u5236\u6392\u5e8f" },
            { "wae", "\u74e6\u723e\u745f\u6587" },
            { "WS", "\u85a9\u6469\u4e9e" },
            { "Bass", metaValue_bas },
            { "type.nu.mtei", "\u66fc\u5c3c\u666e\u723e\u6578\u5b57" },
            { "wal", "\u74e6\u62c9\u83ab\u6587" },
            { "was", "\u74e6\u7d39\u6587" },
            { "XA", "\u507d\u5340\u57df" },
            { "war", "\u74e6\u745e\u6587" },
            { "XB", "\u507d\u6bd4\u8fea" },
            { "awa", "\u963f\u74e6\u6587" },
            { "061", "\u73bb\u91cc\u5c3c\u897f\u4e9e" },
            { "%%KSCOR", "\u6a19\u6e96\u62fc\u5beb" },
            { "XK", "\u79d1\u7d22\u6c83" },
            { "type.nu.brah", "\u5a46\u7f85\u7c73\u6578\u5b57" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u975e\u66f8\u5beb\u8a9e\u8a00" },
            { "Olck", metaValue_sat },
            { "wbp", "\u6c83\u76ae\u745e\u6587" },
            { "Batk", "\u5df4\u5854\u514b\u6587" },
            { "Blis", "\u5e03\u5217\u65af\u6587" },
            { "YE", "\u8449\u9580" },
            { "nqo", "\u66fc\u5fb7\u6587\u5b57 (N\u2019Ko)" },
            { "type.co.standard", "\u6a19\u6e96\u6392\u5e8f" },
            { "lmo", "\u502b\u5df4\u5e95\u6587" },
            { "Zanb", "\u672d\u90a3\u5df4\u672d\u723e\u6587\u5b57" },
            { "fan", "\u82b3\u65cf\u6587" },
            { "%%BALANKA", "\u5b89\u5c3c\u5df4\u6717\u5361\u65b9\u8a00" },
            { "%%ROZAJ", "\u96f7\u897f\u4e9e\u65b9\u8a00" },
            { "%%SUTSILV", "\u745e\u58eb\u8607\u5e0c\u74e6\u65b9\u8a00" },
            { "fat", "\u82b3\u8482\u6587" },
            { "Sgnw", "\u624b\u8a9e\u66f8\u5beb\u7b26\u865f" },
            { "YT", "\u99ac\u7d04\u7279\u5cf6" },
            { "type.nu.cham", "\u5360\u6587\u6578\u5b57" },
            { "ZA", "\u5357\u975e" },
            { "type.nu.sund", "\u5dfd\u4ed6\u6578\u5b57" },
            { "type.lb.loose", "\u5bec\u9b06\u63db\u884c\u6a23\u5f0f" },
            { "Deva", "\u5929\u57ce\u6587" },
            { "type.nu.geor", "\u55ac\u6cbb\u4e9e\u6578\u5b57" },
            { "type.co.zhuyin", "\u6ce8\u97f3\u6392\u5e8f" },
            { "Hira", "\u5e73\u5047\u540d" },
            { "ZM", "\u5c1a\u6bd4\u4e9e" },
            { "%%PINYIN", "\u6f22\u8a9e\u62fc\u97f3" },
            { "ZW", "\u8f9b\u5df4\u5a01" },
            { "ZZ", "\u672a\u77e5\u5340\u57df" },
            { "Runr", "\u53e4\u5317\u6b50\u6587\u5b57" },
            { "type.ms.metric", "\u516c\u5236" },
            { "type.ca.iso8601", "ISO 8601 \u570b\u969b\u66c6\u6cd5" },
            { "lol", "\u8292\u6208\u6587" },
            { "nso", "\u5317\u7d22\u6258\u6587" },
            { "type.nu.telu", "\u6cf0\u76e7\u56fa\u6578\u5b57" },
            { "lou", "\u8def\u6613\u65af\u5b89\u90a3\u514b\u91cc\u5967\u723e\u6587" },
            { "loz", "\u6d1b\u9f4a\u6587" },
            { "Nkgb", "\u7d0d\u897f\u683c\u5df4\u6587" },
            { "jmc", "\u99ac\u6070\u7f8e\u6587" },
            { "hif", "\u6590\u6fdf\u5370\u5730\u6587" },
            { "type.nu.hansfin", "\u5927\u5beb\u7c21\u9ad4\u4e2d\u6587\u6578\u5b57" },
            { "hil", "\u5e0c\u5229\u84cb\u8fb2\u6587" },
            { "type.nu.arabext", "\u963f\u62c9\u4f2f-\u5370\u5ea6\u64f4\u5145\u6578\u5b57" },
            { "nus", "\u52aa\u57c3\u723e\u6587" },
            { "dak", "\u9054\u79d1\u4ed6\u6587" },
            { "type.nu.fullwide", "\u5168\u5f62\u6578\u5b57" },
            { "hit", "\u8d6b\u68af\u6587" },
            { "dar", "\u9054\u723e\u683c\u74e6\u6587" },
            { "dav", "\u53f0\u5854\u6587" },
            { "Maya", "\u746a\u96c5\u8c61\u5f62\u6587\u5b57" },
            { "lrc", "\u5317\u76e7\u723e\u6587" },
            { "type.co.emoji", metaValue_Zsye },
            { "Copt", metaValue_cop },
            { "nwc", "\u53e4\u5c3c\u74e6\u723e\u6587" },
            { "udm", "\u70cf\u5fb7\u7a46\u723e\u7279\u6587" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "\u4f0a\u65af\u862d\u65b0\u6708\u66c6" },
            { "Limb", "\u6797\u4f48\u6587" },
            { "sad", "\u6851\u9054\u97cb\u6587" },
            { "type.nu.roman", "\u7f85\u99ac\u6578\u5b57" },
            { "sah", "\u96c5\u5eab\u7279\u6587" },
            { "type.nu.shrd", "\u590f\u62c9\u9054\u6578\u5b57" },
            { "ltg", "\u62c9\u7279\u52a0\u840a\u6587" },
            { "sam", "\u85a9\u746a\u5229\u4e9e\u963f\u62c9\u59c6\u6587" },
            { "Aghb", "\u9ad8\u52a0\u7d22\u963f\u723e\u5df4\u5c3c\u4e9e\u6587" },
            { "%%SCOUSE", "\u5229\u7269\u6d66\u65b9\u8a00" },
            { "saq", "\u85a9\u5e03\u9b6f\u6587" },
            { "sas", "\u6492\u6492\u514b\u6587" },
            { "sat", metaValue_sat },
            { "Tfng", "\u63d0\u975e\u7d0d\u6587" },
            { "saz", metaValue_saz },
            { "type.d0.npinyin", metaValue_key_nu },
            { "jpr", "\u7336\u592a\u6559-\u6ce2\u65af\u6587" },
            { "type.nu.native", "\u539f\u59cb\u6578\u5b57" },
            { "sba", "\u7518\u62dc\u6587" },
            { "Guru", "\u53e4\u9b6f\u7a46\u5947\u6587" },
            { "%%ALUKU", "\u963f\u9b6f\u5eab\u65b9\u8a00" },
            { "lua", "\u9b6f\u5df4\u9b6f\u9b6f\u4e9e\u6587" },
            { "%%BISCAYAN", "\u6bd4\u65af\u958b\u65b9\u8a00" },
            { "type.nu.tirh", "\u63d0\u723e\u80e1\u5854\u6578\u5b57" },
            { "type.d0.fwidth", "\u5168\u5f62" },
            { "sbp", "\u6851\u53e4\u6587" },
            { "lui", "\u8def\u6613\u585e\u8afe\u6587" },
            { "nyn", "\u5c3c\u63da\u79d1\u840a\u6587" },
            { "nym", "\u5c3c\u63da\u97cb\u9f4a\u6587" },
            { "lun", "\u76e7\u6069\u9054\u6587" },
            { "nyo", "\u5c3c\u5967\u56c9\u6587" },
            { "luo", "\u76e7\u5967\u6587" },
            { "fil", "\u83f2\u5f8b\u8cd3\u6587" },
            { "hmn", "\u5b5f\u6587" },
            { "del", "\u5fb7\u62c9\u74e6\u6587" },
            { "lus", "\u7c73\u4f50\u6587" },
            { "bal", "\u4ffe\u8def\u652f\u6587" },
            { "den", "\u65af\u62c9\u592b" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "type.nu.wara", "\u74e6\u862d\u9f4a\u5730\u6578\u5b57" },
            { "fit", "\u6258\u723e\u8a25\u82ac\u862d\u6587" },
            { "luy", "\u76e7\u96c5\u6587" },
            { "bar", "\u5df4\u4f10\u5229\u4e9e\u6587" },
            { "bas", metaValue_bas },
            { "bax", metaValue_bax },
            { "%%ABL1943", "1943 \u5e74\u62fc\u5b57\u6a19\u6e96" },
            { "jrb", "\u7336\u592a\u963f\u62c9\u4f2f\u6587" },
            { "nzi", "\u5c3c\u8332\u99ac\u6587" },
            { "sco", "\u8607\u683c\u862d\u6587" },
            { "scn", "\u897f\u897f\u91cc\u6587" },
            { "aa", "\u963f\u6cd5\u6587" },
            { "ab", "\u963f\u5e03\u54c8\u8332\u6587" },
            { "Aran", "\u6ce2\u65af\u9ad4" },
            { "bbc", "\u5df4\u5854\u514b\u6258\u5df4\u6587" },
            { "ae", "\u963f\u7dad\u65af\u5854\u6587" },
            { "af", "\u5357\u975e\u8377\u862d\u6587" },
            { "ak", "\u963f\u574e\u6587" },
            { "type.nu.cakm", "\u67e5\u514b\u99ac\u6578\u5b57" },
            { "bbj", "\u6208\u99ac\u62c9\u6587" },
            { "am", "\u963f\u59c6\u54c8\u62c9\u6587" },
            { "Arab", metaValue_ar },
            { "an", "\u963f\u62c9\u8ca2\u6587" },
            { "%%SOLBA", "\u96f7\u897f\u4e9e\u53f2\u6258\u7dad\u85a9\u65b9\u8a00" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u7247\u5047\u540d\u6216\u5e73\u5047\u540d" },
            { "as", "\u963f\u85a9\u59c6\u6587" },
            { "sdc", "\u85a9\u4e01\u5c3c\u4e9e-\u85a9\u85a9\u91cc\u6587" },
            { "Lina", "\u7dda\u6027\u6587\u5b57\uff08A\uff09" },
            { "av", "\u963f\u74e6\u723e\u6587" },
            { "Linb", "\u7dda\u6027\u6587\u5b57\uff08B\uff09" },
            { "sdh", "\u5357\u5eab\u5fb7\u6587" },
            { "ay", "\u827e\u99ac\u62c9\u6587" },
            { "az", "\u4e9e\u585e\u62dc\u7136\u6587" },
            { "Khoj", "\u514b\u5409\u5947\u6587\u5b57" },
            { "%%OSOJS", "\u96f7\u897f\u4e9e\u6b50\u897f\u4e9e\u67ef\u65b9\u8a00" },
            { "ba", "\u5df4\u4ec0\u5580\u723e\u6587" },
            { "type.co.unihan", "\u90e8\u9996\u7b46\u756b\u6392\u5e8f" },
            { "be", "\u767d\u4fc4\u7f85\u65af\u6587" },
            { "bg", "\u4fdd\u52a0\u5229\u4e9e\u6587" },
            { "bi", "\u6bd4\u65af\u62c9\u99ac\u6587" },
            { "type.nu.java", "\u722a\u54c7\u6587\u6578\u5b57" },
            { "bm", "\u73ed\u5df4\u62c9\u6587" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u591a\u683c\u91cc\u5e03\u6587" },
            { "br", "\u5e03\u5217\u5854\u5c3c\u6587" },
            { "Bhks", metaValue_sa },
            { "bs", "\u6ce2\u58eb\u5c3c\u4e9e\u6587" },
            { "see", "\u585e\u8a25\u5361\u6587" },
            { "Mymr", metaValue_my },
            { "sei", "\u745f\u91cc\u6587" },
            { "type.nu.laoo", "\u5bee\u570b\u6578\u5b57" },
            { "seh", "\u8cfd\u7d0d\u6587" },
            { "Nkoo", "\u897f\u975e\u66f8\u9762\u8a9e\u8a00 (N\u2019Ko)" },
            { "sel", "\u585e\u723e\u5eab\u666e\u6587" },
            { "ca", "\u52a0\u6cf0\u862d\u6587" },
            { "ses", "\u6771\u6851\u6d77\u6587" },
            { "ce", "\u8eca\u81e3\u6587" },
            { "ch", "\u67e5\u83ab\u6d1b\u6587" },
            { "%%REVISED", "\u5df2\u4fee\u8a02\u7684\u62fc\u5b57\u5b78" },
            { "co", "\u79d1\u897f\u5609\u6587" },
            { "Orya", metaValue_or },
            { "cr", "\u514b\u91cc\u6587" },
            { "cs", "\u6377\u514b\u6587" },
            { "cu", "\u5b97\u6559\u65af\u62c9\u592b\u6587" },
            { "yrl", "\u5948\u6069\u52a0\u5716\u6587" },
            { "cv", "\u695a\u74e6\u4ec0\u6587" },
            { "cy", "\u5a01\u723e\u65af\u6587" },
            { "type.nu.ethi", "\u8863\u7d22\u6bd4\u4e9e\u6578\u5b57" },
            { "Yiii", "\u5f5e\u6587" },
            { "da", "\u4e39\u9ea5\u6587" },
            { "de", "\u5fb7\u6587" },
            { "type.cf.standard", "\u6a19\u6e96\u8ca8\u5e63\u683c\u5f0f" },
            { "bej", "\u8c9d\u624e\u6587" },
            { "din", "\u4e01\u5361\u6587" },
            { "jut", "\u65e5\u5fb7\u862d\u6587" },
            { "Bugi", metaValue_bug },
            { "bem", "\u5225\u59c6\u5df4\u6587" },
            { "sga", "\u53e4\u611b\u723e\u862d\u6587" },
            { "type.nu.mong", "\u8499\u53e4\u6578\u5b57" },
            { "dv", "\u8fea\u7dad\u897f\u6587" },
            { "bew", "\u8c9d\u5854\u7dad\u6587" },
            { "dz", "\u5b97\u5361\u6587" },
            { "bez", "\u8c9d\u7d0d\u6587" },
            { "type.ca.chinese", "\u8fb2\u66c6" },
            { "lzh", "\u6587\u8a00\u6587" },
            { "Lisu", "\u6817\u50f3\u6587" },
            { "dje", "\u624e\u723e\u99ac\u6587" },
            { "sgs", "\u85a9\u83ab\u5409\u5e0c\u4e9e\u6587" },
            { "type.nu.grek", "\u5e0c\u81d8\u6578\u5b57" },
            { "ee", "\u57c3\u7dad\u6587" },
            { "bfd", "\u5bcc\u7279\u6587" },
            { "type.lb.normal", "\u4e00\u822c\u63db\u884c\u6a23\u5f0f" },
            { "ro_MD", "\u6469\u723e\u591a\u74e6\u6587" },
            { "el", metaValue_el },
            { "en", "\u82f1\u6587" },
            { "eo", "\u4e16\u754c\u6587" },
            { "bfq", "\u5df4\u9054\u52a0\u6587" },
            { "lzz", "\u62c9\u8332\u6587" },
            { "type.co.big5han", "\u7e41\u9ad4\u4e2d\u6587\u6392\u5e8f - Big5" },
            { "es", "\u897f\u73ed\u7259\u6587" },
            { "et", "\u611b\u6c99\u5c3c\u4e9e\u6587" },
            { "Hanb", "\u6a19\u4e0a\u6ce8\u97f3\u7b26\u865f\u7684\u6f22\u5b57" },
            { "eu", "\u5df4\u65af\u514b\u6587" },
            { "Buhd", "\u5e03\u5e0c\u5fb7\u6587" },
            { "Hang", "\u97d3\u6587\u5b57" },
            { "Samr", "\u6492\u99ac\u5229\u4e9e\u6587" },
            { "shi", "\u5e0c\u723e\u54c8\u6587" },
            { "hsb", "\u4e0a\u7d22\u5e03\u6587" },
            { "Hani", "\u6f22\u5b57" },
            { "%%ULSTER", "\u611b\u723e\u862d\u963f\u723e\u65af\u7279\u65b9\u8a00" },
            { "shn", "\u64a3\u6587" },
            { "Hano", "\u54c8\u52aa\u8afe\u6587" },
            { "fa", "\u6ce2\u65af\u6587" },
            { "Hans", "\u7c21\u9ad4" },
            { "type.nu.latn", "\u963f\u62c9\u4f2f\u6578\u5b57" },
            { "Hant", "\u7e41\u9ad4" },
            { "ff", metaValue_ff },
            { "shu", "\u963f\u62c9\u4f2f\u6587\uff08\u67e5\u5fb7\uff09" },
            { "hsn", "\u6e58\u8a9e" },
            { "fi", "\u82ac\u862d\u6587" },
            { "fj", "\u6590\u6fdf\u6587" },
            { "fon", "\u8c50\u6587" },
            { "bgn", "\u897f\u4ffe\u8def\u652f\u6587" },
            { "yue", "\u7cb5\u8a9e" },
            { "fo", "\u6cd5\u7f85\u6587" },
            { "type.m0.bgn", "\u7f8e\u570b\u5730\u540d\u59d4\u54e1\u6703" },
            { "umb", "\u59c6\u672c\u675c\u6587" },
            { "fr", "\u6cd5\u6587" },
            { "sid", "\u5e0c\u9054\u6469\u6587" },
            { "fy", "\u897f\u5f17\u91cc\u897f\u4e9e\u6587" },
            { "ga", "\u611b\u723e\u862d\u6587" },
            { "gd", "\u8607\u683c\u862d\u84cb\u723e\u6587" },
            { "gl", "\u52a0\u5229\u897f\u4e9e\u6587" },
            { "Gonm", metaValue_gon },
            { "gn", "\u74dc\u62c9\u5c3c\u6587" },
            { "bho", "\u535a\u5091\u666e\u723e\u6587" },
            { "und", "\u672a\u77e5\u8a9e\u8a00" },
            { "type.ca.ethiopic-amete-alem", "\u8863\u7d22\u6bd4\u4e9e\u66c6 (Amete Alem)" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u4f0a\u65af\u862d\u5929\u6587\u66c6" },
            { "gv", "\u66fc\u5cf6\u6587" },
            { "type.nu.osma", "\u5967\u65af\u66fc\u4e9e\u6578\u5b57" },
            { "ha", "\u8c6a\u6492\u6587" },
            { "he", metaValue_he },
            { "hi", metaValue_hi },
            { "hup", "\u80e1\u5e15\u6587" },
            { "bik", "\u6bd4\u79d1\u723e\u6587" },
            { "bin", "\u6bd4\u5c3c\u6587" },
            { "ho", "\u897f\u91cc\u83ab\u5716\u571f\u6587" },
            { "hr", "\u514b\u7f85\u57c3\u897f\u4e9e\u6587" },
            { "ht", "\u6d77\u5730\u6587" },
            { "hu", "\u5308\u7259\u5229\u6587" },
            { "hy", metaValue_hy },
            { "hz", "\u8d6b\u96f7\u7f85\u6587" },
            { "frc", "\u5361\u771f\u6cd5\u6587" },
            { "%%FONIPA", "IPA \u62fc\u97f3" },
            { "ia", "\u570b\u969b\u6587" },
            { "Jamo", "\u97d3\u6587\u5b57\u6bcd" },
            { "id", "\u5370\u5c3c\u6587" },
            { "type.nu.tibt", "\u897f\u85cf\u6578\u5b57" },
            { "ie", "\u570b\u969b\u6587\uff08E\uff09" },
            { "ig", "\u4f0a\u5e03\u6587" },
            { "ii", "\u56db\u5ddd\u5f5d\u6587" },
            { "frm", "\u4e2d\u53e4\u6cd5\u6587" },
            { "%%RUMGR", "\u7f85\u66fc\u4ec0\u6587" },
            { "%%AO1990", "1990 \u5e74\u8461\u8a9e\u66f8\u5beb\u5354\u8b70\u7684\u62fc\u5beb" },
            { "ik", "\u4f9d\u5974\u76ae\u7dad\u514b\u6587" },
            { "fro", "\u53e4\u6cd5\u6587" },
            { "frp", "\u6cd5\u862d\u514b-\u666e\u7f85\u65fa\u65af\u6587" },
            { "io", "\u4f0a\u591a\u6587" },
            { "frs", "\u6771\u5f17\u91cc\u897f\u4e9e\u6587" },
            { "bjn", "\u73ed\u4e9e\u723e\u6587" },
            { "frr", "\u5317\u5f17\u91cc\u897f\u4e9e\u6587" },
            { "is", "\u51b0\u5cf6\u6587" },
            { "it", "\u7fa9\u5927\u5229\u6587" },
            { "iu", "\u56e0\u7d10\u7279\u6587" },
            { "sli", "\u4e0b\u897f\u5229\u897f\u4e9e\u6587" },
            { "%%HOGNORSK", "\u9ad8\u5730\u632a\u5a01\u6587" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "\u53e4\u5357\u963f\u62c9\u4f2f\u6587" },
            { "Sara", "\u6c99\u62c9\u5824\u6587" },
            { "doi", "\u591a\u683c\u4f86\u6587" },
            { "sly", "\u585e\u62c9\u4e9e\u6587" },
            { "type.nu.lepc", "\u897f\u7d0d\u6587\u6578\u5b57" },
            { "bkm", "\u5eb7\u59c6\u6587" },
            { "sma", "\u5357\u85a9\u7c73\u6587" },
            { "jv", metaValue_jv },
            { "Shaw", "\u7c2b\u67cf\u7d0d\u5b57\u7b26" },
            { "%%BAUDDHA", "\u4f5b\u6559\u6df7\u5408\u68b5\u6587" },
            { "mad", "\u99ac\u90fd\u62c9\u6587" },
            { "smj", "\u9b6f\u52d2\u85a9\u7c73\u6587" },
            { "mag", "\u99ac\u52a0\u4f0a\u6587" },
            { "maf", "\u99ac\u6cd5\u6587" },
            { "mai", metaValue_mai },
            { "smn", "\u4f0a\u7d0d\u91cc\u85a9\u7c73\u6587" },
            { "ka", metaValue_ka },
            { "bla", "\u932b\u514b\u932b\u5361\u6587" },
            { "mak", "\u671b\u52a0\u932b\u6587" },
            { "wuu", "\u5433\u8a9e" },
            { "sms", "\u65af\u79d1\u7279\u85a9\u7c73\u6587" },
            { "man", "\u66fc\u4e01\u54e5\u6587" },
            { "kg", "\u525b\u679c\u6587" },
            { "Goth", "\u6b4c\u5fb7\u6587" },
            { "ki", "\u5409\u5eab\u5c24\u6587" },
            { "mas", "\u99ac\u8cfd\u6587" },
            { "kj", "\u5ee3\u4e9e\u99ac\u6587" },
            { "kk", "\u54c8\u85a9\u514b\u6587" },
            { "kl", "\u683c\u9675\u862d\u6587" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u5361\u52aa\u91cc\u6587" },
            { "ks", "\u5580\u4ec0\u7c73\u723e\u6587" },
            { "Cirt", "\u8272\u65af\u6587" },
            { "Lepc", "\u96f7\u5e03\u67e5\u6587" },
            { "Avst", "\u963f\u7dad\u65af\u9640\u6587" },
            { "ku", "\u5eab\u5fb7\u6587" },
            { "kv", "\u79d1\u7c73\u6587" },
            { "kw", "\u5eb7\u74e6\u8033\u6587" },
            { "ky", "\u5409\u723e\u5409\u65af\u6587" },
            { "snk", "\u7d22\u5c3c\u57fa\u6587" },
            { "Mult", "\u6728\u723e\u5766\u6587" },
            { "la", metaValue_la },
            { "Hatr", "\u54c8\u7279\u62c9\u6587" },
            { "lb", "\u76e7\u68ee\u5821\u6587" },
            { "type.nu.mlym", "\u99ac\u4f86\u4e9e\u62c9\u59c6\u6578\u5b57" },
            { "lg", "\u5e72\u9054\u6587" },
            { "Roro", "\u6717\u683c\u6717\u683c\u8c61\u5f62\u6587" },
            { "li", "\u6797\u5821\u6587" },
            { "Tibt", "\u897f\u85cf\u6587" },
            { "ln", "\u6797\u52a0\u62c9\u6587" },
            { "fur", "\u5f17\u7559\u5229\u6587" },
            { "lo", "\u5bee\u6587" },
            { "type.ms.uksystem", "\u82f1\u5236\u5ea6\u91cf\u55ae\u4f4d\u7cfb\u7d71" },
            { "type.nu.lana", "\u8001\u50a3\u6587\u6578\u5b57" },
            { "lt", "\u7acb\u9676\u5b9b\u6587" },
            { "lu", "\u9b6f\u5df4\u52a0\u4e39\u52a0\u6587" },
            { "lv", "\u62c9\u812b\u7dad\u4e9e\u6587" },
            { "sog", "\u7d22\u683c\u5e95\u4e9e\u7d0d\u6587" },
            { "ListCompositionPattern", "{0}\uff0c{1}" },
            { "mg", "\u99ac\u9054\u52a0\u65af\u52a0\u6587" },
            { "mh", "\u99ac\u7d39\u723e\u6587" },
            { "type.co.ducet", "\u9810\u8a2d Unicode \u6392\u5e8f" },
            { "mi", "\u6bdb\u5229\u6587" },
            { "mk", "\u99ac\u5176\u9813\u6587" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", metaValue_mr },
            { "ms", "\u99ac\u4f86\u6587" },
            { "mt", "\u99ac\u723e\u4ed6\u6587" },
            { "my", metaValue_my },
            { "Saur", metaValue_saz },
            { "Armn", metaValue_hy },
            { "mdf", "\u83ab\u514b\u6c99\u6587" },
            { "mde", "\u99ac\u5df4\u6587" },
            { "dsb", "\u4e0b\u7d22\u5e03\u6587" },
            { "Armi", "\u7687\u5ba4\u4e9e\u7f8e\u5c3c\u4e9e\u6587" },
            { "na", "\u8afe\u9b6f\u6587" },
            { "type.co.search", "\u4e00\u822c\u7528\u9014\u641c\u5c0b" },
            { "nb", "\u5df4\u514b\u6469\u632a\u5a01\u6587" },
            { "nd", "\u5317\u5730\u7562\u5217\u6587" },
            { "ne", "\u5c3c\u6cca\u723e\u6587" },
            { "ng", "\u6069\u6771\u52a0\u6587" },
            { "mdr", "\u66fc\u9054\u6587" },
            { "nl", "\u8377\u862d\u6587" },
            { "nn", "\u8010\u8afe\u65af\u514b\u632a\u5a01\u6587" },
            { "no", "\u632a\u5a01\u6587" },
            { "nr", "\u5357\u5730\u7562\u5217\u6587" },
            { "type.nu.modi", "\u83ab\u7b1b\u6578\u5b57" },
            { "Osge", metaValue_osa },
            { "nv", "\u7d0d\u74e6\u970d\u6587" },
            { "kaa", "\u5361\u62c9\u5361\u723e\u5e15\u514b\u6587" },
            { "ny", "\u5c3c\u63da\u8cc8\u6587" },
            { "kac", "\u5361\u7434\u6587" },
            { "kab", "\u5361\u6bd4\u723e\u6587" },
            { "%%POLYTON", "\u5e0c\u81d8\u6587\u591a\u8abf\u6b63\u5b57\u6cd5" },
            { "oc", "\u5967\u514b\u897f\u5766\u6587" },
            { "kaj", "\u5361\u6377\u6587" },
            { "kam", "\u5361\u59c6\u5df4\u6587" },
            { "men", metaValue_men },
            { "%%EMODENG", "\u65e9\u671f\u73fe\u4ee3\u82f1\u8a9e" },
            { "oj", "\u5967\u6770\u5e03\u74e6\u6587" },
            { "mer", "\u6885\u9b6f\u6587" },
            { "type.nu.armn", "\u4e9e\u7f8e\u5c3c\u4e9e\u6578\u5b57" },
            { "om", "\u5967\u7f85\u83ab\u6587" },
            { "kaw", "\u5361\u5a01\u6587" },
            { "dtp", "\u4e2d\u90e8\u675c\u9806\u6587" },
            { "Modi", metaValue_mr },
            { "or", metaValue_or },
            { "os", "\u5967\u585e\u63d0\u6587" },
            { "%%ALALC97", "\u7f8e\u570b\u570b\u6703\u5716\u66f8\u9928\u6a19\u6e96\u65b9\u6848\u7f85\u99ac\u5316\uff081997\u5e74\u7248\uff09" },
            { "bpy", "\u6bd4\u4ec0\u5974\u666e\u840a\u5229\u4e9e\u6587" },
            { "kbd", "\u5361\u5df4\u723e\u9054\u6587" },
            { "mfe", "\u514b\u91cc\u5967\u6587\uff08\u6a21\u91cc\u897f\u65af\uff09" },
            { "srn", "\u8607\u62c9\u5357\u6771\u588e\u6587" },
            { "pa", "\u65c1\u906e\u666e\u6587" },
            { "dua", "\u675c\u4e9e\u62c9\u6587" },
            { "srr", "\u585e\u96f7\u723e\u6587" },
            { "%%LIPAW", "\u96f7\u897f\u4e9e\u5229\u6ce2\u74e6\u65b9\u8a00" },
            { "kbl", "\u5361\u5ff5\u5e03\u6587" },
            { "pi", "\u5df4\u5229\u6587" },
            { "bqi", "\u5df4\u8d6b\u8482\u4e9e\u91cc\u6587" },
            { "pl", "\u6ce2\u862d\u6587" },
            { "dum", "\u4e2d\u53e4\u8377\u862d\u6587" },
            { "type.nu.saur", "\u7d22\u62c9\u4ec0\u7279\u62c9\u6587\u6578\u5b57" },
            { "type.ca.dangi", "\u6a80\u7d00\u66c6" },
            { "%%VALLADER", "\u745e\u58eb\u74e6\u52d2\u5fb7\u65b9\u8a00" },
            { "ps", "\u666e\u4ec0\u5716\u6587" },
            { "pt", "\u8461\u8404\u7259\u6587" },
            { "mga", "\u4e2d\u53e4\u611b\u723e\u862d\u6587" },
            { "key.co", "\u6392\u5e8f" },
            { "%%BOHORIC", "\u6ce2\u8d6b\u529b\u5b57\u6bcd" },
            { "kcg", "\u5361\u5854\u5e03\u6587" },
            { "mgh", "\u99ac\u5938\u6587" },
            { "key.cf", "\u8ca8\u5e63\u683c\u5f0f" },
            { "type.nu.nkoo", "\u66fc\u5fb7\u6578\u5b57" },
            { "bra", "\u5e03\u62c9\u6770\u6587" },
            { "key.ca", "\u66c6\u6cd5" },
            { "%%JAUER", "\u7c73\u8332\u6cf0\u723e\u65b9\u8a00" },
            { "Laoo", "\u5bee\u570b\u6587" },
            { "%%SURMIRAN", "\u745e\u58eb\u8607\u9081\u62c9\u65b9\u8a00" },
            { "mgo", "\u7f8e\u5854\u6587" },
            { "type.hc.h23", "24 \u5c0f\u6642\u5236 (0\u201323)" },
            { "type.hc.h24", "24 \u5c0f\u6642\u5236 (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "brh", "\u5e03\u62c9\u7dad\u6587" },
            { "type.nu.mymr", "\u7dec\u7538\u6578\u5b57" },
            { "qu", "\u84cb\u695a\u74e6\u6587" },
            { "zap", "\u85a9\u6ce2\u7279\u514b\u6587" },
            { "brx", "\u535a\u591a\u6587" },
            { "Lana", "\u85cd\u62ff\u6587" },
            { "kde", "\u99ac\u5b54\u5fb7\u6587" },
            { "%%VAIDIKA", "\u5420\u9640\u68b5\u6587" },
            { "stq", "\u6c99\u7279\u83f2\u58eb\u862d\u6587" },
            { "Ethi", "\u8863\u7d22\u6bd4\u4e9e\u6587" },
            { "%%JYUTPING", "\u9999\u6e2f\u8a9e\u8a00\u5b78\u5b78\u6703\u7cb5\u8a9e\u62fc\u97f3" },
            { "type.hc.h12", "12 \u5c0f\u6642\u5236 (1\u201312)" },
            { "type.hc.h11", "12 \u5c0f\u6642\u5236 (0\u201311)" },
            { "rm", "\u7f85\u66fc\u65af\u6587" },
            { "rn", "\u9686\u8fea\u6587" },
            { "key.cu", "\u8ca8\u5e63" },
            { "ro", "\u7f85\u99ac\u5c3c\u4e9e\u6587" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "\u6b50\u8fea\u4e9e\u6578\u5b57" },
            { "type.nu.hanidec", "\u4e2d\u6587\u5341\u9032\u4f4d\u6578\u5b57" },
            { "ru", "\u4fc4\u6587" },
            { "bss", "\u963f\u5eab\u8272\u6587" },
            { "rw", "\u76e7\u5b89\u9054\u6587" },
            { "zbl", "\u5e03\u5217\u65af\u7b26\u865f" },
            { "kea", "\u5361\u5e03\u5a01\u723e\u7b2c\u6587" },
            { "mic", "\u7c73\u514b\u99ac\u514b\u6587" },
            { "suk", "\u8607\u5eab\u99ac\u6587" },
            { "Dupl", "\u675c\u666e\u6d1b\u4f0a\u901f\u8a18" },
            { "sa", metaValue_sa },
            { "%%UCCOR", "\u7d71\u4e00\u5eb7\u6c83\u723e\u6587\u62fc\u5b57" },
            { "sc", "\u6492\u4e01\u6587" },
            { "sus", "\u8607\u8607\u6587" },
            { "sd", metaValue_sd },
            { "se", "\u5317\u85a9\u7c73\u6587" },
            { "min", "\u7c73\u5357\u5361\u5821\u6587" },
            { "sg", "\u6851\u6208\u6587" },
            { "sh", "\u585e\u723e\u7dad\u4e9e\u514b\u7f85\u57c3\u897f\u4e9e\u6587" },
            { "ken", "\u80af\u63da\u6587" },
            { "si", "\u50e7\u4f3d\u7f85\u6587" },
            { "sux", "\u8607\u7f8e\u6587" },
            { "sk", "\u65af\u6d1b\u4f10\u514b\u6587" },
            { "sl", "\u65af\u6d1b\u7dad\u5c3c\u4e9e\u6587" },
            { "Gran", "\u683c\u862d\u4ed6\u6587\u5b57" },
            { "sm", "\u85a9\u6469\u4e9e\u6587" },
            { "sn", "\u7d39\u7d0d\u6587" },
            { "so", "\u7d22\u99ac\u5229\u6587" },
            { "type.nu.arab", "\u963f\u62c9\u4f2f-\u5370\u5ea6\u6578\u5b57" },
            { "sq", "\u963f\u723e\u5df4\u5c3c\u4e9e\u6587" },
            { "sr", "\u585e\u723e\u7dad\u4e9e\u6587" },
            { "ListKeyTypePattern", "{0}\uff1a{1}" },
            { "ss", "\u65af\u74e6\u7279\u6587" },
            { "type.cf.account", "\u6703\u8a08\u8ca8\u5e63\u683c\u5f0f" },
            { "Java", metaValue_jv },
            { "st", "\u585e\u7d22\u6258\u6587" },
            { "su", metaValue_su },
            { "%%NEDIS", "\u90a3\u63d0\u677e\u5c3c\u65b9\u8a00" },
            { "sv", "\u745e\u5178\u6587" },
            { "sw", "\u53f2\u74e6\u5e0c\u91cc\u6587" },
            { "type.nu.hantfin", "\u5927\u5beb\u7e41\u9ad4\u4e2d\u6587\u6578\u5b57" },
            { "ibb", "\u4f0a\u6bd4\u6bd4\u5967\u6587" },
            { "iba", "\u4f0a\u73ed\u6587" },
            { "ta", metaValue_ta },
            { "142", "\u4e9e\u6d32" },
            { "bua", "\u5e03\u91cc\u963f\u7279\u6587" },
            { "143", "\u4e2d\u4e9e" },
            { "te", metaValue_te },
            { "145", "\u897f\u4e9e" },
            { "tg", "\u5854\u5409\u514b\u6587" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "\u63d0\u683c\u5229\u5c3c\u4e9e\u6587" },
            { "kfo", "\u79d1\u7f85\u6587" },
            { "tk", "\u571f\u5eab\u66fc\u6587" },
            { "tl", "\u5854\u52a0\u8def\u65cf\u6587" },
            { "tn", "\u585e\u8332\u74e6\u7d0d\u6587" },
            { "to", "\u6771\u52a0\u6587" },
            { "bum", "\u5e03\u9b6f\u6587" },
            { "dyo", "\u6731\u62c9\u6587" },
            { "type.nu.jpan", "\u5c0f\u5beb\u65e5\u6587\u6578\u5b57" },
            { "tr", "\u571f\u8033\u5176\u6587" },
            { "Cakm", metaValue_ccp },
            { "ts", "\u7279\u677e\u52a0\u6587" },
            { "swb", "\u845b\u6469\u6587" },
            { "tt", "\u97c3\u977c\u6587" },
            { "dyu", "\u8fea\u5c24\u62c9\u6587" },
            { "tw", "\u7279\u5a01\u6587" },
            { "ty", "\u5927\u6eaa\u5730\u6587" },
            { "%%BISKE", "\u8056\u55ac\u6cbb/\u6bd4\u62c9\u65b9\u8a00" },
            { "150", "\u6b50\u6d32" },
            { "151", "\u6771\u6b50" },
            { "type.nu.mathsanb", "\u6578\u5b78\u7121\u896f\u7dda\u7c97\u9ad4\u6578\u5b57" },
            { "154", "\u5317\u6b50" },
            { "dzg", "\u9054\u85a9\u6587" },
            { "155", "\u897f\u6b50" },
            { "ug", "\u7dad\u543e\u723e\u6587" },
            { "Kore", metaValue_ko },
            { "Ital", "\u53e4\u610f\u5927\u5229\u6587" },
            { "kgp", "\u574e\u525b\u6587" },
            { "Zyyy", "\u4e00\u822c\u6587\u5b57" },
            { "uk", "\u70cf\u514b\u862d\u6587" },
            { "zea", "\u897f\u862d\u6587" },
            { "type.ca.coptic", "\u79d1\u666e\u7279\u66c6" },
            { "ur", "\u70cf\u90fd\u6587" },
            { "%%1994", "\u6a19\u6e96\u96f7\u897f\u4e9e\u62fc\u5b57" },
            { "xal", "\u5361\u723e\u6885\u514b\u6587" },
            { "zen", "\u6fa4\u7d0d\u52a0\u6587" },
            { "uz", "\u70cf\u8332\u5225\u514b\u6587" },
            { "kha", "\u5361\u897f\u6587" },
            { "%%1996", "1996 \u5e74\u7684\u5fb7\u8a9e\u62fc\u5b57\u5b78" },
            { "nds_NL", "\u4f4e\u5730\u85a9\u514b\u905c\u6587" },
            { "Sylo", "\u5e0c\u6d1b\u5f1f\u7d0d\u683c\u91cc\u6587" },
            { "ve", "\u6eab\u9054\u6587" },
            { "Wara", "\u74e6\u90ce\u5947\u8482\u6587\u5b57" },
            { "type.ca.roc", "\u570b\u66c6" },
            { "vi", "\u8d8a\u5357\u6587" },
            { "kho", "\u548c\u95d0\u6587" },
            { "khq", "\u897f\u6851\u6d77\u6587" },
            { "key.hc", "\u6642\u9593\u9031\u671f\uff0812 \u5c0f\u6642\u5236\u8207 24 \u5c0f\u6642\u5236\uff09" },
            { "%%TARASK", "\u767d\u4fc4\u7f85\u65af\u6587\u50b3\u7d71\u62fc\u5b57" },
            { "vo", "\u6c83\u62c9\u666e\u514b\u6587" },
            { "khw", "\u79d1\u74e6\u6587" },
            { "syc", "\u53e4\u6558\u5229\u4e9e\u6587" },
            { "type.nu.mathsans", "\u6578\u5b78\u7121\u896f\u7dda\u6578\u5b57" },
            { "Osma", "\u6b50\u65af\u66fc\u4e9e\u6587" },
            { "quc", "\u57fa\u5207\u6587" },
            { "type.nu.gonm", "\u99ac\u85a9\u62c9\u59c6\u8ca2\u5730\u6578\u5b57" },
            { "qug", "\u6b3d\u535a\u62c9\u7d22\u6d77\u862d\u84cb\u4e18\u4e9e\u6587" },
            { "Newa", "Vote \u5c3c\u74e6\u723e\u6587" },
            { "gaa", "\u52a0\u65cf\u6587" },
            { "wa", "\u74e6\u9686\u6587" },
            { "gag", "\u52a0\u544a\u8332\u6587" },
            { "syr", "\u6558\u5229\u4e9e\u6587" },
            { "Grek", metaValue_el },
            { "gan", "\u8d1b\u8a9e" },
            { "kiu", "\u5317\u7d2e\u7d2e\u5176\u6587" },
            { "Lydi", "\u91cc\u5e95\u4e9e\u8a9e" },
            { "Xsux", "\u8607\u7c73\u9b6f\u4e9e\u7532\u6587\u6954\u5f62\u6587\u5b57" },
            { "wo", "\u6c83\u6d1b\u592b\u6587" },
            { "zgh", "\u6a19\u6e96\u6469\u6d1b\u54e5\u5854\u99ac\u585e\u7279\u6587" },
            { "ar_001", "\u73fe\u4ee3\u6a19\u6e96\u963f\u62c9\u4f2f\u6587" },
            { "Cans", "\u52a0\u62ff\u5927\u539f\u4f4f\u6c11\u901a\u7528\u5b57\u7b26" },
            { "%%FONXSAMP", "X-SAMPA \u97f3\u6a19" },
            { "gay", "\u52a0\u7d04\u6587" },
            { "Mong", metaValue_mn },
            { "mnc", "\u6eff\u65cf\u6587" },
            { "Latf", "\u62c9\u4e01\u6587\uff08\u5c16\u89d2\u9ad4\u6d3b\u5b57\u8b8a\u9ad4\uff09" },
            { "szl", "\u897f\u5229\u897f\u4e9e\u6587" },
            { "Hluw", "\u5b89\u90a3\u6258\u5229\u4e9e\u8c61\u5f62\u6587\u5b57" },
            { "gba", "\u845b\u5df4\u4e9e\u6587" },
            { "mni", metaValue_mni },
            { "Latn", metaValue_la },
            { "Latg", "\u62c9\u4e01\u6587\uff08\u84cb\u723e\u8a9e\u8b8a\u9ad4\uff09" },
            { "type.nu.hans", "\u5c0f\u5beb\u7c21\u9ad4\u4e2d\u6587\u6578\u5b57" },
            { "type.nu.hant", "\u5c0f\u5beb\u7e41\u9ad4\u4e2d\u6587\u6578\u5b57" },
            { "xh", "\u79d1\u85a9\u6587" },
            { "type.nu.romanlow", "\u5c0f\u5beb\u7f85\u99ac\u6578\u5b57" },
            { "byn", "\u6bd4\u6797\u6587" },
            { "%%PAMAKA", "\u8607\u5229\u5357\u5e15\u99ac\u5361\u65b9\u8a00" },
            { "Lyci", "\u5442\u897f\u4e9e\u8a9e" },
            { "osa", metaValue_osa },
            { "byv", "\u6885\u6566\u5df4\u6587" },
            { "gbz", "\u7d22\u7f85\u4e9e\u65af\u5fb7\u6559\u9054\u91cc\u6587" },
            { "Moon", "\u8499\u6c0f\u9ede\u5b57" },
            { "moh", "\u83ab\u970d\u514b\u6587" },
            { "kkj", "\u5361\u5eab\u6587" },
            { "%%1694ACAD", "\u65e9\u671f\u73fe\u4ee3\u6cd5\u6587" },
            { "yi", "\u610f\u7b2c\u7dd2\u6587" },
            { "mos", "\u83ab\u897f\u6587" },
            { "Syrc", "\u654d\u5229\u4e9e\u6587" },
            { "Dsrt", "\u5fb7\u745f\u96f7\u7279\u6587" },
            { "yo", "\u7d04\u9b6f\u5df4\u6587" },
            { "type.nu.traditional", "\u50b3\u7d71\u6578\u5b57" },
            { "Syrj", "\u6558\u5229\u4e9e\u6587\uff08\u897f\u65b9\u6587\u5b57\u8b8a\u9ad4\uff09" },
            { "ota", "\u9102\u5716\u66fc\u571f\u8033\u5176\u6587" },
            { "Syre", "\u6558\u5229\u4e9e\u6587\uff08\u798f\u97f3\u9ad4\u6587\u5b57\u8b8a\u9ad4\uff09" },
            { "vai", "\u74e6\u4f0a\u6587" },
            { "za", "\u58ef\u6587" },
            { "Cari", "\u5361\u91cc\u4e9e\u6587" },
            { "kln", "\u5361\u502b\u91d1\u6587" },
            { "zh", "\u4e2d\u6587" },
            { "Afak", "\u963f\u6cd5\u5361\u6587\u5b57" },
            { "Bopo", "\u6ce8\u97f3\u7b26\u865f" },
            { "Perm", "\u53e4\u5f7c\u723e\u59c6\u8af8\u6587" },
            { "key.lb", "\u63db\u884c\u6a23\u5f0f" },
            { "zu", "\u7956\u9b6f\u6587" },
            { "type.co.phonebook", "\u96fb\u8a71\u7c3f\u6392\u5e8f" },
            { "%%MONOTON", "\u5e0c\u81d8\u6587\u55ae\u8abf\u6b63\u5b57\u6cd5" },
            { "Geor", metaValue_ka },
            { "Shrd", "\u590f\u62c9\u9054\u6587" },
            { "kmb", "\u91d1\u90a6\u675c\u6587" },
            { "type.nu.jpanfin", "\u5927\u5beb\u65e5\u6587\u6578\u5b57" },
            { "Cham", "\u5360\u6587" },
            { "gez", "\u5409\u8332\u6587" },
            { "mrj", "\u897f\u99ac\u91cc\u6587" },
            { "Syrn", "\u6558\u5229\u4e9e\u6587\uff08\u6771\u65b9\u6587\u5b57\u8b8a\u9ad4\uff09" },
            { "type.nu.mymrshan", "\u7dec\u7538\u64a3\u6587\u6578\u5b57" },
            { "Elba", "\u611b\u723e\u5df4\u6851\u6587" },
            { "Narb", "\u53e4\u5317\u963f\u62c9\u4f2f\u6587" },
            { "type.nu.olck", "\u6851\u5854\u5229\u6587\u6578\u5b57" },
            { "type.co.reformed", "\u6539\u826f\u6392\u5e8f" },
            { "Tglg", "\u5854\u52a0\u62c9\u6587" },
            { "Egyd", "\u53e4\u57c3\u53ca\u4e16\u4fd7\u9ad4" },
            { "Egyh", "\u53e4\u57c3\u53ca\u50e7\u4fb6\u9ad4" },
            { "%%ITIHASA", "\u53f2\u8a69\u68b5\u6587" },
            { "Palm", "\u5e15\u7c73\u745e\u62c9\u6587\u5b57" },
            { "ebu", "\u6069\u5e03\u6587" },
            { "Egyp", "\u53e4\u57c3\u53ca\u8c61\u5f62\u6587\u5b57" },
            { "Geok", "\u55ac\u6cbb\u4e9e\u8a9e\u7cfb\uff08\u963f\u7d22\u4ed6\u8def\u91cc\u548c\u52aa\u65af\u514b\u80e1\u91cc\u6587\uff09" },
            { "zh_Hans", "\u7c21\u9ad4\u4e2d\u6587" },
            { "koi", "\u79d1\u7c73-\u5f7c\u723e\u7c73\u4e9e\u514b\u6587" },
            { "Hung", "\u53e4\u5308\u7259\u5229\u6587" },
            { "kok", "\u8ca2\u6839\u6587" },
            { "%%1901", "\u50b3\u7d71\u5fb7\u8a9e\u62fc\u5b57\u5b78" },
            { "kos", "\u79d1\u65af\u96f7\u6069\u6587" },
            { "vec", "\u5a01\u5c3c\u65af\u6587" },
            { "type.nu.limb", "\u6797\u5e03\u6587\u6578\u5b57" },
            { "zh_Hant", "\u7e41\u9ad4\u4e2d\u6587" },
            { "Sund", metaValue_su },
            { "vep", "\u7dad\u666e\u68ee\u6587" },
            { "kpe", "\u514b\u4f69\u5217\u6587" },
            { "type.nu.khmr", "\u9ad8\u68c9\u6578\u5b57" },
            { "Tirh", metaValue_mai },
            { "ilo", "\u4f0a\u6d1b\u95ca\u6587" },
            { "%%VALENCIA", "\u74e6\u502b\u897f\u4e9e\u6587" },
            { "Cprt", "\u585e\u6d66\u8def\u65af\u6587" },
            { "%%BAKU1926", "\u7d71\u4e00\u571f\u8033\u5176\u62c9\u4e01\u5b57\u6bcd" },
            { "%%IJEKAVSK", "\u8036\u5361\u767c\u97f3\u585e\u723e\u7dad\u4e9e\u6587" },
            { "mua", "\u8499\u7576\u6587" },
            { "type.nu.guru", "\u53e4\u723e\u7a46\u5947\u6578\u5b57" },
            { "mul", "\u591a\u7a2e\u8a9e\u8a00" },
            { "%%PUTER", "\u745e\u58eb\u666e\u7279\u723e\u65b9\u8a00" },
            { "cad", "\u5361\u591a\u6587" },
            { "key.ms", "\u5ea6\u91cf\u55ae\u4f4d\u7cfb\u7d71" },
            { "mus", "\u514b\u91cc\u514b\u6587" },
            { "Glag", "\u683c\u62c9\u54e5\u91cc\u6587" },
            { "gil", "\u5409\u723e\u4f2f\u7279\u7fa4\u5cf6\u6587" },
            { "%%KKCOR", "\u901a\u7528\u5eb7\u6c83\u723e\u6587\u62fc\u5b57" },
            { "Cher", metaValue_chr },
            { "car", "\u52a0\u52d2\u6bd4\u6587" },
            { "cay", "\u5361\u5c24\u52a0\u6587" },
            { "type.nu.tamldec", metaValue_type_nu_taml },
            { "krc", "\u5361\u62c9\u67f4-\u5305\u723e\u5361\u723e\u6587" },
            { "inh", "\u5370\u53e4\u4ec0\u6587" },
            { "krj", "\u57fa\u90a3\u4f86\u963f\u6587" },
            { "kri", "\u585e\u62c9\u5229\u6602\u514b\u88cf\u5967\u723e\u6587" },
            { "krl", "\u5361\u7d2f\u5229\u963f\u6587" },
            { "%%OXENDICT", "\u725b\u6d25\u82f1\u6587\u5b57\u5178\u62fc\u97f3" },
            { "efi", "\u57c3\u83f2\u514b\u6587" },
            { "key.nu", metaValue_key_nu },
            { "tcy", "\u5716\u76e7\u6587" },
            { "kru", "\u5eab\u9b6f\u79d1\u6587" },
            { "ksb", "\u5c1a\u5df4\u62c9\u6587" },
            { "Telu", metaValue_te },
            { "ksf", "\u5df4\u83f2\u4e9e\u6587" },
        };
        return data;
    }
}
