/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_eu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_si = "sinhala";
        final String metaValue_tl = "tagaloa";
        final String metaValue_ban = "baliera";
        final String metaValue_bug = "buginera";
        final String metaValue_chr = "txerokiera";
        final String metaValue_vai = "vaiera";
        final Object[][] data = new Object[][] {
            { "ksh", "koloniera" },
            { "Ogam", "oghamera" },
            { "mwl", "mirandera" },
            { "Zsym", "ikurrak" },
            { "type.nu.lanatham", "Tai Tham Tham digituak" },
            { "Tagb", "tagbanwa" },
            { "Zsye", "emotikonoa" },
            { "%%NJIVA", "Gniva/Njiva dialektoa" },
            { "ccp", "chakmera" },
            { "Phag", "phags-pa" },
            { "tem", "temnea" },
            { "Medf", "medefaidrinera" },
            { "type.nu.sind", "Digitu khudawadiarrak" },
            { "teo", "tesoera" },
            { "rap", "rapa nui" },
            { "AC", "Ascension uhartea" },
            { "rar", "rarotongera" },
            { "tet", "tetum" },
            { "%%BARLA", "Caboverdeeraren barlavento dialekto taldea" },
            { "type.nu.sinh", "Sinhala Lith digituak" },
            { "AD", "Andorra" },
            { "AE", "Arabiar Emirerri Batuak" },
            { "nl_BE", "flandriera" },
            { "AF", "Afganistan" },
            { "AG", "Antigua eta Barbuda" },
            { "type.nu.mroo", "Mro digituak" },
            { "type.ca.ethiopic", "Egutegi etiopiarra" },
            { "AI", "Aingira" },
            { "key.tz", "Ordu-zona" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antartika" },
            { "AR", "Argentina" },
            { "Prti", "Partiera inskripzioak" },
            { "AS", "Samoa Estatubatuarra" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "AEBko ingeles" },
            { "AX", "\u00c5land" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia-Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuanoera" },
            { "BD", "Bangladesh" },
            { "kum", "kumykera" },
            { "BE", "Belgika" },
            { "Sogo", "sogdiera zaharra" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "myv", "erziera" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibeko Herbehereak" },
            { "BR", "Brasil" },
            { "BS", "Bahamak" },
            { "xog", "sogera" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet uhartea" },
            { "BW", "Botswana" },
            { "BY", "Bielorrusia" },
            { "BZ", "Belize" },
            { "type.ca.persian", "Egutegi persiarra" },
            { "type.nu.hebr", "Zenbaki hebrearrak" },
            { "CA", "Kanada" },
            { "Kits", "khitanerako script txikiak" },
            { "CC", "Cocos (Keeling) uharteak" },
            { "mzn", "mazandarandera" },
            { "CD", "Kongoko Errepublika Demokratikoa" },
            { "CF", "Afrika Erdiko Errepublika" },
            { "CG", "Kongo" },
            { "CH", "Suitza" },
            { "CI", "Boli Kosta" },
            { "CK", "Cook uharteak" },
            { "CL", "Txile" },
            { "Kthi", "kaithiera" },
            { "CM", "Kamerun" },
            { "CN", "Txina" },
            { "CO", "Kolonbia" },
            { "CP", "Clipperton uhartea" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas uhartea" },
            { "CY", "Zipre" },
            { "type.nu.bali", "Digitu balitarrak" },
            { "CZ", "Txekia" },
            { "eka", "akajuka" },
            { "Ahom", "ahomera" },
            { "Pauc", "pau cin hau" },
            { "%%RIGIK", "Volapuk klasikoa" },
            { "Sogd", "sogdiera" },
            { "DE", "Alemania" },
            { "ace", "acehnera" },
            { "cgg", "chiga" },
            { "DG", "Diego Garc\u00eda" },
            { "type.nu.deva", "Digitu devanagariak" },
            { "DJ", "Djibuti" },
            { "DK", "Danimarka" },
            { "ach", "acholiera" },
            { "Brai", "braillea" },
            { "Brah", "brahmiera" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "Zenbaki armeniarrak minuskulaz" },
            { "DO", "Dominikar Errepublika" },
            { "gor", "gorontaloa" },
            { "Mtei", "meitei mayekera" },
            { "zun", "zu\u00f1ia" },
            { "tig", "tigrea" },
            { "Takr", "takriera" },
            { "DZ", "Aljeria" },
            { "pag", "pangasinanera" },
            { "type.d0.hwidth", "Zabalera erdiko karaktere-bihurketa" },
            { "EA", "Ceuta eta Melilla" },
            { "pam", "pampangera" },
            { "EC", "Ekuador" },
            { "pap", "papiamento" },
            { "ada", "adangmera" },
            { "EE", "Estonia" },
            { "EG", "Egipto" },
            { "EH", "Mendebaldeko Sahara" },
            { "pau", "palauera" },
            { "chk", "chuukera" },
            { "chm", "mariera" },
            { "cho", "choctaw" },
            { "type.nu.mathbold", "Digitu matematiko lodiak" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Espainia" },
            { "ET", "Etiopia" },
            { "Vith", "vithkuqi" },
            { "EU", "Europar Batasuna" },
            { "type.ca.gregorian", "Egutegi gregoriarra" },
            { "EZ", "Eurogunea" },
            { "chy", "cheyennera" },
            { "type.nu.gujr", "Digitu gujaratarrak" },
            { "ady", "adigera" },
            { "FI", "Finlandia" },
            { "FJ", "Fiji" },
            { "FK", "Falklandak" },
            { "FM", "Mikronesia" },
            { "key.va", "Eskualdeko ezarpenen aldaera" },
            { "FO", "Faroe uharteak" },
            { "Taml", "tamilarra" },
            { "FR", "Frantzia" },
            { "%%SIMPLE", "SOILA" },
            { "%%DAJNKO", "Dajnko alfabetoa" },
            { "type.ca.indian", "Indiar egutegia" },
            { "GA", "Gabon" },
            { "GB", "Erresuma Batua" },
            { "pcm", "Nigeriako pidgina" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyana Frantsesa" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Ginea" },
            { "GP", "Guadalupe" },
            { "GQ", "Ekuatore Ginea" },
            { "GR", "Grezia" },
            { "GS", "Hegoaldeko Georgia eta Hegoaldeko Sandwich uharteak" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "type.nu.mathmono", "Zuriune bakarreko digitu matematikoak" },
            { "GW", "Ginea Bissau" },
            { "rhg", "rohingyera" },
            { "tlh", "klingonera" },
            { "Talu", "tai lue berria" },
            { "GY", "Guyana" },
            { "ckb", "erdialdeko kurduera" },
            { "zxx", "ez dago eduki linguistikorik" },
            { "de_AT", "Austriako aleman" },
            { "Vaii", metaValue_vai },
            { "HK", "Hong Kong Txinako AEB" },
            { "HM", "Heard eta McDonald uharteak" },
            { "HN", "Honduras" },
            { "HR", "Kroazia" },
            { "agq", "aghemera" },
            { "gsw", "Suitzako aleman" },
            { "type.ca.islamic-umalqura", "Islamiar egutegia (Umm al-Qura)" },
            { "HT", "Haiti" },
            { "HU", "Hungaria" },
            { "IC", "Kanariak" },
            { "ID", "Indonesia" },
            { "Adlm", "adlam" },
            { "type.nu.kali", "Kayah Li digituak" },
            { "IE", "Irlanda" },
            { "nap", "napoliera" },
            { "%%NDYUKA", "Ndyuka dialektoa" },
            { "naq", "namera" },
            { "type.nu.sora", "Sora Sompeng digituak" },
            { "zza", "zazera" },
            { "Tang", "tangutera" },
            { "IL", "Israel" },
            { "Nbat", "nabatera" },
            { "IM", "Man uhartea" },
            { "IN", "India" },
            { "type.co.eor", "Europako ordenatzeko arauak" },
            { "IO", "Indiako Ozeanoko lurralde britainiarra" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "Zmth", "matematikako notazioa" },
            { "type.nu.thai", "Digitu thailandiarrak" },
            { "%%POSIX", "Ordenagailua" },
            { "type.nu.beng", "Digitu bengalarrak" },
            { "type.nu.cyrl", "Zenbaki zirilikoak" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Islamiar egutegia" },
            { "JM", "Jamaika" },
            { "Beng", "bengalarra" },
            { "%%EKAVSK", "Serbiera ekavierako ahoskerarekin" },
            { "JO", "Jordania" },
            { "JP", "Japonia" },
            { "%%1606NICT", "frantses ertain amaieratik 1606ra" },
            { "ain", "ainuera" },
            { "Mend", "mende" },
            { "guz", "gusiiera" },
            { "type.nu.knda", "Digitu kannadarrak" },
            { "Kali", "kayah li" },
            { "Sidd", "siddham" },
            { "de_CH", "Suitzako aleman garai" },
            { "type.co.phonetic", "Ordenatzeko irizpide fonetikoa" },
            { "type.ca.buddhist", "Egutegi budista" },
            { "KE", "Kenya" },
            { "419", "Latinoamerika" },
            { "KG", "Kirgizistan" },
            { "KH", "Kanbodia" },
            { "KI", "Kiribati" },
            { "KM", "Komoreak" },
            { "KN", "Saint Kitts eta Nevis" },
            { "Knda", "kanadarra" },
            { "Zinh", "heredatua" },
            { "fr_CA", "Kanadako frantses" },
            { "KP", "Ipar Korea" },
            { "KR", "Hego Korea" },
            { "Plrd", "polardera fonetikoa" },
            { "fr_CH", "Suitzako frantses" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Kaiman uharteak" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "zirilikoa" },
            { "LA", "Laos" },
            { "LB", "Libano" },
            { "LC", "Santa Luzia" },
            { "gwi", "gwich\u02bcin" },
            { "nds", "behe-aleman" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luxenburgo" },
            { "LV", "Letonia" },
            { "Kana", "katakana" },
            { "Sora", "sora sompeng" },
            { "LY", "Libia" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "Mahj", "mahajaniera" },
            { "lag", "langiera" },
            { "Thaa", "thaana" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavia" },
            { "Nshu", "nushuera" },
            { "ME", "Montenegro" },
            { "MF", "San Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshall Uharteak" },
            { "ale", "aleutera" },
            { "Thai", "thailandiarra" },
            { "type.nu.vaii", "Vai digituak" },
            { "MK", "Ipar Mazedonia" },
            { "type.nu.mathdbl", "Marra bikoitzeko digitu matematikoak" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "new", "newarera" },
            { "MO", "Macau Txinako AEB" },
            { "MP", "Ipar Mariana uharteak" },
            { "MQ", "Martinika" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "Chrs", "korasmiera" },
            { "MT", "Malta" },
            { "type.m0.ungegn", "UN GEGN transliterazioa" },
            { "MU", "Maurizio" },
            { "alt", "hegoaldeko altaiera" },
            { "MV", "Maldivak" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "type.ca.japanese", "Japoniar egutegia" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambike" },
            { "Phli", "pahlavi inskripzioak" },
            { "NA", "Namibia" },
            { "%%ARANES", "ARANERA" },
            { "202", "Saharaz hegoaldeko Afrika" },
            { "type.ca.hebrew", "Hebrear egutegia" },
            { "type.co.dictionary", "Hurrenkera alfabetikoa" },
            { "NC", "Kaledonia Berria" },
            { "%%WADEGILE", "Wade-Giles erromanizazioa" },
            { "%%UCRCOR", "Ortografia berrikusi bateratua" },
            { "NE", "Niger" },
            { "NF", "Norfolk uhartea" },
            { "NG", "Nigeria" },
            { "trv", "tarokoa" },
            { "Phlp", "Pahlavi salmo-liburua" },
            { "NI", "Nikaragua" },
            { "Hmng", "pahawh hmongera" },
            { "NL", "Herbehereak" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "Phnx", "feniziera" },
            { "rof", "rombo" },
            { "NZ", "Zeelanda Berria" },
            { "Merc", "meroitiar etzana" },
            { "%%COLB1945", "1945eko Portugal eta Barasilgo ortografia-hitzarmena" },
            { "Mero", "meroitirra" },
            { "OM", "Oman" },
            { "anp", "angikera" },
            { "crs", "Seychelleetako kreolera" },
            { "type.nu.hmnp", "Nyiakeng Puachue Hmong digituak" },
            { "Xpeo", "pertsiera zaharra" },
            { "type.nu.hmng", "Pahawh Hmong digituak" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Islamiar egutegia (taula-formakoa, garai zibilekoa)" },
            { "en_GB", "Britania Handiko ingeles" },
            { "PE", "Peru" },
            { "PF", "Polinesia Frantsesa" },
            { "PG", "Papua Ginea Berria" },
            { "PH", "Filipinak" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "ewo", "ewondera" },
            { "PM", "Saint-Pierre eta Mikelune" },
            { "PN", "Pitcairn uharteak" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Palestinar Lurralde Okupatuak" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "niasera" },
            { "type.nu.greklow", "Zenbaki grekoak minuskulaz" },
            { "PY", "Paraguai" },
            { "tum", "tumbukera" },
            { "Hebr", "hebrearra" },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "Eskoziar ingeles estandarra" },
            { "niu", "niueera" },
            { "QO", "Mugaz kanpoko Ozeania" },
            { "lez", "lezgiera" },
            { "type.nu.ahom", "Ahom digituak" },
            { "%%FONUPA", "UPa ahoskera" },
            { "type.nu.takr", "Digitu takriarrak" },
            { "tvl", "tuvaluera" },
            { "Tavt", "tai viet" },
            { "%%SOTAV", "Caboverdeerako sotavento dialekto taldea" },
            { "Maka", "makasarrera" },
            { "001", "Mundua" },
            { "002", "Afrika" },
            { "003", "Ipar Amerika" },
            { "RE", "Reunion" },
            { "005", "Hego Amerika" },
            { "jbo", "lojbanera" },
            { "Rjng", "Rejang" },
            { "009", "Ozeania" },
            { "Elym", "elimaikera" },
            { "RO", "Errumania" },
            { "RS", "Serbia" },
            { "Mroo", "mroera" },
            { "RU", "Errusia" },
            { "RW", "Ruanda" },
            { "type.nu.talu", "Digitu tai lue berriak" },
            { "%%METELKO", "Metelko alfabetoa" },
            { "Mani", "manikeoa" },
            { "Ugar", "ugaritiera" },
            { "Khar", "kharoshthi" },
            { "SA", "Saudi Arabia" },
            { "Mand", "mandaera" },
            { "SB", "Salomon Uharteak" },
            { "twq", "tasawaq" },
            { "Tnsa", "tangsa" },
            { "011", "Afrika mendebaldea" },
            { "SC", "Seychelleak" },
            { "SD", "Sudan" },
            { "013", "Erdialdeko Amerika" },
            { "SE", "Suedia" },
            { "014", "Afrika ekialdea" },
            { "015", "Afrika iparraldea" },
            { "SG", "Singapur" },
            { "SH", "Santa Helena" },
            { "type.lb.strict", "Lerro-jauziaren estilo zorrotza" },
            { "017", "Erdialdeko Afrika" },
            { "SI", "Eslovenia" },
            { "type.nu.mymrtlng", "Tai Laing digitu birmaniarrak" },
            { "018", "Afrika hegoaldea" },
            { "SJ", "Svalbard eta Jan Mayen uharteak" },
            { "019", "Amerika" },
            { "SK", "Eslovakia" },
            { "Bamu", "bamum" },
            { "SL", "Sierra Leona" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "maputxe" },
            { "arp", "arapaho" },
            { "type.nu.taml", "Zenbaki tamilar tradizionalak" },
            { "SR", "Surinam" },
            { "SS", "Hego Sudan" },
            { "ST", "Sao Tome eta Principe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Swazilandia" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "Neurketa-sistema anglosaxoia" },
            { "021", "Amerikako iparraldea" },
            { "TC", "Turk eta Caico uharteak" },
            { "yav", "yangbenera" },
            { "TD", "Txad" },
            { "Qaag", "zauagiera" },
            { "TF", "Hegoaldeko lurralde frantsesak" },
            { "TG", "Togo" },
            { "TH", "Thailandia" },
            { "TJ", "Tajikistan" },
            { "029", "Karibea" },
            { "TK", "Tokelau" },
            { "TL", "Ekialdeko Timor" },
            { "ybb", "yemba" },
            { "type.co.searchjl", "Bilatu hangularen lehen kontsonantearen arabera" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "%%NULIK", "Volapuk modernoa" },
            { "TR", "Turkia" },
            { "TT", "Trinidad eta Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturiera" },
            { "Orkh", "orkhonera" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasiera" },
            { "Zzzz", "idazkera ezezaguna" },
            { "Sind", "khudawadi" },
            { "UA", "Ukraina" },
            { "lij", "liguriera" },
            { "rup", "aromaniera" },
            { "030", "Asia ekialdea" },
            { "tyv", "tuvera" },
            { "sw_CD", "Kongoko swahilia" },
            { "034", "Asia hegoaldea" },
            { "035", "Asiako hego-ekialdea" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "Pinyin hurrenkera" },
            { "039", "Europa hegoaldea" },
            { "Sinh", metaValue_si },
            { "UM", "Ameriketako Estatu Batuetako Kanpoaldeko Uharte Txikiak" },
            { "UN", "Nazio Batuak" },
            { "US", "Ameriketako Estatu Batuak" },
            { "haw", "hawaiiera" },
            { "%%1959ACAD", "akademikoa" },
            { "type.co.gb2312han", "Txinera sinplifikatuaren alfabetoa -GB2312" },
            { "UY", "Uruguai" },
            { "prg", "prusiera" },
            { "UZ", "Uzbekistan" },
            { "tzm", "Erdialdeko Atlaseko amazigera" },
            { "type.co.stroke", "Tarteen araberako hurrenkera" },
            { "nnh", "ngiemboonera" },
            { "VA", "Vatikano Hiria" },
            { "VC", "Saint Vincent eta Grenadinak" },
            { "VE", "Venezuela" },
            { "VG", "Birjina uharte britainiarrak" },
            { "VI", "Birjina uharte amerikarrak" },
            { "Soyo", "soyomboera" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "Marc", "martxenera" },
            { "nog", "nogaiera" },
            { "rwk", "rwera" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis eta Futuna" },
            { "type.co.traditional", "Tradizionala" },
            { "057", "Mikronesia eskualdea" },
            { "jgo", "ngomba" },
            { "lkt", "lakotera" },
            { "type.nu.finance", "Finantza-zenbakiak" },
            { "%%HEPBURN", "Hepburn erromanizazioa" },
            { "type.co.compat", "Aurreko hurrenkera, bateragarria izateko" },
            { "wae", "walserera" },
            { "WS", "Samoa" },
            { "Bass", "bassa vah" },
            { "type.nu.mtei", "Meetei Mayek digituak" },
            { "wal", "welayta" },
            { "XA", "Sasiazentuak" },
            { "war", "samerera" },
            { "XB", "Pseudobidia" },
            { "awa", "awadhiera" },
            { "061", "Polinesia" },
            { "%%KSCOR", "Ortografia estandarra" },
            { "XK", "Kosovo" },
            { "type.nu.brah", "Brahmi digituak" },
            { "Gujr", "gujaratarra" },
            { "Zxxx", "idatzi gabea" },
            { "Olck", "ol txikiera" },
            { "Batk", "batak" },
            { "YE", "Yemen" },
            { "nqo", "n\u2019koera" },
            { "type.co.standard", "Ordenatzeko irizpide estandarra" },
            { "Zanb", "zanabazar koadroa" },
            { "%%BALANKA", "Aniieraren balanka dialektoa" },
            { "%%ROZAJ", "Resiera" },
            { "Sgnw", "zeinu-idazketa" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "Txam digituak" },
            { "%%NEWFOUND", "TERNUA" },
            { "ZA", "Hegoafrika" },
            { "type.nu.sund", "Digitu sundadarrak" },
            { "type.lb.loose", "Lerro-jauziaren estilo malgua" },
            { "Deva", "devanagaria" },
            { "type.nu.geor", "Zenbaki georgiarrak" },
            { "type.co.zhuyin", "Zhuyin hurrenkera" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "Pinyin erromanizazioa" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Eskualde ezezaguna" },
            { "Runr", "errunikoa" },
            { "type.ms.metric", "Sistema metrikoa" },
            { "type.ca.iso8601", "ISO-8601 egutegia" },
            { "nso", "pediera" },
            { "type.nu.telu", "Digitu teluguarrak" },
            { "lou", "Louisianako kreolera" },
            { "loz", "loziera" },
            { "%%ASANTE", "ASANTEERA" },
            { "jmc", "machame" },
            { "type.nu.hansfin", "Finantzetarako zenbaki txinatar sinplifikatuak" },
            { "hil", "hiligainon" },
            { "type.nu.arabext", "Digitu arabiar-hindiko hedatuak" },
            { "nus", "nuerera" },
            { "dak", "dakotera" },
            { "type.nu.fullwide", "Zabalera osoko digituak" },
            { "dar", "dargvera" },
            { "dav", "taitera" },
            { "lrc", "iparraldeko lurera" },
            { "type.co.emoji", "Emojien hurrenkera" },
            { "Copt", "koptikera" },
            { "udm", "udmurtera" },
            { "Khmr", "khemerarra" },
            { "type.ca.islamic-rgsa", "Islamiar egutegia (Saudi Arabia, ikuspegiak)" },
            { "Limb", "linbuera" },
            { "sad", "sandaweera" },
            { "type.nu.roman", "Zenbaki erromatarrak" },
            { "sah", "sakhera" },
            { "type.nu.shrd", "Digitu sharadarrak" },
            { "Aghb", "Kaukasoko albaniera" },
            { "%%SCOUSE", "Scouse" },
            { "saq", "samburuera" },
            { "sat", "santalera" },
            { "Tfng", "tifinagera" },
            { "type.d0.npinyin", "Zenbakizko bihurketa" },
            { "type.nu.native", "Zenbaki-sistema" },
            { "sba", "ngambayera" },
            { "Guru", "gurmukhia" },
            { "%%ALUKU", "Aluku dialektoa" },
            { "type.nu.diak", "Dives Akuru digituak" },
            { "lua", "txilubera" },
            { "%%BISCAYAN", "Mendebaldeko euskara" },
            { "type.nu.tirh", "Tirhuta digituak" },
            { "type.d0.fwidth", "Zabalera osoko karaktere-bihurketa" },
            { "sbp", "sanguera" },
            { "nyn", "ankolera" },
            { "lun", "lundera" },
            { "luo", "luoera" },
            { "fil", "filipinera" },
            { "hmn", "hmong" },
            { "lus", "mizoa" },
            { "ban", metaValue_ban },
            { "type.nu.wara", "Warang Citi digituak" },
            { "luy", "luhyera" },
            { "bas", "basaa" },
            { "%%ABL1943", "1943ko ortografia-formulazioa" },
            { "es_ES", "espainiera (Europa)" },
            { "sco", "eskoziera" },
            { "scn", "siziliera" },
            { "aa", "afarera" },
            { "ab", "abkhaziera" },
            { "Aran", "nastaliq" },
            { "af", "afrikaans" },
            { "ak", "akanera" },
            { "type.nu.cakm", "Txakma digituak" },
            { "am", "amharera" },
            { "an", "aragoiera" },
            { "Arab", "arabiarra" },
            { "%%SOLBA", "Stolvizza/Solbica dialektoa" },
            { "Jpan", "japoniarra" },
            { "ar", "arabiera" },
            { "Hrkt", "silabario japoniarrak" },
            { "as", "assamera" },
            { "Lina", "A linearra" },
            { "av", "avarera" },
            { "Linb", "B linearra" },
            { "ay", "aimara" },
            { "az", "azerbaijanera" },
            { "Rohg", "hanifiera" },
            { "Khoj", "khojkiera" },
            { "%%OSOJS", "Oseacco/Osojane dialektoa" },
            { "%%UNIFON", "Alfabeto fonetiko unifonoa" },
            { "ba", "baxkirera" },
            { "type.co.unihan", "Radical trazuen hurrenkera" },
            { "be", "bielorrusiera" },
            { "bg", "bulgariera" },
            { "bi", "bislama" },
            { "type.nu.java", "Digitu javatarrak" },
            { "bm", "bambarera" },
            { "bn", "bengalera" },
            { "bo", "tibetera" },
            { "dgr", "dogribera" },
            { "br", "bretoiera" },
            { "bs", "bosniera" },
            { "Bhks", "bhaiksuki" },
            { "Mymr", "birmaniarra" },
            { "type.nu.laoo", "Digitu laostarrak" },
            { "seh", "senera" },
            { "Nkoo", "n\u2019ko" },
            { "ca", "katalan" },
            { "ses", "koyraboro senni" },
            { "ce", "txetxenera" },
            { "ch", "chamorrera" },
            { "%%REVISED", "Ortografia berrikusia" },
            { "co", "korsikera" },
            { "Orya", "oriyarra" },
            { "cs", "txekiera" },
            { "cu", "elizako eslaviera" },
            { "cv", "txuvaxera" },
            { "cy", "gales" },
            { "type.nu.ethi", "Zenbaki etiopiarrak" },
            { "Yiii", "yiera" },
            { "da", "daniera" },
            { "pt_PT", "Europako portuges" },
            { "de", "aleman" },
            { "type.cf.standard", "Moneta-formatu estandarra" },
            { "Bugi", metaValue_bug },
            { "bem", "bembera" },
            { "type.nu.mong", "Digitu mongoliarrak" },
            { "dv", "divehiera" },
            { "es_419", "Latinoamerikako espainiera" },
            { "dz", "dzongkha" },
            { "bez", "benera" },
            { "type.ca.chinese", "Txinatar egutegia" },
            { "Lisu", "fraserera" },
            { "dje", "zarma" },
            { "type.nu.grek", "Zenbaki grekoak" },
            { "ee", "eweera" },
            { "type.lb.normal", "Lerro-jauziaren estilo arrunta" },
            { "ro_MD", "moldaviera" },
            { "el", "greziera" },
            { "en", "ingeles" },
            { "eo", "esperanto" },
            { "type.co.big5han", "Txinera tradizionalaren alfabetoa-Big5" },
            { "es", "espainiera" },
            { "et", "estoniera" },
            { "Hanb", "h\u00e4nera" },
            { "eu", "euskara" },
            { "Buhd", "buhid" },
            { "Hang", "hangula" },
            { "Samr", "samariera" },
            { "shi", "tachelhit" },
            { "hsb", "goi-sorabiera" },
            { "Hani", "idazkera txinatarra" },
            { "shn", "shanera" },
            { "Hano", "hanunuera" },
            { "fa", "persiera" },
            { "Hans", "sinplifikatua" },
            { "type.nu.latn", "Digitu mendebaldarrak" },
            { "Hant", "tradizionala" },
            { "ff", "fula" },
            { "fi", "finlandiera" },
            { "fj", "fijiera" },
            { "fon", "fona" },
            { "yue", "kantonera" },
            { "fo", "faroera" },
            { "type.m0.bgn", "US BGN transliterazioa" },
            { "umb", "umbundu" },
            { "fr", "frantses" },
            { "%%AKUAPEM", "AKUAPIMERA" },
            { "fy", "frisiera" },
            { "ga", "irlandera" },
            { "Wcho", "wanchoera" },
            { "gd", "Eskoziako gaeliko" },
            { "Gong", "gunjala gondi" },
            { "gl", "galiziera" },
            { "Gonm", "masaram gondiera" },
            { "gn", "guaraniera" },
            { "bho", "bhojpurera" },
            { "und", "hizkuntza ezezaguna" },
            { "type.ca.ethiopic-amete-alem", "Amete Alem egutegi etiopiarra" },
            { "gu", "gujaratera" },
            { "type.ca.islamic-tbla", "Islamiar egutegia (taula-formakoa, gai astronomikokoa)" },
            { "gv", "manxera" },
            { "type.nu.osma", "Digitu osmanyarrak" },
            { "ha", "hausa" },
            { "he", "hebreera" },
            { "hi", "hindi" },
            { "hup", "hupera" },
            { "bin", "edoera" },
            { "hr", "kroaziera" },
            { "ht", "Haitiko kreolera" },
            { "hu", "hungariera" },
            { "hy", "armeniera" },
            { "hz", "hereroera" },
            { "frc", "cajun frantsesa" },
            { "%%FONIPA", "IPA ahoskera" },
            { "ia", "interlingua" },
            { "Jamo", "jamo-bihurketa" },
            { "id", "indonesiera" },
            { "type.nu.tibt", "Digitu tibetarrak" },
            { "ie", "interlingue" },
            { "%%GASCON", "GASKOI" },
            { "ig", "igboera" },
            { "ii", "Sichuango yiera" },
            { "%%AO1990", "1990eko portugesaren ortografia-hitzarmena" },
            { "io", "ido" },
            { "is", "islandiera" },
            { "it", "italiera" },
            { "iu", "inuktitut" },
            { "ja", "japoniera" },
            { "Mlym", "malayalamarra" },
            { "Sarb", "hegoaldeko arabiera zaharra" },
            { "doi", "dogria" },
            { "type.nu.lepc", "Digitu leptxatarrak" },
            { "sma", "hegoaldeko samiera" },
            { "jv", "javera" },
            { "Shaw", "shaviera" },
            { "mad", "madurera" },
            { "smj", "Luleko samiera" },
            { "mag", "magahiera" },
            { "mai", "maithilera" },
            { "Ougr", "uigurrera zaharra" },
            { "smn", "Inariko samiera" },
            { "ka", "georgiera" },
            { "bla", "siksikera" },
            { "mak", "makasarera" },
            { "sms", "skolten samiera" },
            { "kg", "kikongoa" },
            { "Goth", "gotikoa" },
            { "ki", "kikuyuera" },
            { "mas", "masaiera" },
            { "kj", "kuanyama" },
            { "kk", "kazakhera" },
            { "kl", "groenlandiera" },
            { "km", "khemerera" },
            { "kn", "kannada" },
            { "ko", "koreera" },
            { "kr", "kanuriera" },
            { "ks", "kaxmirera" },
            { "Lepc", "leptxa" },
            { "Avst", "avestera" },
            { "ku", "kurduera" },
            { "kv", "komiera" },
            { "kw", "kornubiera" },
            { "ky", "kirgizera" },
            { "snk", "soninkera" },
            { "Mult", "multaniera" },
            { "la", "latin" },
            { "Hatr", "hatreoera" },
            { "lb", "luxenburgera" },
            { "type.nu.mlym", "Digitu malayalamarrak" },
            { "lg", "luganda" },
            { "li", "limburgera" },
            { "Tibt", "tibetarra" },
            { "ln", "lingala" },
            { "fur", "fruilera" },
            { "lo", "laosera" },
            { "type.ms.uksystem", "Neurketa-sistema inperiala" },
            { "type.nu.lana", "Tai Tham Hora digituak" },
            { "lt", "lituaniera" },
            { "lu", "Katangako lubera" },
            { "lv", "letoniera" },
            { "mg", "malgaxe" },
            { "mh", "marshallera" },
            { "type.co.ducet", "Unicode hurrenkera lehenetsia" },
            { "mi", "maoriera" },
            { "mk", "mazedoniera" },
            { "ml", "malabarera" },
            { "mn", "mongoliera" },
            { "mr", "marathera" },
            { "ms", "malaysiera" },
            { "mt", "maltera" },
            { "my", "birmaniera" },
            { "Saur", "saurashtra" },
            { "Armn", "armeniarra" },
            { "mdf", "mokxera" },
            { "dsb", "behe-sorabiera" },
            { "Armi", "aramiera inperiarra" },
            { "na", "nauruera" },
            { "type.co.search", "Bilaketa orokorra" },
            { "nb", "bokm\u00e5l (norvegiera)" },
            { "nd", "iparraldeko ndebeleera" },
            { "ne", "nepalera" },
            { "ng", "ndongera" },
            { "nl", "nederlandera" },
            { "nn", "nynorsk (norvegiera)" },
            { "no", "norvegiera" },
            { "nr", "hegoaldeko ndebelera" },
            { "type.nu.modi", "Modi digituak" },
            { "Osge", "osagera" },
            { "nv", "navajoera" },
            { "ny", "chewera" },
            { "kac", "jingpoera" },
            { "kab", "kabilera" },
            { "%%POLYTON", "Tonu anitza" },
            { "oc", "okzitaniera" },
            { "kaj", "kaiji" },
            { "kam", "kambera" },
            { "men", "mendeera" },
            { "%%EMODENG", "Ingeles moderno goiztiarra" },
            { "mer", "meruera" },
            { "type.nu.armn", "Zenbaki armeniarrak" },
            { "om", "oromoera" },
            { "or", "oriya" },
            { "Modi", "modiera" },
            { "os", "osetiera" },
            { "%%ALALC97", "ALA-LC erromanizazioa, 1997ko edizioa" },
            { "kbd", "kabardiera" },
            { "mfe", "Mauritaniako kreolera" },
            { "srn", "srananera" },
            { "pa", "punjabera" },
            { "dua", "dualera" },
            { "%%LIPAW", "Resiako lipovaz dialektoa" },
            { "pl", "poloniera" },
            { "type.nu.saur", "Digitu saurashtrarrak" },
            { "type.ca.dangi", "Dangi egutegia" },
            { "ps", "paxtuera" },
            { "pt", "portuges" },
            { "key.co", "Ordenatzeko irizpidea" },
            { "pt_BR", "Brasilgo portuges" },
            { "%%BOHORIC", "Bohoric alfabetoa" },
            { "kcg", "kataba" },
            { "mgh", "makhuwa-meettoera" },
            { "key.cf", "Moneta-formatua" },
            { "type.nu.nkoo", "N\u2019Ko digituak" },
            { "key.ca", "Egutegia" },
            { "Laoo", "laosarra" },
            { "mgo", "meta\u02bcera" },
            { "type.hc.h23", "24 orduko sistema (0\u201323)" },
            { "type.hc.h24", "24 orduko sistema (1\u201324)" },
            { "ssy", "sahoa" },
            { "type.nu.mymr", "Digitu birmaniarrak" },
            { "qu", "kitxua" },
            { "brx", "bodoera" },
            { "Lana", "lannera" },
            { "kde", "makondeera" },
            { "Ethi", "etiopiarra" },
            { "type.hc.h12", "12 orduko sistema (1\u201312)" },
            { "type.hc.h11", "12 orduko sistema (0\u201311)" },
            { "rm", "erretorromaniera" },
            { "rn", "rundiera" },
            { "key.cu", "Moneta" },
            { "ro", "errumaniera" },
            { "%%SAAHO", "Saho" },
            { "type.nu.orya", "Digitu oriyarrak" },
            { "type.nu.hanidec", "Zenbaki hamartar txinatarrak" },
            { "ru", "errusiera" },
            { "rw", "kinyaruanda" },
            { "kea", "Cabo Verdeko kreolera" },
            { "mic", "mikmakera" },
            { "suk", "sukumera" },
            { "en_AU", "Australiako ingeles" },
            { "Dupl", "duployiar takigrafia" },
            { "sa", "sanskrito" },
            { "%%UCCOR", "Ortografia bateratua" },
            { "sc", "sardiniera" },
            { "sd", "sindhi" },
            { "se", "iparraldeko samiera" },
            { "min", "minangkabauera" },
            { "sg", "sango" },
            { "sh", "serbokroaziera" },
            { "si", metaValue_si },
            { "sk", "eslovakiera" },
            { "sl", "esloveniera" },
            { "Gran", "grantha" },
            { "sm", "samoera" },
            { "sn", "shonera" },
            { "so", "somaliera" },
            { "type.nu.arab", "Digitu arabiar-hindikoak" },
            { "sq", "albaniera" },
            { "sr", "serbiera" },
            { "ss", "swatiera" },
            { "type.cf.account", "Kontabilitateko moneta-formatua" },
            { "st", "hegoaldeko sothoera" },
            { "Java", "javaniera" },
            { "su", "sundanera" },
            { "%%NEDIS", "Natisoneko dialektoa" },
            { "sv", "suediera" },
            { "sw", "swahilia" },
            { "type.nu.wcho", "Wancho digituak" },
            { "type.nu.hantfin", "Finantzetarako zenbaki txinatar tradizionalak" },
            { "ibb", "ibibioera" },
            { "iba", "ibanera" },
            { "ta", "tamilera" },
            { "142", "Asia" },
            { "143", "Asia erdialdea" },
            { "te", "telugu" },
            { "Toto", "totoera" },
            { "145", "Asia mendebaldea" },
            { "tg", "tajikera" },
            { "th", "thailandiera" },
            { "%%SPANGLIS", "SPANGLISH" },
            { "bug", metaValue_bug },
            { "ti", "tigrinyera" },
            { "kfo", "koroa" },
            { "en_CA", "Kanadako ingeles" },
            { "tk", "turkmenera" },
            { "tl", metaValue_tl },
            { "tn", "tswanera" },
            { "to", "tongera" },
            { "dyo", "fonyi jolera" },
            { "type.nu.jpan", "Zenbaki japoniarrak" },
            { "tr", "turkiera" },
            { "ts", "tsongera" },
            { "swb", "komoreera" },
            { "Cakm", "txakma" },
            { "tt", "tatarera" },
            { "tw", "twia" },
            { "ty", "tahitiera" },
            { "%%BISKE", "San Giorgio / Bila dialektoa" },
            { "150", "Europa" },
            { "151", "Europa ekialdea" },
            { "type.nu.rohg", "Hanifi digitu rohingyak" },
            { "type.nu.mathsanb", "Sans-Serif Bold digitu matematikoak" },
            { "154", "Europa iparraldea" },
            { "dzg", "dazaga" },
            { "155", "Europa mendebaldea" },
            { "ug", "uigurrera" },
            { "Ital", "italiera zaharra" },
            { "Kore", "korearra" },
            { "kgp", "kaingang" },
            { "Zyyy", "ohikoa" },
            { "uk", "ukrainera" },
            { "type.ca.coptic", "Egutegi coptiarra" },
            { "ur", "urdu" },
            { "%%1994", "Resiako ortografia estandarizatua" },
            { "xal", "kalmykera" },
            { "uz", "uzbekera" },
            { "kha", "kashia" },
            { "%%1996", "1996ko ortografia alemana" },
            { "nds_NL", "behe-saxoiera" },
            { "Sylo", "syloti nagriera" },
            { "ve", "vendera" },
            { "Wara", "varang kshiti" },
            { "type.ca.roc", "Minguo egutegia" },
            { "vi", "vietnamera" },
            { "khq", "koyra chiini" },
            { "key.hc", "Ordu-zikloa (12 vs 24)" },
            { "%%TARASK", "Taraskievica ortografia" },
            { "vo", "volap\u00fck" },
            { "type.nu.mathsans", "Sans-Serif digitu matematikoak" },
            { "Osma", "osmaiera" },
            { "quc", "quicheera" },
            { "type.nu.gonm", "Masaram Gondi digituak" },
            { "Newa", "newaera" },
            { "gaa", "ga" },
            { "wa", "waloiera" },
            { "gag", "gagauzera" },
            { "syr", "asiriera" },
            { "Cpmn", "zipro-minoera" },
            { "type.nu.gong", "Gunjala Gondi digituak" },
            { "Grek", "grekoa" },
            { "Lydi", "lidiera" },
            { "Xsux", "sumero-akadiera kuneiformea" },
            { "wo", "wolofera" },
            { "zgh", "amazigera estandarra" },
            { "ar_001", "arabiera moderno estandarra" },
            { "Cans", "Kanadiako aborigenen silabiko bateratua" },
            { "Mong", "mongoliarra" },
            { "Hluw", "hieroglifiko anatoliarrak" },
            { "mni", "manipurera" },
            { "Latn", "latinoa" },
            { "Nand", "nandinagariera" },
            { "type.nu.hans", "Zenbaki txinatar sinplifikatuak" },
            { "type.nu.hant", "Zenbaki txinatar tradizionalak" },
            { "xh", "xhosera" },
            { "type.nu.romanlow", "Zenbaki erromatarrak minuskulaz" },
            { "byn", "bilena" },
            { "Dogr", "dogrera" },
            { "%%PAMAKA", "Pamaka dialektoa" },
            { "Lyci", "liziera" },
            { "moh", "mohawkera" },
            { "kkj", "kako" },
            { "%%1694ACAD", "frantses moderno goiztiarra" },
            { "yi", "yiddish" },
            { "mos", "moreera" },
            { "Syrc", "siriera" },
            { "Dsrt", "deseret" },
            { "yo", "jorubera" },
            { "type.nu.traditional", "Zenbaki tradizionalak" },
            { "es_MX", "Mexikoko espainiera" },
            { "vai", metaValue_vai },
            { "Cari", "kariera" },
            { "kln", "kalenjinera" },
            { "zh", "txinera" },
            { "Bopo", "bopomofoa" },
            { "Perm", "permiera zaharra" },
            { "key.lb", "Lerro-jauziaren estiloa" },
            { "zu", "zuluera" },
            { "type.co.phonebook", "Telefonoen zerrenda" },
            { "%%MONOTON", "Tonu bakarra" },
            { "Geor", "georgiarra" },
            { "Shrd", "sharada" },
            { "kmb", "kimbundua" },
            { "type.nu.jpanfin", "Finantzetarako zenbaki japoniarrak" },
            { "Cham", "txamera" },
            { "gez", "ge\u2019ez" },
            { "type.nu.mymrshan", "Shan digitu birmaniarrak" },
            { "Elba", "elbasanera" },
            { "Narb", "iparraldeko arabiera zaharra" },
            { "type.nu.olck", "Ol Chiki digituak" },
            { "type.co.reformed", "Erreformaren araberako hurrenkera" },
            { "Tglg", metaValue_tl },
            { "Yezi", "yezidiera" },
            { "Palm", "palmiera" },
            { "ebu", "embuera" },
            { "Egyp", "egiptoar hieroglifikoak" },
            { "zh_Hans", "txinera sinplifikatu" },
            { "koi", "komi-permyakera" },
            { "Hung", "hungariera zaharra" },
            { "kok", "konkanera" },
            { "%%1901", "ortografia aleman tradizionala" },
            { "type.nu.limb", "Digitu limbutarrak" },
            { "zh_Hant", "txinera tradizionala" },
            { "Sund", "sudanera" },
            { "kpe", "kpellea" },
            { "type.nu.khmr", "Digitu khemerarrak" },
            { "Tirh", "tirhuta" },
            { "ilo", "ilokanera" },
            { "%%VALENCIA", "Valentziera" },
            { "Cprt", "ziprera" },
            { "Diak", "dives akuru" },
            { "%%BAKU1926", "Turkieraren latindar alfabeto bateratua" },
            { "%%IJEKAVSK", "Serbiera ijekavieraren ahoskerarekin" },
            { "mua", "mudangera" },
            { "type.nu.guru", "Digitu gurmukhiak" },
            { "mul", "zenbait hizkuntza" },
            { "key.ms", "Neurketa-sistema" },
            { "mus", "creera" },
            { "Glag", "glagolitikera" },
            { "gil", "gilbertera" },
            { "%%KKCOR", "Ortografia arrunta" },
            { "Cher", metaValue_chr },
            { "type.nu.tamldec", "Digitu tamilarrak" },
            { "krc", "karachayera-balkarera" },
            { "inh", "ingushera" },
            { "fa_AF", "daria" },
            { "krl", "kareliera" },
            { "%%OXENDICT", "Oxfordeko ingeles-hiztegiko ortografia" },
            { "efi", "efikera" },
            { "key.nu", "Zenbakiak" },
            { "kru", "kurukhera" },
            { "ksb", "shambalera" },
            { "Telu", "teluguarra" },
            { "ksf", "bafiera" },
        };
        return data;
    }
}
