/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_th extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AZ = "อาเซอร์ไบจาน";
        final String metaValue_BY = "เบลารุส";
        final String metaValue_BG = "บัลแกเรีย";
        final String metaValue_CZ = "เช็ก";
        final String metaValue_DK = "เดนมาร์ก";
        final String metaValue_ES = "สเปน";
        final String metaValue_EE = "เอสโตเนีย";
        final String metaValue_FI = "ฟินแลนด์";
        final String metaValue_FJ = "ฟิจิ";
        final String metaValue_FR = "ฝรั่งเศส";
        final String metaValue_HR = "โครเอเชีย";
        final String metaValue_HU = "ฮังการี";
        final String metaValue_AM = "อาร์เมเนีย";
        final String metaValue_ID = "อินโดนีเซีย";
        final String metaValue_IS = "ไอซ์แลนด์";
        final String metaValue_IT = "อิตาลี";
        final String metaValue_JP = "ญี่ปุ่น";
        final String metaValue_GE = "จอร์เจีย";
        final String metaValue_GL = "กรีนแลนด์";
        final String metaValue_LU = "ลักเซมเบิร์ก";
        final String metaValue_UG = "ยูกันดา";
        final String metaValue_LA = "ลาว";
        final String metaValue_LT = "ลิทัวเนีย";
        final String metaValue_LV = "ลัตเวีย";
        final String metaValue_MN = "มองโกเลีย";
        final String metaValue_MT = "มอลตา";
        final String metaValue_NR = "นาอูรู";
        final String metaValue_NP = "เนปาล";
        final String metaValue_NO = "นอร์เวย์";
        final String metaValue_PL = "โปแลนด์";
        final String metaValue_PT = "โปรตุเกส";
        final String metaValue_BI = "บุรุนดี";
        final String metaValue_RO = "โรมาเนีย";
        final String metaValue_RU = "รัสเซีย";
        final String metaValue_RW = "รวันดา";
        final String metaValue_SI = "สโลวีเนีย";
        final String metaValue_WS = "ซามัว";
        final String metaValue_AL = "แอลเบเนีย";
        final String metaValue_RS = "เซอร์เบีย";
        final String metaValue_SE = "สวีเดน";
        final String metaValue_TH = "ไทย";
        final String metaValue_TO = "ตองกา";
        final String metaValue_TR = "ตุรกี";
        final String metaValue_UA = "ยูเครน";
        final String metaValue_VN = "เวียดนาม";
        final String metaValue_CN = "จีน";
        final String metaValue_PH = "ฟิลิปปินส์";
        final String metaValue_PW = "ปาเลา";
        final String metaValue_SY = "ซีเรีย";
        final String metaValue_TK = "โตเกเลา";
        final String metaValue_TV = "ตูวาลู";
        final String metaValue_ar = "อาหรับ";
        final String metaValue_ae = "อเวสตะ";
        final String metaValue_ban = "บาหลี";
        final String metaValue_zbl = "บลิสซิมโบลส์";
        final String metaValue_bug = "บูกิส";
        final String metaValue_ccp = "จักม่า";
        final String metaValue_chr = "เชอโรกี";
        final String metaValue_cop = "คอปติก";
        final String metaValue_got = "โกธิก";
        final String metaValue_el = "กรีก";
        final String metaValue_gu = "คุชราต";
        final String metaValue_jv = "ชวา";
        final String metaValue_km = "เขมร";
        final String metaValue_kn = "กันนาดา";
        final String metaValue_ko = "เกาหลี";
        final String metaValue_la = "ละติน";
        final String metaValue_men = "เมนเด";
        final String metaValue_ml = "มาลายาลัม";
        final String metaValue_my = "พม่า";
        final String metaValue_nqo = "เอ็นโก";
        final String metaValue_phn = "ฟินิเชีย";
        final String metaValue_si = "สิงหล";
        final String metaValue_su = "ซุนดา";
        final String metaValue_ta = "ทมิฬ";
        final String metaValue_te = "เตลูกู";
        final String metaValue_tl = "ตากาล็อก";
        final String metaValue_bo = "ทิเบต";
        final String metaValue_uga = "ยูการิต";
        final String metaValue_vai = "ไว";
        final String metaValue_peo = "เปอร์เซียโบราณ";
        final String metaValue_MD = "มอลโดวา";
        final String metaValue_ssy = "ซาโฮ";
        final String metaValue_Hant = "ตัวเต็ม";
        final String metaValue_Hans = "ตัวย่อ";
        final String metaValue_key_nu = "ตัวเลข";
        final Object[][] data = new Object[][] {
            { "001", "โลก" },
            { "002", "แอฟริกา" },
            { "003", "อเมริกาเหนือ" },
            { "005", "อเมริกาใต้" },
            { "009", "โอเชียเนีย" },
            { "011", "แอฟริกาตะวันตก" },
            { "013", "อเมริกากลาง" },
            { "014", "แอฟริกาตะวันออก" },
            { "015", "แอฟริกาเหนือ" },
            { "017", "แอฟริกากลาง" },
            { "018", "แอฟริกาตอนใต้" },
            { "019", "อเมริกา" },
            { "021", "อเมริกาตอนเหนือ" },
            { "029", "แคริบเบียน" },
            { "030", "เอเชียตะวันออก" },
            { "034", "เอเชียใต้" },
            { "035", "เอเชียตะวันออกเฉียงใต้" },
            { "039", "ยุโรปใต้" },
            { "053", "ออสตราเลเซีย" },
            { "054", "เมลานีเซีย" },
            { "057", "เขตไมโครนีเซีย" },
            { "061", "โปลินีเซีย" },
            { "142", "เอเชีย" },
            { "143", "เอเชียกลาง" },
            { "145", "เอเชียตะวันตก" },
            { "150", "ยุโรป" },
            { "151", "ยุโรปตะวันออก" },
            { "154", "ยุโรปเหนือ" },
            { "155", "ยุโรปตะวันตก" },
            { "202", "แอฟริกาใต้สะฮารา" },
            { "419", "ละตินอเมริกา" },
            { "AC", "เกาะแอสเซนชัน" },
            { "AD", "อันดอร์รา" },
            { "AE", "สหรัฐอาหรับเอมิเรตส์" },
            { "AF", "อัฟกานิสถาน" },
            { "AG", "แอนติกาและบาร์บูดา" },
            { "AI", "แองกวิลลา" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "AO", "แองโกลา" },
            { "AQ", "แอนตาร์กติกา" },
            { "AR", "อาร์เจนตินา" },
            { "AS", "อเมริกันซามัว" },
            { "AT", "ออสเตรีย" },
            { "AU", "ออสเตรเลีย" },
            { "AW", "อารูบา" },
            { "AX", "หมู่เกาะโอลันด์" },
            { "AZ", metaValue_AZ },
            { "BA", "บอสเนียและเฮอร์เซโกวีนา" },
            { "BB", "บาร์เบโดส" },
            { "BD", "บังกลาเทศ" },
            { "BE", "เบลเยียม" },
            { "BF", "บูร์กินาฟาโซ" },
            { "BG", metaValue_BG },
            { "BH", "บาห์เรน" },
            { "BI", metaValue_BI },
            { "BJ", "เบนิน" },
            { "BL", "เซนต์บาร์เธเลมี" },
            { "BM", "เบอร์มิวดา" },
            { "BN", "บรูไน" },
            { "BO", "โบลิเวีย" },
            { "BQ", "เนเธอร์แลนด์แคริบเบียน" },
            { "BR", "บราซิล" },
            { "BS", "บาฮามาส" },
            { "BT", "ภูฏาน" },
            { "BV", "เกาะบูเว" },
            { "BW", "บอตสวานา" },
            { "BY", metaValue_BY },
            { "BZ", "เบลีซ" },
            { "CA", "แคนาดา" },
            { "CC", "หมู่เกาะโคโคส (คีลิง)" },
            { "CD", "คองโก - กินชาซา" },
            { "CF", "สาธารณรัฐแอฟริกากลาง" },
            { "CG", "คองโก - บราซซาวิล" },
            { "CH", "สวิตเซอร์แลนด์" },
            { "CI", "โกตดิวัวร์" },
            { "CK", "หมู่เกาะคุก" },
            { "CL", "ชิลี" },
            { "CM", "แคเมอรูน" },
            { "CN", metaValue_CN },
            { "CO", "โคลอมเบีย" },
            { "CP", "เกาะคลิปเปอร์ตัน" },
            { "CR", "คอสตาริกา" },
            { "CU", "คิวบา" },
            { "CV", "เคปเวิร์ด" },
            { "CW", "คูราเซา" },
            { "CX", "เกาะคริสต์มาส" },
            { "CY", "ไซปรัส" },
            { "CZ", metaValue_CZ },
            { "DE", "เยอรมนี" },
            { "DG", "ดิเอโกการ์เซีย" },
            { "DJ", "จิบูตี" },
            { "DK", metaValue_DK },
            { "DM", "โดมินิกา" },
            { "DO", "สาธารณรัฐโดมินิกัน" },
            { "DZ", "แอลจีเรีย" },
            { "EA", "เซวตาและเมลียา" },
            { "EC", "เอกวาดอร์" },
            { "EE", metaValue_EE },
            { "EG", "อียิปต์" },
            { "EH", "ซาฮาราตะวันตก" },
            { "ER", "เอริเทรีย" },
            { "ES", metaValue_ES },
            { "ET", "เอธิโอเปีย" },
            { "EU", "สหภาพยุโรป" },
            { "EZ", "ยูโรโซน" },
            { "FI", metaValue_FI },
            { "FJ", metaValue_FJ },
            { "FK", "หมู่เกาะฟอล์กแลนด์" },
            { "FM", "ไมโครนีเซีย" },
            { "FO", "หมู่เกาะแฟโร" },
            { "FR", metaValue_FR },
            { "GA", "กาบอง" },
            { "GB", "สหราชอาณาจักร" },
            { "GD", "เกรเนดา" },
            { "GE", metaValue_GE },
            { "GF", "เฟรนช์เกียนา" },
            { "GG", "เกิร์นซีย์" },
            { "GH", "กานา" },
            { "GI", "ยิบรอลตาร์" },
            { "GL", metaValue_GL },
            { "GM", "แกมเบีย" },
            { "GN", "กินี" },
            { "GP", "กวาเดอลูป" },
            { "GQ", "อิเควทอเรียลกินี" },
            { "GR", "กรีซ" },
            { "GS", "เกาะเซาท์จอร์เจียและหมู่เกาะเซาท์แซนด์วิช" },
            { "GT", "กัวเตมาลา" },
            { "GU", "กวม" },
            { "GW", "กินี-บิสเซา" },
            { "GY", "กายอานา" },
            { "HK", "เขตปกครองพิเศษฮ่องกงแห่งสาธารณรัฐประชาชนจีน" },
            { "HM", "เกาะเฮิร์ดและหมู่เกาะแมกดอนัลด์" },
            { "HN", "ฮอนดูรัส" },
            { "HR", metaValue_HR },
            { "HT", "เฮติ" },
            { "HU", metaValue_HU },
            { "IC", "หมู่เกาะคานารี" },
            { "ID", metaValue_ID },
            { "IE", "ไอร์แลนด์" },
            { "IL", "อิสราเอล" },
            { "IM", "เกาะแมน" },
            { "IN", "อินเดีย" },
            { "IO", "บริติชอินเดียนโอเชียนเทร์ริทอรี" },
            { "IQ", "อิรัก" },
            { "IR", "อิหร่าน" },
            { "IS", metaValue_IS },
            { "IT", metaValue_IT },
            { "JE", "เจอร์ซีย์" },
            { "JM", "จาเมกา" },
            { "JO", "จอร์แดน" },
            { "JP", metaValue_JP },
            { "KE", "เคนยา" },
            { "KG", "คีร์กีซสถาน" },
            { "KH", "กัมพูชา" },
            { "KI", "คิริบาส" },
            { "KM", "คอโมโรส" },
            { "KN", "เซนต์คิตส์และเนวิส" },
            { "KP", "เกาหลีเหนือ" },
            { "KR", "เกาหลีใต้" },
            { "KW", "คูเวต" },
            { "KY", "หมู่เกาะเคย์แมน" },
            { "KZ", "คาซัคสถาน" },
            { "LA", metaValue_LA },
            { "LB", "เลบานอน" },
            { "LC", "เซนต์ลูเซีย" },
            { "LI", "ลิกเตนสไตน์" },
            { "LK", "ศรีลังกา" },
            { "LR", "ไลบีเรีย" },
            { "LS", "เลโซโท" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "LY", "ลิเบีย" },
            { "MA", "โมร็อกโก" },
            { "MC", "โมนาโก" },
            { "MD", metaValue_MD },
            { "ME", "มอนเตเนโกร" },
            { "MF", "เซนต์มาร์ติน" },
            { "MG", "มาดากัสการ์" },
            { "MH", "หมู่เกาะมาร์แชลล์" },
            { "MK", "มาซิโดเนียเหนือ" },
            { "ML", "มาลี" },
            { "MM", "เมียนมา (พม่า)" },
            { "MN", metaValue_MN },
            { "MO", "เขตปกครองพิเศษมาเก๊าแห่งสาธารณรัฐประชาชนจีน" },
            { "MP", "หมู่เกาะนอร์เทิร์นมาเรียนา" },
            { "MQ", "มาร์ตินีก" },
            { "MR", "มอริเตเนีย" },
            { "MS", "มอนต์เซอร์รัต" },
            { "MT", metaValue_MT },
            { "MU", "มอริเชียส" },
            { "MV", "มัลดีฟส์" },
            { "MW", "มาลาวี" },
            { "MX", "เม็กซิโก" },
            { "MY", "มาเลเซีย" },
            { "MZ", "โมซัมบิก" },
            { "NA", "นามิเบีย" },
            { "NC", "นิวแคลิโดเนีย" },
            { "NE", "ไนเจอร์" },
            { "NF", "เกาะนอร์ฟอล์ก" },
            { "NG", "ไนจีเรีย" },
            { "NI", "นิการากัว" },
            { "NL", "เนเธอร์แลนด์" },
            { "NO", metaValue_NO },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "นีอูเอ" },
            { "NZ", "นิวซีแลนด์" },
            { "OM", "โอมาน" },
            { "PA", "ปานามา" },
            { "PE", "เปรู" },
            { "PF", "เฟรนช์โปลินีเซีย" },
            { "PG", "ปาปัวนิวกินี" },
            { "PH", metaValue_PH },
            { "PK", "ปากีสถาน" },
            { "PL", metaValue_PL },
            { "PM", "แซงปีแยร์และมีเกอลง" },
            { "PN", "หมู่เกาะพิตแคร์น" },
            { "PR", "เปอร์โตริโก" },
            { "PS", "ดินแดนปาเลสไตน์" },
            { "PT", metaValue_PT },
            { "PW", metaValue_PW },
            { "PY", "ปารากวัย" },
            { "QA", "กาตาร์" },
            { "QO", "เอาต์ไลอิงโอเชียเนีย" },
            { "RE", "เรอูนียง" },
            { "RO", metaValue_RO },
            { "RS", metaValue_RS },
            { "RU", metaValue_RU },
            { "RW", metaValue_RW },
            { "SA", "ซาอุดีอาระเบีย" },
            { "SB", "หมู่เกาะโซโลมอน" },
            { "SC", "เซเชลส์" },
            { "SD", "ซูดาน" },
            { "SE", metaValue_SE },
            { "SG", "สิงคโปร์" },
            { "SH", "เซนต์เฮเลนา" },
            { "SI", metaValue_SI },
            { "SJ", "สฟาลบาร์และยานไมเอน" },
            { "SK", "สโลวะเกีย" },
            { "SL", "เซียร์ราลีโอน" },
            { "SM", "ซานมาริโน" },
            { "SN", "เซเนกัล" },
            { "SO", "โซมาเลีย" },
            { "SR", "ซูรินาเม" },
            { "SS", "ซูดานใต้" },
            { "ST", "เซาตูเมและปรินซิปี" },
            { "SV", "เอลซัลวาดอร์" },
            { "SX", "ซินต์มาร์เทน" },
            { "SY", metaValue_SY },
            { "SZ", "เอสวาตีนี" },
            { "TA", "ทริสตันดาคูนา" },
            { "TC", "หมู่เกาะเติกส์และหมู่เกาะเคคอส" },
            { "TD", "ชาด" },
            { "TF", "เฟรนช์เซาเทิร์นเทร์ริทอรีส์" },
            { "TG", "โตโก" },
            { "TH", metaValue_TH },
            { "TJ", "ทาจิกิสถาน" },
            { "TK", metaValue_TK },
            { "TL", "ติมอร์-เลสเต" },
            { "TM", "เติร์กเมนิสถาน" },
            { "TN", "ตูนิเซีย" },
            { "TO", metaValue_TO },
            { "TR", metaValue_TR },
            { "TT", "ตรินิแดดและโตเบโก" },
            { "TV", metaValue_TV },
            { "TW", "ไต้หวัน" },
            { "TZ", "แทนซาเนีย" },
            { "UA", metaValue_UA },
            { "UG", metaValue_UG },
            { "UM", "หมู่เกาะรอบนอกของสหรัฐอเมริกา" },
            { "UN", "สหประชาชาติ" },
            { "US", "สหรัฐอเมริกา" },
            { "UY", "อุรุกวัย" },
            { "UZ", "อุซเบกิสถาน" },
            { "VA", "นครวาติกัน" },
            { "VC", "เซนต์วินเซนต์และเกรนาดีนส์" },
            { "VE", "เวเนซุเอลา" },
            { "VG", "หมู่เกาะบริติชเวอร์จิน" },
            { "VI", "หมู่เกาะเวอร์จินของสหรัฐอเมริกา" },
            { "VN", metaValue_VN },
            { "VU", "วานูอาตู" },
            { "WF", "วาลลิสและฟุตูนา" },
            { "WS", metaValue_WS },
            { "XA", "สำเนียงไม่จริง" },
            { "XB", "Bidi ไม่จริง" },
            { "XK", "โคโซโว" },
            { "YE", "เยเมน" },
            { "YT", "มายอต" },
            { "ZA", "แอฟริกาใต้" },
            { "ZM", "แซมเบีย" },
            { "ZW", "ซิมบับเว" },
            { "ZZ", "ภูมิภาคที่ไม่รู้จัก" },
            { "aa", "อะฟาร์" },
            { "ab", "อับฮาเซีย" },
            { "ae", metaValue_ae },
            { "af", "แอฟริกานส์" },
            { "ak", "อาคาน" },
            { "am", "อัมฮารา" },
            { "an", "อารากอน" },
            { "ar", metaValue_ar },
            { "as", "อัสสัม" },
            { "av", "อาวาร์" },
            { "ay", "ไอย์มารา" },
            { "az", metaValue_AZ },
            { "ba", "บัชคีร์" },
            { "be", metaValue_BY },
            { "bg", metaValue_BG },
            { "bi", "บิสลามา" },
            { "bm", "บัมบารา" },
            { "bn", "บังกลา" },
            { "bo", metaValue_bo },
            { "br", "เบรตัน" },
            { "bs", "บอสเนีย" },
            { "ca", "คาตาลัน" },
            { "ce", "เชเชน" },
            { "ch", "ชามอร์โร" },
            { "co", "คอร์ซิกา" },
            { "cr", "ครี" },
            { "cs", metaValue_CZ },
            { "cu", "เชอร์ชสลาวิก" },
            { "cv", "ชูวัช" },
            { "cy", "เวลส์" },
            { "da", metaValue_DK },
            { "de", "เยอรมัน" },
            { "dv", "ธิเวหิ" },
            { "dz", "ซองคา" },
            { "ee", "เอเว" },
            { "el", metaValue_el },
            { "en", "อังกฤษ" },
            { "eo", "เอสเปรันโต" },
            { "es", metaValue_ES },
            { "et", metaValue_EE },
            { "eu", "บาสก์" },
            { "fa", "เปอร์เซีย" },
            { "ff", "ฟูลาห์" },
            { "fi", metaValue_FI },
            { "fj", metaValue_FJ },
            { "fo", "แฟโร" },
            { "fr", metaValue_FR },
            { "fy", "ฟริเซียนตะวันตก" },
            { "ga", "ไอริช" },
            { "gd", "เกลิกสกอต" },
            { "gl", "กาลิเซีย" },
            { "gn", "กัวรานี" },
            { "gu", metaValue_gu },
            { "gv", "มานซ์" },
            { "ha", "เฮาซา" },
            { "he", "ฮิบรู" },
            { "hi", "ฮินดี" },
            { "ho", "ฮีรีโมตู" },
            { "hr", metaValue_HR },
            { "ht", "เฮติครีโอล" },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "เฮเรโร" },
            { "ia", "อินเตอร์ลิงกัว" },
            { "id", metaValue_ID },
            { "ie", "อินเตอร์ลิงกิว" },
            { "ig", "อิกโบ" },
            { "ii", "เสฉวนยี่" },
            { "ik", "อีนูเปียก" },
            { "io", "อีโด" },
            { "is", metaValue_IS },
            { "it", metaValue_IT },
            { "iu", "อินุกติตุต" },
            { "ja", metaValue_JP },
            { "jv", metaValue_jv },
            { "ka", metaValue_GE },
            { "kg", "คองโก" },
            { "ki", "กีกูยู" },
            { "kj", "กวนยามา" },
            { "kk", "คาซัค" },
            { "kl", metaValue_GL },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "คานูรี" },
            { "ks", "แคชเมียร์" },
            { "ku", "เคิร์ด" },
            { "kv", "โกมิ" },
            { "kw", "คอร์นิช" },
            { "ky", "คีร์กีซ" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "lg", metaValue_UG },
            { "li", "ลิมเบิร์ก" },
            { "ln", "ลิงกาลา" },
            { "lo", metaValue_LA },
            { "lt", metaValue_LT },
            { "lu", "ลูบา-กาตองกา" },
            { "lv", metaValue_LV },
            { "mg", "มาลากาซี" },
            { "mh", "มาร์แชลล์" },
            { "mi", "เมารี" },
            { "mk", "มาซิโดเนีย" },
            { "ml", metaValue_ml },
            { "mn", metaValue_MN },
            { "mr", "มราฐี" },
            { "ms", "มาเลย์" },
            { "mt", metaValue_MT },
            { "my", metaValue_my },
            { "na", metaValue_NR },
            { "nb", "นอร์เวย์บุคมอล" },
            { "nd", "เอ็นเดเบเลเหนือ" },
            { "ne", metaValue_NP },
            { "ng", "ดองกา" },
            { "nl", "ดัตช์" },
            { "nn", "นอร์เวย์นีนอสก์" },
            { "no", metaValue_NO },
            { "nr", "เอ็นเดเบเลใต้" },
            { "nv", "นาวาโฮ" },
            { "ny", "เนียนจา" },
            { "oc", "อ็อกซิตัน" },
            { "oj", "โอจิบวา" },
            { "om", "โอโรโม" },
            { "or", "โอดิยา" },
            { "os", "ออสเซเตีย" },
            { "pa", "ปัญจาบ" },
            { "pi", "บาลี" },
            { "pl", metaValue_PL },
            { "ps", "พัชโต" },
            { "pt", metaValue_PT },
            { "qu", "เคชวา" },
            { "rm", "โรแมนซ์" },
            { "rn", metaValue_BI },
            { "ro", metaValue_RO },
            { "ru", metaValue_RU },
            { "rw", metaValue_RW },
            { "sa", "สันสกฤต" },
            { "sc", "ซาร์เดญา" },
            { "sd", "สินธิ" },
            { "se", "ซามิเหนือ" },
            { "sg", "ซันโก" },
            { "sh", "เซอร์โบ-โครเอเชีย" },
            { "si", metaValue_si },
            { "sk", "สโลวัก" },
            { "sl", metaValue_SI },
            { "sm", metaValue_WS },
            { "sn", "โชนา" },
            { "so", "โซมาลี" },
            { "sq", metaValue_AL },
            { "sr", metaValue_RS },
            { "ss", "สวาติ" },
            { "st", "โซโทใต้" },
            { "su", metaValue_su },
            { "sv", metaValue_SE },
            { "sw", "สวาฮีลี" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "ทาจิก" },
            { "th", metaValue_TH },
            { "ti", "ติกริญญา" },
            { "tk", "เติร์กเมน" },
            { "tl", metaValue_tl },
            { "tn", "สวานา" },
            { "to", metaValue_TO },
            { "tr", metaValue_TR },
            { "ts", "ซองกา" },
            { "tt", "ตาตาร์" },
            { "tw", "ทวิ" },
            { "ty", "ตาฮิตี" },
            { "ug", "อุยกูร์" },
            { "uk", metaValue_UA },
            { "ur", "อูรดู" },
            { "uz", "อุซเบก" },
            { "ve", "เวนดา" },
            { "vi", metaValue_VN },
            { "vo", "โวลาพึค" },
            { "wa", "วอลลูน" },
            { "wo", "โวลอฟ" },
            { "xh", "คะห์โอซา" },
            { "yi", "ยิดดิช" },
            { "yo", "โยรูบา" },
            { "za", "จ้วง" },
            { "zh", metaValue_CN },
            { "zu", "ซูลู" },
            { "ace", "อาเจะห์" },
            { "ach", "อาโคลิ" },
            { "ada", "อาแดงมี" },
            { "ady", "อะดืยเก" },
            { "aeb", "อาหรับตูนิเซีย" },
            { "afh", "แอฟริฮีลี" },
            { "agq", "อักเฮม" },
            { "ain", "ไอนุ" },
            { "akk", "อักกาด" },
            { "akz", "แอละแบมา" },
            { "ale", "อาลิวต์" },
            { "aln", "เกกแอลเบเนีย" },
            { "alt", "อัลไตใต้" },
            { "ang", "อังกฤษโบราณ" },
            { "ann", "โอโบโล" },
            { "anp", "อังคิกา" },
            { "arc", "อราเมอิก" },
            { "arn", "มาปูเช" },
            { "aro", "อาเรานา" },
            { "arp", "อาราปาโฮ" },
            { "arq", "อาหรับแอลจีเรีย" },
            { "ars", "อาหรับนัจญ์ดี" },
            { "arw", "อาราวัก" },
            { "ary", "อาหรับโมร็อกโก" },
            { "arz", "อาหรับพื้นเมืองอียิปต์" },
            { "asa", "อาซู" },
            { "ase", "ภาษามืออเมริกัน" },
            { "ast", "อัสตูเรียส" },
            { "atj", "อะทิคาเมก" },
            { "avk", "โคตาวา" },
            { "awa", "อวธี" },
            { "bal", "บาลูชิ" },
            { "ban", metaValue_ban },
            { "bar", "บาวาเรีย" },
            { "bas", "บาสา" },
            { "bax", "บามัน" },
            { "bbc", "บาตักโทบา" },
            { "bbj", "โคมาลา" },
            { "bej", "เบจา" },
            { "bem", "เบมบา" },
            { "bew", "เบตาวี" },
            { "bez", "เบนา" },
            { "bfd", "บาฟัต" },
            { "bfq", "พทคะ" },
            { "bgc", "หริยนวี" },
            { "bgn", "บาลูจิตะวันตก" },
            { "bho", "โภชปุรี" },
            { "bik", "บิกอล" },
            { "bin", "บินี" },
            { "bjn", "บันจาร์" },
            { "bkm", "กม" },
            { "bla", "สิกสิกา" },
            { "blo", "อานี" },
            { "bpy", "พิศนุปริยะ" },
            { "bqi", "บักติยารี" },
            { "bra", "พัรช" },
            { "brh", "บราฮุย" },
            { "brx", "โพโฑ" },
            { "bss", "อาโคซี" },
            { "bua", "บูเรียต" },
            { "bug", metaValue_bug },
            { "bum", "บูลู" },
            { "byn", "บลิน" },
            { "byv", "เมดุมบา" },
            { "cad", "คัดโด" },
            { "car", "คาริบ" },
            { "cay", "คายูกา" },
            { "cch", "แอตแซม" },
            { "ccp", metaValue_ccp },
            { "ceb", "เซบู" },
            { "cgg", "คีกา" },
            { "chb", "ชิบชา" },
            { "chg", "ชะกะไต" },
            { "chk", "ชูก" },
            { "chm", "มารี" },
            { "chn", "ชินุกจาร์กอน" },
            { "cho", "ช็อกทอว์" },
            { "chp", "ชิพิวยัน" },
            { "chr", metaValue_chr },
            { "chy", "เชเยนเน" },
            { "ckb", "เคิร์ดตอนกลาง" },
            { "clc", "ชิลโคติน" },
            { "cop", metaValue_cop },
            { "cps", "กาปิซนอน" },
            { "crg", "มิชิฟ" },
            { "crh", "ตุรกีไครเมีย" },
            { "crj", "ครีตะวันออกเฉียงใต้" },
            { "crk", "เพลนส์ครี" },
            { "crl", "ครีตะวันออกเฉียงเหนือ" },
            { "crm", "มูสครี" },
            { "crr", "อัลกอนควินแคโรไลนา" },
            { "crs", "ครีโอลเซเซลส์ฝรั่งเศส" },
            { "csb", "คาซูเบียน" },
            { "csw", "สวอมปีครี" },
            { "dak", "ดาโกทา" },
            { "dar", "ดาร์กิน" },
            { "dav", "ไททา" },
            { "del", "เดลาแวร์" },
            { "den", "สเลวี" },
            { "dgr", "โดกริบ" },
            { "din", "ดิงกา" },
            { "dje", "ซาร์มา" },
            { "doi", "โฑครี" },
            { "dsb", "ซอร์เบียตอนล่าง" },
            { "dtp", "ดูซุนกลาง" },
            { "dua", "ดัวลา" },
            { "dum", "ดัตช์กลาง" },
            { "dyo", "โจลา-ฟอนยี" },
            { "dyu", "ดิวลา" },
            { "dzg", "ดาซากา" },
            { "ebu", "เอ็มบู" },
            { "efi", "อีฟิก" },
            { "egl", "เอมีเลีย" },
            { "egy", "อียิปต์โบราณ" },
            { "eka", "อีกาจุก" },
            { "elx", "อีลาไมต์" },
            { "enm", "อังกฤษกลาง" },
            { "esu", "ยูพิกกลาง" },
            { "ewo", "อีวันโด" },
            { "ext", "เอกซ์เตรมาดูรา" },
            { "fan", "ฟอง" },
            { "fat", "ฟันติ" },
            { "fil", metaValue_PH },
            { "fit", "ฟินแลนด์ทอร์เนดาเล็น" },
            { "fon", "ฟอน" },
            { "frc", "ฝรั่งเศสเคจัน" },
            { "frm", "ฝรั่งเศสกลาง" },
            { "fro", "ฝรั่งเศสโบราณ" },
            { "frp", "อาร์พิตา" },
            { "frr", "ฟริเซียนเหนือ" },
            { "frs", "ฟริเซียนตะวันออก" },
            { "fur", "ฟรูลี" },
            { "gaa", "กา" },
            { "gag", "กากาอุซ" },
            { "gan", "จีนกั้น" },
            { "gay", "กาโย" },
            { "gba", "กบายา" },
            { "gbz", "ดารีโซโรอัสเตอร์" },
            { "gez", "กีซ" },
            { "gil", "กิลเบอร์ต" },
            { "glk", "กิลากี" },
            { "gmh", "เยอรมันสูงกลาง" },
            { "goh", "เยอรมันสูงโบราณ" },
            { "gon", "กอนดิ" },
            { "gor", "กอรอนทาโล" },
            { "got", metaValue_got },
            { "grb", "เกรโบ" },
            { "grc", "กรีกโบราณ" },
            { "gsw", "เยอรมันสวิส" },
            { "guc", "วายู" },
            { "gur", "ฟราฟรา" },
            { "guz", "กุซซี" },
            { "gwi", "กวิชอิน" },
            { "hai", "ไฮดา" },
            { "hak", "จีนแคะ" },
            { "haw", "ฮาวาย" },
            { "hax", "เฮดาใต้" },
            { "hif", "ฮินดีฟิจิ" },
            { "hil", "ฮีลีกัยนน" },
            { "hit", "ฮิตไตต์" },
            { "hmn", "ม้ง" },
            { "hsb", "ซอร์เบียตอนบน" },
            { "hsn", "จีนเซียง" },
            { "hup", "ฮูปา" },
            { "hur", "ฮัลโกเมเลม" },
            { "iba", "อิบาน" },
            { "ibb", "อิบิบิโอ" },
            { "ikt", "อินุกติตุตแคนาดาตะวันตก" },
            { "ilo", "อีโลโก" },
            { "inh", "อินกุช" },
            { "izh", "อินเกรียน" },
            { "jam", "อังกฤษคลีโอลจาเมกา" },
            { "jbo", "โลชบัน" },
            { "jgo", "อึนกอมบา" },
            { "jmc", "มาชาเม" },
            { "jpr", "ยิว-เปอร์เซีย" },
            { "jrb", "ยิว-อาหรับ" },
            { "jut", "จัท" },
            { "kaa", "การา-กาลพาก" },
            { "kab", "กาไบล" },
            { "kac", "กะฉิ่น" },
            { "kaj", "คจู" },
            { "kam", "คัมบา" },
            { "kaw", "กวี" },
            { "kbd", "คาบาร์เดีย" },
            { "kbl", "คาเนมบู" },
            { "kcg", "ทีแยป" },
            { "kde", "มาคอนเด" },
            { "kea", "คาบูเวอร์เดียนู" },
            { "ken", "เกินยาง" },
            { "kfo", "โคโร" },
            { "kgp", "เคนก่าง" },
            { "kha", "กาสี" },
            { "kho", "โคตัน" },
            { "khq", "โคย์ราชีนี" },
            { "khw", "โควาร์" },
            { "kiu", "เคอร์มานิกิ" },
            { "kkj", "คาโก" },
            { "kln", "คาเลนจิน" },
            { "kmb", "คิมบุนดู" },
            { "koi", "โคมิ-เปียร์เมียค" },
            { "kok", "กอนกานี" },
            { "kos", "คูสไร" },
            { "kpe", "กาแปล" },
            { "krc", "คาราไช-บัลคาร์" },
            { "kri", "คริโอ" },
            { "krj", "กินารายอา" },
            { "krl", "คารีเลียน" },
            { "kru", "กุรุข" },
            { "ksb", "ชัมบาลา" },
            { "ksf", "บาเฟีย" },
            { "ksh", "โคโลญ" },
            { "kum", "คูมืยค์" },
            { "kut", "คูเทไน" },
            { "kwk", "ควักวาลา" },
            { "kxv", "กูวี" },
            { "lad", "ลาดิโน" },
            { "lag", "แลนจี" },
            { "lah", "ลาฮ์นดา" },
            { "lam", "แลมบา" },
            { "lez", "เลซเกีย" },
            { "lfn", "ลิงกัวฟรังกาโนวา" },
            { "lij", "ลิกูเรีย" },
            { "lil", "ลิลลูเอต" },
            { "liv", "ลิโวเนีย" },
            { "lkt", "ลาโกตา" },
            { "lmo", "ลอมบาร์ด" },
            { "lol", "มองโก" },
            { "lou", "ครีโอลุยเซียนา" },
            { "loz", "โลซิ" },
            { "lrc", "ลูรีเหนือ" },
            { "lsm", "ซาเมีย" },
            { "ltg", "ลัตเกล" },
            { "lua", "ลูบา-ลูลัว" },
            { "lui", "ลุยเซโน" },
            { "lun", "ลันดา" },
            { "luo", "ลัว" },
            { "lus", "มิโซ" },
            { "luy", "ลูเยีย" },
            { "lzh", "จีนคลาสสิก" },
            { "lzz", "แลซ" },
            { "mad", "มาดูรา" },
            { "maf", "มาฟา" },
            { "mag", "มคหี" },
            { "mai", "ไมถิลี" },
            { "mak", "มากาซาร์" },
            { "man", "มันดิงกา" },
            { "mas", "มาไซ" },
            { "mde", "มาบา" },
            { "mdf", "มอคชา" },
            { "mdr", "มานดาร์" },
            { "men", metaValue_men },
            { "mer", "เมรู" },
            { "mfe", "มอริสเยน" },
            { "mga", "ไอริชกลาง" },
            { "mgh", "มากัววา-มีทโท" },
            { "mgo", "เมตา" },
            { "mic", "มิกแมก" },
            { "min", "มีนังกาเบา" },
            { "mnc", "แมนจู" },
            { "mni", "มณีปุระ" },
            { "moe", "อินนุ-ไอมุน" },
            { "moh", "โมฮอว์ก" },
            { "mos", "โมซี" },
            { "mrj", "มารีตะวันตก" },
            { "mua", "มันดัง" },
            { "mul", "หลายภาษา" },
            { "mus", "มัสคีกี" },
            { "mwl", "มีรันดา" },
            { "mwr", "มารวาฑี" },
            { "mwv", "เม็นตาไว" },
            { "mye", "มยีน" },
            { "myv", "เอียร์ซยา" },
            { "mzn", "มาซันดารานี" },
            { "nan", "จีนมินหนาน" },
            { "nap", "นาโปลี" },
            { "naq", "นามา" },
            { "nds", "เยอรมันต่ำ" },
            { "new", "เนวาร์" },
            { "nia", "นีอัส" },
            { "niu", "นีวเว" },
            { "njo", "อ๋าวนากา" },
            { "nmg", "กวาซิโอ" },
            { "nnh", "จีมบูน" },
            { "nog", "โนไก" },
            { "non", "นอร์สโบราณ" },
            { "nov", "โนเวียล" },
            { "nqo", metaValue_nqo },
            { "nso", "โซโทเหนือ" },
            { "nus", "เนือร์" },
            { "nwc", "เนวาร์ดั้งเดิม" },
            { "nym", "เนียมเวซี" },
            { "nyn", "เนียนโกเล" },
            { "nyo", "นิโอโร" },
            { "nzi", "นซิมา" },
            { "ojb", "โอจิบเวตะวันตกเฉียงเหนือ" },
            { "ojc", "โอจิบเวตอนกลาง" },
            { "ojs", "ออจิ-ครี" },
            { "ojw", "โอจิบเวตะวันตก" },
            { "oka", "โอคานากัน" },
            { "osa", "โอซากี" },
            { "ota", "ตุรกีออตโตมัน" },
            { "pag", "ปังกาซีนัน" },
            { "pal", "ปะห์ลาวี" },
            { "pam", "ปัมปังกา" },
            { "pap", "ปาเปียเมนโต" },
            { "pau", metaValue_PW },
            { "pcd", "ปิการ์" },
            { "pcm", "ไนจีเรียนพิดจิน" },
            { "pdc", "เยอรมันเพนซิลเวเนีย" },
            { "pdt", "เพลาท์ดิช" },
            { "peo", metaValue_peo },
            { "pfl", "เยอรมันพาลาทิเนต" },
            { "phn", metaValue_phn },
            { "pis", "พิดจิน" },
            { "pms", "พีดมอนต์" },
            { "pnt", "พอนติก" },
            { "pon", "พอห์นเพ" },
            { "pqm", "มาเลไซท์-ปัสมาโควดี" },
            { "prg", "ปรัสเซีย" },
            { "pro", "โปรวองซาลโบราณ" },
            { "quc", "กีเช" },
            { "qug", "ควิชัวไฮแลนด์ชิมโบราโซ" },
            { "raj", "ราชสถาน" },
            { "rap", "ราปานูอี" },
            { "rar", "ราโรทองกา" },
            { "rgn", "โรมัณโญ" },
            { "rhg", "โรฮิงญา" },
            { "rif", "ริฟฟิอัน" },
            { "rof", "รอมโบ" },
            { "rom", "โรมานี" },
            { "rtm", "โรทูมัน" },
            { "rue", "รูซิน" },
            { "rug", "โรเวียนา" },
            { "rup", "อาโรมาเนีย" },
            { "rwk", "รวา" },
            { "sad", "ซันดาเว" },
            { "sah", "ซาคา" },
            { "sam", "อราเมอิกซามาเรีย" },
            { "saq", "แซมบูรู" },
            { "sas", "ซาซัก" },
            { "sat", "สันตาลี" },
            { "saz", "เสาราษฏร์" },
            { "sba", "กัมเบ" },
            { "sbp", "แซงกู" },
            { "scn", "ซิซิลี" },
            { "sco", "สกอตส์" },
            { "sdc", "ซาร์ดิเนียซาสซารี" },
            { "sdh", "เคอร์ดิชใต้" },
            { "see", "เซนิกา" },
            { "seh", "เซนา" },
            { "sei", "เซรี" },
            { "sel", "เซลคุป" },
            { "ses", "โคย์ราโบโรเซนนี" },
            { "sga", "ไอริชโบราณ" },
            { "sgs", "ซาโมจิเตียน" },
            { "shi", "ทาเชลีห์ท" },
            { "shn", "ไทใหญ่" },
            { "shu", "อาหรับ-ชาด" },
            { "sid", "ซิดาโม" },
            { "slh", "ลูชูตซีดใต้" },
            { "sli", "ไซลีเซียตอนล่าง" },
            { "sly", "เซลายาร์" },
            { "sma", "ซามิใต้" },
            { "smj", "ซามิลูเล" },
            { "smn", "ซามิอีนารี" },
            { "sms", "ซามิสคอลต์" },
            { "snk", "โซนีนเก" },
            { "sog", "ซอกดีน" },
            { "srn", "สรานานตองโก" },
            { "srr", "เซแรร์" },
            { "ssy", metaValue_ssy },
            { "stq", "ฟรีเซียนซัทเธอร์แลนด์" },
            { "str", "สเตรตส์ซาลิช" },
            { "suk", "ซูคูมา" },
            { "sus", "ซูซู" },
            { "sux", "ซูเมอ" },
            { "swb", "โคเมอเรีย" },
            { "syc", "ซีเรียแบบดั้งเดิม" },
            { "syr", metaValue_SY },
            { "szl", "ไซลีเซีย" },
            { "tce", "ทัชโชนใต้" },
            { "tcy", "ตูลู" },
            { "tem", "ทิมเน" },
            { "teo", "เตโซ" },
            { "ter", "เทเรโน" },
            { "tet", "เตตุม" },
            { "tgx", "ทากิช" },
            { "tht", "ทาลทาน" },
            { "tig", "ตีเกร" },
            { "tiv", "ทิฟ" },
            { "tkl", metaValue_TK },
            { "tkr", "แซคเซอร์" },
            { "tlh", "คลิงงอน" },
            { "tli", "ทลิงกิต" },
            { "tly", "ทาลิช" },
            { "tmh", "ทามาเชก" },
            { "tog", "ไนอะซาตองกา" },
            { "tok", "โทคิโพนา" },
            { "tpi", "ท็อกพิซิน" },
            { "tru", "ตูโรโย" },
            { "trv", "ทาโรโก" },
            { "tsd", "ซาโคเนีย" },
            { "tsi", "ซิมชีแอน" },
            { "ttm", "ทัชโชนเหนือ" },
            { "ttt", "ตัตมุสลิม" },
            { "tum", "ทุมบูกา" },
            { "tvl", metaValue_TV },
            { "twq", "ตัสซาวัค" },
            { "tyv", "ตูวา" },
            { "tzm", "ทามาไซต์แอตลาสกลาง" },
            { "udm", "อุดมูร์ต" },
            { "uga", metaValue_uga },
            { "umb", "อุมบุนดู" },
            { "und", "ภาษาที่ไม่รู้จัก" },
            { "vai", metaValue_vai },
            { "vec", "เวเนโต้" },
            { "vep", "เวปส์" },
            { "vls", "เฟลมิชตะวันตก" },
            { "vmf", "เมน-ฟรานโกเนีย" },
            { "vmw", "มากัววา" },
            { "vot", "โวทิก" },
            { "vro", "โวโร" },
            { "vun", "วุนจู" },
            { "wae", "วัลเซอร์" },
            { "wal", "โวแลตตา" },
            { "war", "วาเรย์" },
            { "was", "วาโช" },
            { "wbp", "วอล์เพอร์รี" },
            { "wuu", "จีนอู๋" },
            { "xal", "คัลมืยค์" },
            { "xmf", "เมเกรเลีย" },
            { "xnr", "กังกรี" },
            { "xog", "โซกา" },
            { "yao", "เย้า" },
            { "yap", "ยัป" },
            { "yav", "แยงเบน" },
            { "ybb", "เยมบา" },
            { "yrl", "เหงงกาตุ" },
            { "yue", "กวางตุ้ง" },
            { "zap", "ซาโปเตก" },
            { "zbl", metaValue_zbl },
            { "zea", "เซแลนด์" },
            { "zen", "เซนากา" },
            { "zgh", "ทามาไซต์โมร็อกโกมาตรฐาน" },
            { "zun", "ซูนิ" },
            { "zxx", "ไม่มีข้อมูลภาษา" },
            { "zza", "ซาซา" },
            { "Adlm", "อัดลัม" },
            { "Afak", "อะฟาคา" },
            { "Aghb", "แอลเบเนีย คอเคเซีย" },
            { "Arab", metaValue_ar },
            { "Aran", "นาสตาลิก" },
            { "Armi", "อิมพีเรียล อราเมอิก" },
            { "Armn", metaValue_AM },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", "บามุม" },
            { "Bass", "บัสซา" },
            { "Batk", "บาตัก" },
            { "Beng", "เบงกาลี" },
            { "Blis", metaValue_zbl },
            { "Bopo", "ปอพอมอฟอ" },
            { "Brah", "พราหมี" },
            { "Brai", "เบรลล์" },
            { "Bugi", metaValue_bug },
            { "Buhd", "บูฮิด" },
            { "Cakm", metaValue_ccp },
            { "Cans", "อักษรพยางค์ของชาวอะบอริจินในแคนาดา" },
            { "Cari", "คาเรีย" },
            { "Cham", "จาม" },
            { "Cher", metaValue_chr },
            { "Cirt", "เซิร์ท" },
            { "Copt", metaValue_cop },
            { "Cprt", "ไซเปรียท" },
            { "Cyrl", "ซีริลลิก" },
            { "Cyrs", "เชอร์ชสลาโวนิกซีริลลิกโบราณ" },
            { "Deva", "เทวนาครี" },
            { "Dsrt", "เดเซเรท" },
            { "Dupl", "ชวเลขดัปโลยัน" },
            { "Egyd", "ดีโมติกอียิปต์" },
            { "Egyh", "เฮียราติกอียิปต์" },
            { "Egyp", "เฮียโรกลิฟส์อียิปต์" },
            { "Elba", "เอลบ์ซาน" },
            { "Ethi", "เอธิโอปิก" },
            { "Geok", "คัตซูรีจอร์เจีย" },
            { "Geor", metaValue_GE },
            { "Glag", "กลาโกลิติก" },
            { "Goth", metaValue_got },
            { "Gran", "คฤณห์" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "กูร์มูคี" },
            { "Hanb", "จีนกลาง" },
            { "Hang", "ฮันกึล" },
            { "Hani", "ฮั่น" },
            { "Hano", "ฮานูโนโอ" },
            { "Hans", metaValue_Hans },
            { "Hant", metaValue_Hant },
            { "Hebr", "ฮีบรู" },
            { "Hira", "ฮิระงะนะ" },
            { "Hluw", "อักขระอานาโตเลีย" },
            { "Hmng", "ปาเฮาห์ม้ง" },
            { "Hrkt", "คะตะกะนะหรือฮิระงะนะ" },
            { "Hung", "ฮังการีโบราณ" },
            { "Inds", "อินดัส" },
            { "Ital", "อิตาลีโบราณ" },
            { "Jamo", "จาโม" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_JP },
            { "Jurc", "จูร์เชน" },
            { "Kali", "คยาห์" },
            { "Kana", "คะตะกะนะ" },
            { "Khar", "ขโรษฐี" },
            { "Khmr", metaValue_km },
            { "Khoj", "คอจคี" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", "เปลเล" },
            { "Kthi", "กายติ" },
            { "Lana", "ล้านนา" },
            { "Laoo", metaValue_LA },
            { "Latf", "ลาติน - ฟรังเตอร์" },
            { "Latg", "ลาติน - แกลิก" },
            { "Latn", metaValue_la },
            { "Lepc", "เลปชา" },
            { "Limb", "ลิมบู" },
            { "Lina", "ลีเนียร์เอ" },
            { "Linb", "ลีเนียร์บี" },
            { "Lisu", "เฟรเซอร์" },
            { "Loma", "โลมา" },
            { "Lyci", "ไลเซีย" },
            { "Lydi", "ลีเดีย" },
            { "Mahj", "มหาชนี" },
            { "Mand", "แมนเดียน" },
            { "Mani", "มานิแชน" },
            { "Maya", "มายาไฮโรกลิฟส์" },
            { "Mend", metaValue_men },
            { "Merc", "เคอร์ซีฟ-เมโรอิติก" },
            { "Mero", "เมโรติก" },
            { "Mlym", metaValue_ml },
            { "Modi", "โมฑี" },
            { "Mong", metaValue_MN },
            { "Moon", "มูน" },
            { "Mroo", "มโร" },
            { "Mtei", "เมเทมาเยก" },
            { "Mymr", metaValue_my },
            { "Narb", "อาระเบียเหนือโบราณ" },
            { "Nbat", "นาบาทาเอียน" },
            { "Nkgb", "กีบา-นาซี" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "นุซุ" },
            { "Ogam", "โอคัม" },
            { "Olck", "โอลชิกิ" },
            { "Orkh", "ออร์คอน" },
            { "Orya", "โอริยา" },
            { "Osma", "ออสมันยา" },
            { "Palm", "พาลไมรีน" },
            { "Pauc", "ป่อจิ้งฮอ" },
            { "Perm", "เปอร์มิกโบราณ" },
            { "Phag", "ฟากส์-ปา" },
            { "Phli", "ปะห์ลาวีอินสคริปชันแนล" },
            { "Phlp", "ปะห์ลาวีซอลเตอร์" },
            { "Phlv", "ปะห์ลาวีบุ๊ก" },
            { "Phnx", metaValue_phn },
            { "Plrd", "สัทศาสตร์พอลลาร์ด" },
            { "Prti", "พาร์เทียอินสคริปชันแนล" },
            { "Rjng", "เรจัง" },
            { "Rohg", "ฮะนีฟี" },
            { "Roro", "รองโกรองโก" },
            { "Runr", "รูนิก" },
            { "Samr", "ซามาเรีย" },
            { "Sara", "ซาราติ" },
            { "Sarb", "อาระเบียใต้โบราณ" },
            { "Saur", "โสวรัสตระ" },
            { "Sgnw", "ไซน์ไรติ้ง" },
            { "Shaw", "ซอเวียน" },
            { "Shrd", "ชาราดา" },
            { "Sidd", "สิทธัม" },
            { "Sind", "คุดาวาดี" },
            { "Sinh", metaValue_si },
            { "Sora", "โสราสมเป็ง" },
            { "Sund", metaValue_su },
            { "Sylo", "ซิโลตินากรี" },
            { "Syrc", metaValue_SY },
            { "Syre", "ซีเรียเอสทรานจีโล" },
            { "Syrj", "ซีเรียตะวันตก" },
            { "Syrn", "ซีเรียตะวันออก" },
            { "Tagb", "ตักบันวา" },
            { "Takr", "ทาครี" },
            { "Tale", "ไทเล" },
            { "Talu", "ไทลื้อใหม่" },
            { "Taml", metaValue_ta },
            { "Tang", "ตันกัท" },
            { "Tavt", "ไทเวียต" },
            { "Telu", metaValue_te },
            { "Teng", "เทงกวาร์" },
            { "Tfng", "ทิฟินาก" },
            { "Tglg", metaValue_tl },
            { "Thaa", "ทานา" },
            { "Thai", metaValue_TH },
            { "Tibt", metaValue_bo },
            { "Tirh", "เทอฮุทา" },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "คำพูดที่มองเห็นได้" },
            { "Wara", "วารังกสิติ" },
            { "Wole", "โอลีเอ" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "อักษรรูปลิ่มสุเมเรีย-อัคคาเดีย" },
            { "Yiii", "ยิ" },
            { "Zinh", "อินเฮอริต" },
            { "Zmth", "เครื่องหมายทางคณิตศาสตร์" },
            { "Zsye", "อีโมจิ" },
            { "Zsym", "สัญลักษณ์" },
            { "Zxxx", "ไม่มีภาษาเขียน" },
            { "Zyyy", "สามัญ" },
            { "Zzzz", "ตัวอักษรที่ไม่รู้จัก" },
            { "de_AT", "เยอรมัน - ออสเตรีย" },
            { "de_CH", "เยอรมันสูง (สวิส)" },
            { "en_AU", "อังกฤษ - ออสเตรเลีย" },
            { "en_CA", "อังกฤษ - แคนาดา" },
            { "en_GB", "อังกฤษ - สหราชอาณาจักร" },
            { "en_US", "อังกฤษ - สหรัฐอเมริกา" },
            { "es_ES", "สเปน - ยุโรป" },
            { "es_MX", "สเปน - เม็กซิโก" },
            { "fa_AF", "ดารี" },
            { "fr_CA", "ฝรั่งเศส - แคนาดา" },
            { "fr_CH", "ฝรั่งเศส - สวิส" },
            { "nl_BE", "เฟลมิช" },
            { "pt_BR", "โปรตุเกส - บราซิล" },
            { "pt_PT", "โปรตุเกส - ยุโรป" },
            { "ro_MD", metaValue_MD },
            { "sw_CD", "สวาฮีลี - คองโก" },
            { "%%1901", "เยอรมันออร์โธกราฟีดั้งเดิม" },
            { "%%1994", "อักขระเรเซียนมาตราฐาน" },
            { "%%1996", "เยอรมันออร์โธกราฟีปี 1996" },
            { "ar_001", "อาหรับมาตรฐานสมัยใหม่" },
            { "es_419", "สเปน - ละตินอเมริกา" },
            { "key.ca", "ปฏิทิน" },
            { "key.cf", "รูปแบบสกุลเงิน" },
            { "key.co", "ลำดับการจัดเรียง" },
            { "key.cu", "สกุลเงิน" },
            { "key.hc", "วงจรชั่วโมง (เทียบ 12 และ 24)" },
            { "key.lb", "รูปแบบการขึ้นบรรทัดใหม่" },
            { "key.ms", "ระบบการวัด" },
            { "key.nu", metaValue_key_nu },
            { "key.tz", "เขตเวลา" },
            { "key.va", "ตัวแปรภาษาถิ่น" },
            { "nds_NL", "แซกซอนใต้" },
            { "%%ALUKU", "ภาษาพื้นเมืองอลูคู" },
            { "%%BISKE", "ภาษาพื้นเมืองซานจอร์โจ/บิลา" },
            { "%%BOONT", "บูนทลิ่ง" },
            { "%%JAUER", "เยาเออร์" },
            { "%%KKCOR", "อักขรวิธีสามัญ" },
            { "%%KSCOR", "อักขรวิธีมาตรฐาน" },
            { "%%LIPAW", "ภาษาพื้นเมืองลิโพวาซของเรเซียน" },
            { "%%NEDIS", "ภาษาพื้นเมืองนาทิโซเน" },
            { "%%NJIVA", "ภาษาพื้นเมืองจนีวา/นจีวา" },
            { "%%NULIK", "โวลาพึคสมัยใหม่" },
            { "%%OSOJS", "ภาษาพื้นเมืองโอเซียคโค/โอโซยาเน" },
            { "%%POSIX", "คอมพิวเตอร์" },
            { "%%PUTER", "พิวเตอร์" },
            { "%%RIGIK", "โวลาพึคดั้งเดิม" },
            { "%%ROZAJ", "เรเซียน" },
            { "%%RUMGR", "รัมกร์" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "ภาษาพื้นเมืองสโตวีซซา/โซลบีกา" },
            { "%%UCCOR", "อักขรวิธีแบบครบวงจร" },
            { "zh_Hans", "จีนตัวย่อ" },
            { "zh_Hant", "จีนตัวเต็ม" },
            { "%%DAJNKO", "ตัวอักษรดายนชิซา" },
            { "%%FONIPA", "สัทอักษรสากล" },
            { "%%FONUPA", "สัทอักษร UPA" },
            { "%%NDYUKA", "ดิวคา" },
            { "%%PAMAKA", "ภาษาพื้นเมืองพามาคา" },
            { "%%PINYIN", "พินอิน" },
            { "%%SCOUSE", "สเกาส์" },
            { "%%TARASK", "ทาราซเคียวิซาออร์โธกราฟี" },
            { "%%UCRCOR", "อักขรวิธีแบบปรับปรุงครบวงจร" },
            { "%%ULSTER", "อัลสเตอร์" },
            { "%%ALALC97", "การถอดอักษรเป็นอักษรโรมันตามเกณฑ์ของสมาคมห้องสมุดอเมริกันและห้องสมุดรัฐสภา ฉบับพิมพ์ปี 1997" },
            { "%%AREVELA", "อาร์เมเนียตะวันออก" },
            { "%%AREVMDA", "อาร์เมเนียตะวันตก" },
            { "%%BAUDDHA", "พระพุทธเจ้า" },
            { "%%BOHORIC", "ตัวอักษรโบโฮริช" },
            { "%%EMODENG", "อังกฤษสมัยใหม่ตอนต้น" },
            { "%%HEPBURN", "การถอดอักษรแบบเฮปเบิร์น" },
            { "%%ITIHASA", "อิติหาสะ" },
            { "%%LAUKIKA", "ลัวกิกา" },
            { "%%METELKO", "ตัวอักษรเมเตวชิซา" },
            { "%%MONOTON", "โมโนโทนิก" },
            { "%%POLYTON", "โพลีโทนิก" },
            { "%%REVISED", "ออร์โธกราฟิปรับปรุง" },
            { "%%SURSILV", "ซูร์ซีลฟ์" },
            { "%%SUTSILV", "ซุตซีลฟ์" },
            { "%%VAIDIKA", "เวดิคา" },
            { "%%1606NICT", "ปลายยุคกลางฝรั่งเศสถึงปี ค.ศ. 1606" },
            { "%%1694ACAD", "ตอนต้นยุคใหม่ฝรั่งเศส" },
            { "%%1959ACAD", "วิชาการ" },
            { "%%BAKU1926", "ตัวอักษรละตินเตอร์กิกแบบครบวงจร" },
            { "%%BISCAYAN", "บิสคายัน" },
            { "%%FONXSAMP", "ฟอนซ์แซมพ์" },
            { "%%HOGNORSK", "ภาษานอร์วิเจียนสูง" },
            { "%%JYUTPING", "ระบบถอดอักษรแบบยวึดพิง" },
            { "%%LUNA1918", "ลูน่า 1918" },
            { "%%PETR1708", "พีท 1708" },
            { "%%SCOTLAND", "ภาษาอังกฤษมาตราฐานสก๊อต" },
            { "%%SURMIRAN", "ซูร์มิราน" },
            { "%%VALENCIA", "วาเลนเซีย" },
            { "%%VALLADER", "วัลลาเดอร์" },
            { "%%WADEGILE", "การถอดอักษรแบบเวด-ไจลส์" },
            { "type.ca.roc", "ปฏิทินไต้หวัน" },
            { "type.co.eor", "กฎการเรียงลำดับตามแบบยุโรป" },
            { "type.hc.h11", "ระบบ 12 ชั่วโมง (0–11)" },
            { "type.hc.h12", "ระบบ 12 ชั่วโมง (1–12)" },
            { "type.hc.h23", "ระบบ 24 ชั่วโมง (0–23)" },
            { "type.hc.h24", "ระบบ 24 ชั่วโมง (1–24)" },
            { "type.m0.bgn", "ชื่อมาตรฐานอังกฤษ (BGN)" },
            { "type.nu.arab", "ตัวเลขอารบิก-อินดิก" },
            { "type.nu.armn", "ตัวเลขอาร์เมเนีย" },
            { "type.nu.bali", "ตัวเลขบาหลี" },
            { "type.nu.beng", "ตัวเลขบังกลาเทศ" },
            { "type.nu.brah", "ตัวเลขพราหมี" },
            { "type.nu.cakm", "ตัวเลขจักม่า" },
            { "type.nu.cham", "ตัวเลขชาม" },
            { "type.nu.deva", "ตัวเลขเทวนาครี" },
            { "type.nu.ethi", "ตัวเลขเอธิโอเปีย" },
            { "type.nu.geor", "ตัวเลขจอร์เจีย" },
            { "type.nu.grek", "ตัวเลขกรีก" },
            { "type.nu.gujr", "ตัวเลขคุชราต" },
            { "type.nu.guru", "ตัวเลขกูร์มูคี" },
            { "type.nu.hans", "ตัวเลขจีนตัวย่อ" },
            { "type.nu.hant", "ตัวเลขจีนตัวเต็ม" },
            { "type.nu.hebr", "ตัวเลขฮิบรู" },
            { "type.nu.java", "ตัวเลขชวา" },
            { "type.nu.jpan", "ตัวเลขญี่ปุ่น" },
            { "type.nu.kali", "ตัวเลขคยาห์" },
            { "type.nu.khmr", "ตัวเลขเขมร" },
            { "type.nu.knda", "ตัวเลขกันนาดา" },
            { "type.nu.lana", "ตัวเลขไททัมโฮรา" },
            { "type.nu.laoo", "ตัวเลขลาว" },
            { "type.nu.latn", "ตัวเลขอารบิก" },
            { "type.nu.lepc", "ตัวเลขเลปชา" },
            { "type.nu.limb", "ตัวเลขลิมบู" },
            { "type.nu.mlym", "ตัวเลขมาลายาลัม" },
            { "type.nu.mong", "ตัวเลขมองโกเลีย" },
            { "type.nu.mtei", "ตัวเลขเมไตมาเยก" },
            { "type.nu.mymr", "ตัวเลขพม่า" },
            { "type.nu.nkoo", "ตัวเลขเอ็นโก" },
            { "type.nu.olck", "ตัวเลขโอลจิกิ" },
            { "type.nu.orya", "ตัวเลขโอริยา" },
            { "type.nu.osma", "ตัวเลขออสมันยา" },
            { "type.nu.saur", "ตัวเลขเศารัชธรา" },
            { "type.nu.shrd", "ตัวเลขชาราดา" },
            { "type.nu.sora", "ตัวเลขโสราสมเป็ง" },
            { "type.nu.sund", "ตัวเลขซุนดา" },
            { "type.nu.takr", "ตัวเลขทาครี" },
            { "type.nu.talu", "ตัวเลขไทลื้อใหม่" },
            { "type.nu.taml", "ตัวเลขทมิฬดั้งเดิม" },
            { "type.nu.telu", "ตัวเลขเตลูกู" },
            { "type.nu.thai", "ตัวเลขไทย" },
            { "type.nu.tibt", "ตัวเลขทิเบต" },
            { "type.nu.vaii", "ตัวเลขไว" },
            { "type.ca.dangi", "ปฏิทินเกาหลี" },
            { "type.co.ducet", "ลำดับการจัดเรียงตาม Unicode เริ่มต้น" },
            { "type.lb.loose", "รูปแบบที่ยืดหยุ่นของการขึ้นบรรทัดใหม่" },
            { "type.nu.roman", "ตัวเลขโรมัน" },
            { "type.ca.coptic", "ปฏิทินคอปติก" },
            { "type.ca.hebrew", "ปฏิทินฮิบรู" },
            { "type.ca.indian", "ปฏิทินแห่งชาติอินเดีย" },
            { "type.co.compat", "ลำดับการจัดเรียงก่อนหน้านี้ ตามความเหมาะสม" },
            { "type.co.pinyin", "ลำดับการจัดเรียงตามการถอดเสียงภาษาจีน" },
            { "type.co.search", "การค้นหาทั่วไป" },
            { "type.co.stroke", "ลำดับการจัดเรียงตามการลากเส้น" },
            { "type.co.unihan", "ลำดับการจัดเรียงตามจำนวนขีด" },
            { "type.co.zhuyin", "ลำดับการจัดเรียงตามการสะกดแบบจู้อิน" },
            { "type.d0.fwidth", metaValue_Hant },
            { "type.d0.hwidth", metaValue_Hans },
            { "type.lb.normal", "รูปแบบปกติของการขึ้นบรรทัดใหม่" },
            { "type.lb.strict", "รูปแบบที่เคร่งครัดของการขึ้นบรรทัดใหม่" },
            { "type.m0.ungegn", "ชื่อภูมิศาสตร์มาตรฐาน UN (UNGEGN)" },
            { "type.ms.metric", "ระบบเมตริก" },
            { "type.nu.native", "ตัวเลขพื้นเมือง" },
            { "type.ca.chinese", "ปฏิทินจีน" },
            { "type.ca.islamic", "ปฏิทินอิสลาม" },
            { "type.ca.iso8601", "ปฏิทิน ISO-8601" },
            { "type.ca.persian", "ปฏิทินเปอร์เชีย" },
            { "type.cf.account", "รูปแบบสกุลเงินบัญชี" },
            { "type.co.big5han", "ลำดับการจัดเรียงตามอักษรจีนดั้งเดิม" },
            { "type.d0.npinyin", metaValue_key_nu },
            { "type.nu.arabext", "ตัวเลขอารบิก-อินดิกแบบขยาย" },
            { "type.nu.armnlow", "ตัวเลขอาร์เมเนียพิมพ์เล็ก" },
            { "type.nu.finance", "ตัวเลขทางการเงิน" },
            { "type.nu.greklow", "ตัวเลขกรีกพิมพ์เล็ก" },
            { "type.nu.hanidec", "ตัวเลขทศนิยมจีน" },
            { "type.nu.hansfin", "ตัวเลขทางการเงินแบบตัวย่อของจีน" },
            { "type.nu.hantfin", "ตัวเลขทางการเงินแบบตัวเต็มของจีน" },
            { "type.nu.jpanfin", "ตัวเลขทางการเงินของญี่ปุ่น" },
            { "type.nu.tamldec", "ตัวเลขทมิฬ" },
            { "type.ca.buddhist", "ปฏิทินพุทธ" },
            { "type.ca.ethiopic", "ปฏิทินเอธิโอเปีย" },
            { "type.ca.japanese", "ปฏิทินญี่ปุ่น" },
            { "type.cf.standard", "รูปแบบสกุลเงินมาตรฐาน" },
            { "type.co.phonetic", "ลำดับการจัดเรียงตามการออกเสียง" },
            { "type.co.searchjl", "ค้นหาตามพยัญชนะขึ้นต้นที่เป็นฮันกึล" },
            { "type.co.standard", "ลำดับการจัดเรียงแบบมาตรฐาน" },
            { "type.ms.uksystem", "ระบบการวัดอิมพีเรียล" },
            { "type.ms.ussystem", "ระบบการวัดอเมริกัน" },
            { "type.nu.fullwide", "ตัวเลขแบบเต็มขนาด" },
            { "type.nu.lanatham", "ตัวเลขไททัมทัม" },
            { "type.nu.mymrshan", "ตัวเลขชานพม่า" },
            { "type.nu.romanlow", "ตัวเลขโรมันพิมพ์เล็ก" },
            { "type.ca.gregorian", "ปฏิทินเกรกอเรียน" },
            { "type.co.gb2312han", "ลำดับการจัดเรียงตามอักษรจีนประยุกต์" },
            { "type.co.phonebook", "ลำดับการจัดเรียงตามสมุดโทรศัพท์" },
            { "type.co.dictionary", "ลำดับการจัดเรียงตามพจนานุกรม" },
            { "type.co.traditional", "ลำดับการจัดเรียงตามแบบดั้งเดิม" },
            { "type.nu.traditional", "ตัวเลขแบบดั้งเดิม" },
            { "type.ca.islamic-civil", "ปฏิทินอิสลามซีวิล" },
            { "type.ca.islamic-umalqura", "ปฏิทินอิสลาม (อุมม์อัลกุรา)" },
            { "type.ca.ethiopic-amete-alem", "ปฏิทินปีโลกเอธิโอเปีย" },
        };
        return data;
    }
}
