/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_eo extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "universala tempo kunordigita",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "samoa norma tempo",
               "",
               "samoa somera tempo",
               "",
               "samoa tempo",
               "",
            };
        final String[] Cook = new String[] {
               "kukinsula norma tempo",
               "",
               "kukinsula somera tempo",
               "",
               "kukinsula tempo",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubo (norma tempo)",
               "CST",
               "Kubo (somera tempo)",
               "CDT",
               "tempo: Kubo",
               "CT",
            };
        final String[] Fiji = new String[] {
               "fiĝia norma tempo",
               "",
               "fiĝia somera tempo",
               "",
               "fiĝia tempo",
               "",
            };
        final String[] Gulf = new String[] {
               "arabgolfa norma tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "ĥovda norma tempo",
               "",
               "ĥovda somera tempo",
               "",
               "ĥovda tempo",
               "",
            };
        final String[] Iran = new String[] {
               "irana norma tempo",
               "",
               "irana somera tempo",
               "",
               "irana tempo",
               "",
            };
        final String[] Niue = new String[] {
               "niua tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "omska norma tempo",
               "",
               "omska somera tempo",
               "",
               "omska tempo",
               "",
            };
        final String[] Peru = new String[] {
               "perua norma tempo",
               "",
               "perua somera tempo",
               "",
               "perua tempo",
               "",
            };
        final String[] Truk = new String[] {
               "tempo: Ĉuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "vejkinsula tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "ĉilia norma tempo",
               "",
               "ĉilia somera tempo",
               "",
               "ĉilia tempo",
               "",
            };
        final String[] China = new String[] {
               "ĉina norma tempo",
               "CST",
               "ĉina somera tempo",
               "CDT",
               "ĉina tempo",
               "CT",
            };
        final String[] Cocos = new String[] {
               "kokosinsula tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "tempo: Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "hinda norma tempo",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "japana norma tempo",
               "JST",
               "japana somera tempo",
               "JDT",
               "japana tempo",
               "JT",
            };
        final String[] Korea = new String[] {
               "korea norma tempo",
               "KST",
               "korea somera tempo",
               "KST",
               "korea tempo",
               "KST",
            };
        final String[] Nauru = new String[] {
               "naura tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "nepala tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "palaŭa tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "uson-samoa norma tempo",
               "SST",
               "uson-samoa somera tempo",
               "SST",
               "uson-samoa tempo",
               "SST",
            };
        final String[] Syowa = new String[] {
               "tempo: Showa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "tonga norma tempo",
               "",
               "tonga somera tempo",
               "",
               "tonga tempo",
               "",
            };
        final String[] Yukon = new String[] {
               "jukonia tempo",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "alaska norma tempo",
               "AKST",
               "alaska somera tempo",
               "AKDT",
               "alaska tempo",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "amazona norma tempo",
               "",
               "amazona somera tempo",
               "",
               "amazona tempo",
               "",
            };
        final String[] Azores = new String[] {
               "Acoroj (norma tempo)",
               "",
               "Acoroj (somera tempo)",
               "",
               "tempo: Acoroj",
               "",
            };
        final String[] Bhutan = new String[] {
               "butana tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "bruneja tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "paskinsula norma tempo",
               "",
               "paskinsula somera tempo",
               "",
               "paskinsula tempo",
               "",
            };
        final String[] Guyana = new String[] {
               "gujana tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Havajo-Aleutoj (norma tempo)",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "israela norma tempo",
               "IST",
               "israela somera tempo",
               "IDT",
               "israela tempo",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "tempo: Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "tempo: Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "moskva norma tempo",
               "MSK",
               "moskva somera tempo",
               "MSK",
               "moskva tempo",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "tempo: Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "tahitia tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "tajvana norma tempo",
               "CST",
               "tajvana somera tempo",
               "CDT",
               "tajvana tempo",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "tuvala tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "tempo: Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "tempo: Valiso kaj Futuno",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "araba norma tempo",
               "",
               "araba somera tempo",
               "",
               "araba tempo",
               "",
            };
        final String[] Armenia = new String[] {
               "armena norma tempo",
               "",
               "armena somera tempo",
               "",
               "armena tempo",
               "",
            };
        final String[] Bolivia = new String[] {
               "bolivia tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "ĉathama norma tempo",
               "",
               "ĉathama somera tempo",
               "",
               "ĉathama tempo",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "universala tempo kunordigita",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ekvadora tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "tempo: Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "kartvela norma tempo",
               "",
               "kartvela somera tempo",
               "",
               "kartvela tempo",
               "",
            };
        final String[] Irkutsk = new String[] {
               "irkutska norma tempo",
               "",
               "irkutska somera tempo",
               "",
               "irkutska tempo",
               "",
            };
        final String[] Magadan = new String[] {
               "magadana norma tempo",
               "",
               "magadana somera tempo",
               "",
               "magadana tempo",
               "",
            };
        final String[] Myanmar = new String[] {
               "birma tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "norfolkinsula norma tempo",
               "",
               "norfolkinsula somera tempo",
               "",
               "norfolkinsula tempo",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha (norma tempo)",
               "",
               "Fernando de Noronha (somera tempo)",
               "",
               "tempo: Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "tempo: Reunio",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "tempo: Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "tempo: Salomonoj",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "tokelaa tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "urugvaja norma tempo",
               "",
               "urugvaja somera tempo",
               "",
               "urugvaja tempo",
               "",
            };
        final String[] Vanuatu = new String[] {
               "vanuatua norma tempo",
               "",
               "vanuatua somera tempo",
               "",
               "vanuatua tempo",
               "",
            };
        final String[] Yakutsk = new String[] {
               "jakutska norma tempo",
               "",
               "jakutska somera tempo",
               "",
               "jakutska tempo",
               "",
            };
        final String[] Atlantic = new String[] {
               "atlantika nordamerika norma tempo",
               "AST",
               "atlantika nordamerika somera tempo",
               "AST",
               "atlantika nordamerika tempo",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "brazilja norma tempo",
               "",
               "brazilja somera tempo",
               "",
               "brazilja tempo",
               "",
            };
        final String[] Chamorro = new String[] {
               "ĉamora tempo",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "kolombia norma tempo",
               "",
               "kolombia somera tempo",
               "",
               "kolombia tempo",
               "",
            };
        final String[] Falkland = new String[] {
               "falklanda norma tempo",
               "",
               "falklanda somera tempo",
               "",
               "falklanda tempo",
               "",
            };
        final String[] Malaysia = new String[] {
               "malajzia tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "maldiva tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ulanbatora norma tempo",
               "",
               "ulanbatora somera tempo",
               "",
               "ulanbatora tempo",
               "",
            };
        final String[] Pakistan = new String[] {
               "pakistana norma tempo",
               "PKT",
               "pakistana somera tempo",
               "PKST",
               "pakistana tempo",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "paragvaja norma tempo",
               "",
               "paragvaja somera tempo",
               "",
               "paragvaja tempo",
               "",
            };
        final String[] Pitcairn = new String[] {
               "pitkarninsula tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "surinama tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "argentina norma tempo",
               "",
               "argentina somera tempo",
               "",
               "argentina tempo",
               "",
            };
        final String[] Christmas = new String[] {
               "kristnaskinsula tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "galapaga tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "honkonga norma tempo",
               "HKT",
               "honkonga somera tempo",
               "HKST",
               "honkonga tempo",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "hindoĉina tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgiza tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe (norma tempo)",
               "",
               "Lord Howe (somera tempo)",
               "",
               "tempo: Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "markizinsula tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "maŭricia norma tempo",
               "",
               "maŭricia somera tempo",
               "",
               "maŭricia tempo",
               "",
            };
        final String[] Singapore = new String[] {
               "singapura norma tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "venezuela tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajĝana norma tempo",
               "",
               "azerbajĝana somera tempo",
               "",
               "azerbajĝana tempo",
               "",
            };
        final String[] Bangladesh = new String[] {
               "bangladeŝa norma tempo",
               "",
               "bangladeŝa somera tempo",
               "",
               "bangladeŝa tempo",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "kaboverda norma tempo",
               "",
               "kaboverda somera tempo",
               "",
               "kaboverda tempo",
               "",
            };
        final String[] East_Timor = new String[] {
               "orient-timora tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "kazaĥa tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "sejŝela tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "taĝika tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "uzbeka norma tempo",
               "",
               "uzbeka somera tempo",
               "",
               "uzbeka tempo",
               "",
            };
        final String[] Afghanistan = new String[] {
               "afgana tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasnojarska norma tempo",
               "",
               "krasnojarska somera tempo",
               "",
               "krasnojarska tempo",
               "",
            };
        final String[] New_Zealand = new String[] {
               "novzelanda norma tempo",
               "NZST",
               "novzelanda somera tempo",
               "NZDT",
               "novzelanda tempo",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "filipina norma tempo",
               "PST",
               "filipina somera tempo",
               "PDT",
               "filipina tempo",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "vladivostoka norma tempo",
               "",
               "vladivostoka somera tempo",
               "",
               "vladivostoka tempo",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "hindoceana tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "tempo: Liniaj Insuloj",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Novlando (norma tempo)",
               "NST",
               "Novlando (somera tempo)",
               "NDT",
               "tempo: Novlando",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "turkmena norma tempo",
               "",
               "turkmena somera tempo",
               "",
               "turkmena tempo",
               "",
            };
        final String[] French_Guiana = new String[] {
               "tempo: Franca Gujano",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "novkaledonia norma tempo",
               "",
               "novkaledonia somera tempo",
               "",
               "novkaledonia tempo",
               "",
            };
        final String[] South_Georgia = new String[] {
               "tempo: Sud-Georgio",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "jekaterinburga norma tempo",
               "",
               "jekaterinburga somera tempo",
               "",
               "jekaterinburga tempo",
               "",
            };
        final String[] Africa_Central = new String[] {
               "centrafrika tempo",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "orientafrika tempo",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "okcidentafrika tempo",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "tempo: Dumont d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "centreŭropa norma tempo",
               "CET",
               "centreŭropa somera tempo",
               "CEST",
               "centreŭropa tempo",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "orienteŭropa norma tempo",
               "EET",
               "orienteŭropa somera tempo",
               "EEST",
               "orienteŭropa tempo",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "okcidenteŭropa norma tempo",
               "WET",
               "okcidenteŭropa somera tempo",
               "WEST",
               "okcidenteŭropa tempo",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "pacifika meksika norma tempo",
               "MST",
               "pacifika meksika somera tempo",
               "MDT",
               "pacifika meksika tempo",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "sudafrika tempo",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "centra nordamerika norma tempo",
               "CST",
               "centra nordamerika somera tempo",
               "CDT",
               "centra nordamerika tempo",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "orienta nordamerika norma tempo",
               "EST",
               "orienta nordamerika somera tempo",
               "EST",
               "orienta nordamerika tempo",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "pacifika nordamerika norma tempo",
               "PST",
               "pacifika nordamerika somera tempo",
               "PDT",
               "pacifika nordamerika tempo",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "tempo: Francaj Sudaj Teritorioj",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "gilbertinsula tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajo-Aleutoj (norma tempo)",
               "HST",
               "Havajo-Aleutoj (somera tempo)",
               "HDT",
               "tempo: Havajo-Aleutoj",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "feniksinsula tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sankta Piero kaj Mikelono (norma tempo)",
               "",
               "Sankta Piero kaj Mikelono (somera tempo)",
               "",
               "tempo: Sankta Piero kaj Mikelono",
               "",
            };
        final String[] America_Mountain = new String[] {
               "montara nordamerika norma tempo",
               "MST",
               "montara nordamerika somera tempo",
               "MST",
               "montara nordamerika tempo",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "marŝalinsula tempo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "tempo: Papuo-Nov-Gvineo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "centra aŭstralia norma tempo",
               "ACST",
               "centra aŭstralia somera tempo",
               "ACDT",
               "centra aŭstralia tempo",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "orienta aŭstralia norma tempo",
               "AEST",
               "orienta aŭstralia somera tempo",
               "AEDT",
               "orienta aŭstralia tempo",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "okcidenta aŭstralia norma tempo",
               "AWST",
               "okcidenta aŭstralia somera tempo",
               "AWDT",
               "okcidenta aŭstralia tempo",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "centr-indonezia tempo",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "orient-indonezia tempo",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "okcident-indonezia tempo",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "centrokcidenta aŭstralia norma tempo",
               "",
               "centrokcidenta aŭstralia somera tempo",
               "",
               "centrokcidenta aŭstralia tempo",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "universala tempo kunordigita",
                    "GMT",
                    "brita somera tempo",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "universala tempo kunordigita",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "universala tempo kunordigita",
                    "GMT",
                    "irlanda norma tempo",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "universala tempo kunordigita",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "universala tempo kunordigita",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "universala tempo kunordigita",
                    "GMT",
                    "brita somera tempo",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "universala tempo kunordigita",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "universala tempo kunordigita",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "universala tempo kunordigita",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "universala tempo kunordigita",
                    "GMT",
                    "irlanda norma tempo",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "universala tempo kunordigita",
                    "GMT",
                    "brita somera tempo",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "universala tempo kunordigita",
                    "GMT",
                    "brita somera tempo",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "universala tempo kunordigita",
                    "GMT",
                    "brita somera tempo",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "universala tempo kunordigita",
                    "GMT",
                    "brita somera tempo",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "universala tempo kunordigita",
                    "GMT",
                    "brita somera tempo",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Adeno" },
            { "timezone.excity.Asia/Baku", "Bakuo" },
            { "timezone.excity.Asia/Dili", "Dilo" },
            { "timezone.excity.Asia/Gaza", "Gazao" },
            { "timezone.excity.Asia/Hovd", "Ĥovd" },
            { "timezone.excity.Asia/Omsk", "Omsko" },
            { "timezone.excity.Asia/Oral", "Oralo" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amano" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Ĉita" },
            { "timezone.excity.Asia/Dhaka", "Dako" },
            { "timezone.excity.Asia/Dubai", "Dubajurbo" },
            { "timezone.excity.Asia/Kabul", "Kabulo" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "timezone.excity.Asia/Qatar", "Kataro" },
            { "timezone.excity.Asia/Seoul", "Seulo" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Ĝubao" },
            { "timezone.excity.Africa/Lome", "Lomeo" },
            { "timezone.excity.Asia/Almaty", "Almato" },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "timezone.excity.Asia/Beirut", "Bejruto" },
            { "timezone.excity.Asia/Brunei", "Brunejo" },
            { "timezone.excity.Asia/Hebron", "Hebrono" },
            { "timezone.excity.Asia/Kuwait", "Kuvajto" },
            { "timezone.excity.Asia/Manila", "Manilo" },
            { "timezone.excity.Asia/Muscat", "Maskato" },
            { "timezone.excity.Asia/Riyadh", "Riado" },
            { "timezone.excity.Asia/Saigon", "Hoĉimino" },
            { "timezone.excity.Asia/Taipei", "Tajpeo" },
            { "timezone.excity.Asia/Tehran", "Teherano" },
            { "timezone.excity.Asia/Urumqi", "Urumĉio" },
            { "timezone.excity.Etc/Unknown", "nekonata loko" },
            { "timezone.excity.Europe/Kiev", "Kievo" },
            { "timezone.excity.Europe/Riga", "Rigo" },
            { "timezone.excity.Europe/Rome", "Romo" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akrao" },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Africa/Ceuta", "Ceŭto" },
            { "timezone.excity.Africa/Dakar", "Dakaro" },
            { "timezone.excity.Africa/Lagos", "Lagoso" },
            { "timezone.excity.Africa/Tunis", "Tunizo" },
            { "timezone.excity.America/Lima", "Limo" },
            { "timezone.excity.Asia/Baghdad", "Bagdado" },
            { "timezone.excity.Asia/Bahrain", "Barejno" },
            { "timezone.excity.Asia/Bangkok", "Bankoko" },
            { "timezone.excity.Asia/Bishkek", "Biŝkeko" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsko" },
            { "timezone.excity.Asia/Jakarta", "Ĝakarto" },
            { "timezone.excity.Asia/Karachi", "Karaĉio" },
            { "timezone.excity.Asia/Nicosia", "Nikozio" },
            { "timezone.excity.Asia/Rangoon", "Ranguno" },
            { "timezone.excity.Asia/Tbilisi", "Tbiliso" },
            { "timezone.excity.Asia/Thimphu", "Timbuo" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsko" },
            { "timezone.excity.Asia/Yerevan", "Erevano" },
            { "timezone.excity.Europe/Malta", "Malto" },
            { "timezone.excity.Europe/Minsk", "Minsko" },
            { "timezone.excity.Europe/Paris", "Parizo" },
            { "timezone.excity.Europe/Sofia", "Sofio" },
            { "timezone.excity.Europe/Vaduz", "Vaduzo" },
            { "timezone.excity.Indian/Cocos", "Kokosinsuloj" },
            { "timezone.excity.Pacific/Apia", "Apio" },
            { "timezone.excity.Pacific/Fiji", "Fiĝio" },
            { "timezone.excity.Pacific/Guam", "Gvamo" },
            { "timezone.excity.Pacific/Niue", "Niuo" },
            { "timezone.excity.Pacific/Truk", "Ĉuuk" },
            { "timezone.excity.Pacific/Wake", "Vejkinsulo" },
            { "timezone.excity.Africa/Asmera", "Asmero" },
            { "timezone.excity.Africa/Bangui", "Bango" },
            { "timezone.excity.Africa/Banjul", "Banjulo" },
            { "timezone.excity.Africa/Bissau", "Bisaŭo" },
            { "timezone.excity.Africa/Douala", "Dualao" },
            { "timezone.excity.Africa/Harare", "Harareo" },
            { "timezone.excity.Africa/Kigali", "Kigalo" },
            { "timezone.excity.Africa/Luanda", "Luando" },
            { "timezone.excity.Africa/Lusaka", "Lusako" },
            { "timezone.excity.Africa/Maseru", "Maseruo" },
            { "timezone.excity.Africa/Niamey", "Niamejo" },
            { "timezone.excity.America/Aruba", "Arubo" },
            { "timezone.excity.America/Bahia", "Bahio" },
            { "timezone.excity.America/Belem", "Belemo" },
            { "timezone.excity.America/Thule", "Qaanaaq" },
            { "timezone.excity.Asia/Ashgabat", "Aŝĥabado" },
            { "timezone.excity.Asia/Calcutta", "Kolkato" },
            { "timezone.excity.Asia/Damascus", "Damasko" },
            { "timezone.excity.Asia/Dushanbe", "Duŝanbeo" },
            { "timezone.excity.Asia/Katmandu", "Katmanduo" },
            { "timezone.excity.Asia/Khandyga", "Ĥandiga" },
            { "timezone.excity.Asia/Qostanay", "Kostanaj" },
            { "timezone.excity.Asia/Sakhalin", "Saĥaleno" },
            { "timezone.excity.Asia/Shanghai", "Ŝanhajo" },
            { "timezone.excity.Asia/Tashkent", "Taŝkento" },
            { "timezone.excity.Asia/Ust-Nera", "Ustnero" },
            { "timezone.excity.Europe/Athens", "Ateno" },
            { "timezone.excity.Europe/Berlin", "Berlino" },
            { "timezone.excity.Europe/Dublin", "Dublino" },
            { "timezone.excity.Europe/Jersey", "Ĵerzejo" },
            { "timezone.excity.Europe/Lisbon", "Lisbono" },
            { "timezone.excity.Europe/London", "Londono" },
            { "timezone.excity.Europe/Madrid", "Madrido" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskvo" },
            { "timezone.excity.Europe/Prague", "Prago" },
            { "timezone.excity.Europe/Skopje", "Skopjo" },
            { "timezone.excity.Europe/Tirane", "Tirano" },
            { "timezone.excity.Europe/Vienna", "Vieno" },
            { "timezone.excity.Europe/Warsaw", "Varsovio" },
            { "timezone.excity.Europe/Zagreb", "Zagrebo" },
            { "timezone.excity.Europe/Zurich", "Zuriko" },
            { "timezone.excity.Indian/Chagos", "Ĉagosoj" },
            { "timezone.excity.Indian/Comoro", "Komoroj" },
            { "timezone.excity.Pacific/Nauru", "Nauro" },
            { "timezone.excity.Pacific/Palau", "Palaŭo" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abiĝano" },
            { "timezone.excity.Africa/Algiers", "Alĝero" },
            { "timezone.excity.Africa/Conakry", "Konakrio" },
            { "timezone.excity.Africa/Kampala", "Kampalo" },
            { "timezone.excity.Africa/Mbabane", "Mbabano" },
            { "timezone.excity.Africa/Nairobi", "Najrobio" },
            { "timezone.excity.Africa/Tripoli", "Tripolo" },
            { "timezone.excity.America/Belize", "Belizo" },
            { "timezone.excity.America/Bogota", "Bogoto" },
            { "timezone.excity.America/Cancun", "Kankuno" },
            { "timezone.excity.America/Cayman", "Kajmanoj" },
            { "timezone.excity.America/Denver", "Denvero" },
            { "timezone.excity.America/Guyana", "Gujano" },
            { "timezone.excity.America/Havana", "Havano" },
            { "timezone.excity.America/Manaus", "Manaŭso" },
            { "timezone.excity.America/Merida", "Merido" },
            { "timezone.excity.America/Nassau", "Nasaŭo" },
            { "timezone.excity.America/Panama", "Panamo" },
            { "timezone.excity.Asia/Hong_Kong", "Honkongo" },
            { "timezone.excity.Asia/Jerusalem", "Jerusalemo" },
            { "timezone.excity.Asia/Kamchatka", "Kamĉatko" },
            { "timezone.excity.Asia/Pyongyang", "Pjongjango" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilordo" },
            { "timezone.excity.Asia/Samarkand", "Samarkando" },
            { "timezone.excity.Asia/Singapore", "Singapuro" },
            { "timezone.excity.Asia/Vientiane", "Vjentiano" },
            { "timezone.excity.Europe/Andorra", "Andoro" },
            { "timezone.excity.Europe/Tallinn", "Talino" },
            { "timezone.excity.Europe/Vatican", "Vatikano" },
            { "timezone.excity.Europe/Vilnius", "Vilno" },
            { "timezone.excity.Indian/Mayotte", "Majoto" },
            { "timezone.excity.Indian/Reunion", "Reunio" },
            { "timezone.excity.Pacific/Easter", "Paskinsulo" },
            { "timezone.excity.Pacific/Midway", "Midvejinsuloj" },
            { "timezone.excity.Pacific/Noumea", "Numeo" },
            { "timezone.excity.Pacific/Ponape", "Ponape" },
            { "timezone.excity.Pacific/Saipan", "Saipano" },
            { "timezone.excity.Pacific/Tahiti", "Tahitio" },
            { "timezone.excity.Pacific/Tarawa", "Taravo" },
            { "timezone.excity.Pacific/Wallis", "Valiso" },
            { "timezone.excity.Africa/Djibouti", "Ĝibutio" },
            { "timezone.excity.Africa/El_Aaiun", "Ajuno" },
            { "timezone.excity.Africa/Freetown", "Fritaŭno" },
            { "timezone.excity.Africa/Gaborone", "Gaborono" },
            { "timezone.excity.Africa/Khartoum", "Ĥartumo" },
            { "timezone.excity.Africa/Kinshasa", "Kinŝaso" },
            { "timezone.excity.Africa/Monrovia", "Monrovio" },
            { "timezone.excity.Africa/Ndjamena", "Niĝameno" },
            { "timezone.excity.Africa/Sao_Tome", "Santomeo" },
            { "timezone.excity.Africa/Windhoek", "Vindhuko" },
            { "timezone.excity.America/Antigua", "Antigvo" },
            { "timezone.excity.America/Caracas", "Karakaso" },
            { "timezone.excity.America/Cayenne", "Kajeno" },
            { "timezone.excity.America/Chicago", "Ĉikago" },
            { "timezone.excity.America/Cordoba", "Kordobo" },
            { "timezone.excity.America/Curacao", "Kuracao" },
            { "timezone.excity.America/Detroit", "Detrojto" },
            { "timezone.excity.America/Godthab", "Nuko" },
            { "timezone.excity.America/Grenada", "Grenado" },
            { "timezone.excity.America/Halifax", "Halifakso" },
            { "timezone.excity.America/Iqaluit", "Ikaluito" },
            { "timezone.excity.America/Jamaica", "Jamajko" },
            { "timezone.excity.America/Managua", "Managvo" },
            { "timezone.excity.America/Marigot", "Marigoto" },
            { "timezone.excity.America/Moncton", "Monktono" },
            { "timezone.excity.America/Phoenix", "Fenikso" },
            { "timezone.excity.Asia/Phnom_Penh", "Pnompeno" },
            { "timezone.excity.Atlantic/Azores", "Acoroj" },
            { "timezone.excity.Atlantic/Canary", "Kanarioj" },
            { "timezone.excity.Atlantic/Faeroe", "Ferooj" },
            { "timezone.excity.Australia/Perth", "Perto" },
            { "timezone.excity.Europe/Belgrade", "Beogrado" },
            { "timezone.excity.Europe/Brussels", "Bruselo" },
            { "timezone.excity.Europe/Budapest", "Budapeŝto" },
            { "timezone.excity.Europe/Busingen", "Büsingen am Hochrhein" },
            { "timezone.excity.Europe/Chisinau", "Kiŝinevo" },
            { "timezone.excity.Europe/Guernsey", "Gernezejo" },
            { "timezone.excity.Europe/Helsinki", "Helsinko" },
            { "timezone.excity.Europe/Istanbul", "Istanbulo" },
            { "timezone.excity.Indian/Maldives", "Maldivoj" },
            { "timezone.excity.Pacific/Chatham", "Ĉathamo" },
            { "timezone.excity.Pacific/Norfolk", "Norfolkinsulo" },
            { "timezone.excity.Africa/Bujumbura", "Buĵumburo" },
            { "timezone.excity.Africa/Mogadishu", "Mogadiŝo" },
            { "timezone.excity.America/Anguilla", "Angvilo" },
            { "timezone.excity.America/Asuncion", "Asunciono" },
            { "timezone.excity.America/Barbados", "Barbado" },
            { "timezone.excity.America/Dominica", "Dominiko" },
            { "timezone.excity.America/Edmonton", "Edmontono" },
            { "timezone.excity.America/Miquelon", "Mikelono" },
            { "timezone.excity.America/New_York", "Nov-Jorko" },
            { "timezone.excity.America/St_Kitts", "Sankta Kristoforo" },
            { "timezone.excity.America/St_Lucia", "Sankta Lucio" },
            { "timezone.excity.America/Winnipeg", "Vinipego" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsko" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsko" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulanbatoro" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostoko" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudoj" },
            { "timezone.excity.Atlantic/Madeira", "Madejro" },
            { "timezone.excity.Atlantic/Stanley", "Stanlejo" },
            { "timezone.excity.Australia/Darwin", "Darvino" },
            { "timezone.excity.Australia/Hobart", "Hobarto" },
            { "timezone.excity.Australia/Sydney", "Sidnejo" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdamo" },
            { "timezone.excity.Europe/Astrakhan", "Astraĥano" },
            { "timezone.excity.Europe/Bucharest", "Bukareŝto" },
            { "timezone.excity.Europe/Gibraltar", "Ĝibraltaro" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljano" },
            { "timezone.excity.Europe/Podgorica", "Podgorico" },
            { "timezone.excity.Europe/Stockholm", "Stokholmo" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsko" },
            { "timezone.excity.Europe/Volgograd", "Volgogrado" },
            { "timezone.excity.Indian/Christmas", "Kristnaskinsulo" },
            { "timezone.excity.Indian/Kerguelen", "Kergelenoj" },
            { "timezone.excity.Indian/Mauritius", "Maŭricio" },
            { "timezone.excity.Pacific/Auckland", "Aŭklando" },
            { "timezone.excity.Pacific/Funafuti", "Funafutio" },
            { "timezone.excity.Pacific/Pitcairn", "Pitkarna Insulo" },
            { "timezone.excity.Africa/Casablanca", "Kazablanko" },
            { "timezone.excity.Africa/Libreville", "Librevilo" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbaŝo" },
            { "timezone.excity.Africa/Nouakchott", "Nuakŝoto" },
            { "timezone.excity.Africa/Porto-Novo", "Portonovo" },
            { "timezone.excity.America/Fortaleza", "Fortalezo" },
            { "timezone.excity.America/Guatemala", "Gvatemalo" },
            { "timezone.excity.America/Monterrey", "Monterejo" },
            { "timezone.excity.America/Sao_Paulo", "Sanpaŭlo" },
            { "timezone.excity.America/St_Thomas", "Sankta Tomaso" },
            { "timezone.excity.America/Vancouver", "Vankuvero" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kualalumpuro" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznecko" },
            { "timezone.excity.Europe/Bratislava", "Bratislavo" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhago" },
            { "timezone.excity.Europe/Luxembourg", "Luksemburgo" },
            { "timezone.excity.Europe/San_Marino", "Sanmarino" },
            { "timezone.excity.Europe/Simferopol", "Simferopolo" },
            { "timezone.excity.Pacific/Enderbury", "Kanton-insulo" },
            { "timezone.excity.Pacific/Galapagos", "Galapagoj" },
            { "timezone.excity.Pacific/Marquesas", "Markizinsuloj" },
            { "timezone.excity.Pacific/Pago_Pago", "Pagopago" },
            { "timezone.excity.Pacific/Rarotonga", "Rarotongo" },
            { "timezone.excity.Africa/Addis_Ababa", "Adisabebo" },
            { "timezone.excity.Africa/Brazzaville", "Brazavilo" },
            { "timezone.excity.Africa/Ouagadougou", "Vagaduguo" },
            { "timezone.excity.America/Costa_Rica", "Kostariko" },
            { "timezone.excity.America/Grand_Turk", "Granda Turko" },
            { "timezone.excity.America/Guadeloupe", "Gvadelupo" },
            { "timezone.excity.America/Martinique", "Martiniko" },
            { "timezone.excity.America/Montserrat", "Moncerato" },
            { "timezone.excity.America/St_Vincent", "Sankta Vincento" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburgo" },
            { "timezone.excity.Atlantic/Reykjavik", "Rejkjaviko" },
            { "timezone.excity.Atlantic/St_Helena", "Sankta Heleno" },
            { "timezone.excity.Australia/Adelaide", "Adelajdo" },
            { "timezone.excity.Australia/Brisbane", "Brisbano" },
            { "timezone.excity.Europe/Isle_of_Man", "Manksinsulo" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrado" },
            { "timezone.excity.Africa/Johannesburg", "Johanesburgo" },
            { "timezone.excity.America/El_Salvador", "Salvadoro" },
            { "timezone.excity.America/Los_Angeles", "Losanĝeleso" },
            { "timezone.excity.America/Mexico_City", "Meksikurbo" },
            { "timezone.excity.America/Puerto_Rico", "Puertoriko" },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpo" },
            { "timezone.excity.Arctic/Longyearbyen", "Longjerurbo" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kaboverdo" },
            { "timezone.excity.Australia/Melbourne", "Melburno" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Daresalamo" },
            { "timezone.excity.America/Buenos_Aires", "Bonaero" },
            { "timezone.excity.America/Indiana/Knox", "Knox, Indianao" },
            { "timezone.excity.America/Indianapolis", "Indianapolo, Indianao" },
            { "timezone.excity.Antarctica/Macquarie", "Makvora insulo" },
            { "timezone.excity.America/Cambridge_Bay", "Kembriĝa Golfo" },
            { "timezone.excity.America/Indiana/Vevay", "Vevay, Indianao" },
            { "timezone.excity.America/Port_of_Spain", "Portospeno" },
            { "timezone.excity.America/Santo_Domingo", "Sankta Domingo" },
            { "timezone.excity.America/St_Barthelemy", "Sankta Bartolomeo" },
            { "timezone.excity.America/Port-au-Prince", "Portoprinco" },
            { "timezone.excity.Atlantic/South_Georgia", "Sud-Georgio" },
            { "timezone.excity.America/Argentina/Salta", "Saltaurbo" },
            { "timezone.excity.America/Indiana/Marengo", "Marengo, Indianao" },
            { "timezone.excity.America/Indiana/Winamac", "Winamac, Indianao" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell City, Indianao" },
            { "timezone.excity.America/Indiana/Vincennes", "Vincennes, Indianao" },
            { "timezone.excity.America/Indiana/Petersburg", "Petersburg, Indianao" },
            { "timezone.excity.America/Kentucky/Monticello", "Monticello, Kentukio" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Norda Dakoto" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Norda Dakoto" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Norda Dakoto" },
        };
        return data;
    }
}
