/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_se_FI extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwicha áigi",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apia dálveáigi",
               "",
               "Apia geasseáigi",
               "",
               "Apia áigi",
               "",
            };
        final String[] Cook = new String[] {
               "Cooksulloid dálveáigi",
               "",
               "Cooksulloid geasi beallemuttu áigi",
               "",
               "Cooksulloid áigi",
               "",
            };
        final String[] Cuba = new String[] {
               "Cuba dálveáigi",
               "CST",
               "Cuba geasseáigi",
               "CDT",
               "Cuba áigi",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fiji dálveáigi",
               "",
               "Fiji geasseáigi",
               "",
               "Fiji áigi",
               "",
            };
        final String[] Gulf = new String[] {
               "Golfa dálveáigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovda dálveáigi",
               "",
               "Hovda geasseáigi",
               "",
               "Hovda áigi",
               "",
            };
        final String[] Iran = new String[] {
               "Irana dálveáigi",
               "",
               "Irana geasseáigi",
               "",
               "Irana áigi",
               "",
            };
        final String[] Niue = new String[] {
               "Niuea áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omska dálveáigi",
               "",
               "Omska geasseáigi",
               "",
               "Omska áigi",
               "",
            };
        final String[] Peru = new String[] {
               "Peru dálveáigi",
               "",
               "Peru geasseáigi",
               "",
               "Peru áigi",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuka áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wakesullo áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chile dálveáigi",
               "",
               "Chile geasseáigi",
               "",
               "Chile áigi",
               "",
            };
        final String[] China = new String[] {
               "Kiinná dálveáigi",
               "CST",
               "Kiinná geasseáigi",
               "CDT",
               "Kiinná áigi",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokossulloid áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davisa áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India dálveáigi",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japána dálveáigi",
               "JST",
               "Japána geasseáigi",
               "JDT",
               "Japána áigi",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korea dálveáigi",
               "KST",
               "Korea geasseáigi",
               "KST",
               "Korea áigi",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepala áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palaua áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa dálveáigi",
               "SST",
               "Samoa geasseáigi",
               "SST",
               "Samoa áigi",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga dálveáigi",
               "",
               "Tonga geasseáigi",
               "",
               "Tonga áigi",
               "",
            };
        final String[] Alaska = new String[] {
               "Alaska dálveáigi",
               "AKST",
               "Alaska geasseáigi",
               "AKDT",
               "Alaska áigi",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazona dálveáigi",
               "",
               "Amazona geasseáigi",
               "",
               "Amazona áigi",
               "",
            };
        final String[] Azores = new String[] {
               "Azoraid dálveáigi",
               "",
               "Azoraid geasseáigi",
               "",
               "Azoraid áigi",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutana áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalama áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Beassášsullo dálveáigi",
               "",
               "Beassášsullo geasseáigi",
               "",
               "Beassášsullo áigi",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Hawaii-aleuhtalaš dálveáigi",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Israela dálveáigi",
               "IST",
               "Israela geasseáigi",
               "IDT",
               "Israela áigi",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosraea áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawsona áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskva dálveáigi",
               "MSK",
               "Moskva geasseáigi",
               "MSK",
               "Moskva áigi",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipeia dálveáigi",
               "CST",
               "Taipeia geasseáigi",
               "CDT",
               "Taipeia áigi",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostoka áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis- ja Futuna áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arábia dálveáigi",
               "",
               "Arábia geasseáigi",
               "",
               "Arábia áigi",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenia dálveáigi",
               "",
               "Armenia geasseáigi",
               "",
               "Armenia áigi",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivia áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chathama dálveáigi",
               "",
               "Chathama geasseáigi",
               "",
               "Chathama áigi",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "koordinerejuvvon oktasaš áigi",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadora áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiera áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgia dálveáigi",
               "",
               "Georgia geasseáigi",
               "",
               "Georgia áigi",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkucka dálveáigi",
               "",
               "Irkucka geasseáigi",
               "",
               "Irkucka áigi",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadana dálveáigi",
               "",
               "Magadana geasseáigi",
               "",
               "Magadana áigi",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmara áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolksullo áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha dálveáigi",
               "",
               "Fernando de Noronha geasseáigi",
               "",
               "Fernando de Noronha áigi",
               "",
            };
        final String[] Reunion = new String[] {
               "Reuniona áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonsulloid áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelaua áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguaya dálveáigi",
               "",
               "Uruguaya geasseáigi",
               "",
               "Uruguaya áigi",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu dálveáigi",
               "",
               "Vanuatu geasseáigi",
               "",
               "Vanuatu áigi",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakucka dálveáigi",
               "",
               "Jakucka geasseáigi",
               "",
               "Jakucka áigi",
               "",
            };
        final String[] Atlantic = new String[] {
               "atlántalaš dálveáigi",
               "AST",
               "atlántalaš geasseáigi",
               "AST",
               "atlántalaš áigi",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasilia dálveáigi",
               "",
               "Brasilia geasseáigi",
               "",
               "Brasilia áigi",
               "",
            };
        final String[] Chamorro = new String[] {
               "Čamorro dálveáigi",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Colombia dálveáigi",
               "",
               "Colombia geasseáigi",
               "",
               "Colombia áigi",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandsulluid dálveáigi",
               "",
               "Falklandsulluid geasseáigi",
               "",
               "Falklandsulluid áigi",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malesia áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Malediivvaid áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan-Batora dálveáigi",
               "",
               "Ulan-Batora geasseáigi",
               "",
               "Ulan-Batora áigi",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistana dálveáigi",
               "PKT",
               "Pakistana geasseáigi",
               "PKST",
               "Pakistana áigi",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguaya dálveáigi",
               "",
               "Paraguaya geasseáigi",
               "",
               "Paraguaya áigi",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairnsulloid áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina dálveáigi",
               "",
               "Argentina geasseáigi",
               "",
               "Argentina áigi",
               "",
            };
        final String[] Christmas = new String[] {
               "Juovlasullo áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagosa áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Konga dálveáigi",
               "HKT",
               "Hong Konga geasseáigi",
               "HKST",
               "Hong Konga áigi",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indokiinná áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisia áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe dálveáigi",
               "",
               "Lord Howe geasseáigi",
               "",
               "Lord Howe áigi",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesasiid áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritiusa dálveáigi",
               "",
               "Mauritiusa geasseáigi",
               "",
               "Mauritiusa áigi",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapore dálveáigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbaižana dálveáigi",
               "",
               "Aserbaižana geasseáigi",
               "",
               "Aserbaižana áigi",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesha dálveáigi",
               "",
               "Bangladesha geasseáigi",
               "",
               "Bangladesha áigi",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kap Verde dálveáigi",
               "",
               "Kap Verde geasseáigi",
               "",
               "Kap Verde áigi",
               "",
            };
        final String[] East_Timor = new String[] {
               "Nuorta-Timora áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychellaid áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tažikistana áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistana dálveáigi",
               "",
               "Usbekistana geasseáigi",
               "",
               "Usbekistana áigi",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganisthana áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarska dálveáigi",
               "",
               "Krasnojarska geasseáigi",
               "",
               "Krasnojarska áigi",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ođđa-Selánda dálveáigi",
               "NZST",
               "Ođđa-Selánda geasseáigi",
               "NZDT",
               "Ođđa-Selánda áigi",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Filippiinnaid dálveáigi",
               "PST",
               "Filippiinnaid geasseáigi",
               "PDT",
               "Filippiinnaid áigi",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostoka dálveáigi",
               "",
               "Vladivostoka geasseáigi",
               "",
               "Vladivostoka áigi",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indiaábi áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Linesulloid áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundlanda dálveáigi",
               "NST",
               "Newfoundlanda geasseáigi",
               "NDT",
               "Newfoundlanda áigi",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistana dálveáigi",
               "",
               "Turkmenistana geasseáigi",
               "",
               "Turkmenistana áigi",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Frankriikka Guyana áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Ođđa-Kaledonia dálveáigi",
               "",
               "Ođđa-Kaledonia geasseáigi",
               "",
               "Ođđa-Kaledonia áigi",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Lulli-Georgia áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburga dálveáigi",
               "",
               "Jekaterinburga geasseáigi",
               "",
               "Jekaterinburga áigi",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Gaska-Afrihká áigi",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Nuorta-Afrihká áigi",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Oarje-Afrihká áigi",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d’Urville áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Gaska-Eurohpá dálveáigi",
               "CET",
               "Gaska-Eurohpá geasseáigi",
               "CEST",
               "Gaska-Eurohpá áigi",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Nuorta-Eurohpa dálveáigi",
               "EET",
               "Nuorta-Eurohpa geasseáigi",
               "EEST",
               "Nuorta-Eurohpa áigi",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Oarje-Eurohpá dálveáigi",
               "WET",
               "Oarje-Eurohpá geasseáigi",
               "WEST",
               "Oarje-Eurohpá áigi",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksiko Jáskesábi dálveáigi",
               "MST",
               "Meksiko Jáskesábi geasseáigi",
               "MDT",
               "Meksiko Jáskesábi áigi",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Lulli-Afrihká dálveáigi",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "dábálaš dálveáigi",
               "CST",
               "dábálaš geasseáigi",
               "CDT",
               "dábálašáigi",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "dálveáigi nuortan",
               "EST",
               "geasseáigi nuortan",
               "EST",
               "áigi nuortan",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Jaskesábi dálveáigi",
               "PST",
               "Jaskesábi geasseáigi",
               "PDT",
               "Jaskesábi áigi",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Frankriikka lulli & antárktisa áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbertsulloid áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-aleuhtalaš dálveáigi",
               "HST",
               "Hawaii-aleuhtalaš geasseáigi",
               "HDT",
               "Hawaii-aleuhtalaš áigi",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixsulloid áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. Pierre & Miquelo dálveáigi",
               "",
               "St. Pierre & Miquelo geasseáigi",
               "",
               "St. Pierre & Miquelo áigi",
               "",
            };
        final String[] America_Mountain = new String[] {
               "dálveduottaráigi",
               "MST",
               "geasseduottaráigi",
               "MST",
               "duottaráigi",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshallsulloid áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Ođđa-Guinea áigi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Gaska-Austrália dálveáigi",
               "ACST",
               "Gaska-Austrália geasseáigi",
               "ACDT",
               "Gaska-Austrália áigi",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Nuorta-Austrália dálveáigi",
               "AEST",
               "Nuorta-Austrália geasseáigi",
               "AEDT",
               "Nuorta-Austrália áigi",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Oarje-Austrália dálveáigi",
               "AWST",
               "Oarje-Austrália geasseáigi",
               "AWDT",
               "Oarje-Austrália áigi",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Gaska-Indonesia áigi",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Nuorta-Indonesia áigi",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Oarje-Indonesia áigi",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Gaska-Austrália oarjjabeali dálveáigi",
               "",
               "Gaska-Austrália oarjjabeali geasseáigi",
               "",
               "Gaska-Austrália oarjjabeali áigi",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwicha áigi",
                    "GMT",
                    "Brihtalaš geasseáigi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "koordinerejuvvon oktasaš áigi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwicha áigi",
                    "GMT",
                    "Irlánddalaš dálveáigi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "koordinerejuvvon oktasaš áigi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "koordinerejuvvon oktasaš áigi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwicha áigi",
                    "GMT",
                    "Brihtalaš geasseáigi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "koordinerejuvvon oktasaš áigi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "koordinerejuvvon oktasaš áigi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "koordinerejuvvon oktasaš áigi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwicha áigi",
                    "GMT",
                    "Irlánddalaš dálveáigi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwicha áigi",
                    "GMT",
                    "Brihtalaš geasseáigi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwicha áigi",
                    "GMT",
                    "Brihtalaš geasseáigi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwicha áigi",
                    "GMT",
                    "Brihtalaš geasseáigi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwicha áigi",
                    "GMT",
                    "Brihtalaš geasseáigi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwicha áigi",
                    "GMT",
                    "Brihtalaš geasseáigi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "Dovdameahttun gávpot" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Irkutsk", "Irkuck" },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Asia/Yakutsk", "Jakuck" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Indian/Cocos", "Kokos" },
            { "timezone.excity.Asia/Damascus", "Damaskos" },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "timezone.excity.Europe/Athens", "Athena" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "timezone.excity.Europe/Warsaw", "Warsawa" },
            { "timezone.excity.Europe/Zurich", "Zürich" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Asia/Kamchatka", "Kamčatka" },
            { "timezone.excity.Atlantic/Azores", "Azorat" },
            { "timezone.excity.Atlantic/Canary", "Kanária" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Brüssel" },
            { "timezone.excity.Europe/Helsinki", "Helsset" },
            { "timezone.excity.Indian/Maldives", "Malediivvat" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan-Bator" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Indian/Christmas", "Juovlasuolu" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokusneck" },
            { "timezone.excity.Europe/Copenhagen", "København" },
            { "timezone.excity.Europe/Luxembourg", "Luxenburg" },
            { "timezone.excity.Pacific/Marquesas", "Marquesasat" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Europe/Isle_of_Man", "Mansuolu" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Verde" },
            { "timezone.excity.America/Danmarkshavn", "Dánmárkkuhámman" },
            { "timezone.excity.Atlantic/South_Georgia", "Lulli-Georgia" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Davvi-Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Guovddáš, Davvi-Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Davvi-Dakota" },
        };
        return data;
    }
}
