/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sq extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_lo = "laosisht";
        final String metaValue_mak = "makasarisht";
        final String metaValue_mn = "mongolisht";
        final String metaValue_bo = "tibetisht";
        final Object[][] data = new Object[][] {
            { "001", "Bota" },
            { "002", "Afrikë" },
            { "003", "Amerika e Veriut" },
            { "005", "Amerika e Jugut" },
            { "009", "Oqeani" },
            { "011", "Afrika Perëndimore" },
            { "013", "Amerika Qendrore" },
            { "014", "Afrika Lindore" },
            { "015", "Afrika Veriore" },
            { "017", "Afrika e Mesme" },
            { "018", "Afrika Jugore" },
            { "019", "Amerikë" },
            { "021", "Amerika Veriore" },
            { "029", "Karaibe" },
            { "030", "Azia Lindore" },
            { "034", "Azia Jugore" },
            { "035", "Azia Juglindore" },
            { "039", "Evropa Jugore" },
            { "053", "Australazia" },
            { "054", "Melanezia" },
            { "057", "Rajoni Mikronezian" },
            { "061", "Polinezia" },
            { "142", "Azi" },
            { "143", "Azia Qendrore" },
            { "145", "Azia Perëndimore" },
            { "150", "Evropë" },
            { "151", "Evropa Lindore" },
            { "154", "Evropa Veriore" },
            { "155", "Evropa Perëndimore" },
            { "202", "Afrika Subsahariane" },
            { "419", "Amerika Latine" },
            { "AC", "Ishulli Asenshion" },
            { "AD", "Andorrë" },
            { "AE", "Emiratet e Bashkuara Arabe" },
            { "AF", "Afganistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguilë" },
            { "AL", "Shqipëri" },
            { "AM", "Armeni" },
            { "AO", "Angolë" },
            { "AQ", "Antarktikë" },
            { "AR", "Argjentinë" },
            { "AS", "Samoa Amerikane" },
            { "AT", "Austri" },
            { "AU", "Australi" },
            { "AW", "Arubë" },
            { "AX", "Ishujt Alandë" },
            { "AZ", "Azerbajxhan" },
            { "BA", "Bosnjë-Hercegovinë" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgjikë" },
            { "BF", "Burkina-Faso" },
            { "BG", "Bullgari" },
            { "BH", "Bahrejn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sen-Bartelemi" },
            { "BM", "Bermude" },
            { "BN", "Brunei" },
            { "BO", "Bolivi" },
            { "BQ", "Karaibet holandeze" },
            { "BR", "Brazil" },
            { "BS", "Bahama" },
            { "BT", "Butan" },
            { "BV", "Ishulli Bove" },
            { "BW", "Botsvanë" },
            { "BY", "Bjellorusi" },
            { "BZ", "Belizë" },
            { "CA", "Kanada" },
            { "CC", "Ishujt Kokos" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Republika e Afrikës Qendrore" },
            { "CG", "Kongo-Brazavilë" },
            { "CH", "Zvicër" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Ishujt Kuk" },
            { "CL", "Kili" },
            { "CM", "Kamerun" },
            { "CN", "Kinë" },
            { "CO", "Kolumbi" },
            { "CP", "Ishulli Klipërton" },
            { "CQ", "Sark" },
            { "CR", "Kosta-Rikë" },
            { "CU", "Kubë" },
            { "CV", "Kepi i Gjelbër" },
            { "CW", "Kurasao" },
            { "CX", "Ishulli i Krishtlindjes" },
            { "CY", "Qipro" },
            { "CZ", "Çeki" },
            { "DE", "Gjermani" },
            { "DG", "Diego-Garsia" },
            { "DJ", "Xhibuti" },
            { "DK", "Danimarkë" },
            { "DM", "Dominikë" },
            { "DO", "Republika Dominikane" },
            { "DZ", "Algjeri" },
            { "EA", "Theuta e Melila" },
            { "EC", "Ekuador" },
            { "EE", "Estoni" },
            { "EG", "Egjipt" },
            { "EH", "Saharaja Perëndimore" },
            { "ER", "Eritre" },
            { "ES", "Spanjë" },
            { "ET", "Etiopi" },
            { "EU", "Bashkimi Evropian" },
            { "EZ", "Zona euro" },
            { "FI", "Finlandë" },
            { "FJ", "Fixhi" },
            { "FK", "Ishujt Falkland" },
            { "FM", "Mikronezi" },
            { "FO", "Ishujt Faroe" },
            { "FR", "Francë" },
            { "GA", "Gabon" },
            { "GB", "Mbretëria e Bashkuar" },
            { "GD", "Granadë" },
            { "GE", "Gjeorgji" },
            { "GF", "Guajana Franceze" },
            { "GG", "Gernsej" },
            { "GH", "Ganë" },
            { "GI", "Gjibraltar" },
            { "GL", "Grënlandë" },
            { "GM", "Gambi" },
            { "GN", "Guine" },
            { "GP", "Guadelupë" },
            { "GQ", "Guineja Ekuatoriale" },
            { "GR", "Greqi" },
            { "GS", "Xhorxha Jugore dhe Ishujt Senduiçë të Jugut" },
            { "GT", "Guatemalë" },
            { "GU", "Guam" },
            { "GW", "Guine-Bisau" },
            { "GY", "Guajanë" },
            { "HK", "RPA i Hong-Kongut" },
            { "HM", "Ishujt Hërd e Mekdonald" },
            { "HN", "Honduras" },
            { "HR", "Kroaci" },
            { "HT", "Haiti" },
            { "HU", "Hungari" },
            { "IC", "Ishujt Kanarie" },
            { "ID", "Indonezi" },
            { "IE", "Irlandë" },
            { "IL", "Izrael" },
            { "IM", "Ishulli i Manit" },
            { "IN", "Indi" },
            { "IO", "Territori Britanik i Oqeanit Indian" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandë" },
            { "IT", "Itali" },
            { "JE", "Xhersej" },
            { "JM", "Xhamajkë" },
            { "JO", "Jordani" },
            { "JP", "Japoni" },
            { "KE", "Kenia" },
            { "KG", "Kirgizi" },
            { "KH", "Kamboxhia" },
            { "KI", "Kiribati" },
            { "KM", "Komore" },
            { "KN", "Shën-Kits dhe Nevis" },
            { "KP", "Kore e Veriut" },
            { "KR", "Kore e Jugut" },
            { "KW", "Kuvajt" },
            { "KY", "Ishujt Kajman" },
            { "KZ", "Kazakistan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Shën-Luçia" },
            { "LI", "Lihtenshtajn" },
            { "LK", "Sri-Lankë" },
            { "LR", "Liberi" },
            { "LS", "Lesoto" },
            { "LT", "Lituani" },
            { "LU", "Luksemburg" },
            { "LV", "Letoni" },
            { "LY", "Libi" },
            { "MA", "Marok" },
            { "MC", "Monako" },
            { "MD", "Moldavi" },
            { "ME", "Mal i Zi" },
            { "MF", "Sen-Marten" },
            { "MG", "Madagaskar" },
            { "MH", "Ishujt Marshall" },
            { "MK", "Maqedonia e Veriut" },
            { "ML", "Mali" },
            { "MM", "Mianmar (Burmë)" },
            { "MN", "Mongoli" },
            { "MO", "RPA i Makaos" },
            { "MP", "Ishujt e Marianës Veriore" },
            { "MQ", "Martinikë" },
            { "MR", "Mauritani" },
            { "MS", "Montserat" },
            { "MT", "Maltë" },
            { "MU", "Mauritius" },
            { "MV", "Maldive" },
            { "MW", "Malavi" },
            { "MX", "Meksikë" },
            { "MY", "Malajzi" },
            { "MZ", "Mozambik" },
            { "NA", "Namibi" },
            { "NC", "Kaledoni e Re" },
            { "NE", "Niger" },
            { "NF", "Ishulli Norfolk" },
            { "NG", "Nigeri" },
            { "NI", "Nikaragua" },
            { "NL", "Holandë" },
            { "NO", "Norvegji" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Zelandë e Re" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinezia Franceze" },
            { "PG", "Guineja e Re-Papua" },
            { "PH", "Filipine" },
            { "PK", "Pakistan" },
            { "PL", "Poloni" },
            { "PM", "Shën-Pier dhe Mikelon" },
            { "PN", "Ishujt Pitkern" },
            { "PR", "Porto-Riko" },
            { "PS", "Territoret Palestineze" },
            { "PT", "Portugali" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Katar" },
            { "QO", "Oqeania e Largët (Lindja e Largët)" },
            { "RE", "Reunion" },
            { "RO", "Rumani" },
            { "RS", "Serbi" },
            { "RU", "Rusi" },
            { "RW", "Ruandë" },
            { "SA", "Arabi Saudite" },
            { "SB", "Ishujt Solomon" },
            { "SC", "Sejshelle" },
            { "SD", "Sudan" },
            { "SE", "Suedi" },
            { "SG", "Singapor" },
            { "SH", "Shën-Elenë" },
            { "SI", "Slloveni" },
            { "SJ", "Svalbard e Jan-Majen" },
            { "SK", "Sllovaki" },
            { "SL", "Sierra-Leone" },
            { "SM", "San-Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali" },
            { "SR", "Surinami" },
            { "SS", "Sudani i Jugut" },
            { "ST", "Sao-Tome e Principe" },
            { "SV", "Salvador" },
            { "SX", "Sint-Marten" },
            { "SY", "Siri" },
            { "SZ", "Esvatini" },
            { "TA", "Tristan-da-Kuna" },
            { "TC", "Ishujt Turks dhe Kaikos" },
            { "TD", "Çad" },
            { "TF", "Territoret Jugore Franceze" },
            { "TG", "Togo" },
            { "TH", "Tajlandë" },
            { "TJ", "Taxhikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunizi" },
            { "TO", "Tonga" },
            { "TR", "Turqi" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajvan" },
            { "TZ", "Tanzani" },
            { "UA", "Ukrainë" },
            { "UG", "Ugandë" },
            { "UM", "Ishujt Periferikë të SHBA-së" },
            { "UN", "Organizata e Kombeve të Bashkuara" },
            { "US", "SHBA" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikan" },
            { "VC", "Shën-Vincent dhe Grenadine" },
            { "VE", "Venezuelë" },
            { "VG", "Ishujt e Virgjër Britanikë" },
            { "VI", "Ishujt e Virgjër të SHBA-së" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Uollis e Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-thekse" },
            { "XB", "Pseudo-bidi" },
            { "XK", "Kosovë" },
            { "YE", "Jemen" },
            { "YT", "Majotë" },
            { "ZA", "Afrika e Jugut" },
            { "ZM", "Zambi" },
            { "ZW", "Zimbabve" },
            { "ZZ", "I panjohur" },
            { "aa", "afarisht" },
            { "ab", "abkazisht" },
            { "af", "afrikanisht" },
            { "ak", "akanisht" },
            { "am", "amarisht" },
            { "an", "aragonezisht" },
            { "ar", "arabisht" },
            { "as", "asamezisht" },
            { "av", "avarikisht" },
            { "ay", "ajmarisht" },
            { "az", "azerbajxhanisht" },
            { "ba", "bashkirisht" },
            { "be", "bjellorusisht" },
            { "bg", "bullgarisht" },
            { "bi", "bislamisht" },
            { "bm", "bambarisht" },
            { "bn", "bengalisht" },
            { "bo", metaValue_bo },
            { "br", "bretonisht" },
            { "bs", "boshnjakisht" },
            { "ca", "katalonisht" },
            { "ce", "çeçenisht" },
            { "ch", "kamoroisht" },
            { "co", "korsikisht" },
            { "cs", "çekisht" },
            { "cu", "sllavishte kishtare" },
            { "cv", "çuvashisht" },
            { "cy", "uellsisht" },
            { "da", "danisht" },
            { "de", "gjermanisht" },
            { "dv", "divehisht" },
            { "dz", "xhongaisht" },
            { "ee", "eveisht" },
            { "el", "greqisht" },
            { "en", "anglisht" },
            { "eo", "esperanto" },
            { "es", "spanjisht" },
            { "et", "estonisht" },
            { "eu", "baskisht" },
            { "fa", "persisht" },
            { "ff", "fulaisht" },
            { "fi", "finlandisht" },
            { "fj", "fixhianisht" },
            { "fo", "faroisht" },
            { "fr", "frëngjisht" },
            { "fy", "frizianishte perëndimore" },
            { "ga", "irlandisht" },
            { "gd", "galishte skoceze" },
            { "gl", "galicisht" },
            { "gn", "guaranisht" },
            { "gu", "guxharatisht" },
            { "gv", "manksisht" },
            { "ha", "hausisht" },
            { "he", "hebraisht" },
            { "hi", "indisht" },
            { "hr", "kroatisht" },
            { "ht", "kreolishte e Haitit" },
            { "hu", "hungarisht" },
            { "hy", "armenisht" },
            { "hz", "hereroisht" },
            { "ia", "interlingua" },
            { "id", "indonezisht" },
            { "ie", "gjuha oksidentale" },
            { "ig", "igboisht" },
            { "ii", "sishuanisht" },
            { "io", "idoisht" },
            { "is", "islandisht" },
            { "it", "italisht" },
            { "iu", "inuktitutisht" },
            { "ja", "japonisht" },
            { "jv", "javanisht" },
            { "ka", "gjeorgjisht" },
            { "ki", "kikujuisht" },
            { "kj", "kuanjamaisht" },
            { "kk", "kazakisht" },
            { "kl", "kalalisutisht" },
            { "km", "kmerisht" },
            { "kn", "kanadisht" },
            { "ko", "koreanisht" },
            { "kr", "kanurisht" },
            { "ks", "kashmirisht" },
            { "ku", "kurmanjisht" },
            { "kv", "komisht" },
            { "kw", "kornisht" },
            { "ky", "kirgizisht" },
            { "la", "latinisht" },
            { "lb", "luksemburgisht" },
            { "lg", "gandaisht" },
            { "li", "limburgisht" },
            { "ln", "lingalisht" },
            { "lo", metaValue_lo },
            { "lt", "lituanisht" },
            { "lu", "luba-katangaisht" },
            { "lv", "letonisht" },
            { "mg", "madagaskarisht" },
            { "mh", "marshallisht" },
            { "mi", "maorisht" },
            { "mk", "maqedonisht" },
            { "ml", "malajalamisht" },
            { "mn", metaValue_mn },
            { "mr", "maratisht" },
            { "ms", "malajisht" },
            { "mt", "maltisht" },
            { "my", "birmanisht" },
            { "na", "nauruisht" },
            { "nb", "norvegjishte letrare" },
            { "nd", "ndebelishte veriore" },
            { "ne", "nepalisht" },
            { "ng", "ndongaisht" },
            { "nl", "holandisht" },
            { "nn", "norvegjishte nynorsk" },
            { "no", "norvegjisht" },
            { "nr", "ndebelishte jugore" },
            { "nv", "navahoisht" },
            { "ny", "nianjisht" },
            { "oc", "oksitanisht" },
            { "om", "oromoisht" },
            { "or", "odisht" },
            { "os", "osetisht" },
            { "pa", "punxhabisht" },
            { "pl", "polonisht" },
            { "ps", "pashtoisht" },
            { "pt", "portugalisht" },
            { "qu", "keçuaisht" },
            { "rm", "retoromanisht" },
            { "rn", "rundisht" },
            { "ro", "rumanisht" },
            { "ru", "rusisht" },
            { "rw", "kiniaruandisht" },
            { "sa", "sanskritisht" },
            { "sc", "sardenjisht" },
            { "sd", "sindisht" },
            { "se", "samishte veriore" },
            { "sg", "sangoisht" },
            { "sh", "serbo-kroatisht" },
            { "si", "sinhalisht" },
            { "sk", "sllovakisht" },
            { "sl", "sllovenisht" },
            { "sm", "samoanisht" },
            { "sn", "shonisht" },
            { "so", "somalisht" },
            { "sq", "shqip" },
            { "sr", "serbisht" },
            { "ss", "suatisht" },
            { "st", "sotoishte jugore" },
            { "su", "sundanisht" },
            { "sv", "suedisht" },
            { "sw", "suahilisht" },
            { "ta", "tamilisht" },
            { "te", "teluguisht" },
            { "tg", "taxhikisht" },
            { "th", "tajlandisht" },
            { "ti", "tigrinjaisht" },
            { "tk", "turkmenisht" },
            { "tn", "cuanaisht" },
            { "to", "tonganisht" },
            { "tr", "turqisht" },
            { "ts", "congaisht" },
            { "tt", "tatarisht" },
            { "tw", "tuisht" },
            { "ty", "tahitisht" },
            { "ug", "ujgurisht" },
            { "uk", "ukrainisht" },
            { "ur", "urduisht" },
            { "uz", "uzbekisht" },
            { "ve", "vendaisht" },
            { "vi", "vietnamisht" },
            { "vo", "volapykisht" },
            { "wa", "ualunisht" },
            { "wo", "uolofisht" },
            { "xh", "xhosaisht" },
            { "yi", "jidisht" },
            { "yo", "jorubaisht" },
            { "za", "zhuangisht" },
            { "zh", "kinezisht" },
            { "zu", "zuluisht" },
            { "ace", "akinezisht" },
            { "ada", "andangmeisht" },
            { "ady", "adigisht" },
            { "agq", "agemisht" },
            { "ain", "ajnuisht" },
            { "ale", "aleutisht" },
            { "alt", "altaishte jugore" },
            { "ann", "oboloisht" },
            { "anp", "angikisht" },
            { "arn", "mapuçisht" },
            { "arp", "arapahoisht" },
            { "ars", "arabishte naxhdi" },
            { "asa", "asuisht" },
            { "ast", "asturisht" },
            { "atj", "atikamekisht" },
            { "awa", "auadhisht" },
            { "bal", "balukisht" },
            { "ban", "balinezisht" },
            { "bas", "basaisht" },
            { "bem", "bembaisht" },
            { "bez", "benaisht" },
            { "bgc", "harjanvisht" },
            { "bgn", "balokishte perëndimore" },
            { "bho", "boxhpurisht" },
            { "bin", "binisht" },
            { "bla", "siksikaisht" },
            { "blo", "anisht" },
            { "brx", "bodoisht" },
            { "bug", "buginezisht" },
            { "byn", "blinisht" },
            { "cay", "kajugaisht" },
            { "ccp", "çakmaisht" },
            { "ceb", "sebuanisht" },
            { "cgg", "çigisht" },
            { "chk", "çukezisht" },
            { "chm", "marisht" },
            { "cho", "çoktauisht" },
            { "chp", "çipeuajanisht" },
            { "chr", "çerokisht" },
            { "chy", "çejenisht" },
            { "ckb", "kurdishte qendrore" },
            { "clc", "çilkotinisht" },
            { "crg", "miçifisht" },
            { "crj", "krijishte juglindore" },
            { "crk", "krijishte fusharake" },
            { "crl", "krijishte verilindore" },
            { "crm", "krijishte e Muzit" },
            { "crr", "algonkuianishte e Karolinës" },
            { "crs", "frëngjishte kreole seselve" },
            { "csw", "krijishte e moçaleve (Ontario)" },
            { "dak", "dakotisht" },
            { "dar", "darguaisht" },
            { "dav", "tajtaisht" },
            { "dgr", "dogribisht" },
            { "dje", "zarmaisht" },
            { "doi", "dogrisht" },
            { "dsb", "sorbishte e poshtme" },
            { "dua", "dualaisht" },
            { "dyo", "xhulafonjisht" },
            { "dzg", "dazagauisht" },
            { "ebu", "embuisht" },
            { "efi", "efikisht" },
            { "eka", "ekajukisht" },
            { "ewo", "euondoisht" },
            { "fil", "filipinisht" },
            { "fon", "fonisht" },
            { "frc", "frëngjishte kajune" },
            { "frr", "frisianishte veriore" },
            { "fur", "friulianisht" },
            { "gaa", "gaisht" },
            { "gag", "gagauzisht" },
            { "gez", "gizisht" },
            { "gil", "gilbertazisht" },
            { "gor", "gorontaloisht" },
            { "gsw", "gjermanishte zvicerane" },
            { "guz", "gusisht" },
            { "gwi", "guiçinisht" },
            { "hai", "haidaisht" },
            { "haw", "havaisht" },
            { "hax", "haidaishte jugore" },
            { "hil", "hiligajnonisht" },
            { "hmn", "hmongisht" },
            { "hsb", "sorbishte e sipërme" },
            { "hup", "hupaisht" },
            { "hur", "halkemejlemisht" },
            { "iba", "ibanisht" },
            { "ibb", "ibibioisht" },
            { "ikt", "inuktitutishte kanadeze perëndimore" },
            { "ilo", "ilokoisht" },
            { "inh", "ingushisht" },
            { "jbo", "lojbanisht" },
            { "jgo", "ngombisht" },
            { "jmc", "maçamisht" },
            { "kab", "kabilisht" },
            { "kac", "kaçinisht" },
            { "kaj", "kajeisht" },
            { "kam", "kambaisht" },
            { "kbd", "kabardianisht" },
            { "kcg", "tjapisht" },
            { "kde", "makondisht" },
            { "kea", "kreolishte e Kepit të Gjelbër" },
            { "kfo", "koroisht" },
            { "kgp", "kaingangisht" },
            { "kha", "kasisht" },
            { "khq", "kojraçinisht" },
            { "kkj", "kakoisht" },
            { "kln", "kalenxhinisht" },
            { "kmb", "kimbunduisht" },
            { "koi", "komi-parmjakisht" },
            { "kok", "konkanisht" },
            { "kpe", "kpeleisht" },
            { "krc", "karaçaj-balkarisht" },
            { "krl", "karelianisht" },
            { "kru", "kurukisht" },
            { "ksb", "shambalisht" },
            { "ksf", "bafianisht" },
            { "ksh", "këlnisht" },
            { "kum", "kumikisht" },
            { "kwk", "kuakualaisht" },
            { "kxv", "kuvisht" },
            { "lad", "ladinoisht" },
            { "lag", "langisht" },
            { "lez", "lezgianisht" },
            { "lij", "ligurisht" },
            { "lil", "lilluetisht" },
            { "lkt", "lakotisht" },
            { "lmo", "lombardisht" },
            { "lou", "kreolishte e Luizianës" },
            { "loz", "lozisht" },
            { "lrc", "lurishte veriore" },
            { "lsm", "samisht" },
            { "lua", "luba-luluaisht" },
            { "lun", "lundaisht" },
            { "luo", "luoisht" },
            { "lus", "mizoisht" },
            { "luy", "lujaisht" },
            { "mad", "madurezisht" },
            { "mag", "magaisht" },
            { "mai", "maitilisht" },
            { "mak", metaValue_mak },
            { "mas", "masaisht" },
            { "mdf", "mokshaisht" },
            { "men", "mendisht" },
            { "mer", "meruisht" },
            { "mfe", "morisjenisht" },
            { "mgh", "makua-mitoisht" },
            { "mgo", "metaisht" },
            { "mic", "mikmakisht" },
            { "min", "minangkabauisht" },
            { "mni", "manipurisht" },
            { "moe", "inuaimunisht" },
            { "moh", "mohokisht" },
            { "mos", "mosisht" },
            { "mua", "mundangisht" },
            { "mul", "gjuhë të shumëfishta" },
            { "mus", "krikisht" },
            { "mwl", "mirandisht" },
            { "myv", "erzjaisht" },
            { "mzn", "mazanderanisht" },
            { "nap", "napoletanisht" },
            { "naq", "namaisht" },
            { "nds", "gjermanishte e vendeve të ulëta" },
            { "new", "neuarisht" },
            { "nia", "niasisht" },
            { "niu", "niueanisht" },
            { "nmg", "kuasisht" },
            { "nnh", "ngiembunisht" },
            { "nog", "nogajisht" },
            { "nqo", "nkoisht" },
            { "nso", "sotoishte veriore" },
            { "nus", "nuerisht" },
            { "nyn", "niankolisht" },
            { "ojb", "oxhibuaishte verilindore" },
            { "ojc", "oxhibuaishte qendrore" },
            { "ojs", "oxhikrijisht" },
            { "ojw", "oxhibuaishte perëndimore" },
            { "oka", "okanaganisht" },
            { "pag", "pangasinanisht" },
            { "pam", "pampangaisht" },
            { "pap", "papiamentisht" },
            { "pau", "paluanisht" },
            { "pcm", "pixhinishte nigeriane" },
            { "pis", "pixhinisht" },
            { "pqm", "malisit-pasamakuadisht" },
            { "prg", "prusisht" },
            { "quc", "kiçeisht" },
            { "raj", "raxhastanisht" },
            { "rap", "rapanuisht" },
            { "rar", "rarontonganisht" },
            { "rhg", "rohingiaisht" },
            { "rof", "romboisht" },
            { "rup", "vllahisht" },
            { "rwk", "ruaisht" },
            { "sad", "sandauisht" },
            { "sah", "sakaisht" },
            { "saq", "samburisht" },
            { "sat", "santalisht" },
            { "sba", "ngambajisht" },
            { "sbp", "sanguisht" },
            { "scn", "siçilianisht" },
            { "sco", "skotisht" },
            { "sdh", "kurdishte jugore" },
            { "seh", "senaisht" },
            { "ses", "senishte kojrabore" },
            { "shi", "taçelitisht" },
            { "shn", "shanisht" },
            { "slh", "lashutsidishte jugore" },
            { "sma", "samishte jugore" },
            { "smj", "samishte lule" },
            { "smn", "samishte inari" },
            { "sms", "samishte skolti" },
            { "snk", "soninkisht" },
            { "srn", "srananisht (sranantongoisht)" },
            { "ssy", "sahoisht" },
            { "str", "sejlishte e Ngushticave të Rozarios" },
            { "suk", "sukumaisht" },
            { "swb", "kamorianisht" },
            { "syr", "siriakisht" },
            { "szl", "silesisht" },
            { "tce", "tatshonishte jugore" },
            { "tem", "timneisht" },
            { "teo", "tesoisht" },
            { "tet", "tetumisht" },
            { "tgx", "tagishisht" },
            { "tht", "taltanisht" },
            { "tig", "tigreisht" },
            { "tlh", "klingonisht" },
            { "tli", "tlingitisht" },
            { "tok", "tokiponaisht" },
            { "tpi", "pisinishte toku" },
            { "trv", "torokoisht" },
            { "ttm", "taçoneishte veriore" },
            { "tum", "tumbukaisht" },
            { "tvl", "tuvaluisht" },
            { "twq", "tasavakisht" },
            { "tyv", "tuvinianisht" },
            { "tzm", "tamazajtisht e Atlasit Qendror" },
            { "udm", "udmurtisht" },
            { "umb", "umbunduisht" },
            { "und", "E panjohur" },
            { "vai", "vaisht" },
            { "vec", "venetisht" },
            { "vmw", "makuvaisht" },
            { "vun", "vunxhoisht" },
            { "wae", "ualserisht" },
            { "wal", "ulajtaisht" },
            { "war", "uarajisht" },
            { "wbp", "uarlpirisht" },
            { "wuu", "kinezishte vu" },
            { "xal", "kalmikisht" },
            { "xnr", "kangrisht" },
            { "xog", "sogisht" },
            { "yav", "jangbenisht" },
            { "ybb", "jembaisht" },
            { "yrl", "nejengatuisht" },
            { "yue", "kantonezisht" },
            { "zgh", "tamaziatishte standarde marokene" },
            { "zun", "zunisht" },
            { "zxx", "nuk ka përmbajtje gjuhësore" },
            { "zza", "zazaisht" },
            { "Adlm", "adlam" },
            { "Aghb", "albanishte e Kaukazit" },
            { "Ahom", "ahomisht" },
            { "Arab", "arabik" },
            { "Aran", "nastalik" },
            { "Armi", "aramaishte perandorake" },
            { "Armn", "armen" },
            { "Avst", "avestanisht" },
            { "Bali", "bali" },
            { "Bamu", "bamu" },
            { "Bass", "basavahisht" },
            { "Batk", "batak" },
            { "Beng", "bengal" },
            { "Bhks", "baiksukisht" },
            { "Bopo", "bopomof" },
            { "Brah", "brahmisht" },
            { "Brai", "brailisht" },
            { "Bugi", "buginisht" },
            { "Buhd", "buhidisht" },
            { "Cakm", "çakma" },
            { "Cans", "rrokje të unifikuara aborigjene kanadeze" },
            { "Cari", "karianisht" },
            { "Cham", "çam" },
            { "Cher", "çeroki" },
            { "Chrs", "korasmianisht" },
            { "Copt", "koptisht" },
            { "Cpmn", "minoishte e Qipros" },
            { "Cprt", "qipriotisht" },
            { "Cyrl", "cirilik" },
            { "Deva", "devanagar" },
            { "Diak", "divesakuruisht" },
            { "Dogr", "dograisht" },
            { "Dsrt", "deseretisht" },
            { "Dupl", "duplojanisht - formë e shkurtër" },
            { "Egyp", "hieroglife egjiptiane" },
            { "Elba", "shkrim i Elbasanit" },
            { "Elym", "elimaisht" },
            { "Ethi", "etiopik" },
            { "Geor", "gjeorgjian" },
            { "Glag", "glagolitikisht" },
            { "Gong", "gong" },
            { "Gonm", "masaramgondisht" },
            { "Goth", "gotik" },
            { "Gran", "grantaisht" },
            { "Grek", "grek" },
            { "Gujr", "guxharat" },
            { "Guru", "gurmuk" },
            { "Hanb", "hanbik" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoisht" },
            { "Hans", "i thjeshtuar" },
            { "Hant", "tradicional" },
            { "Hatr", "hatranisht" },
            { "Hebr", "hebraik" },
            { "Hira", "hiragan" },
            { "Hluw", "hieroglife anatoliane" },
            { "Hmng", "pahauhmonisht" },
            { "Hmnp", "niakeng puaçue hmong" },
            { "Hrkt", "alfabet rrokjesor japonez" },
            { "Hung", "hungarishte e vjetër" },
            { "Ital", "italishte e vjetër" },
            { "Jamo", "xhamosisht" },
            { "Java", "java" },
            { "Jpan", "japonez" },
            { "Kali", "kajali" },
            { "Kana", "katakan" },
            { "Kawi", "kavi" },
            { "Khar", "karoshtisht" },
            { "Khmr", "kmer" },
            { "Khoj", "koxhkisht" },
            { "Kits", "shkrim i vogël kitan" },
            { "Knda", "kanad" },
            { "Kore", "korean" },
            { "Kthi", "kaitisht" },
            { "Lana", "lana" },
            { "Laoo", metaValue_lo },
            { "Latn", "latin" },
            { "Lepc", "lepça" },
            { "Limb", "limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lisu", "fraser" },
            { "Lyci", "licianisht" },
            { "Lydi", "lidianisht" },
            { "Mahj", "mahaxhanisht" },
            { "Maka", metaValue_mak },
            { "Mand", "mande" },
            { "Mani", "manikeanisht" },
            { "Marc", "markenisht" },
            { "Medf", "medefaidrinisht" },
            { "Mend", "mendeisht" },
            { "Merc", "meroitik kursiv" },
            { "Mero", "meroitik" },
            { "Mlym", "malajalam" },
            { "Modi", "modisht" },
            { "Mong", metaValue_mn },
            { "Mroo", "mroisht" },
            { "Mtei", "mitei-majek" },
            { "Mult", "multanisht" },
            { "Mymr", "birman" },
            { "Nagm", "nag mundari" },
            { "Nand", "nandigarisht" },
            { "Narb", "arabishte veriore e vjetër" },
            { "Nbat", "nabateanisht" },
            { "Newa", "neva" },
            { "Nkoo", "nko" },
            { "Nshu", "nyshuisht" },
            { "Ogam", "ogamisht" },
            { "Olck", "ol çiki" },
            { "Orkh", "orkonisht" },
            { "Orya", "orija" },
            { "Osge", "osage" },
            { "Osma", "osmaniaisht" },
            { "Ougr", "ujgurishte e vjetër" },
            { "Palm", "palmirenisht" },
            { "Pauc", "pausinhauisht" },
            { "Perm", "permike e vjetër" },
            { "Phag", "fagspaisht" },
            { "Phli", "palavishte mbishkrimesh" },
            { "Phlp", "palavishte psalteri" },
            { "Phnx", "fenikisht" },
            { "Plrd", "polard fonetik" },
            { "Prti", "persishte mbishkrimesh" },
            { "Qaag", "zaugi" },
            { "Rjng", "rexhangisht" },
            { "Rohg", "hanifi" },
            { "Runr", "runike" },
            { "Samr", "samaritanisht" },
            { "Sarb", "arabishte jugore e vjetër" },
            { "Saur", "saurashtra" },
            { "Sgnw", "shkrim sing" },
            { "Shaw", "shavianisht" },
            { "Shrd", "sharadisht" },
            { "Sidd", "sidamisht" },
            { "Sind", "kudavadisht" },
            { "Sinh", "sinhal" },
            { "Sogd", "sogdianisht" },
            { "Sogo", "sogdianishte e vjetër" },
            { "Sora", "sorasompengisht" },
            { "Soyo", "sojomboisht" },
            { "Sund", "sundan" },
            { "Sylo", "siloti nagri" },
            { "Syrc", "siriak" },
            { "Tagb", "tagbanvaisht" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "tai lue i ri" },
            { "Taml", "tamil" },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", "telug" },
            { "Tfng", "tifinag" },
            { "Tglg", "tagalog" },
            { "Thaa", "tanisht" },
            { "Thai", "tajlandez" },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Tnsa", "tangsa" },
            { "Toto", "toto" },
            { "Ugar", "ugaritik" },
            { "Vaii", "vai" },
            { "Vith", "vithkuqi" },
            { "Wara", "varang kshiti" },
            { "Wcho", "vanço" },
            { "Xpeo", "persian i vjetër" },
            { "Xsux", "kuneiform sumero-akadian" },
            { "Yezi", "jezidi" },
            { "Yiii", "ji" },
            { "Zanb", "katror zanabazar" },
            { "Zinh", "zin" },
            { "Zmth", "simbole matematikore" },
            { "Zsye", "emoji" },
            { "Zsym", "me simbole" },
            { "Zxxx", "i pashkruar" },
            { "Zyyy", "i zakonshëm" },
            { "Zzzz", "i panjohur" },
            { "de_AT", "gjermanishte austriake" },
            { "de_CH", "gjermanishte zvicerane (dialekti i Alpeve)" },
            { "en_AU", "anglishte australiane" },
            { "en_CA", "anglishte kanadeze" },
            { "en_GB", "anglishte britanike" },
            { "en_US", "anglishte amerikane" },
            { "es_ES", "spanjishte evropiane" },
            { "es_MX", "spanjishte meksikane" },
            { "fa_AF", "darisht" },
            { "fr_CA", "frëngjishte kanadeze" },
            { "fr_CH", "frëngjishte zvicerane" },
            { "nl_BE", "flamandisht" },
            { "pt_BR", "portugalishte braziliane" },
            { "pt_PT", "portugalishte evropiane" },
            { "ro_MD", "moldavisht" },
            { "sw_CD", "suahilishte kongoleze" },
            { "ar_001", "arabishte standarde moderne" },
            { "es_419", "spanjishte amerikano-latine" },
            { "key.ca", "Kalendari" },
            { "key.cf", "Formati valutor" },
            { "key.co", "Radhitja" },
            { "key.cu", "Valuta" },
            { "key.em", "Prezantimi i emoji-ve" },
            { "key.hc", "Cikli orar (12 - 24)" },
            { "key.lb", "Stili i gjerësisë së rreshtave" },
            { "key.lw", "Ndarja e rreshtit brenda fjalëve" },
            { "key.ms", "Sistemi i njësive matëse" },
            { "key.nu", "Numrat/shifrat" },
            { "key.ss", "Ndërprerja e fjalisë pas shkurtimit" },
            { "nds_NL", "gjermanishte saksone e vendeve të ulëta" },
            { "hi_Latn", "hindisht (latine)" },
            { "zh_Hans", "kinezishte e thjeshtuar" },
            { "zh_Hant", "kinezishte tradicionale" },
            { "type.ca.roc", "kalendar minguo" },
            { "type.co.eor", "Rregulla evropiane radhitjeje" },
            { "type.hc.h11", "sistem 12-orësh (0 - 11)" },
            { "type.hc.h12", "sistem 12-orësh (1 - 12)" },
            { "type.hc.h23", "sistem 24-orësh (0 - 23)" },
            { "type.hc.h24", "sistem 24-orësh (1 - 24)" },
            { "type.nu.ahom", "shifra ahom" },
            { "type.nu.arab", "shifra indo-arabe" },
            { "type.nu.armn", "numra armenë" },
            { "type.nu.bali", "shifra bali" },
            { "type.nu.beng", "shifra bengali" },
            { "type.nu.brah", "shifra brahmi" },
            { "type.nu.cakm", "shifra çakma" },
            { "type.nu.cham", "shifra çam" },
            { "type.nu.cyrl", "numra cirilikë" },
            { "type.nu.deva", "shifra devanagari" },
            { "type.nu.diak", "shifra dives akuru" },
            { "type.nu.ethi", "numra etiopianë" },
            { "type.nu.geor", "numra gjeorgjianë" },
            { "type.nu.gong", "shifra gunxhala gondi" },
            { "type.nu.gonm", "shifra masaram gondi" },
            { "type.nu.grek", "numra grekë" },
            { "type.nu.gujr", "shifra guxharati" },
            { "type.nu.guru", "shifra gurmuki" },
            { "type.nu.hans", "numra të kinezishtes së thjeshtuar" },
            { "type.nu.hant", "numra të kinezishtes tradicionale" },
            { "type.nu.hebr", "numra hebraikë" },
            { "type.nu.hmng", "shifra pahau hmong" },
            { "type.nu.hmnp", "shifra niakeng puaçue hmong" },
            { "type.nu.java", "shifra java" },
            { "type.nu.jpan", "numra japonezë" },
            { "type.nu.kali", "shifra kaja li" },
            { "type.nu.kawi", "shifra kavi" },
            { "type.nu.khmr", "shifra kmere" },
            { "type.nu.knda", "shifra kanade" },
            { "type.nu.lana", "shifra tai tam hora" },
            { "type.nu.laoo", "shifra lao" },
            { "type.nu.latn", "shifra latino-perëndimore" },
            { "type.nu.lepc", "shifra lepça" },
            { "type.nu.limb", "shifra limbu" },
            { "type.nu.mlym", "shifra malajalame" },
            { "type.nu.modi", "shifra modi" },
            { "type.nu.mong", "shifra mongole" },
            { "type.nu.mroo", "shifra mro" },
            { "type.nu.mtei", "shifra mitei-majeke" },
            { "type.nu.mymr", "shifra mianmari" },
            { "type.nu.nagm", "shifra nag mundan" },
            { "type.nu.nkoo", "shifra nko" },
            { "type.nu.olck", "shifra ol-çikike" },
            { "type.nu.orya", "shifra orije" },
            { "type.nu.osma", "shifra osmania" },
            { "type.nu.rohg", "shifra hanifi rohingia" },
            { "type.nu.saur", "shifra saurashtra" },
            { "type.nu.shrd", "shifra sharada" },
            { "type.nu.sind", "shifra kudavadi" },
            { "type.nu.sinh", "shifra sinala lit" },
            { "type.nu.sora", "shifra sora sompeng" },
            { "type.nu.sund", "shifra sundan" },
            { "type.nu.takr", "shifra takri" },
            { "type.nu.talu", "shifra të reja tai lue" },
            { "type.nu.taml", "numra tamilë tradicionalë" },
            { "type.nu.telu", "shifra teluguje" },
            { "type.nu.thai", "shifra tajlandeze" },
            { "type.nu.tibt", "shifra tibetiane" },
            { "type.nu.tirh", "shifra tirhuta" },
            { "type.nu.tnsa", "shifra tangsa" },
            { "type.nu.vaii", "shifra vai" },
            { "type.nu.wara", "shifra varang citi" },
            { "type.nu.wcho", "shifra vanço" },
            { "type.ca.dangi", "kalendar dangi" },
            { "type.co.ducet", "radhitje unikode e parazgjedhur" },
            { "type.co.emoji", "Radhitje Emoji" },
            { "type.lb.loose", "stil i gjerësisë së rreshtave - i larguar" },
            { "type.nu.roman", "numra romakë" },
            { "type.ca.coptic", "kalendar koptik" },
            { "type.ca.hebrew", "kalendar hebraik" },
            { "type.ca.indian", "Kalendari Kombëtar Indian" },
            { "type.co.compat", "Radhitja e mëparshme, për pajtueshmëri" },
            { "type.co.pinyin", "Radhitje pinini" },
            { "type.co.search", "kërkim i përgjithshëm" },
            { "type.co.stroke", "radhitje me vijëzim" },
            { "type.co.unihan", "radhitje me vijëzim radikal" },
            { "type.co.zhuyin", "radhitje zhujin" },
            { "type.lb.normal", "stil i gjerësisë së rreshtave - normal" },
            { "type.lb.strict", "stil i gjerësisë së rreshtave - i ngushtuar" },
            { "type.ms.metric", "sistem metrik" },
            { "type.ca.chinese", "kalendar kinez" },
            { "type.ca.islamic", "kalendar islam" },
            { "type.ca.iso8601", "kalendar ISO-8601" },
            { "type.ca.persian", "kalendar persian" },
            { "type.cf.account", "format valutor llogaritës" },
            { "type.nu.arabext", "shifra indo-arabe të zgjatura" },
            { "type.nu.armnlow", "numra armenë të vegjël" },
            { "type.nu.greklow", "numra grekë të vegjël" },
            { "type.nu.hanidec", "numra dhjetorë kinezë" },
            { "type.nu.hansfin", "numra financiarë të kinezishtes së thjeshtuar" },
            { "type.nu.hantfin", "numra financiarë të kinezishtes tradicionale" },
            { "type.nu.jpanfin", "numra financiarë japonezë" },
            { "type.nu.mathdbl", "shifra matematike me dy kalime" },
            { "type.nu.tamldec", "shifra tamile" },
            { "type.ca.buddhist", "kalendar budist" },
            { "type.ca.ethiopic", "kalendari etiopik" },
            { "type.ca.japanese", "kalendar japonez" },
            { "type.cf.standard", "format valutor standard" },
            { "type.co.searchjl", "kërkim sipas bashkëtingëllores fillestare hangul" },
            { "type.co.standard", "radhitje standarde" },
            { "type.ms.uksystem", "sistem imperial (britanik) i njësive matëse" },
            { "type.ms.ussystem", "sistem amerikan i njësive matëse" },
            { "type.nu.fullwide", "shifra me largësi të brendshme" },
            { "type.nu.lanatham", "shifra tai tam tam" },
            { "type.nu.mathbold", "shifra të trasha matematike" },
            { "type.nu.mathmono", "shifra matematike monohapësire" },
            { "type.nu.mathsanb", "shifra të trasha matematike sans-serif" },
            { "type.nu.mathsans", "shifra matematike sans-serif" },
            { "type.nu.mymrshan", "shifra mianmar-shan" },
            { "type.nu.mymrtlng", "shifra mianmar tai lang" },
            { "type.nu.romanlow", "numra romakë të vegjël" },
            { "type.ca.gregorian", "kalendar gregorian" },
            { "type.co.phonebook", "Radhitje libri telefonik" },
            { "type.co.dictionary", "Radhitje fjalori" },
            { "type.co.traditional", "radhitje tradicionale" },
            { "type.ca.islamic-rgsa", "kalendar islamik (Arabi Saudite, shikim)" },
            { "type.ca.islamic-tbla", "kalendar islam (tabelor, epoka astronomike)" },
            { "type.ca.islamic-civil", "kalendar islam (tabelor, epoka civile)" },
            { "type.ca.islamic-umalqura", "kalendar islam (um al-qura)" },
            { "type.ca.ethiopic-amete-alem", "kalendar etiopik amete-alem" },
        };
        return data;
    }
}
