/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kok extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "फिजी";
        final String metaValue_TR = "तुर्की";
        final String metaValue_TV = "तुवालू";
        final String metaValue_hy = "आर्मेनियन";
        final String metaValue_ccp = "चाक्मा";
        final String metaValue_ka = "जॉर्जियन";
        final String metaValue_el = "ग्रीक";
        final String metaValue_gu = "गुजराती";
        final String metaValue_ja = "जपानी";
        final String metaValue_kn = "कन्नड";
        final String metaValue_ko = "कोरियन";
        final String metaValue_lo = "लाओ";
        final String metaValue_ml = "मल्याळम";
        final String metaValue_MM = "म्यानमार";
        final String metaValue_nqo = "नको";
        final String metaValue_ta = "तमिळ";
        final String metaValue_te = "तेलुगू";
        final String metaValue_th = "थाई";
        final Object[][] data = new Object[][] {
            { "001", "जग" },
            { "002", "आफ्रिका" },
            { "003", "उत्तर अमेरिका" },
            { "005", "दक्षिण अमेरिका" },
            { "009", "ओसेनिया" },
            { "011", "अस्तंत आफ्रिका" },
            { "013", "मध्य अमेरिका" },
            { "014", "उदेंत आफ्रिका" },
            { "015", "उत्तरी आफ्रिका" },
            { "017", "मध्य आफ्रिका" },
            { "018", "दक्षिणी आफ्रिका" },
            { "019", "अमेरिकास" },
            { "021", "उत्तरी अमेरिका" },
            { "029", "कॅरिबियन" },
            { "030", "उदेंत आशिया" },
            { "034", "दक्षिण आशिया" },
            { "035", "आग्नेय आशिया" },
            { "039", "दक्षिण युरोप" },
            { "053", "ऑस्ट्रेलेसिया" },
            { "054", "मेलानेसिया" },
            { "057", "मायक्रोनेशियन प्रांत" },
            { "061", "पोलिनेशिया" },
            { "142", "आशिया" },
            { "143", "मध्य आशिया" },
            { "145", "अस्तंत आशिया" },
            { "150", "युरोप" },
            { "151", "उदेंत युरोप" },
            { "154", "उत्तरी येरोप" },
            { "155", "अस्तंत युरोप" },
            { "202", "उप-सहाराई आफ्रिका" },
            { "419", "लॅटीन अमेरिका" },
            { "AC", "असँसांव जुंवो" },
            { "AD", "आंडोरा" },
            { "AE", "संयुक्त अरबी अमीरात" },
            { "AF", "अफगानिस्तान" },
            { "AG", "अँटिगुआ आनी बार्बुडा" },
            { "AI", "अँग्विला" },
            { "AL", "आल्बान्या" },
            { "AM", "अर्मेनिया" },
            { "AO", "अंगोला" },
            { "AQ", "अंटार्क्टिका" },
            { "AR", "आर्जेंटीना" },
            { "AS", "अमेरिकेचो सामोआ" },
            { "AT", "ऑस्ट्रिया" },
            { "AU", "ऑस्ट्रेलिया" },
            { "AW", "अरुबा" },
            { "AX", "ओलँड जुंवे" },
            { "AZ", "आजरबैजान" },
            { "BA", "बॉस्निया आनी हर्जेगोविना" },
            { "BB", "बार्बाडोस" },
            { "BD", "बांगलादेश" },
            { "BE", "बेल्जियम" },
            { "BF", "बुर्कीना फासो" },
            { "BG", "बुल्गारिया" },
            { "BH", "बाहरेन" },
            { "BI", "बुरुंडी" },
            { "BJ", "बेनीन" },
            { "BL", "सांव बार्टोलोमेव" },
            { "BM", "बर्मुडा" },
            { "BN", "ब्रूनेई" },
            { "BO", "बोलिविया" },
            { "BQ", "कॅरिबियन नॅदरलँड" },
            { "BR", "ब्राझील" },
            { "BS", "बाहामास" },
            { "BT", "भूतान" },
            { "BV", "बोउवे जुंवो" },
            { "BW", "बोट्स्वाना" },
            { "BY", "बेलारूस" },
            { "BZ", "बेलिझ" },
            { "CA", "कॅनडा" },
            { "CC", "कोकोस (कीलिंग) जुंवे" },
            { "CD", "काँगो - किंशासा" },
            { "CF", "मदलें अफ्रीकी प्रजासत्तो" },
            { "CG", "कोंगो - ब्राझाविला" },
            { "CH", "स्वित्झरलँड" },
            { "CI", "कोस्ता दो मारफ़ीम" },
            { "CK", "कुक जुंवे" },
            { "CL", "चिली" },
            { "CM", "कॅमरून" },
            { "CN", "चीन" },
            { "CO", "कोलंबिया" },
            { "CP", "क्लिपर्टन जुंवो" },
            { "CQ", "सार्क" },
            { "CR", "कोस्ता रिका" },
            { "CU", "क्युबा" },
            { "CV", "काबो वेर्दे" },
            { "CW", "कुरासाव" },
            { "CX", "ख्रिसमस जुंवो" },
            { "CY", "सिप्रुस" },
            { "CZ", "चेकिया" },
            { "DE", "जर्मनी" },
            { "DG", "डिएगो गार्सिया" },
            { "DJ", "जिबूती" },
            { "DK", "डेनमार्क" },
            { "DM", "डोमिनिका" },
            { "DO", "डोमिनिकन प्रजासत्तो" },
            { "DZ", "अल्जीरिया" },
            { "EA", "सेउता आनि मेलिया" },
            { "EC", "एक्वाडोर" },
            { "EE", "एस्टोनिया" },
            { "EG", "एजिप्त" },
            { "EH", "अस्तंती सहारा" },
            { "ER", "एरिट्रिया" },
            { "ES", "स्पेन" },
            { "ET", "इथियोपिया" },
            { "EU", "युरोपियन युनियन" },
            { "EZ", "युरोझोन" },
            { "FI", "फिनलँड" },
            { "FJ", metaValue_FJ },
            { "FK", "फ़ॉकलैंड आइलैंड्स" },
            { "FM", "मायक्रोनिशिया" },
            { "FO", "फेरो जुंवे" },
            { "FR", "फ्रान्स" },
            { "GA", "गाबॉन" },
            { "GB", "युनायटेड किंगडम" },
            { "GD", "ग्रेनाडा" },
            { "GE", "जॉर्जिया" },
            { "GF", "फ्रांसेझ गियॅना" },
            { "GG", "गॅर्नजी" },
            { "GH", "घाना" },
            { "GI", "जिब्राल्टर" },
            { "GL", "ग्रीनलँड" },
            { "GM", "गाम्बिया" },
            { "GN", "गिनी" },
            { "GP", "ग्वाडलूप" },
            { "GQ", "भूमध्यरेखी गिनी" },
            { "GR", "ग्रीस" },
            { "GS", "दक्षिण जॉर्जिया आनी दक्षिण सँडविच जुंवे" },
            { "GT", "ग्वाटेमाला" },
            { "GU", "गुआम" },
            { "GW", "गिनी-बिसाउ" },
            { "GY", "गियॅना" },
            { "HK", "हाँग काँग" },
            { "HM", "हर्ड आनि मॅक्डोनल्ड जुंवे" },
            { "HN", "हाँडूरास" },
            { "HR", "क्रोएशिया" },
            { "HT", "हैती" },
            { "HU", "हंगरी" },
            { "IC", "कानारियास जुंवे" },
            { "ID", "इंडोनिशिया" },
            { "IE", "आयरलँड" },
            { "IL", "इज्राएल" },
            { "IM", "मॅनाचो जुंवो" },
            { "IN", "भारत" },
            { "IO", "ब्रिटनाचो हिंदी महासागर प्रांत" },
            { "IQ", "इराक" },
            { "IR", "इरान" },
            { "IS", "आइसलँड" },
            { "IT", "इटली" },
            { "JE", "जर्सी" },
            { "JM", "जमैका" },
            { "JO", "जॉर्डन" },
            { "JP", "जपान" },
            { "KE", "केनिया" },
            { "KG", "किर्गिस्तान" },
            { "KH", "कॅम्बोडिया" },
            { "KI", "किरिबास" },
            { "KM", "कोमोरोस" },
            { "KN", "सांव क्रिस्टोवांव आनी नेविस" },
            { "KP", "उत्तर कोरिया" },
            { "KR", "दक्षिण कोरिया" },
            { "KW", "कुवेत" },
            { "KY", "केमॅन जुंवे" },
            { "KZ", "कजाखस्तान" },
            { "LA", "लाओस" },
            { "LB", "लेबनन" },
            { "LC", "सांता लूसिया" },
            { "LI", "लिश्टेंस्टाइन" },
            { "LK", "श्री लंका" },
            { "LR", "लायबिरिया" },
            { "LS", "लेसोथो" },
            { "LT", "लितुआनिया" },
            { "LU", "लुक्सेमबर्ग" },
            { "LV", "लाटविया" },
            { "LY", "लिबिया" },
            { "MA", "मोरोक्को" },
            { "MC", "मोनाको" },
            { "MD", "मॉल्डोवा" },
            { "ME", "मोंटेनेग्रो" },
            { "MF", "सॅंट मार्टिन" },
            { "MG", "मॅडागास्कर" },
            { "MH", "मार्शल जुंवे" },
            { "MK", "उत्तर मॅसिडोनिया" },
            { "ML", "माली" },
            { "MM", metaValue_MM },
            { "MN", "मंगोलिया" },
            { "MO", "मकाव" },
            { "MP", "उत्तरी मारियाना जुंवे" },
            { "MQ", "मार्टिनीक" },
            { "MR", "मॉरिटानिया" },
            { "MS", "मॉन्टसेराट" },
            { "MT", "माल्टा" },
            { "MU", "मॉरिशस" },
            { "MV", "मालदीव" },
            { "MW", "मलावी" },
            { "MX", "मेक्सिको" },
            { "MY", "मलेशिया" },
            { "MZ", "मोजाम्बिक" },
            { "NA", "नामिबिया" },
            { "NC", "नोवो कॅलेडोनिया" },
            { "NE", "नायजर" },
            { "NF", "नॉरफोक जुंवो" },
            { "NG", "नायजिरिया" },
            { "NI", "निकारागुआ" },
            { "NL", "नॅदरलँड" },
            { "NO", "नॉर्वे" },
            { "NP", "नेपाळ" },
            { "NR", "नाउरु" },
            { "NU", "निउए" },
            { "NZ", "नोवो झीलॅंड" },
            { "OM", "ओमान" },
            { "PA", "पानामा" },
            { "PE", "पेरू" },
            { "PF", "फ्रांसेझ पॉलिनिशिया" },
            { "PG", "पापुआ नोवो गिनी" },
            { "PH", "फिलिपीन्स" },
            { "PK", "पाकिस्तान" },
            { "PL", "पोलँड" },
            { "PM", "सांव पेद्रु आनी मिकेलांव" },
            { "PN", "पिटकॅर्न जुंवे" },
            { "PR", "पोर्टो रिको" },
            { "PS", "पालेसटीन" },
            { "PT", "पुर्तुगाल" },
            { "PW", "पालाउ" },
            { "PY", "पॅरग्वे" },
            { "QA", "कातार" },
            { "QO", "आवटलायींग ओशेनिया" },
            { "RE", "रेयुनियांव" },
            { "RO", "रोमेनिया" },
            { "RS", "सर्बिया" },
            { "RU", "रूस" },
            { "RW", "रुआंडा" },
            { "SA", "साउदी अरब" },
            { "SB", "सोलोमन जुंवे" },
            { "SC", "सेशेल्स" },
            { "SD", "सुदान" },
            { "SE", "स्वीडन" },
            { "SG", "सिंगापुर" },
            { "SH", "सांता हेलेना" },
            { "SI", "स्लोवेनिया" },
            { "SJ", "स्वालबार्ड आनी यान मायेन" },
            { "SK", "स्लोवाकिया" },
            { "SL", "सेर्रा लेओं" },
            { "SM", "सान मारीनो" },
            { "SN", "सेनेगाल" },
            { "SO", "सोमालिया" },
            { "SR", "सुरिनाम" },
            { "SS", "दक्षिण सुदान" },
            { "ST", "सांव टोमे आनी प्रिंसिपे" },
            { "SV", "एल साल्वाडोर" },
            { "SX", "सांव मोर्टिन (नॅदरलँड)" },
            { "SY", "सिरिया" },
            { "SZ", "एस्वातीनी" },
            { "TA", "ट्रीस्टांव दा कुन्ह्या" },
            { "TC", "तुर्क आनी कायकोस जुंवे" },
            { "TD", "चाड" },
            { "TF", "फ्रांसेझ दक्षिणी प्रांत" },
            { "TG", "टोगो" },
            { "TH", "थायलँड" },
            { "TJ", "ताजीकिस्तान" },
            { "TK", "टोकलाउ" },
            { "TL", "तिमोर-लेस्ते" },
            { "TM", "तुर्कमेनिस्तान" },
            { "TN", "टुनिसिया" },
            { "TO", "टाँगा" },
            { "TR", metaValue_TR },
            { "TT", "त्रिनदाड आनी तोबाग" },
            { "TV", metaValue_TV },
            { "TW", "ताइवान" },
            { "TZ", "तांजानिया" },
            { "UA", "युक्रेन" },
            { "UG", "युगांडा" },
            { "UM", "संयुक्त राज्यांचे पयशिल्ले धाकटे जुंवे" },
            { "UN", "संयुक्त राष्ट्रां" },
            { "US", "युनायटेड स्टेट्स" },
            { "UY", "उरुग्वे" },
            { "UZ", "उज्बेकिस्तान" },
            { "VA", "वॅटिकन शार" },
            { "VC", "सांव विसेंट आनी ग्रानाडीनस" },
            { "VE", "वेनेजुएला" },
            { "VG", "ब्रिटनाचे विर्जिन जुंवे" },
            { "VI", "संयुक्त राज्यांचे विर्जिन जुंवे" },
            { "VN", "विएतनाम" },
            { "VU", "वानुआतु" },
            { "WF", "वॉलिस आनी फुतुना" },
            { "WS", "सामोआ" },
            { "XA", "स्युडो-ऍक्सेंट" },
            { "XB", "स्युडो-बिडी" },
            { "XK", "कोसोवो" },
            { "YE", "येमेन" },
            { "YT", "मायोट" },
            { "ZA", "दक्षिण आफ्रिका" },
            { "ZM", "जाम्बिया" },
            { "ZW", "जिम्बाब्वे" },
            { "ZZ", "अज्ञात प्रांत" },
            { "aa", "अफार" },
            { "ab", "अबखेज़ियन" },
            { "af", "अफ्रिकान्स" },
            { "ak", "अकान" },
            { "am", "अमहारिक्" },
            { "an", "आरागोनिस" },
            { "ar", "अरबी" },
            { "as", "असमिया" },
            { "av", "अवारिक" },
            { "ay", "ऐमरा" },
            { "az", "अझरबैजानी" },
            { "ba", "बष्किर" },
            { "be", "बेलारुशियन" },
            { "bg", "बल्गेरियन" },
            { "bi", "बिसलमा" },
            { "bm", "बंबारा" },
            { "bn", "बांगला" },
            { "bo", "तिबेटी" },
            { "br", "ब्रेटन" },
            { "bs", "बोस्नियन" },
            { "ca", "कटलान" },
            { "ce", "चिचेन" },
            { "ch", "चामोर्रो" },
            { "co", "कोर्सिकन" },
            { "cs", "चेक" },
            { "cu", "चर्च स्लेव्हीक" },
            { "cv", "चुवाश" },
            { "cy", "वेल्श" },
            { "da", "डॅनिश" },
            { "de", "जर्मन" },
            { "dv", "दिवेही" },
            { "dz", "झोंग्खा" },
            { "ee", "एव" },
            { "el", metaValue_el },
            { "en", "इंग्लीश" },
            { "eo", "इस्परान्टो" },
            { "es", "स्पॅनीश" },
            { "et", "इस्टोनियन" },
            { "eu", "बास्क" },
            { "fa", "पर्शियन" },
            { "ff", "फुला" },
            { "fi", "फिनिश" },
            { "fj", metaValue_FJ },
            { "fo", "फेरोस" },
            { "fr", "फ्रेंच" },
            { "fy", "पश्चिमी फ्रिशियन" },
            { "ga", "आयरिश" },
            { "gd", "स्कॉटीश गॅलीक" },
            { "gl", "गेलीशियन" },
            { "gn", "ग्वारानी" },
            { "gu", metaValue_gu },
            { "gv", "मांक्स" },
            { "ha", "हौसा" },
            { "he", "हेब्रेव" },
            { "hi", "हिन्दी" },
            { "hr", "क्रोएशियन" },
            { "ht", "हैतियन क्रेयॉल" },
            { "hu", "हंगेरियन" },
            { "hy", metaValue_hy },
            { "hz", "हिरिरो" },
            { "ia", "इन्टरलिंग्वा" },
            { "id", "इंडोनेशियन" },
            { "ie", "इन्टरलिंग्वे" },
            { "ig", "इग्बो" },
            { "ii", "सिच्युआन यी" },
            { "ik", "इनूपेयाक्" },
            { "io", "इदो" },
            { "is", "आयस्लान्डिक" },
            { "it", "इटालियन" },
            { "iu", "इन्युक्तिटुट" },
            { "ja", metaValue_ja },
            { "jv", "जावनीज" },
            { "ka", metaValue_ka },
            { "ki", "किकुयु" },
            { "kj", "क्वानयामा" },
            { "kk", "कझाख" },
            { "kl", "कालाल्लिसुट" },
            { "km", "कंबोडिया" },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "कानुरी" },
            { "ks", "कश्मीरी" },
            { "ku", "कुर्मनजी" },
            { "kv", "कोमी" },
            { "kw", "कोर्निश" },
            { "ky", "किर्गिझ" },
            { "la", "लातीन" },
            { "lb", "लक्झेम्बर्गीश" },
            { "lg", "गांडा" },
            { "li", "लिंबर्गिश" },
            { "ln", "लिंगाला" },
            { "lo", metaValue_lo },
            { "lt", "लिथुआनियन" },
            { "lu", "लुबा-काटांगा" },
            { "lv", "लात्वियन" },
            { "mg", "मलागसी" },
            { "mh", "मार्शलीज" },
            { "mi", "माओरी" },
            { "mk", "मेसेडोनियन" },
            { "ml", metaValue_ml },
            { "mn", "मंगोलियन" },
            { "mr", "मराठी" },
            { "ms", "मलय" },
            { "mt", "माल्टिज" },
            { "my", "बर्मीज" },
            { "na", "नौरू" },
            { "nb", "नॉर्वेजियन बोकमाल" },
            { "nd", "उत्तर डेबेले" },
            { "ne", "नेपाळी" },
            { "ng", "डोंगा" },
            { "nl", "हाॅलँडी" },
            { "nn", "नॉर्वेजियन नायनोर्स्क" },
            { "no", "नोर्वेजियन" },
            { "nr", "दक्षिण डेबेले" },
            { "nv", "नावाजो" },
            { "ny", "नांन्जा" },
            { "oc", "ऑक्सिटन" },
            { "om", "ओरोमो" },
            { "or", "उडीया" },
            { "os", "ओसेटिक" },
            { "pa", "पंजाबी" },
            { "pl", "पोलिश" },
            { "ps", "पश्तो" },
            { "pt", "पोर्तुगीज" },
            { "qu", "क्वेच्वा" },
            { "rm", "रोमान्श" },
            { "rn", "रुंदी" },
            { "ro", "रोमानियन" },
            { "ru", "रशियन" },
            { "rw", "किन्यार्वान्डा" },
            { "sa", "संस्कृत" },
            { "sc", "सार्डिनियान" },
            { "sd", "सिंधी" },
            { "se", "उत्तरीय सामी" },
            { "sg", "सांगो" },
            { "sh", "सेर्बो-क्रोयेषियन्" },
            { "si", "सिंहला" },
            { "sk", "स्लोवाक" },
            { "sl", "स्लोवानियन" },
            { "sm", "सामोअन" },
            { "sn", "शोना" },
            { "so", "सोमाली" },
            { "sq", "आल्बेनियन्" },
            { "sr", "सर्बियन" },
            { "ss", "स्वाती" },
            { "st", "दक्षिणी सोथो" },
            { "su", "सुंदनीस" },
            { "sv", "स्विडीश" },
            { "sw", "स्वाहिली" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "ताजिक" },
            { "th", metaValue_th },
            { "ti", "तिग्रिन्या" },
            { "tk", "तुर्कमेन" },
            { "tl", "तगालोग" },
            { "tn", "सेत्स्वाना" },
            { "to", "तोंगान" },
            { "tr", metaValue_TR },
            { "ts", "त्सोंगा" },
            { "tt", "तातर" },
            { "tw", "त्वि" },
            { "ty", "ताहीशियन" },
            { "ug", "उयघूर" },
            { "uk", "युक्रेनियन" },
            { "ur", "उर्दू" },
            { "uz", "उझबेक" },
            { "ve", "वेंदा" },
            { "vi", "व्हिएतनामीज" },
            { "vo", "ओलापुक" },
            { "wa", "वालून" },
            { "wo", "वोलोफ" },
            { "xh", "खोसा" },
            { "yi", "यिडिश" },
            { "yo", "योरुबा" },
            { "za", "झ्हुन्ग" },
            { "zh", "चीनी" },
            { "zu", "झुलू" },
            { "ace", "अचायनीज" },
            { "ada", "अडांग्मे" },
            { "ady", "अडिघे" },
            { "agq", "अघेम" },
            { "ain", "आयनू" },
            { "ale", "आलिट" },
            { "alt", "दक्षिणी अल्टाय" },
            { "ann", "ओबोलो" },
            { "anp", "अंगिका" },
            { "arn", "मापुचे" },
            { "arp", "अरापाहो" },
            { "ars", "नाझदी अरबी" },
            { "asa", "असु" },
            { "ast", "अस्टुरियान" },
            { "atj", "अटिकामेक्वु" },
            { "awa", "अवधी" },
            { "bal", "Baluchi" },
            { "ban", "बालिनीज" },
            { "bas", "बस्सा" },
            { "bem", "बेम्बा" },
            { "bez", "बेना" },
            { "bgc", "हरयाणवी" },
            { "bho", "भोजपुरी" },
            { "bin", "बिनी" },
            { "bla", "सिकसिका" },
            { "blo", "अनी" },
            { "brx", "बोडो" },
            { "bug", "बुगिनिज" },
            { "byn", "ब्लीन" },
            { "cay", "कायुगा" },
            { "ccp", metaValue_ccp },
            { "ceb", "सेबुआनो" },
            { "cgg", "चिगा" },
            { "chk", "चुकीज" },
            { "chm", "मारी" },
            { "cho", "चाकता" },
            { "chp", "चिपेवायन" },
            { "chr", "चॅरोकी" },
            { "chy", "शायान" },
            { "ckb", "मध्य कर्दिश" },
            { "clc", "चिलकोटिन" },
            { "crg", "मिचिफ" },
            { "crj", "आग्नेय क्री" },
            { "crk", "प्लेन्स क्री" },
            { "crl", "ईशान्य क्री" },
            { "crm", "मूझ क्री" },
            { "crr", "कॅरोलीना अल्गॉन्क्वियन" },
            { "crs", "सेसेल्वा क्रयॉल फ्रेन्च" },
            { "csw", "स्वॉम्पी क्री" },
            { "dak", "डाकोटा" },
            { "dar", "दार्ग्वा" },
            { "dav", "तायता" },
            { "dgr", "डोगरीब" },
            { "dje", "झर्मा" },
            { "doi", "डोग्री" },
            { "dsb", "सकयलें सोर्बियन" },
            { "dua", "डुआला" },
            { "dyo", "जोला-फोन्यी" },
            { "dzg", "डाझागा" },
            { "ebu", "एम्बु" },
            { "efi", "एफीक" },
            { "eka", "एकाजुक" },
            { "ewo", "एवोंडो" },
            { "fil", "फिलिपिनो" },
            { "fon", "फोन" },
            { "frc", "कॅजां फ्रेंच" },
            { "frr", "उत्तरीय फ्रिशियन" },
            { "fur", "फ्रिलियन" },
            { "gaa", "गा" },
            { "gez", "गेझ" },
            { "gil", "गिलबर्टीस" },
            { "gor", "गोरोंटालो" },
            { "gsw", "स्विस जर्मन" },
            { "guz", "गुसी" },
            { "gwi", "ग्विच" },
            { "hai", "हैदा" },
            { "haw", "हवायियान" },
            { "hax", "दक्षिणी हैदा" },
            { "hil", "हिलीगायनॉन" },
            { "hmn", "मोंग" },
            { "hsb", "अपर सोर्बियन" },
            { "hup", "हुपा" },
            { "hur", "हाल्कोमेलेम" },
            { "iba", "आयबन" },
            { "ibb", "ईबिबियो" },
            { "ikt", "पश्चिमी कॅनडियन इनक्तितुत" },
            { "ilo", "इलोको" },
            { "inh", "इंगूश" },
            { "jbo", "लोजबान" },
            { "jgo", "गोंबा" },
            { "jmc", "मचामे" },
            { "kab", "काबायले" },
            { "kac", "काचीन" },
            { "kaj", "जु" },
            { "kam", "कंबा" },
            { "kbd", "काबार्डियन" },
            { "kcg", "त्याप" },
            { "kde", "माकोंडे" },
            { "kea", "काबुवर्डियनु" },
            { "kfo", "कोरो" },
            { "kgp", "कैनगँग" },
            { "kha", "खासी" },
            { "khq", "कोयरा छिनी" },
            { "kkj", "काको" },
            { "kln", "कालेंजीन" },
            { "kmb", "किंबुंडु" },
            { "kok", "कोंकणी" },
            { "kpe", "पेल्ले" },
            { "krc", "कराची-बाल्कर" },
            { "krl", "कारेलियन" },
            { "kru", "कुरुख" },
            { "ksb", "शांबाला" },
            { "ksf", "बाफिया" },
            { "ksh", "कोलोनियन" },
            { "kum", "कुमयक" },
            { "kwk", "क्वाकवाला" },
            { "kxv", "कुवी" },
            { "lad", "लाडिनो" },
            { "lag", "लांगी" },
            { "lez", "लेझघियान" },
            { "lij", "लिगुरियन" },
            { "lil", "लल्युएत" },
            { "lkt", "लाकोटा" },
            { "lmo", "लोमबार्ड" },
            { "lou", "ल्युइसियाना क्रियोल" },
            { "loz", "लोझीं" },
            { "lrc", "उत्तरीय लुरी" },
            { "lsm", "सामिया" },
            { "lua", "लुबा-लुलुआ" },
            { "lun", "लुंडा" },
            { "luo", "लुओ" },
            { "lus", "मिझो" },
            { "luy", "ल्युइया" },
            { "mad", "मादुरीज" },
            { "mag", "मगाही" },
            { "mai", "मैथिली" },
            { "mak", "माकासार" },
            { "mas", "मसाई" },
            { "mdf", "मोक्ष" },
            { "men", "मेंडे" },
            { "mer", "मेरू" },
            { "mfe", "मोरिसेन" },
            { "mgh", "माखुवा-मिट्टो" },
            { "mgo", "मेटा" },
            { "mic", "मिक्माक" },
            { "min", "मिनान्गकाबाव" },
            { "mni", "मणिपुरी" },
            { "moe", "इन्यु-ऐमुन" },
            { "moh", "मोहाक" },
            { "mos", "मोस्सी" },
            { "mua", "मुडांग" },
            { "mul", "साबार भाशा" },
            { "mus", "मस्कोजी" },
            { "mwl", "मिरांडीस" },
            { "myv", "एरझिया" },
            { "mzn", "मझांडेराणी" },
            { "nap", "नियापोलिटन" },
            { "naq", "नामा" },
            { "nds", "सकयलें जर्मन" },
            { "new", "नेवारी" },
            { "nia", "नियास" },
            { "niu", "नायान" },
            { "nmg", "क्वासीयो" },
            { "nnh", "गियेम्बून" },
            { "nog", "नोगाय" },
            { "nqo", metaValue_nqo },
            { "nso", "उत्तरी सोथो" },
            { "nus", "न्युयर" },
            { "nyn", "नानकोले" },
            { "ojb", "वायव्य ओजिब्वे" },
            { "ojc", "मध्य ओजिब्वे" },
            { "ojs", "ओजि-क्री" },
            { "ojw", "पश्चिमी ओजिब्वे" },
            { "oka", "ओकानागान" },
            { "pag", "पांगासियनान" },
            { "pam", "पांपान्गा" },
            { "pap", "पाप्यामेंटो" },
            { "pau", "पालावान" },
            { "pcm", "नायजिरियन पिजिन" },
            { "pis", "पिजिन" },
            { "pqm", "मालिसीत-पास्सामाखिडी" },
            { "prg", "प्रुसियन" },
            { "quc", "किचे" },
            { "raj", "राजस्थानी" },
            { "rap", "रापान्यु" },
            { "rar", "रारोटोंगान" },
            { "rhg", "रोहिंग्या" },
            { "rof", "रोम्बो" },
            { "rup", "आरोमेनियन" },
            { "rwk", "रवा" },
            { "sad", "संडावे" },
            { "sah", "साखा" },
            { "saq", "साम्बुरू" },
            { "sat", "संथाली" },
            { "sba", "गांबे" },
            { "sbp", "सांगू" },
            { "scn", "सिसिलियान" },
            { "sco", "स्कॉट्स" },
            { "seh", "सेना" },
            { "ses", "कोयराबोरो सेन्नी" },
            { "shi", "ताछेल्हीट" },
            { "shn", "शान" },
            { "slh", "दक्षिणी लशूतसीड" },
            { "sma", "दक्षिणी सामी" },
            { "smj", "लुले सामी" },
            { "smn", "ईनारी सामी" },
            { "sms", "स्कोल्ट सामी" },
            { "snk", "सोनिके" },
            { "srn", "श्रानन टोंगो" },
            { "ssy", "साहो" },
            { "str", "स्ट्रैट सालिश" },
            { "suk", "सुकुमा" },
            { "swb", "कोमोरियन" },
            { "syr", "सिरियाक" },
            { "szl", "सिलेसियान" },
            { "tce", "दक्षिणी तुत्चोने" },
            { "tem", "तिम्ने" },
            { "teo", "तेसो" },
            { "tet", "तेतम" },
            { "tgx", "टॅगिश" },
            { "tht", "ताहल्तान" },
            { "tig", "टिग्रे" },
            { "tlh", "क्लिंगॉन" },
            { "tli", "लिंगिट" },
            { "tok", "तोकी पोना" },
            { "tpi", "तोक पिसीन" },
            { "trv", "तारोको" },
            { "ttm", "उत्तरीय तुत्चोने" },
            { "tum", "तुंबुका" },
            { "tvl", metaValue_TV },
            { "twq", "तासावाक" },
            { "tyv", "तुविनियन" },
            { "tzm", "केंद्रीय अटलास तामाझायट" },
            { "udm", "उडमुर्त" },
            { "umb", "उंबुंडु" },
            { "und", "अज्ञात भास" },
            { "vai", "वाई" },
            { "vec", "वेनेशियन" },
            { "vmw", "माखुवा" },
            { "vun", "वुंजो" },
            { "wae", "वाल्सर" },
            { "wal", "वोलायटा" },
            { "war", "वरय" },
            { "wuu", "व्हु चिनी" },
            { "xal", "कालमायक" },
            { "xnr", "कांग्री" },
            { "xog", "सोगा" },
            { "yav", "यांगबेन" },
            { "ybb", "येम्बा" },
            { "yrl", "न्हीनगातु" },
            { "yue", "कॅण्टोनीस" },
            { "zgh", "प्रमाणीत मॉरोक्कन तमाझीट" },
            { "zun", "झुनी" },
            { "zxx", "भाशीक मजकूर ना" },
            { "zza", "झाझा" },
            { "Adlm", "अडलाम" },
            { "Arab", "आरबी" },
            { "Aran", "नास्तालिक" },
            { "Armn", metaValue_hy },
            { "Beng", "बांग्ला" },
            { "Bopo", "बोपोमोफो" },
            { "Brai", "ब्रेल" },
            { "Cakm", metaValue_ccp },
            { "Cans", "संयुक्त कॅनडियन ॲबओरीजिनल सिलेबिक" },
            { "Cher", "चेरोकी" },
            { "Cyrl", "सिरिलिक" },
            { "Deva", "देवनागरी" },
            { "Ethi", "इथियोपीक" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "गुरूमुखी" },
            { "Hanb", "बोपोफोमो सयत हान" },
            { "Hang", "हंगूल" },
            { "Hani", "हान" },
            { "Hans", "सोंपी" },
            { "Hant", "पारंपारीक" },
            { "Hebr", "हिब्रू" },
            { "Hira", "हिरागना" },
            { "Hrkt", "जपानी अक्षरमाळ" },
            { "Jamo", "जामो" },
            { "Jpan", metaValue_ja },
            { "Kana", "कटाकाना" },
            { "Khmr", "कंबोडियन" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", "रोमी" },
            { "Mlym", metaValue_ml },
            { "Mong", "मोंगोलियन" },
            { "Mtei", "मेयतेई मायेक" },
            { "Mymr", metaValue_MM },
            { "Nkoo", metaValue_nqo },
            { "Olck", "ओल चिकी" },
            { "Orya", "ओडिया" },
            { "Rohg", "हानिफी" },
            { "Sinh", "सिंहाला" },
            { "Sund", "सुंदानीज" },
            { "Syrc", "सिरीयाक" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "टिफीनाघ" },
            { "Thaa", "थाणा" },
            { "Thai", metaValue_th },
            { "Tibt", "तिबेटन" },
            { "Vaii", "वाइ" },
            { "Yiii", "यी" },
            { "Zmth", "गणिताची चिन्नां" },
            { "Zsye", "ईमोजी" },
            { "Zsym", "चिन्नां" },
            { "Zxxx", "अलिखीत" },
            { "Zyyy", "सामान्य" },
            { "Zzzz", "अज्ञात लिपी" },
            { "de_AT", "ऑस्ट्रियन जर्मन" },
            { "de_CH", "स्विझ हाय जर्मन" },
            { "en_AU", "ऑस्ट्रेलियन इंग्लीश" },
            { "en_CA", "कॅनडियन इंग्लीश" },
            { "en_GB", "ब्रिटीश इंग्लीश" },
            { "en_US", "अमेरिकन इंग्लीश" },
            { "es_ES", "युरोपियन स्पॅनीश" },
            { "es_MX", "मॅक्सिकन स्पॅनीश" },
            { "fa_AF", "दारी" },
            { "fr_CA", "कॅनडियन फ्रेंच" },
            { "fr_CH", "स्विझ फ्रेंच" },
            { "nl_BE", "फ्लेमिश" },
            { "pt_BR", "ब्राझिलियन पोर्तुगीज" },
            { "pt_PT", "युरोपियन पोर्तुगीज" },
            { "ro_MD", "मोल्डावियन्" },
            { "sw_CD", "काँगो स्वाहिली" },
            { "ar_001", "आधुनिक प्रमाणित अरबी" },
            { "es_419", "लातीं अमेरिकन स्पॅनीश" },
            { "key.ca", "दिनदर्शिका" },
            { "key.cf", "चलनाचें स्वरूप" },
            { "key.co", "वर्गवारी क्रम" },
            { "key.cu", "चलन" },
            { "key.em", "इमोजी सादरीकरण" },
            { "key.hc", "वराचें चक्र (12 वि 24)" },
            { "key.lb", "रेग खंड करपाची शैली" },
            { "key.lw", "शब्दां भितर ओळी मोडप" },
            { "key.ms", "मापन प्रणाली" },
            { "key.nu", "संख्या" },
            { "key.ss", "वाक्य विराम उपरांत Abbr." },
            { "hi_Latn", "हिन्दी (रोमी)" },
            { "zh_Hans", "सोंपी चिनी" },
            { "zh_Hant", "पारंपारीक चिनी" },
            { "type.ca.roc", "मिंगुआ दिनदर्शिका (अणकाराची कुरू: जाका चिनी दिनदर्शिकेचें प्रजासत्ताक\", \"रिपब्लिकन दिनदर्शिका\")" },
            { "type.hc.h11", "12 वरांची यंत्रणा (0–11)" },
            { "type.hc.h12", "12 वरांची यंत्रणा (1–12)" },
            { "type.hc.h23", "24 वरांची यंत्रणा (0–23)" },
            { "type.hc.h24", "24 वरांची यंत्रणा (1–24)" },
            { "type.nu.arab", "अरेबिक-भारतीय अंक" },
            { "type.nu.armn", "आर्मेनियन संख्या" },
            { "type.nu.beng", "बांग्ला अंक" },
            { "type.nu.cakm", "चाक्मा अंक" },
            { "type.nu.deva", "देवनागरी अंक" },
            { "type.nu.ethi", "इथियोपिक संख्या" },
            { "type.nu.geor", "जॉर्जियन संख्या" },
            { "type.nu.grek", "ग्रीक संख्या" },
            { "type.nu.gujr", "गुजराती अंक" },
            { "type.nu.guru", "गुरुमुखी अंक" },
            { "type.nu.hans", "सोंपी केल्ली चिनी संख्या" },
            { "type.nu.hant", "पारंपारीक चिनी संख्या" },
            { "type.nu.hebr", "हिब्रू संख्या" },
            { "type.nu.java", "जावानीज अंक" },
            { "type.nu.jpan", "जपानी संख्या" },
            { "type.nu.khmr", "कंबोडियन अंक" },
            { "type.nu.knda", "कन्नड अंक" },
            { "type.nu.laoo", "लाओ अंक" },
            { "type.nu.latn", "अस्तंतीय अंक" },
            { "type.nu.mlym", "मल्याळम अंक" },
            { "type.nu.mtei", "मीतेई मायेक अंक" },
            { "type.nu.mymr", "म्यानमार अंक" },
            { "type.nu.olck", "ओल चिकी अंक" },
            { "type.nu.orya", "ओडिया अंक" },
            { "type.nu.taml", "पारंपारीक तमिळ संख्या" },
            { "type.nu.telu", "तेलुगू अंक" },
            { "type.nu.thai", "थाय अंक" },
            { "type.nu.tibt", "तिबेतियन अंक" },
            { "type.nu.vaii", "वाई अंक" },
            { "type.ca.dangi", "डांगी दिनदर्शिका" },
            { "type.co.ducet", "डिफॉल्ट युनिकोड वर्गवारी क्रम" },
            { "type.lb.loose", "सुटी रेग खंड शैली" },
            { "type.nu.roman", "रोमन संख्या" },
            { "type.ca.coptic", "कॉप्टिक दिनदर्शिका" },
            { "type.ca.hebrew", "हिब्रू दिनदर्शिका" },
            { "type.ca.indian", "भारतीय राष्ट्रीय दिनदर्शिका" },
            { "type.co.search", "सामान्य-उद्देशान केल्लो सोद" },
            { "type.lb.normal", "सामान्य रेग खंड शैली" },
            { "type.lb.strict", "सक्तीची रेग खंड शैली" },
            { "type.ms.metric", "मॅट्रीक प्रणाली" },
            { "type.ca.chinese", "चीनी दिनदर्शिका" },
            { "type.ca.islamic", "ईस्लामीक दिनदर्शिका" },
            { "type.ca.iso8601", "आयएसओ-8601 दिनदर्शिका" },
            { "type.ca.persian", "पर्शियन दिनदर्शिका" },
            { "type.cf.account", "लेखा चलन स्वरूप" },
            { "type.nu.arabext", "विस्तारीत अरेबीक-भारतीय अंक" },
            { "type.nu.armnlow", "आर्मेनियन लोवरकेस संख्या" },
            { "type.nu.greklow", "ग्रीक लोवरकेस संख्या" },
            { "type.nu.hanidec", "चिनी दशांश संख्या" },
            { "type.nu.hansfin", "सोंपी केल्ली चिनी महसूल संख्या" },
            { "type.nu.hantfin", "पारंपारीक चिनी महसूल संख्या" },
            { "type.nu.jpanfin", "जपानी महसूल संख्या" },
            { "type.nu.tamldec", "तमिळ अंक" },
            { "type.ca.buddhist", "बौद्ध दिनदर्शिका" },
            { "type.ca.ethiopic", "इथियोपिक दिनदर्शिका" },
            { "type.ca.japanese", "जपानी दिनदर्शिका" },
            { "type.cf.standard", "प्रमाणित चलन स्वरुप" },
            { "type.co.standard", "प्रमाणित वर्गवारी क्रम" },
            { "type.ms.uksystem", "भव्य मापन प्रणाली" },
            { "type.ms.ussystem", "युएस मापन प्रणाली" },
            { "type.nu.fullwide", "पूर्ण-रुंदी अंक" },
            { "type.nu.romanlow", "रोमन लोवरकेस संख्या" },
            { "type.ca.gregorian", "ग्रेगोरियन कॅलॅण्डर" },
            { "type.ca.islamic-civil", "ईस्लामीक दिनदर्शिका (कोश्टक, नागरी शक)" },
            { "type.ca.islamic-umalqura", "ईस्लामीक दिनदर्शिका (उम अल-कुरा)" },
            { "type.ca.ethiopic-amete-alem", "इथियोपिक अमिटी आलेम दिनदर्शिका" },
        };
        return data;
    }
}
