/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf;

public final class PerfVersion {
    private static final String DELIMITER = ".";
    private int major;
    private int minor;
    private int micro;
    private String qualifier;

    public PerfVersion(String version) {
        String escapedVersion = version.replace('-', '.');
        String[] splitVersion = escapedVersion.split("\\.", 4);
        if (splitVersion[0] != null) {
            this.major = Integer.valueOf(splitVersion[0]);
        }
        if (splitVersion[1] != null) {
            this.minor = Integer.valueOf(splitVersion[1]);
        }
        if (splitVersion[2] != null) {
            this.micro = Integer.valueOf(splitVersion[2]);
        }
        if (splitVersion.length > 3 && splitVersion[3] != null) {
            this.qualifier = splitVersion[3];
        }
    }

    public PerfVersion(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public boolean isNewer(PerfVersion other) {
        if (this.major != other.major) {
            return this.major > other.major;
        }
        if (this.minor != other.minor) {
            return this.minor > other.minor;
        }
        return this.micro > other.micro;
    }

    public String toString() {
        return this.major + DELIMITER + this.minor + DELIMITER + this.micro + DELIMITER + this.qualifier;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        if (this.qualifier == null) {
            return "";
        }
        return this.qualifier;
    }
}

