/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.ICompletable;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.ProbevarNodeData;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;

public final class STPMetadataSingleton {
    public static TreeNode[] NO_MATCHES = new TreeNode[0];
    private static STPMetadataSingleton instance = null;

    private STPMetadataSingleton() {
    }

    public static STPMetadataSingleton getInstance() {
        if (instance == null) {
            instance = new STPMetadataSingleton();
        }
        return instance;
    }

    public TreeNode[] getFunctionCompletions(String prefix) {
        TreeNode node = TapsetLibrary.getFunctions();
        return this.getMatchingChildren(node, prefix);
    }

    public TreeNode[] getProbeCompletions(String prefix) {
        LinkedList<TreeNode> matches = new LinkedList<TreeNode>();
        String groupName = this.extractProbeGroupName(prefix);
        for (TreeNode node : TapsetLibrary.getProbeCategoryNodes()) {
            TreeNode groupNode = node.getChildByName(groupName);
            if (groupNode != null) {
                node = groupNode;
            }
            matches.addAll(Arrays.asList(this.getMatchingChildren(node, prefix)));
        }
        return !matches.isEmpty() ? matches.toArray(new TreeNode[matches.size()]) : NO_MATCHES;
    }

    public TreeNode[] getProbeVariableCompletions(String probe, String prefix) {
        TreeNode node = this.getProbeAlias(probe);
        return node != null ? this.getMatchingChildren(node, prefix) : NO_MATCHES;
    }

    public boolean isVariableInProbe(String probe, String variable) {
        TreeNode node = this.getProbeAlias(probe);
        if (node == null) {
            return false;
        }
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeNode child = node.getChildAt(i);
            String nodeVar = ((ProbevarNodeData)child.getData()).getCompletionText();
            if (!nodeVar.equals(variable)) continue;
            return true;
        }
        return false;
    }

    public TreeNode getProbeAlias(String probe) {
        TreeNode node = TapsetLibrary.getProbeAliases();
        if (node == null) {
            return null;
        }
        if ((node = node.getChildByName(this.extractProbeGroupName(probe))) == null) {
            return null;
        }
        return node.getChildByName(probe);
    }

    private TreeNode[] getMatchingChildren(TreeNode node, String prefix) {
        ArrayList<TreeNode> matches = new ArrayList<TreeNode>();
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeNode childNode = node.getChildAt(i);
            String childName = childNode.getData() instanceof ICompletable ? ((ICompletable)childNode.getData()).getCompletionText() : childNode.toString();
            if (!childName.startsWith(prefix)) continue;
            matches.add(childNode);
        }
        return matches.toArray(new TreeNode[0]);
    }

    private String extractProbeGroupName(String probeName) {
        int dotIndex = probeName.indexOf(46);
        int parenIndex = probeName.indexOf(40);
        if (dotIndex > 0 && parenIndex > 0) {
            return probeName.substring(0, Math.min(dotIndex, parenIndex));
        }
        if (dotIndex > 0) {
            return probeName.substring(0, dotIndex);
        }
        if (parenIndex > 0) {
            return probeName.substring(0, parenIndex);
        }
        return probeName;
    }
}

