import { TextDocument } from 'vscode-languageserver-textdocument';
import { Position, CompletionItem } from 'vscode-languageserver-types';
import { DockerRegistryClient } from './dockerRegistryClient';
import { CompletionItemCapabilities } from './main';
export declare class DockerAssist {
    private snippetSupport;
    private deprecatedSupport;
    private supportedTags;
    private document;
    /**
     * The client for communicating with a Docker registry.
     */
    private dockerRegistryClient;
    /**
     * Creates a content assist processor for suggesting completion items related to a Dockerfile.
     *
     * @param document the text document to provide suggestions for
     * @param dockerRegistryClient the client for communicating with a Docker registry
     * @param completionItemCapabilities the capabilities that should be set for the returned items
     */
    constructor(document: TextDocument, dockerRegistryClient: DockerRegistryClient, completionItemCapabilities: CompletionItemCapabilities);
    computeProposals(position: Position): CompletionItem[] | PromiseLike<CompletionItem[]>;
    createProposals(keywords: string[], previousWord: string, prefixLength: number, offset: number): CompletionItem[];
    private createAddProposals;
    private createOtherFlagProposals;
    private createFlagProposals;
    private createCopyProposals;
    private createTargetFolderProposals;
    private createWorkdirPathProposals;
    private createFromProposals;
    private createHealthcheckProposals;
    /**
    * Walks back in the text buffer to calculate the true prefix of the
    * current text caret offset. This function will handle the
    * Dockerfile escape characters to skip escaped newline characters
    * where applicable.
    *
    * @param buffer the content of the opened file
    * @param offset the current text caret's offset
    * @param escapeCharacter the escape character defined in this Dockerfile
    */
    private calculateTruePrefix;
    createSingleProposals(keyword: string, prefixLength: number, offset: number): CompletionItem;
    createADD(prefixLength: number, offset: number, markdown: string): CompletionItem;
    private createARG;
    createARG_NameOnly(prefixLength: number, offset: number): CompletionItem;
    createARG_DefaultValue(prefixLength: number, offset: number): CompletionItem;
    createCMD(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createCOPY(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createENTRYPOINT(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createENV(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createEXPOSE(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createFROM(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createHEALTHCHECK_CMD(prefixLength: number, offset: number): CompletionItem;
    private createHEALTHCHECK_CMD_Subcommand;
    private createADD_FlagChown;
    private createCOPY_FlagChown;
    private createCOPY_FlagFrom;
    private createFROM_FlagPlatform;
    private createHEALTHCHECK_FlagInterval;
    private createHEALTHCHECK_FlagRetries;
    private createHEALTHCHECK_FlagStartInterval;
    private createHEALTHCHECK_FlagStartPeriod;
    private createHEALTHCHECK_FlagTimeout;
    createHEALTHCHECK_NONE(prefixLength: number, offset: number): CompletionItem;
    private createHEALTHCHECK_NONE_Subcommand;
    createLABEL(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createMAINTAINER(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createONBUILD(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createRUN(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createSHELL(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createSTOPSIGNAL(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createUSER(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createVOLUME(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createWORKDIR(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createEscape(prefixLength: number, offset: number, markdown: string): CompletionItem;
    private createSyntax;
    createKeywordCompletionItem(keyword: string, label: string, prefixLength: number, offset: number, insertText: string, markdown: string): CompletionItem;
    private createPlainTextCompletionItem;
    private createFlagCompletionItem;
    private createSourceImageCompletionItem;
    private createVariableCompletionItem;
    private createTextEdit;
}
