import { DockerfileLanguageService, ILogger, Capabilities, FormatterSettings } from "./main";
import { Position, CompletionItem, Range, CodeActionContext, Command, TextDocumentIdentifier, SemanticTokens, Location, DocumentHighlight, SymbolInformation, SignatureHelp, DocumentLink, TextEdit, Hover, Diagnostic, FoldingRange } from "vscode-languageserver-types";
import * as DockerfileUtils from 'dockerfile-utils';
export declare class LanguageService implements DockerfileLanguageService {
    private markdownDocumentation;
    private plainTextDocumentation;
    private logger;
    private hoverContentFormat;
    private completionItemCapabilities;
    private foldingRangeLineFoldingOnly;
    private foldingRangeLimit;
    setLogger(logger: ILogger): void;
    setCapabilities(capabilities: Capabilities): void;
    computeCodeActions(textDocument: TextDocumentIdentifier, range: Range, context: CodeActionContext): Command[];
    computeLinks(content: string): DocumentLink[];
    resolveLink(link: DocumentLink): DocumentLink;
    computeCommandEdits(content: string, command: string, args: any[]): TextEdit[];
    computeCompletionItems(content: string, position: Position): CompletionItem[] | PromiseLike<CompletionItem[]>;
    resolveCompletionItem(item: CompletionItem): CompletionItem;
    computeDefinition(textDocument: TextDocumentIdentifier, content: string, position: Position): Location;
    computeFoldingRanges(content: string): FoldingRange[];
    computeHighlightRanges(content: string, position: Position): DocumentHighlight[];
    computeHover(content: string, position: Position): Hover | null;
    computeSymbols(textDocument: TextDocumentIdentifier, content: string): SymbolInformation[];
    computeSignatureHelp(content: string, position: Position): SignatureHelp;
    computeRename(textDocument: TextDocumentIdentifier, content: string, position: Position, newName: string): TextEdit[];
    prepareRename(content: string, position: Position): Range | null;
    computeSemanticTokens(content: string): SemanticTokens;
    validate(content: string, settings?: DockerfileUtils.ValidatorSettings): Diagnostic[];
    format(content: string, settings: FormatterSettings): TextEdit[];
    formatRange(content: string, range: Range, settings: FormatterSettings): TextEdit[];
    formatOnType(content: string, position: Position, ch: string, settings: FormatterSettings): TextEdit[];
}
