/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.linuxtools.docker.core.EnumDockerStatus;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerPortMapping;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerContentProvider;
import org.eclipse.linuxtools.internal.docker.ui.views.LabelProviderUtils;
import org.eclipse.swt.graphics.Image;

public class DockerExplorerLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
ILabelProvider {
    private Image OPEN_CONNECTION_IMAGE = SWTImagesFactory.DESC_REPOSITORY_MIDDLE.createImage();
    private Image UNOPEN_CONNECTION_IMAGE = SWTImagesFactory.DESC_REPOSITORY_MIDDLED.createImage();
    private Image CATEGORY_IMAGE = SWTImagesFactory.DESC_DB_GROUP.createImage();
    private Image IMAGE_IMAGE = SWTImagesFactory.DESC_IMAGE.createImage();
    private Image STARTED_CONTAINER_IMAGE = SWTImagesFactory.DESC_CONTAINER_STARTED.createImage();
    private Image PAUSED_CONTAINER_IMAGE = SWTImagesFactory.DESC_CONTAINER_PAUSED.createImage();
    private Image STOPPED_CONTAINER_IMAGE = SWTImagesFactory.DESC_CONTAINER_STOPPED.createImage();
    private Image CONTAINER_LINK_IMAGE = SWTImagesFactory.DESC_CONTAINER_LINK.createImage();
    private Image CONTAINER_VOLUME_IMAGE = SWTImagesFactory.DESC_CONTAINER_VOLUME.createImage();
    private Image CONTAINER_PORT_IMAGE = SWTImagesFactory.DESC_CONTAINER_PORT.createImage();
    private Image LOADING_IMAGE = SWTImagesFactory.DESC_SYSTEM_PROCESS.createImage();

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.OPEN_CONNECTION_IMAGE.dispose();
        this.UNOPEN_CONNECTION_IMAGE.dispose();
        this.CATEGORY_IMAGE.dispose();
        this.IMAGE_IMAGE.dispose();
        this.STARTED_CONTAINER_IMAGE.dispose();
        this.PAUSED_CONTAINER_IMAGE.dispose();
        this.STOPPED_CONTAINER_IMAGE.dispose();
        this.CONTAINER_LINK_IMAGE.dispose();
        this.CONTAINER_VOLUME_IMAGE.dispose();
        this.CONTAINER_PORT_IMAGE.dispose();
        this.LOADING_IMAGE.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        if (element instanceof IDockerConnection) {
            if (((IDockerConnection)element).isOpen()) {
                return this.OPEN_CONNECTION_IMAGE;
            }
            return this.UNOPEN_CONNECTION_IMAGE;
        }
        if (element instanceof DockerExplorerContentProvider.DockerImagesCategory) {
            return this.CATEGORY_IMAGE;
        }
        if (element instanceof DockerExplorerContentProvider.DockerContainersCategory) {
            return this.CATEGORY_IMAGE;
        }
        if (element instanceof IDockerImage) {
            return this.IMAGE_IMAGE;
        }
        if (element instanceof IDockerContainer) {
            IDockerContainer container = (IDockerContainer)element;
            EnumDockerStatus containerStatus = EnumDockerStatus.fromStatusMessage((String)container.status());
            if (containerStatus == EnumDockerStatus.RUNNING) {
                return this.STARTED_CONTAINER_IMAGE;
            }
            if (containerStatus == EnumDockerStatus.PAUSED) {
                return this.PAUSED_CONTAINER_IMAGE;
            }
            return this.STOPPED_CONTAINER_IMAGE;
        }
        if (element instanceof DockerExplorerContentProvider.DockerContainerLinksCategory || element instanceof DockerExplorerContentProvider.DockerContainerLink) {
            return this.CONTAINER_LINK_IMAGE;
        }
        if (element instanceof DockerExplorerContentProvider.DockerContainerVolumesCategory || element instanceof DockerExplorerContentProvider.DockerContainerVolume) {
            return this.CONTAINER_VOLUME_IMAGE;
        }
        if (element instanceof DockerExplorerContentProvider.DockerContainerPortMappingsCategory || element instanceof IDockerPortMapping) {
            return this.CONTAINER_PORT_IMAGE;
        }
        if (element instanceof DockerExplorerContentProvider.LoadingStub) {
            return this.LOADING_IMAGE;
        }
        return null;
    }

    public String getText(Object element) {
        StyledString styledText = this.getStyledText(element);
        if (styledText != null) {
            return styledText.getString();
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        return LabelProviderUtils.getStyledText(element);
    }
}

