/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.NodeStatus;

final class ImmutableNodeStatus
implements NodeStatus {
    private final String state;
    @Nullable
    private final String addr;

    private ImmutableNodeStatus(String state, @Nullable String addr) {
        this.state = state;
        this.addr = addr;
    }

    @Override
    @JsonProperty(value="State")
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty(value="Addr")
    @Nullable
    public String addr() {
        return this.addr;
    }

    public final ImmutableNodeStatus withState(String value) {
        String newValue = Objects.requireNonNull(value, "state");
        if (this.state.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeStatus(newValue, this.addr);
    }

    public final ImmutableNodeStatus withAddr(@Nullable String value) {
        if (Objects.equals(this.addr, value)) {
            return this;
        }
        return new ImmutableNodeStatus(this.state, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeStatus && this.equalsByValue((ImmutableNodeStatus)another);
    }

    private boolean equalsByValue(ImmutableNodeStatus another) {
        return this.state.equals(another.state) && Objects.equals(this.addr, another.addr);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + Objects.hashCode(this.addr);
        return h;
    }

    public String toString() {
        return "NodeStatus{state=" + this.state + ", addr=" + this.addr + "}";
    }

    public static ImmutableNodeStatus copyOf(NodeStatus instance) {
        if (instance instanceof ImmutableNodeStatus) {
            return (ImmutableNodeStatus)instance;
        }
        return ImmutableNodeStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_STATE = 1L;
        private long initBits = 1L;
        private String state;
        private String addr;

        private Builder() {
        }

        public final Builder from(NodeStatus instance) {
            Objects.requireNonNull(instance, "instance");
            this.state(instance.state());
            String addrValue = instance.addr();
            if (addrValue != null) {
                this.addr(addrValue);
            }
            return this;
        }

        @JsonProperty(value="State")
        public final Builder state(String state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Addr")
        public final Builder addr(@Nullable String addr) {
            this.addr = addr;
            return this;
        }

        public ImmutableNodeStatus build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeStatus(this.state, this.addr);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("state");
            }
            return "Cannot build NodeStatus, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

