/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class SemiInteractiveCrossMinProcessor
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Semi-Interactive Crossing Minimization Processor", 1.0f);
        for (Layer l : layeredGraph) {
            ArrayList nodes = Lists.newArrayList((Iterable)Iterables.filter(l.getNodes(), n -> n.getType() == LNode.NodeType.NORMAL));
            if (nodes.size() < 2) continue;
            Collections.sort(nodes, (n1, n2) -> {
                KVector origPos1 = (KVector)n1.getProperty(LayeredOptions.POSITION);
                KVector origPos2 = (KVector)n2.getProperty(LayeredOptions.POSITION);
                if (origPos1 != null && origPos2 != null) {
                    return Double.compare(origPos1.y, origPos2.y);
                }
                return 0;
            });
            assert (nodes.size() >= 2);
            Iterator nodeIt = nodes.iterator();
            LNode prev = (LNode)((Object)nodeIt.next());
            while (nodeIt.hasNext()) {
                LNode cur = (LNode)((Object)nodeIt.next());
                ((List)prev.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS)).add(cur);
                prev = cur;
            }
        }
        progressMonitor.done();
    }
}

