/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.qvto.util.internal;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.InternalTransformationExecutor;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceTransformatorExecutor
extends InternalTransformationExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceTransformatorExecutor.class);
    private URI itsTraceURI = null;

    public TraceTransformatorExecutor(URI uri) {
        super(uri);
    }

    public TraceTransformatorExecutor(URI uri, EPackage.Registry registry) {
        super(uri, registry);
    }

    public void setTraceURI(URI uri) {
        this.itsTraceURI = uri;
    }

    protected void handleExecutionTraces(Trace traces) {
        if (this.itsTraceURI == null) {
            return;
        }
        ResourceSet resourceSet = this.getResourceSet();
        Resource resource = resourceSet.createResource(this.itsTraceURI);
        resource.getContents().add((Object)traces);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("PROCESS_DANGLING_HREF", "DISCARD");
        LOGGER.debug("Saving trace file: {}", (Object)this.itsTraceURI);
        try {
            resource.save(options);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save trace file: " + e.getMessage(), (Throwable)e);
        }
    }
}

