/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.declwrap;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.parser.ast.declarations.AConstDecl;
import org.eclipse.escet.cif.parser.ast.declarations.AConstant;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifAnnotationsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypesTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class ConstDeclWrap
extends DeclWrap<Constant> {
    private final AConstDecl astDecls;
    private final AConstant astDecl;

    public ConstDeclWrap(CifTypeChecker tchecker, ParentScope<?> scope, AConstDecl astDecls, AConstant astDecl, Constant mmDecl) {
        super(tchecker, scope, mmDecl);
        this.astDecls = astDecls;
        this.astDecl = astDecl;
    }

    @Override
    public String getName() {
        return ((Constant)this.mmDecl).getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)this.mmDecl);
    }

    @Override
    public void tcheckForUseImpl() {
        this.checkName();
        this.tchecker.addToCycle(this);
        try {
            CifType type = CifTypesTypeChecker.transCifType(this.astDecls.type, this.scope, this.tchecker);
            CifType ntype = CifTypeUtils.normalizeType((CifType)type);
            Expression value = CifExprsTypeChecker.transExpression(this.astDecl.value, type, this.scope, null, this.tchecker);
            CifType vtype = value.getType();
            CifType nvtype = CifTypeUtils.normalizeType((CifType)vtype);
            ((Constant)this.mmDecl).setValue(value);
            if (CifTypeUtils.hasComponentLikeType((CifType)type)) {
                this.tchecker.addProblem(ErrMsg.DECL_INVALID_TYPE, type.getPosition(), "Constant", this.getAbsName(), CifTextUtils.typeToStr((CifType)type));
                throw new SemanticException();
            }
            if (ntype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ntype))) {
                if (!(nvtype instanceof IntType)) {
                    this.tchecker.addProblem(ErrMsg.CONST_TYPE_VALUE_MISMATCH, ((Constant)this.mmDecl).getPosition(), CifTextUtils.typeToStr((CifType)vtype), this.getAbsName(), CifTextUtils.typeToStr((CifType)type));
                    throw new SemanticException();
                }
                ((Constant)this.mmDecl).setType((CifType)EMFHelper.deepclone((EObject)vtype));
            } else {
                if (!CifTypeUtils.checkTypeCompat((CifType)type, (CifType)vtype, (RangeCompat)RangeCompat.CONTAINED)) {
                    this.tchecker.addProblem(ErrMsg.CONST_TYPE_VALUE_MISMATCH, ((Constant)this.mmDecl).getPosition(), CifTextUtils.typeToStr((CifType)vtype), this.getAbsName(), CifTextUtils.typeToStr((CifType)type));
                    throw new SemanticException();
                }
                ((Constant)this.mmDecl).setType(type);
            }
            CifExprsTypeChecker.checkStaticEvaluable(value, this.tchecker);
            try {
                CifEvalUtils.eval((Expression)value, (boolean)false);
            }
            catch (CifEvalException e) {
                this.tchecker.addProblem(ErrMsg.EVAL_FAILURE, e.expr.getPosition(), e.getMessage());
                throw new SemanticException();
            }
        }
        finally {
            this.tchecker.removeFromCycle(this);
        }
        this.status = CheckStatus.USE;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
        if (this.isCheckedFull()) {
            return;
        }
        List<Annotation> annos = CifAnnotationsTypeChecker.transAnnotations(this.astDecls.annotations, this.scope, this.tchecker);
        ((Constant)this.mmDecl).getAnnotations().addAll(annos);
        this.status = CheckStatus.FULL;
    }
}

