/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.postchk;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProblemReporter;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProvider;
import org.eclipse.escet.cif.typechecker.annotations.DoNothingAnnotationProvider;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class CifAnnotationsPostChecker
extends CifWalker {
    private final CifPostCheckEnv env;
    private final ProblemReporter reporter = new ProblemReporter();
    private final Map<String, AnnotationProvider> annotationProviders = Maps.map();

    public CifAnnotationsPostChecker(CifPostCheckEnv env) {
        this.env = env;
    }

    public void check(Specification spec) {
        Assert.check((!CifScopeUtils.hasCompDefInst((Group)spec) ? 1 : 0) != 0, (Object)"Can't post check annotations on spec with comp def/inst.");
        this.walkSpecification(spec);
        for (AnnotationProvider provider : this.annotationProviders.values()) {
            provider.checkGlobal(spec, this.reporter);
        }
    }

    protected void preprocessAnnotatedObject(AnnotatedObject annotatedObj) {
        for (Annotation annotation : annotatedObj.getAnnotations()) {
            String annotationName = annotation.getName();
            AnnotationProvider provider = this.annotationProviders.get(annotationName);
            if (provider == null) {
                provider = this.getProvider(annotationName, annotation.getPosition());
                if (provider == null) {
                    provider = new DoNothingAnnotationProvider(annotationName);
                }
                this.annotationProviders.put(annotationName, provider);
            }
            provider.checkAnnotation(annotatedObj, annotation, this.reporter);
        }
    }

    private AnnotationProvider getProvider(String annotationName, Position position) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        String extensionPointId = "org.eclipse.escet.cif.annotations";
        IConfigurationElement[] extensions = registry.getConfigurationElementsFor(extensionPointId);
        List providers = Lists.listc((int)1);
        boolean anyIssue = false;
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            block22: {
                IConfigurationElement extension = iConfigurationElementArray[n2];
                if ("provider".equals(extension.getName()) && annotationName.equals(extension.getAttribute("annotationName"))) {
                    String contributorName = extension.getContributor().getName();
                    String pluginName = extension.getAttribute("plugin");
                    if (pluginName == null) {
                        anyIssue = true;
                        this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider does not specify a plugin (contributed by \"%s\").", (Object[])new Object[]{contributorName}));
                    } else {
                        String className = extension.getAttribute("class");
                        if (className == null) {
                            anyIssue = true;
                            this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider does not specify a class (contributed by \"%s\").", (Object[])new Object[]{contributorName}));
                        } else {
                            Bundle bundle = Platform.getBundle((String)pluginName);
                            if (bundle == null) {
                                anyIssue = true;
                                this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider plugin \"%s\" not found (contributed by \"%s\").", (Object[])new Object[]{pluginName, contributorName}));
                            } else {
                                boolean stateOk;
                                int state = bundle.getState();
                                boolean bl = stateOk = state == 4 || state == 8 || state == 32;
                                if (!stateOk) {
                                    anyIssue = true;
                                    this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider plugin \"%s\" is in a wrong state (state %d, contributed by \"%s\").", (Object[])new Object[]{pluginName, state, contributorName}));
                                } else {
                                    BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                                    if (bundleWiring == null) {
                                        anyIssue = true;
                                        this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider plugin \"%s\" has no bundle wiring (contributed by \"%s\").", (Object[])new Object[]{pluginName, contributorName}));
                                    } else {
                                        ClassLoader classLoader = bundleWiring.getClassLoader();
                                        if (classLoader == null) {
                                            anyIssue = true;
                                            this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider plugin \"%s\" has no class loader (contributed by \"%s\").", (Object[])new Object[]{pluginName, contributorName}));
                                        } else {
                                            AnnotationProvider provider;
                                            Class<?> cls;
                                            try {
                                                cls = classLoader.loadClass(className);
                                            }
                                            catch (ClassNotFoundException e) {
                                                anyIssue = true;
                                                this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider plugin \"%s\" is missing annotation provider class \"%s\" (contributed by \"%s\").", (Object[])new Object[]{pluginName, className, contributorName}));
                                                break block22;
                                            }
                                            try {
                                                provider = (AnnotationProvider)cls.getDeclaredConstructor(String.class).newInstance(annotationName);
                                            }
                                            catch (ReflectiveOperationException e) {
                                                anyIssue = true;
                                                this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider plugin \"%s\" has an annotation provider class \"%s\" that could not be instantiated (contributed by \"%s\").", (Object[])new Object[]{pluginName, className, contributorName}));
                                                break block22;
                                            }
                                            providers.add(provider);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        if (anyIssue) {
            return null;
        }
        if (providers.size() == 1) {
            return (AnnotationProvider)providers.get(0);
        }
        if (providers.isEmpty()) {
            this.env.addProblem(ErrMsg.ANNO_UNREGISTERED_NAME, position, annotationName);
        } else {
            String names = providers.stream().map(p -> Strings.fmt((String)"\"%s\"", (Object[])new Object[]{p.getClass().getName()})).sorted(Strings.SORTER).collect(Collectors.joining(", "));
            this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"multiple annotation providers are registered for the annotation in the current environment: %s.", (Object[])new Object[]{names}));
        }
        return null;
    }

    private class ProblemReporter
    implements AnnotationProblemReporter {
        private ProblemReporter() {
        }

        @Override
        public void reportProblem(String annotationName, String message, Position position, SemanticProblemSeverity severity) {
            ErrMsg msg = switch (severity) {
                case SemanticProblemSeverity.ERROR -> ErrMsg.ANNO_SPECIFIC_ERR;
                case SemanticProblemSeverity.WARNING -> ErrMsg.ANNO_SPECIFIC_WARN;
                default -> throw new AssertionError((Object)("Unknown severity: " + String.valueOf(severity)));
            };
            CifAnnotationsPostChecker.this.env.addProblem(msg, position, annotationName, message);
        }
    }
}

