# coding: utf-8

"""
    LSAT API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.5.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from lsat_client.models.lsat_base import LsatBase
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from lsat_client.models.activity import Activity
from lsat_client.models.dispatch import Dispatch
from lsat_client.models.dispatch_group import DispatchGroup
from lsat_client.models.graph import Graph
from lsat_client.models.peripheral import Peripheral
from lsat_client.models.peripheral_type import PeripheralType
from lsat_client.models.product import Product
from lsat_client.models.product_definition import ProductDefinition
from lsat_client.models.resource import Resource
from lsat_client.models.schedule import Schedule
from lsat_client.models.task import Task
from typing import Optional, Set
from typing_extensions import Self

class LsatData(LsatBase):
    """
    LsatData
    """ # noqa: E501
    product_definitions: Optional[Dict[str, ProductDefinition]] = Field(default=None, description="Mapping of product-types to their definitions.", alias="productDefinitions")
    peripheral_types: Optional[Dict[str, PeripheralType]] = Field(default=None, description="Mapping of peripheral type names to their definitions.", alias="peripheralTypes")
    resources: Optional[Dict[str, Resource]] = Field(default=None, description="Mapping of resource fully qualified names to their definitions.")
    peripherals: Optional[Dict[str, Peripheral]] = Field(default=None, description="Mapping of peripherals fully qualified names to their definitions.")
    declarations: Optional[Dict[str, Union[StrictFloat, StrictInt]]] = Field(default=None, description="Mapping of variable declarations to their values.")
    activities: Optional[Dict[str, Activity]] = Field(default=None, description="Mapping of activity names to their definitions.")
    dispatches: Optional[Dict[str, Dispatch]] = Field(default=None, description="Mapping of dispatch unique-ids to their definitions.")
    dispatch_groups: Optional[Dict[str, DispatchGroup]] = Field(default=None, description="Mapping of dispatch group names to their definitions.", alias="dispatchGroups")
    tasks: Optional[Dict[str, Task]] = Field(default=None, description="Mapping of task unique-ids to their definitions.")
    graph: Optional[Graph] = None
    schedule: Optional[Schedule] = None
    products: Optional[Dict[str, Product]] = Field(default=None, description="Export of products as they traversed through the system")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["productDefinitions", "peripheralTypes", "resources", "peripherals", "declarations", "activities", "dispatches", "dispatchGroups", "tasks", "graph", "schedule", "products"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LsatData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in product_definitions (dict)
        _field_dict = {}
        if self.product_definitions:
            for _key_product_definitions in self.product_definitions:
                if self.product_definitions[_key_product_definitions]:
                    _field_dict[_key_product_definitions] = self.product_definitions[_key_product_definitions].to_dict()
            _dict['productDefinitions'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in peripheral_types (dict)
        _field_dict = {}
        if self.peripheral_types:
            for _key_peripheral_types in self.peripheral_types:
                if self.peripheral_types[_key_peripheral_types]:
                    _field_dict[_key_peripheral_types] = self.peripheral_types[_key_peripheral_types].to_dict()
            _dict['peripheralTypes'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in resources (dict)
        _field_dict = {}
        if self.resources:
            for _key_resources in self.resources:
                if self.resources[_key_resources]:
                    _field_dict[_key_resources] = self.resources[_key_resources].to_dict()
            _dict['resources'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in peripherals (dict)
        _field_dict = {}
        if self.peripherals:
            for _key_peripherals in self.peripherals:
                if self.peripherals[_key_peripherals]:
                    _field_dict[_key_peripherals] = self.peripherals[_key_peripherals].to_dict()
            _dict['peripherals'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in activities (dict)
        _field_dict = {}
        if self.activities:
            for _key_activities in self.activities:
                if self.activities[_key_activities]:
                    _field_dict[_key_activities] = self.activities[_key_activities].to_dict()
            _dict['activities'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in dispatches (dict)
        _field_dict = {}
        if self.dispatches:
            for _key_dispatches in self.dispatches:
                if self.dispatches[_key_dispatches]:
                    _field_dict[_key_dispatches] = self.dispatches[_key_dispatches].to_dict()
            _dict['dispatches'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in dispatch_groups (dict)
        _field_dict = {}
        if self.dispatch_groups:
            for _key_dispatch_groups in self.dispatch_groups:
                if self.dispatch_groups[_key_dispatch_groups]:
                    _field_dict[_key_dispatch_groups] = self.dispatch_groups[_key_dispatch_groups].to_dict()
            _dict['dispatchGroups'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in tasks (dict)
        _field_dict = {}
        if self.tasks:
            for _key_tasks in self.tasks:
                if self.tasks[_key_tasks]:
                    _field_dict[_key_tasks] = self.tasks[_key_tasks].to_dict()
            _dict['tasks'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of graph
        if self.graph:
            _dict['graph'] = self.graph.to_dict()
        # override the default output from pydantic by calling `to_dict()` of schedule
        if self.schedule:
            _dict['schedule'] = self.schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in products (dict)
        _field_dict = {}
        if self.products:
            for _key_products in self.products:
                if self.products[_key_products]:
                    _field_dict[_key_products] = self.products[_key_products].to_dict()
            _dict['products'] = _field_dict
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LsatData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "productDefinitions": dict(
                (_k, ProductDefinition.from_dict(_v))
                for _k, _v in obj["productDefinitions"].items()
            )
            if obj.get("productDefinitions") is not None
            else None,
            "peripheralTypes": dict(
                (_k, PeripheralType.from_dict(_v))
                for _k, _v in obj["peripheralTypes"].items()
            )
            if obj.get("peripheralTypes") is not None
            else None,
            "resources": dict(
                (_k, Resource.from_dict(_v))
                for _k, _v in obj["resources"].items()
            )
            if obj.get("resources") is not None
            else None,
            "peripherals": dict(
                (_k, Peripheral.from_dict(_v))
                for _k, _v in obj["peripherals"].items()
            )
            if obj.get("peripherals") is not None
            else None,
            "declarations": obj.get("declarations"),
            "activities": dict(
                (_k, Activity.from_dict(_v))
                for _k, _v in obj["activities"].items()
            )
            if obj.get("activities") is not None
            else None,
            "dispatches": dict(
                (_k, Dispatch.from_dict(_v))
                for _k, _v in obj["dispatches"].items()
            )
            if obj.get("dispatches") is not None
            else None,
            "dispatchGroups": dict(
                (_k, DispatchGroup.from_dict(_v))
                for _k, _v in obj["dispatchGroups"].items()
            )
            if obj.get("dispatchGroups") is not None
            else None,
            "tasks": dict(
                (_k, Task.from_dict(_v))
                for _k, _v in obj["tasks"].items()
            )
            if obj.get("tasks") is not None
            else None,
            "graph": Graph.from_dict(obj["graph"]) if obj.get("graph") is not None else None,
            "schedule": Schedule.from_dict(obj["schedule"]) if obj.get("schedule") is not None else None,
            "products": dict(
                (_k, Product.from_dict(_v))
                for _k, _v in obj["products"].items()
            )
            if obj.get("products") is not None
            else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        _obj.resolve_references(_obj)
        return _obj


