# coding: utf-8

"""
    LSAT API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.5.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from lsat_client.models.lsat_base import LsatBase
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from lsat_client.models.action_type import ActionType
from lsat_client.models.axis import Axis
from lsat_client.models.set_point import SetPoint
from typing import Optional, Set
from typing_extensions import Self

class PeripheralType(LsatBase):
    """
    PeripheralType
    """ # noqa: E501
    name: StrictStr
    conversion: Optional[StrictStr] = None
    axes: Optional[Dict[str, Axis]] = None
    set_points: Optional[Dict[str, SetPoint]] = Field(default=None, alias="setPoints")
    actions: Optional[List[ActionType]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "conversion", "axes", "setPoints", "actions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PeripheralType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in axes (dict)
        _field_dict = {}
        if self.axes:
            for _key_axes in self.axes:
                if self.axes[_key_axes]:
                    _field_dict[_key_axes] = self.axes[_key_axes].to_dict()
            _dict['axes'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in set_points (dict)
        _field_dict = {}
        if self.set_points:
            for _key_set_points in self.set_points:
                if self.set_points[_key_set_points]:
                    _field_dict[_key_set_points] = self.set_points[_key_set_points].to_dict()
            _dict['setPoints'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in actions (list)
        _items = []
        if self.actions:
            for _item_actions in self.actions:
                if _item_actions:
                    _items.append(_item_actions.to_dict())
            _dict['actions'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PeripheralType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "conversion": obj.get("conversion"),
            "axes": dict(
                (_k, Axis.from_dict(_v))
                for _k, _v in obj["axes"].items()
            )
            if obj.get("axes") is not None
            else None,
            "setPoints": dict(
                (_k, SetPoint.from_dict(_v))
                for _k, _v in obj["setPoints"].items()
            )
            if obj.get("setPoints") is not None
            else None,
            "actions": [ActionType.from_dict(_item) for _item in obj["actions"]] if obj.get("actions") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


