/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.dispatching.teditor.scoping;

import activity.Activity;
import activity.Claim;
import activity.ResourceAction;
import activity.util.ActivityParametersUtil;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import common.HasName;
import common.Parameter;
import common.ParameterReference;
import common.TypeDefinition;
import dispatching.Constraint;
import dispatching.Dispatch;
import dispatching.DispatchGroup;
import dispatching.DispatchingPackage;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import machine.IResource;
import machine.ResourceItem;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * This class contains custom scoping description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#scoping
 * on how and when to use it
 */
@SuppressWarnings("all")
public class DispatchingScopeProvider extends AbstractDeclarativeScopeProvider {
  /**
   * Allow for shortName (@link ResourceItem name)
   */
  public IScope scope_Parameter_declaration(final Parameter par, final EReference ref) {
    final Dispatch dis = EcoreUtil2.<Dispatch>getContainerOfType(par, Dispatch.class);
    final int parIndex = dis.getParameters().indexOf(par);
    Activity _activity = dis.getActivity();
    boolean _tripleEquals = (_activity == null);
    if (_tripleEquals) {
      return IScope.NULLSCOPE;
    }
    final Function1<Parameter, TypeDefinition> _function = (Parameter it) -> {
      return it.getDeclaration();
    };
    final List<TypeDefinition> preceding = ListExtensions.<Parameter, TypeDefinition>map(dis.getParameters().subList(0, parIndex), _function);
    IScope _scopeFor = Scopes.scopeFor(ActivityParametersUtil.getDeclarations(dis.getActivity()));
    final Predicate<IEObjectDescription> _function_1 = (IEObjectDescription it) -> {
      boolean _contains = preceding.contains(it.getEObjectOrProxy());
      return (!_contains);
    };
    return new FilteringScope(_scopeFor, _function_1);
  }

  public IScope scope_ParameterReference_reference(final ParameterReference parRef, final EReference ref) {
    final Dispatch dis = EcoreUtil2.<Dispatch>getContainerOfType(parRef, Dispatch.class);
    final Parameter par = EcoreUtil2.<Parameter>getContainerOfType(parRef, Parameter.class);
    Activity _activity = dis.getActivity();
    boolean _tripleEquals = (_activity == null);
    if (_tripleEquals) {
      return IScope.NULLSCOPE;
    }
    final int parIndex = dis.getParameters().indexOf(par);
    final int refIndex = par.getReferences().indexOf(parRef);
    if (((par.getDeclaration() == null) && (IterableExtensions.<Parameter>findFirst(dis.getParameters().subList(0, parIndex), ((Function1<Parameter, Boolean>) (Parameter it) -> {
      TypeDefinition _declaration = it.getDeclaration();
      return Boolean.valueOf((_declaration != null));
    })) != null))) {
      return IScope.NULLSCOPE;
    }
    TypeDefinition _xifexpression = null;
    TypeDefinition _declaration = par.getDeclaration();
    boolean _tripleNotEquals = (_declaration != null);
    if (_tripleNotEquals) {
      _xifexpression = par.getDeclaration();
    } else {
      _xifexpression = ActivityParametersUtil.getDeclarations(dis.getActivity()).get(parIndex);
    }
    final TypeDefinition decl = _xifexpression;
    final Function1<Claim, IResource> _function = (Claim it) -> {
      return it.getResource();
    };
    final Function1<IResource, Boolean> _function_1 = (IResource it) -> {
      boolean _isDeclaration = ActivityParametersUtil.isDeclaration(it);
      return Boolean.valueOf((!_isDeclaration));
    };
    List<IResource> resourcesFromActivity = IterableExtensions.<IResource>toList(IterableExtensions.<IResource>filter(IterableExtensions.<Claim, IResource>map(Iterables.<Claim>filter(dis.getActivity().getNodes(), Claim.class), _function), _function_1));
    final Function1<Parameter, HasName> _function_2 = (Parameter it) -> {
      return it.getReferences().getLast().getReference();
    };
    final Function1<IResource, List<IResource>> _function_3 = (IResource it) -> {
      return ActivityParametersUtil.getResourceOrItems(it);
    };
    final List<IResource> resourcesFromParameters = IterableExtensions.<IResource>toList(IterableExtensions.<IResource, IResource>flatMap(Iterables.<IResource>filter(ListExtensions.<Parameter, HasName>map(dis.getParameters().subList(0, parIndex), _function_2), IResource.class), _function_3));
    List<IResource> resourceCandidates = IterableExtensions.<IResource>toList(Iterables.<IResource>concat(resourcesFromActivity, resourcesFromParameters));
    final Function1<ParameterReference, HasName> _function_4 = (ParameterReference it) -> {
      return it.getReference();
    };
    final Collection<? extends HasName> eligibleItems = ActivityParametersUtil.findCandidate(dis.getActivity(), resourceCandidates, decl, IterableExtensions.<HasName>toList(ListExtensions.<ParameterReference, HasName>map(par.getReferences().subList(0, refIndex), _function_4)));
    final Function1<HasName, String> _function_5 = (HasName it) -> {
      return it.getName();
    };
    final Function1<List<HasName>, Boolean> _function_6 = (List<HasName> it) -> {
      int _size = it.size();
      return Boolean.valueOf((_size == 1));
    };
    final Function1<HasName, IEObjectDescription> _function_7 = (HasName it) -> {
      return EObjectDescription.create(it.getName(), it);
    };
    final Iterable<IEObjectDescription> validNameItems = IterableExtensions.<HasName, IEObjectDescription>map(Iterables.<HasName>concat(IterableExtensions.<List<HasName>>filter(IterableExtensions.<String, HasName>groupBy(IterableExtensions.toSet(eligibleItems), _function_5).values(), _function_6)), _function_7);
    SimpleScope _simpleScope = new SimpleScope(validNameItems);
    return Scopes.scopeFor(eligibleItems, _simpleScope);
  }

  public IScope scope_Parameter_declaration(final Dispatch dis, final EReference ref) {
    final Function1<Parameter, Boolean> _function = (Parameter it) -> {
      TypeDefinition _declaration = it.getDeclaration();
      return Boolean.valueOf((_declaration == null));
    };
    Parameter par = IterableExtensions.<Parameter>findFirst(dis.getParameters(), _function);
    if ((par != null)) {
      return this.scope_Parameter_declaration(par, ref);
    }
    Activity _activity = dis.getActivity();
    boolean _tripleEquals = (_activity == null);
    if (_tripleEquals) {
      return IScope.NULLSCOPE;
    }
    return Scopes.scopeFor(ActivityParametersUtil.getDeclarations(dis.getActivity()));
  }

  public IScope scope_ParameterReference_reference(final Dispatch dis, final EReference ref) {
    EList<Parameter> _parameters = dis.getParameters();
    Iterable<ParameterReference> _flatMap = null;
    if (_parameters!=null) {
      final Function1<Parameter, EList<ParameterReference>> _function = (Parameter it) -> {
        return it.getReferences();
      };
      _flatMap=IterableExtensions.<Parameter, ParameterReference>flatMap(_parameters, _function);
    }
    final Function2<ParameterReference, ParameterReference, ParameterReference> _function_1 = (ParameterReference a, ParameterReference b) -> {
      return b;
    };
    ParameterReference parRef = IterableExtensions.<ParameterReference>reduce(_flatMap, _function_1);
    if ((parRef != null)) {
      return this.scope_ParameterReference_reference(parRef, ref);
    }
    return this.delegateGetScope(dis, ref);
  }

  public IScope ResourceYieldMapEntry(final DispatchGroup dg, final EReference ref) {
    EList<Dispatch> _dispatches = dg.getDispatches();
    boolean _tripleEquals = (_dispatches == null);
    if (_tripleEquals) {
      return IScope.NULLSCOPE;
    }
    final Function1<Dispatch, EList<Node>> _function = (Dispatch it) -> {
      return it.getActivity().getNodes();
    };
    final Function1<ResourceAction, IResource> _function_1 = (ResourceAction it) -> {
      return it.getResource();
    };
    return Scopes.scopeFor(IterableExtensions.<IResource>toSet(IterableExtensions.<ResourceAction, IResource>map(Iterables.<ResourceAction>filter(IterableExtensions.<Dispatch, Node>flatMap(dg.getDispatches(), _function), ResourceAction.class), _function_1)));
  }

  public IScope scope_Dispatch(final Constraint constraint, final EReference ref) {
    boolean isSrc = Objects.equals(ref, DispatchingPackage.Literals.CONSTRAINT__SOURCE_DISPATCH);
    DispatchGroup _xifexpression = null;
    if (isSrc) {
      _xifexpression = constraint.getSourceDispatchGroup();
    } else {
      _xifexpression = constraint.getTargetDispatchGroup();
    }
    DispatchGroup dispatchGroup = _xifexpression;
    if ((dispatchGroup == null)) {
      dispatchGroup = EcoreUtil2.<DispatchGroup>getContainerOfType(constraint, DispatchGroup.class);
    }
    if ((dispatchGroup == null)) {
      return IScope.NULLSCOPE;
    }
    return Scopes.scopeFor(dispatchGroup.getDispatches());
  }

  public IScope scope_Action(final Constraint constraint, final EReference ref) {
    boolean isSrc = Objects.equals(ref, DispatchingPackage.Literals.CONSTRAINT__SOURCE_ACTION);
    Dispatch _xifexpression = null;
    if (isSrc) {
      _xifexpression = constraint.getSourceDispatch();
    } else {
      _xifexpression = constraint.getTargetDispatch();
    }
    Dispatch dispatch = _xifexpression;
    if ((dispatch == null)) {
      return IScope.NULLSCOPE;
    }
    return Scopes.scopeFor(dispatch.getActivity().getNodes());
  }
}
