/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.resource_throughput.ui.editors;

import activity.Activity;
import dispatching.ActivityDispatching;
import dispatching.Dispatch;
import dispatching.DispatchGroup;
import dispatching.util.DispatchingUtil;
import distributions.CalculationMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.lsat.timing.util.ITimingCalculator;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.lsat.timing.util.TimingCalculator;
import setting.Settings;

public class ResourceThroughputEditingDomain
extends AdapterFactoryEditingDomain {
    private TimingCalculator timingCalculator;
    private Collection<String> dispatchPhases;

    public ResourceThroughputEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack) {
        super(adapterFactory, commandStack);
    }

    public void reCalculate() {
        if (this.timingCalculator != null) {
            this.timingCalculator.reset();
        }
    }

    private <T> QueryableIterable<T> getContents(Class<T> type) {
        return QueryableIterable.from((Iterable)this.getResourceSet().getResources()).collect(Resource::getContents).objectsOfKind(type);
    }

    public ActivityDispatching getActivityDispatching() {
        ActivityDispatching activityDispatching = (ActivityDispatching)EcoreUtil.copy((EObject)this.getRawActivityDispatching());
        DispatchingUtil.expandActivities((ActivityDispatching)activityDispatching);
        return this.filterPhase(DispatchingUtil.convertYield((ActivityDispatching)activityDispatching));
    }

    public ActivityDispatching getFullyExpandedActivityDispatching() {
        ActivityDispatching activityDispatching = (ActivityDispatching)EcoreUtil.copy((EObject)this.getRawActivityDispatching());
        DispatchingUtil.expand((ActivityDispatching)activityDispatching);
        return this.filterPhase(activityDispatching);
    }

    public void setDispatchPhases(String[] phases) {
        if (phases == null || phases.length == 0) {
            this.dispatchPhases = null;
        }
        this.dispatchPhases = Arrays.asList(phases);
    }

    public String[] getSelectedDispatchPhases() {
        return this.dispatchPhases != null ? this.dispatchPhases.toArray(new String[this.dispatchPhases.size()]) : this.getDispatchPhases();
    }

    public String[] getDispatchPhases() {
        return (String[])this.getRawActivityDispatching().getDispatchGroups().stream().map(DispatchGroup::getName).distinct().toArray(String[]::new);
    }

    public QueryableIterable<Activity> getActivities() {
        return QueryableIterable.from((Object[])new ActivityDispatching[]{this.getActivityDispatching()}).xcollect(ActivityDispatching::getDispatchGroups).sortedBy(DispatchGroup::getOffset).xcollect(DispatchGroup::getDispatches).xcollectOne(Dispatch::getActivity);
    }

    public Settings getSettings() throws SpecificationException {
        Settings settings = (Settings)this.getContents(Settings.class).first();
        if (settings == null) {
            throw new SpecificationException("Settings not found, please see problems tab.", new EObject[0]);
        }
        return settings;
    }

    public ITimingCalculator getTimingCalculator() throws MotionException, SpecificationException {
        Settings settings = this.getSettings();
        MotionCalculatorExtension motionCalculator = MotionCalculatorExtension.getSelectedMotionCalculator();
        if (this.timingCalculator == null || settings != this.timingCalculator.getSettings() || motionCalculator != this.timingCalculator.getMotionCalculator()) {
            this.timingCalculator = new TimingCalculator(settings, motionCalculator, CalculationMode.MEAN, false, true);
        }
        return this.timingCalculator;
    }

    private ActivityDispatching getRawActivityDispatching() {
        return (ActivityDispatching)this.getContents(ActivityDispatching.class).first();
    }

    private ActivityDispatching filterPhase(ActivityDispatching dispatching) {
        if (this.dispatchPhases == null) {
            return dispatching;
        }
        ActivityDispatching out = (ActivityDispatching)EcoreUtil.copy((EObject)dispatching);
        Iterator iter = out.getDispatchGroups().iterator();
        while (iter.hasNext()) {
            if (this.dispatchPhases.contains(((DispatchGroup)iter.next()).getName())) continue;
            iter.remove();
        }
        return out;
    }
}

