/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p3order.ISweepPortDistributor;
import org.eclipse.elk.alg.layered.p3order.counting.IInitializable;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.alg.layered.properties.PortType;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

public abstract class AbstractBarycenterPortDistributor
implements ISweepPortDistributor,
IInitializable {
    private float[] portRanks;
    private float minBarycenter;
    private float maxBarycenter;
    private int[][] nodePositions;
    private float[] portBarycenter;
    private List<LPort> inLayerPorts = Lists.newArrayList();
    private int nPorts;

    public AbstractBarycenterPortDistributor(int numLayers) {
        this.nodePositions = new int[numLayers][];
    }

    public float[] getPortRanks() {
        return this.portRanks;
    }

    @Override
    public boolean distributePortsWhileSweeping(LNode[][] nodeOrder, int currentIndex, boolean isForwardSweep) {
        PortSide side;
        this.updateNodePositions(nodeOrder, currentIndex);
        LNode[] freeLayer = nodeOrder[currentIndex];
        PortSide portSide = side = isForwardSweep ? PortSide.WEST : PortSide.EAST;
        if (this.isNotFirstLayer(nodeOrder.length, currentIndex, isForwardSweep)) {
            LNode node;
            LNode[] fixedLayer = nodeOrder[isForwardSweep ? currentIndex - 1 : currentIndex + 1];
            this.calculatePortRanks(fixedLayer, this.portTypeFor(isForwardSweep));
            LNode[] lNodeArray = freeLayer;
            int n = freeLayer.length;
            int n2 = 0;
            while (n2 < n) {
                node = lNodeArray[n2];
                this.distributePorts(node, side);
                ++n2;
            }
            this.calculatePortRanks(freeLayer, this.portTypeFor(!isForwardSweep));
            lNodeArray = fixedLayer;
            n = fixedLayer.length;
            n2 = 0;
            while (n2 < n) {
                node = lNodeArray[n2];
                if (!this.hasNestedGraph(node)) {
                    this.distributePorts(node, side.opposed());
                }
                ++n2;
            }
        } else {
            LNode[] lNodeArray = freeLayer;
            int n = freeLayer.length;
            int n3 = 0;
            while (n3 < n) {
                LNode node = lNodeArray[n3];
                this.distributePorts(node, side);
                ++n3;
            }
        }
        return false;
    }

    public final void calculatePortRanks(LNode[] layer, PortType portType) {
        float consumedRank = 0.0f;
        int nodeIx = 0;
        while (nodeIx < layer.length) {
            consumedRank += this.calculatePortRanks(layer[nodeIx], consumedRank, portType);
            ++nodeIx;
        }
    }

    protected abstract float calculatePortRanks(LNode var1, float var2, PortType var3);

    private void distributePorts(LNode node, PortSide side) {
        if (!((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
            this.distributePorts(node, node.getPorts(side));
            this.distributePorts(node, node.getPorts(PortSide.SOUTH));
            this.distributePorts(node, node.getPorts(PortSide.NORTH));
            this.sortPorts(node);
        }
    }

    private void distributePorts(LNode node, Iterable<LPort> ports) {
        this.inLayerPorts.clear();
        this.iteratePortsAndCollectInLayerPorts(node, ports);
        if (!this.inLayerPorts.isEmpty()) {
            this.calculateInLayerPortsBarycenterValues(node);
        }
    }

    private void iteratePortsAndCollectInLayerPorts(LNode node, Iterable<LPort> ports) {
        this.minBarycenter = 0.0f;
        this.maxBarycenter = 0.0f;
        float absurdlyLargeFloat = 2 * node.getLayer().getNodes().size() + 1;
        block0: for (LPort port : ports) {
            boolean northSouthPort = port.getSide() == PortSide.NORTH || port.getSide() == PortSide.SOUTH;
            float sum = 0.0f;
            if (northSouthPort) {
                LNode portDummy = (LNode)((Object)port.getProperty(InternalProperties.PORT_DUMMY));
                if (portDummy == null) continue;
                sum += this.dealWithNorthSouthPorts(absurdlyLargeFloat, port, portDummy);
            } else {
                LPort connectedPort;
                for (LEdge outgoingEdge : port.getOutgoingEdges()) {
                    connectedPort = outgoingEdge.getTarget();
                    if (connectedPort.getNode().getLayer() == node.getLayer()) {
                        this.inLayerPorts.add(port);
                        continue block0;
                    }
                    sum += this.portRanks[connectedPort.id];
                }
                for (LEdge incomingEdge : port.getIncomingEdges()) {
                    connectedPort = incomingEdge.getSource();
                    if (connectedPort.getNode().getLayer() == node.getLayer()) {
                        this.inLayerPorts.add(port);
                        continue block0;
                    }
                    sum -= this.portRanks[connectedPort.id];
                }
            }
            if (port.getDegree() > 0) {
                this.portBarycenter[port.id] = sum / (float)port.getDegree();
                this.minBarycenter = Math.min(this.minBarycenter, this.portBarycenter[port.id]);
                this.maxBarycenter = Math.max(this.maxBarycenter, this.portBarycenter[port.id]);
                continue;
            }
            if (!northSouthPort) continue;
            this.portBarycenter[port.id] = sum;
        }
    }

    private void calculateInLayerPortsBarycenterValues(LNode node) {
        int nodeIndexInLayer = this.positionOf(node) + 1;
        int layerSize = node.getLayer().getNodes().size() + 1;
        for (LPort inLayerPort : this.inLayerPorts) {
            int sum = 0;
            int inLayerConnections = 0;
            for (LPort connectedPort : inLayerPort.getConnectedPorts()) {
                if (connectedPort.getNode().getLayer() != node.getLayer()) continue;
                sum += this.positionOf(connectedPort.getNode()) + 1;
                ++inLayerConnections;
            }
            float barycenter = (float)sum / (float)inLayerConnections;
            PortSide portSide = inLayerPort.getSide();
            if (portSide == PortSide.EAST) {
                if (barycenter < (float)nodeIndexInLayer) {
                    this.portBarycenter[inLayerPort.id] = this.minBarycenter - barycenter;
                    continue;
                }
                this.portBarycenter[inLayerPort.id] = this.maxBarycenter + ((float)layerSize - barycenter);
                continue;
            }
            if (portSide != PortSide.WEST) continue;
            this.portBarycenter[inLayerPort.id] = barycenter < (float)nodeIndexInLayer ? this.maxBarycenter + barycenter : this.minBarycenter - ((float)layerSize - barycenter);
        }
    }

    private float dealWithNorthSouthPorts(float absurdlyLargeFloat, LPort port, LNode portDummy) {
        boolean input = false;
        boolean output = false;
        for (LPort portDummyPort : portDummy.getPorts()) {
            if (portDummyPort.getProperty(InternalProperties.ORIGIN) != port) continue;
            if (!portDummyPort.getOutgoingEdges().isEmpty()) {
                output = true;
                continue;
            }
            if (portDummyPort.getIncomingEdges().isEmpty()) continue;
            input = true;
        }
        float sum = 0.0f;
        if (input && input ^ output) {
            sum = port.getSide() == PortSide.NORTH ? (float)(-this.positionOf(portDummy)) : absurdlyLargeFloat - (float)this.positionOf(portDummy);
        } else if (output && input ^ output) {
            sum = (float)this.positionOf(portDummy) + 1.0f;
        } else if (input && output) {
            sum = port.getSide() == PortSide.NORTH ? 0.0f : absurdlyLargeFloat / 2.0f;
        }
        return sum;
    }

    private int positionOf(LNode node) {
        return this.nodePositions[node.getLayer().id][node.id];
    }

    private void updateNodePositions(LNode[][] nodeOrder, int currentIndex) {
        LNode[] layer = nodeOrder[currentIndex];
        int i = 0;
        while (i < layer.length) {
            LNode node = layer[i];
            this.nodePositions[node.getLayer().id][node.id] = i++;
        }
    }

    private boolean hasNestedGraph(LNode node) {
        return node.getProperty(InternalProperties.NESTED_LGRAPH) != null;
    }

    private boolean isNotFirstLayer(int length, int currentIndex, boolean isForwardSweep) {
        return isForwardSweep ? currentIndex != 0 : currentIndex != length - 1;
    }

    private PortType portTypeFor(boolean isForwardSweep) {
        return isForwardSweep ? PortType.OUTPUT : PortType.INPUT;
    }

    private void sortPorts(LNode node) {
        Collections.sort(node.getPorts(), (port1, port2) -> {
            PortSide side2;
            PortSide side1 = port1.getSide();
            if (side1 != (side2 = port2.getSide())) {
                return side1.ordinal() - side2.ordinal();
            }
            float port1Bary = this.portBarycenter[port1.id];
            float port2Bary = this.portBarycenter[port2.id];
            if (port1Bary == 0.0f && port2Bary == 0.0f) {
                return 0;
            }
            if (port1Bary == 0.0f) {
                return -1;
            }
            if (port2Bary == 0.0f) {
                return 1;
            }
            return Float.compare(port1Bary, port2Bary);
        });
    }

    @Override
    public void initAtLayerLevel(int l, LNode[][] nodeOrder) {
        this.nodePositions[l] = new int[nodeOrder[l].length];
    }

    @Override
    public void initAtNodeLevel(int l, int n, LNode[][] nodeOrder) {
        LNode node = nodeOrder[l][n];
        node.id = n;
        this.nodePositions[l][n] = n;
    }

    @Override
    public void initAtPortLevel(int l, int n, int p, LNode[][] nodeOrder) {
        nodeOrder[l][n].getPorts().get((int)p).id = this.nPorts++;
    }

    @Override
    public void initAfterTraversal() {
        this.portRanks = new float[this.nPorts];
        this.portBarycenter = new float[this.nPorts];
    }
}

