/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.mtl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.trace4cps.analysis.mtl.AtomicProposition;
import org.eclipse.trace4cps.analysis.mtl.ExplanationTable;
import org.eclipse.trace4cps.analysis.mtl.InformativePrefix;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.mtl.MtlResult;
import org.eclipse.trace4cps.analysis.stl.StlFormula;

public final class MtlUtil {
    private MtlUtil() {
    }

    public static boolean isMtl(MtlFormula phi) {
        for (MtlFormula sub : MtlUtil.getSubformulas(phi)) {
            if (!(sub instanceof StlFormula)) continue;
            return false;
        }
        return true;
    }

    public static boolean isStl(MtlFormula phi) {
        return phi instanceof StlFormula;
    }

    public static boolean isStlMx(MtlFormula phi) {
        return !MtlUtil.isStl(phi) && !MtlUtil.isMtl(phi);
    }

    public static Collection<Integer> getAtomicPropIndices(MtlResult r) {
        Set<AtomicProposition> aps = MtlUtil.getAtomicPropositions(r.getPhi());
        ExplanationTable tab = r.getExplanation();
        HashSet<Integer> result = new HashSet<Integer>();
        for (AtomicProposition ap : aps) {
            for (ExplanationTable.Region region : tab.getRegions(ap)) {
                if (region.getValue() != InformativePrefix.GOOD) continue;
                int i = region.getStartIndex();
                while (i <= region.getEndIndex()) {
                    result.add(i);
                    ++i;
                }
            }
        }
        return result;
    }

    public static List<MtlFormula> getSubformulas(MtlFormula phi) {
        ArrayList<MtlFormula> r = new ArrayList<MtlFormula>();
        MtlUtil.depthFirstSub(phi, r);
        return r;
    }

    public static Set<AtomicProposition> getAtomicPropositions(MtlFormula phi) {
        HashSet<AtomicProposition> r = new HashSet<AtomicProposition>();
        MtlUtil.depthFirstAP(phi, r);
        return r;
    }

    private static void depthFirstAP(MtlFormula phi, Set<AtomicProposition> r) {
        if (!phi.getChildren().isEmpty()) {
            for (MtlFormula c : phi.getChildren()) {
                MtlUtil.depthFirstAP(c, r);
            }
        } else if (phi instanceof AtomicProposition) {
            r.add((AtomicProposition)phi);
        }
    }

    private static void depthFirstSub(MtlFormula phi, List<MtlFormula> r) {
        if (!phi.getChildren().isEmpty()) {
            for (MtlFormula c : phi.getChildren()) {
                MtlUtil.depthFirstSub(c, r);
            }
        }
        if (!r.contains(phi)) {
            r.add(phi);
        }
    }
}

