/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGeneratorResult;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class InitPredCodeGenerator {
    private InitPredCodeGenerator() {
    }

    public static void gencodeInitPreds(Specification spec, CifCompilerContext ctxt) {
        JavaCodeFile file = ctxt.addCodeFile("InitPreds");
        CodeBox h = file.header;
        h.add("/** Initialization predicates. */");
        h.add("public final class InitPreds {");
        CodeBox c = file.body;
        c.add("public static boolean evalInitPreds(State state) {");
        c.indent();
        List<ExprCodeGeneratorResult> exprResults = InitPredCodeGenerator.gencodeComponent((ComplexComponent)spec, ctxt, c);
        c.add();
        c.add("// All initialization predicates satisfied.");
        c.add("return true;");
        c.dedent();
        c.add("}");
        for (ExprCodeGeneratorResult exprResult : exprResults) {
            exprResult.addExtraMethods(c);
        }
    }

    private static List<ExprCodeGeneratorResult> gencodeComponent(ComplexComponent comp, CifCompilerContext ctxt, CodeBox c) {
        String absName = CifTextUtils.getAbsName((PositionObject)comp);
        if (!comp.getInitials().isEmpty()) {
            c.add("// Initialization predicates for \"%s\".", new Object[]{absName});
        }
        List exprResults = Lists.list();
        for (Expression init : comp.getInitials()) {
            c.add("try {");
            c.indent();
            String initTxt = CifTextUtils.exprToStr((Expression)init);
            String compTxt = CifTextUtils.getComponentText2((ComplexComponent)comp);
            ExprCodeGeneratorResult result = ExprCodeGenerator.gencodeExpr(init, ctxt, "state");
            c.add("if (!(%s)) {", new Object[]{result});
            exprResults.add(result);
            c.indent();
            c.add("warn(\"Initialization predicate \\\"%s\\\" of %s is not satisfied.\");", new Object[]{StringEscapeUtils.escapeJava((String)Strings.truncate((String)initTxt, (int)1000)), StringEscapeUtils.escapeJava((String)compTxt)});
            c.add("return false;");
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of initialization predicate \\\"%s\\\" of %s failed.\", e, state);", new Object[]{StringEscapeUtils.escapeJava((String)Strings.truncate((String)initTxt, (int)1000)), StringEscapeUtils.escapeJava((String)compTxt)});
            c.dedent();
            c.add("}");
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                exprResults.addAll(InitPredCodeGenerator.gencodeComponent((ComplexComponent)child, ctxt, c));
            }
        }
        return exprResults;
    }
}

