/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.meanpayoff.solvers.zwick;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsat.common.ludus.backend.games.meanpayoff.MeanPayoffGame;

public class ZwickPatersonDouble {
    private ZwickPatersonDouble() {
    }

    protected static <V, E> Map<V, Double> solve(MeanPayoffGame<V, E, Double> game, Double epsilon) {
        return ZwickPatersonDouble.computeEstimate(game, epsilon);
    }

    protected static <V, E> Map<V, Double> computeEstimate(MeanPayoffGame<V, E, Double> game, Double epsilon) {
        Map<V, Double> valueMap = ZwickPatersonDouble.computePathValues(game, epsilon);
        HashMap<V, Double> estimateMap = new HashMap<V, Double>();
        Integer n = game.getVertices().size();
        Double k = 2.0 * (double)n.intValue() * (Double)game.getMaxAbsValue() / epsilon;
        for (V v : valueMap.keySet()) {
            estimateMap.put(v, valueMap.get(v) / k);
        }
        return estimateMap;
    }

    private static <V, E> Map<V, Double> computePathValues(MeanPayoffGame<V, E, Double> game, Double epsilon) {
        HashMap valueMap = new HashMap();
        for (Object v : game.getVertices()) {
            valueMap.put(v, 0.0);
        }
        Integer n = game.getVertices().size();
        Double k = 2.0 * (double)n.intValue() * (Double)game.getMaxAbsValue() / epsilon;
        int i = 1;
        while ((long)i <= Math.round(k)) {
            HashMap oldVector = valueMap;
            HashMap newVector = new HashMap();
            for (Object v : game.getVertices()) {
                Double newValue;
                if (game.getV0().contains(v)) {
                    Double maxValue = Double.NEGATIVE_INFINITY;
                    for (Object e : game.outgoingEdgesOf(v)) {
                        u = game.getEdgeTarget(e);
                        maxValue = Math.max(maxValue, (Double)oldVector.get(u) + (Double)game.getWeight(e));
                    }
                    newValue = maxValue;
                } else {
                    Double minValue = Double.POSITIVE_INFINITY;
                    for (Object e : game.outgoingEdgesOf(v)) {
                        u = game.getEdgeTarget(e);
                        minValue = Math.min(minValue, (Double)oldVector.get(u) + (Double)game.getWeight(e));
                    }
                    newValue = minValue;
                }
                newVector.put(v, newValue);
            }
            valueMap = newVector;
            ++i;
        }
        return valueMap;
    }
}

