/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.lsp4j.jsonrpc.ProtocolSince;

/**
 * A machine-readable explanation of why a breakpoint may not be verified. If
 * a breakpoint is verified or a specific reason is not known, the adapter
 * should omit this property.
 */
@ProtocolSince("1.64")
@SuppressWarnings("all")
public enum BreakpointNotVerifiedReason {
  /**
   * Indicates a breakpoint might be verified in the future, but the adapter cannot verify it in the current state.
   */
  PENDING,

  /**
   * Indicates a breakpoint was not able to be verified,
   * and the adapter does not believe it can be verified without intervention.
   */
  FAILED;
}
