/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;

public class ResourceUtils {
    public static final String FILE_UNC_PREFIX = "file:////";

    public static String fixURI(URI uri) {
        if (uri == null) {
            return null;
        }
        if ("win32".equals(Platform.getOS()) && URIUtil.isFileURI((URI)uri)) {
            uri = URIUtil.toFile((URI)uri).toURI();
        }
        String uriString = uri.toString();
        return uriString.replaceFirst("file:/([^/])", "file:///$1");
    }

    public static File toFile(URI uri) {
        if ("win32".equals(Platform.getOS())) {
            return URIUtil.toFile((URI)uri);
        }
        return new File(uri);
    }

    public static String toClientUri(String uri) {
        if (uri != null && "win32".equals(Platform.getOS()) && uri.startsWith(FILE_UNC_PREFIX)) {
            uri = uri.replace(FILE_UNC_PREFIX, "file://");
        }
        return uri;
    }
}

