/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.java.codeaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4jakarta.commons.codeaction.ICodeActionId;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.ModifyModifiersProposal;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;

public abstract class InsertModifierToNestedClassQuickFix
implements IJavaCodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(InsertModifierToNestedClassQuickFix.class.getName());
    private final String modifier;

    public InsertModifierToNestedClassQuickFix(String modifier) {
        this.modifier = modifier;
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ArrayList<ExtendedCodeAction> codeActions = new ArrayList<ExtendedCodeAction>();
        ASTNode node = context.getCoveredNode();
        IBinding parentType = this.getBinding(node);
        if (parentType != null) {
            ExtendedCodeAction codeAction = new ExtendedCodeAction(this.getLabel(this.modifier));
            codeAction.setRelevance(0);
            codeAction.setKind("quickfix");
            codeAction.setDiagnostics(Arrays.asList(diagnostic));
            codeAction.setData(new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), null, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported(), this.getCodeActionId()));
            codeActions.add(codeAction);
        }
        return codeActions;
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction toResolve = context.getUnresolved();
        ASTNode node = context.getCoveredNode();
        if (node.getParent() instanceof VariableDeclarationFragment) {
            IVariableBinding binding = (IVariableBinding)this.getBinding(node);
            if (binding != null) {
                ITypeBinding fieldType = binding.getType();
                this.insertModifier(context, toResolve, fieldType);
            }
        } else if (node.getParent() instanceof MethodDeclaration) {
            IMethodBinding methodBinding = (IMethodBinding)this.getBinding(node);
            ITypeBinding[] iTypeBindingArray = methodBinding.getParameterTypes();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding paramType = iTypeBindingArray[n2];
                this.insertModifier(context, toResolve, paramType);
                ++n2;
            }
        }
        return toResolve;
    }

    protected CodeAction insertModifier(JavaCodeActionResolveContext context, CodeAction toResolve, ITypeBinding type) {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode declNode = astRoot.findDeclaringNode((IBinding)type);
        if (!(declNode instanceof TypeDeclaration var6_7)) {
            return null;
        }
        if (this.isModifierExist((TypeDeclaration)innerDecl)) {
            return null;
        }
        try {
            ModifyModifiersProposal proposal = new ModifyModifiersProposal(this.getLabel(this.modifier), context.getCompilationUnit(), astRoot, (IBinding)type.getTypeDeclaration(), 0, (ASTNode)innerDecl, List.of(this.modifier));
            toResolve.setEdit(context.convertToWorkspaceEdit(proposal));
            return toResolve;
        }
        catch (IllegalArgumentException | NoSuchMethodError | CoreException e) {
            LOGGER.log(Level.SEVERE, "Unable to create ModifyModifiersProposal", e);
            return null;
        }
    }

    protected IBinding getBinding(ASTNode node) {
        if (node.getParent() instanceof VariableDeclarationFragment) {
            return ((VariableDeclarationFragment)node.getParent()).resolveBinding();
        }
        if (node.getParent() instanceof MethodDeclaration) {
            return ((MethodDeclaration)node.getParent()).resolveBinding();
        }
        return Bindings.getBindingOfParentType((ASTNode)node);
    }

    protected String getLabel(String modifier) {
        return Messages.getMessage("InsertModifierToNestedClass", modifier);
    }

    protected abstract ICodeActionId getCodeActionId();

    protected abstract boolean isModifierExist(TypeDeclaration var1);
}

