/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.store.internals;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.TDBFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetBuilder.class);

    public static Dataset buildPersistent(Path path) throws IOException {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            LOGGER.info("Path {} should exists now", (Object)path);
            Dataset dataset = TDBFactory.createDataset((String)path.toString());
            ARQ.getContext().set(TDB.symUnionDefaultGraph, true);
            return dataset;
        }
        catch (IOException e) {
            LOGGER.error(String.valueOf(e));
            throw e;
        }
    }
}

