/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.core.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public final class InheritedMethodAnnotationHelper {
    private InheritedMethodAnnotationHelper() {
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        T annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        for (Class<?> currentSuperClass = declaringClass.getSuperclass(); currentSuperClass != null; currentSuperClass = currentSuperClass.getSuperclass()) {
            try {
                Method superClassMethod = currentSuperClass.getMethod(method.getName(), method.getParameterTypes());
                T superClassMethodAnnotation = superClassMethod.getAnnotation(annotationClass);
                if (superClassMethodAnnotation == null) continue;
                return superClassMethodAnnotation;
            }
            catch (Exception superClassMethod) {
                // empty catch block
            }
        }
        Class<?> currentClass = declaringClass;
        do {
            Class<?>[] interfaces;
            for (Class<?> interfac : interfaces = currentClass.getInterfaces()) {
                T interfaceMethodAnnotation = InheritedMethodAnnotationHelper.getRecursiveInterfaceMethodAnnotation(interfac, method, annotationClass);
                if (interfaceMethodAnnotation == null) continue;
                return interfaceMethodAnnotation;
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return null;
    }

    private static <T extends Annotation> T getRecursiveInterfaceMethodAnnotation(Class<?> interfac, Method method, Class<T> annotationClass) {
        Class<?>[] superInterfaces;
        try {
            Method interfaceMethod = interfac.getMethod(method.getName(), method.getParameterTypes());
            T interfaceMethodAnnotation = interfaceMethod.getAnnotation(annotationClass);
            if (interfaceMethodAnnotation != null) {
                return interfaceMethodAnnotation;
            }
        }
        catch (Exception interfaceMethod) {
            // empty catch block
        }
        for (Class<?> superInterface : superInterfaces = interfac.getInterfaces()) {
            T interfaceMethodAnnotation = InheritedMethodAnnotationHelper.getRecursiveInterfaceMethodAnnotation(superInterface, method, annotationClass);
            if (interfaceMethodAnnotation == null) continue;
            return interfaceMethodAnnotation;
        }
        return null;
    }
}

