/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTRelation.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Key;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.AbstractQVTRelationOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyOperations
extends AbstractQVTRelationOperations {
    public static KeyOperations INSTANCE = new KeyOperations();

    public boolean checkAtLeastOnePart(Key key, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int partCount = key.getPart().size() + key.getOppositePart().size();
        if (partCount <= 0) {
            if (diagnostics != null) {
                diagnostics.add(this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_KeyMustHaveAtLeastOnePart_diagnostic", new Object[]{this.getObjectLabel((EObject)key, context)}, new Object[]{key}, context));
            }
            return false;
        }
        return true;
    }

    public boolean checkPartSourceIsIdentifiedClass(Key key, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        EClass identifiedClass = key.getIdentifies();
        for (EStructuralFeature part : key.getPart()) {
            EClass partSource = part.getEContainingClass();
            if (partSource.isSuperTypeOf(identifiedClass)) continue;
            allOk = false;
            if (diagnostics == null) continue;
            diagnostics.add(this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_KeyPartSourceMustBeKeyIdentifies_diagnostic", new Object[]{this.getObjectLabel((EObject)part, context), this.getObjectLabel((EObject)key, context), this.getObjectLabel((EObject)identifiedClass, context)}, new Object[]{part}, context));
        }
        return allOk;
    }

    public boolean checkOppositePartTargetIsIdentifiedClass(Key key, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        EClass identifiedClass = key.getIdentifies();
        for (EReference oppositePart : key.getOppositePart()) {
            EClass partTarget = oppositePart.getEReferenceType();
            if (partTarget.isSuperTypeOf(identifiedClass)) continue;
            allOk = false;
            if (diagnostics == null) continue;
            diagnostics.add(this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_KeyOppositePartTargetMustBeKeyIdentifies_diagnostic", new Object[]{this.getObjectLabel((EObject)oppositePart, context), this.getObjectLabel((EObject)key, context), this.getObjectLabel((EObject)identifiedClass, context)}, new Object[]{oppositePart}, context));
        }
        return allOk;
    }
}

