/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.pages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.qvt.declarative.ecore.mappings.MappingConfigurationException;
import org.eclipse.qvt.declarative.editor.ui.IMasterPageManager;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.paged.PagedEditor;
import org.eclipse.qvt.declarative.editor.ui.pages.AbstractPageManager;
import org.eclipse.qvt.declarative.editor.ui.text.ITextEditorWithUndoContext;
import org.eclipse.qvt.declarative.editor.ui.text.LazyFileEditorInput;
import org.eclipse.qvt.declarative.modelregistry.eclipse.EclipseProjectHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditorPageManager
extends AbstractPageManager<ITextEditorWithUndoContext>
implements IMasterPageManager {
    protected final XMLResource resource;
    protected final IFileEditorInput masterEditorInput;
    private LazyFileEditorInput lazyEditorInput = null;
    private IFileEditorInput currentEditorInput;
    private boolean needsDeactivation;
    private long deactivatedResourceSetTimeStamp = -1L;

    public EditorPageManager(PagedEditor pagedEditor, XMLResource resource, boolean isMaster, String pageTitle) {
        super(pagedEditor, pageTitle);
        this.setEditor(this.createEditor());
        this.resource = resource;
        this.needsDeactivation = isMaster;
        IFileEditorInput pagedEditorInput = pagedEditor.getEditorInput();
        if (isMaster) {
            this.masterEditorInput = pagedEditorInput;
            this.currentEditorInput = pagedEditorInput;
        } else {
            this.masterEditorInput = null;
            try {
                this.lazyEditorInput = this.createLazyEditorInput();
            }
            catch (CoreException e) {
                String message = "Error creating nested '" + pageTitle + "' editor";
                pagedEditor.showError(message, (Exception)((Object)e));
            }
            this.currentEditorInput = this.lazyEditorInput;
        }
    }

    @Override
    public void activate(IProgressMonitor monitor, long resourceSetTimeStamp) throws CoreException, IOException, MappingConfigurationException {
        if (!this.isMaster() && resourceSetTimeStamp != this.deactivatedResourceSetTimeStamp) {
            if (this.lazyEditorInput == null) {
                this.lazyEditorInput = this.createLazyEditorInput();
            }
            ByteArrayOutputStream2InputStream outputStream = new ByteArrayOutputStream2InputStream();
            this.createContents(outputStream);
            ByteArrayInputStream inputStream = outputStream.createInputStreamReusingBuffer();
            this.lazyEditorInput.setContents(inputStream, monitor);
            outputStream.close();
            this.currentEditorInput = this.lazyEditorInput;
            ((ITextEditorWithUndoContext)this.editor).setInput((IEditorInput)this.currentEditorInput);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    protected abstract ITextEditorWithUndoContext createEditor();

    @Deprecated
    protected LazyFileEditorInput createLazyEditorInput() throws CoreException {
        IFile masterFile = this.pagedEditor.getEditorInputFile();
        return new LazyFileEditorInput(this.pagedEditor.getTmpDir(), masterFile.getName(), this.getFileExtension());
    }

    @Override
    public void deactivated(IProgressMonitor monitor, long resourceSetTimeStamp) {
        this.deactivatedResourceSetTimeStamp = resourceSetTimeStamp;
        this.needsDeactivation = false;
        ((ITextEditorWithUndoContext)this.editor).doSave(monitor);
    }

    @Override
    public void doSave(IProgressMonitor monitor) throws OperationCanceledException {
        ((ITextEditorWithUndoContext)this.editor).doSave(monitor);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        assert (this.isMaster()) : "Should be master";
        if (this.lazyEditorInput != null) {
            try {
                InputStream inputStream = this.lazyEditorInput.getFile().getContents();
                this.masterEditorInput.getFile().setContents(inputStream, 1, monitor);
            }
            catch (CoreException e) {
                QVTEditorPlugin.logError("Failed to copy temporary file to master", e);
            }
            this.currentEditorInput = this.masterEditorInput;
            ((ITextEditorWithUndoContext)this.editor).setInput((IEditorInput)this.currentEditorInput);
            this.lazyEditorInput = null;
        }
    }

    @Override
    public IAction getAction(String actionID) {
        return ((ITextEditorWithUndoContext)this.editor).getAction(actionID);
    }

    @Override
    public String getCurrentContents() {
        IDocumentProvider documentProvider = ((ITextEditorWithUndoContext)this.editor).getDocumentProvider();
        IDocument document = documentProvider.getDocument((Object)this.currentEditorInput);
        return document != null ? document.get() : "";
    }

    @Override
    public XMLResource getEcoreResource() {
        return this.resource;
    }

    @Override
    public IFileEditorInput getEditorInput() {
        return this.isMaster() ? this.masterEditorInput : this.lazyEditorInput;
    }

    protected AbstractFileHandle getFileHandle() {
        IProject project = this.pagedEditor.getProject();
        EclipseProjectHandle projectHandle = new EclipseProjectHandle(project);
        return projectHandle.getFileHandle((IResource)this.pagedEditor.getEditorInputFile());
    }

    @Override
    public IEditorPart getInitialPage() {
        return this.getEditor();
    }

    @Override
    public XMLResource getResource() {
        return this.resource;
    }

    public ISelection getSelection() {
        return this.pagedEditor.getSelection();
    }

    @Override
    public IUndoContext getUndoContext() {
        return ((ITextEditorWithUndoContext)this.editor).getUndoContext();
    }

    @Override
    public boolean gotoMarker(IMarker marker) {
        return false;
    }

    @Override
    public boolean hasResourceSetTimeStamp(long resourceSetTimeStamp) {
        return this.deactivatedResourceSetTimeStamp == resourceSetTimeStamp;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isMaster() {
        return this.masterEditorInput != null;
    }

    @Override
    public boolean needsDeactivation() {
        return this.needsDeactivation;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    @Override
    public void saveTo(IFile file, IProgressMonitor monitor) {
        try {
            String contents = this.getCurrentContents();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes());
            if (file.exists()) {
                file.setContents((InputStream)inputStream, true, true, monitor);
            } else {
                file.create((InputStream)inputStream, true, monitor);
            }
        }
        catch (Exception e) {
            String message = "Failed to save '" + this.getTitle() + "' editor to '" + file.getName() + "'";
            this.pagedEditor.showError(message, e);
        }
    }

    public void setSelection(ISelection selection) {
    }

    public static final class ByteArrayOutputStream2InputStream
    extends ByteArrayOutputStream {
        public ByteArrayInputStream createInputStreamReusingBuffer() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

