/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.ui.properties;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.presentation.EcoreActionBarContributor;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelSerializationRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.AccessorRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.ModelSerialization;
import org.eclipse.qvt.declarative.modelregistry.model.Registration;
import org.eclipse.qvt.declarative.modelregistry.ui.help.ModelRegistryHelpIds;
import org.eclipse.qvt.declarative.modelregistry.ui.help.ModelRegistryHelper;
import org.eclipse.qvt.declarative.modelregistry.ui.properties.PreferencesMessages;
import org.eclipse.qvt.declarative.modelregistry.ui.ripoffs.StatusInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationDialog
extends StatusDialog {
    private final AccessorRegistry<?> accessorRegistry;
    private final Registration<?> registration;
    private final List<Registration<?>> currentRegistrationModel;
    private final AbstractFileHandle fileHandle;
    private Text accessorNameText;
    private Text modelURIText;
    private Combo serializationCombo;
    private String accessorName = null;
    private String resourceURI = null;
    private String serialization = null;

    public RegistrationDialog(Shell parent, AccessorRegistry<?> accessorRegistry, Registration<?> registration, List<Registration<?>> currentRegistrationModel, AbstractFileHandle fileHandle) {
        super(parent);
        this.accessorRegistry = accessorRegistry;
        this.registration = registration;
        this.currentRegistrationModel = currentRegistrationModel;
        this.fileHandle = fileHandle;
        if (registration == null) {
            this.setTitle(PreferencesMessages.RegistrationDialog_new_title);
        } else {
            this.setTitle(PreferencesMessages.RegistrationDialog_edit_title);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected void createAccessorNameControls(Composite parent) {
        Label accessorNameLabel = new Label(parent, 0);
        accessorNameLabel.setText(PreferencesMessages.ModelRegistryConfigurationBlock_accessor_name_column);
        this.accessorNameText = new Text(parent, 2048);
        this.accessorNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.accessorNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegistrationDialog.this.doValidation();
            }
        });
        ModelRegistryHelper.setHelp((Control)accessorNameLabel, ModelRegistryHelpIds.General.ACCESSOR_NAME);
        ModelRegistryHelper.setHelp((Control)this.accessorNameText, ModelRegistryHelpIds.General.ACCESSOR_NAME);
    }

    protected void createBrowseFileSystemButton(Composite parent) {
        Button browseFileSystemButton = new Button(parent, 8);
        browseFileSystemButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_BrowseFileSystem_label"));
        browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                FileDialog fileDialog = new FileDialog(RegistrationDialog.this.getShell(), 0);
                fileDialog.setFilterPath(RegistrationDialog.this.fileHandle.getAbsoluteName());
                if (fileDialog.open() == null) {
                    return;
                }
                String filterPath = fileDialog.getFilterPath();
                String fileName = fileDialog.getFileName();
                if (fileName == null) {
                    return;
                }
                URI ecoreURI = URI.createFileURI((String)(String.valueOf(filterPath) + File.separator + fileName));
                RegistrationDialog.this.setResourceURI(ecoreURI);
            }
        });
        ModelRegistryHelper.setHelp((Control)browseFileSystemButton, ModelRegistryHelpIds.RegistrationDialog.BROWSE_FILE_SYSTEM);
    }

    protected void createBrowseRegisteredPackagesButton(Composite parent) {
        Button browseRegisteredPackagesButton = new Button(parent, 8);
        browseRegisteredPackagesButton.setText(EcoreEditorPlugin.INSTANCE.getString("_UI_BrowseRegisteredPackages_label"));
        browseRegisteredPackagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                EcoreActionBarContributor.ExtendedLoadResourceAction.RegisteredPackageDialog registeredPackageDialog = new EcoreActionBarContributor.ExtendedLoadResourceAction.RegisteredPackageDialog(RegistrationDialog.this.getShell());
                registeredPackageDialog.setMultipleSelection(false);
                registeredPackageDialog.open();
                Object[] result = registeredPackageDialog.getResult();
                if (result == null || result.length < 1) {
                    return;
                }
                String uriString = result[0].toString().trim();
                Map genModelMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
                if (genModelMap == null) {
                    RegistrationDialog.this.showError("No genmodel map error", "EcorePlugin.getEPackageNsURIToGenModelLocationMap() returned null", null);
                    return;
                }
                URI genModelURI = (URI)genModelMap.get(uriString);
                if (genModelURI == null) {
                    RegistrationDialog.this.showError("No genmodel error", "No genmodel URI obtainable for '" + uriString + "'", null);
                    return;
                }
                String genModelURIString = genModelURI.toString();
                if (!genModelURIString.endsWith(".genmodel")) {
                    RegistrationDialog.this.showError("Bad genmodel error", "Selected package's genmodel '" + genModelURIString + "' is not '*.genmodel'", null);
                    return;
                }
                String ecoreURIString = String.valueOf(genModelURIString.substring(0, genModelURIString.length() - 9)) + ".ecore";
                URI ecoreURI = URI.createURI((String)ecoreURIString);
                RegistrationDialog.this.setResourceURI(ecoreURI);
            }
        });
        ModelRegistryHelper.setHelp((Control)browseRegisteredPackagesButton, ModelRegistryHelpIds.RegistrationDialog.BROWSE_REGISTERED_PACKAGES);
    }

    protected void createBrowseWorkspaceButton(Composite parent) {
        Button browseWorkspaceButton = new Button(parent, 8);
        browseWorkspaceButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label"));
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                IFile file;
                IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)RegistrationDialog.this.getShell(), null, null, (boolean)false, (Object[])new Object[]{RegistrationDialog.this.fileHandle}, null);
                IFile iFile = file = files.length != 0 ? files[0] : null;
                if (file == null) {
                    return;
                }
                String filePath = file.getFullPath().toString();
                URI ecoreURI = URI.createPlatformResourceURI((String)filePath, (boolean)true);
                RegistrationDialog.this.setResourceURI(ecoreURI);
            }
        });
        ModelRegistryHelper.setHelp((Control)browseWorkspaceButton, ModelRegistryHelpIds.RegistrationDialog.BROWSE_WORKSPACE);
    }

    protected Control createDialogArea(Composite parent) {
        int columnsPerLine = 4;
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = columnsPerLine;
        inner.setLayout((Layout)layout);
        this.createAccessorNameControls(inner);
        this.createSerializationControls(inner);
        this.createResourceURIControls(inner, columnsPerLine);
        this.createBrowseFileSystemButton(inner);
        this.createBrowseRegisteredPackagesButton(inner);
        this.createBrowseWorkspaceButton(inner);
        RegistrationDialog.applyDialogFont((Control)composite);
        ModelRegistryHelper.setHelp((Control)composite, ModelRegistryHelpIds.RegistrationDialog.OVERVIEW);
        if (this.registration != null) {
            this.accessorNameText.setText(this.registration.getAccessorName());
            this.modelURIText.setText(this.registration.getURIString());
            this.serializationCombo.select(this.serializationCombo.indexOf(this.registration.getSerialization().getName()));
        } else {
            this.serializationCombo.select(this.serializationCombo.indexOf("XML"));
        }
        this.doValidation();
        return composite;
    }

    protected void createResourceURIControls(Composite parent, int columnsPerLine) {
        Label modelURILabel = new Label(parent, 0);
        modelURILabel.setText(PreferencesMessages.ModelRegistryConfigurationBlock_platform_resource_column);
        this.modelURIText = new Text(parent, 2048);
        this.modelURIText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, columnsPerLine - 1, 1));
        this.modelURIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegistrationDialog.this.doValidation();
            }
        });
        ModelRegistryHelper.setHelp((Control)modelURILabel, ModelRegistryHelpIds.General.MODEL_URI);
        ModelRegistryHelper.setHelp((Control)this.modelURIText, ModelRegistryHelpIds.General.MODEL_URI);
    }

    protected void createSerializationControls(Composite parent) {
        Label serializationLabel = new Label(parent, 0);
        serializationLabel.setText(PreferencesMessages.ModelRegistryConfigurationBlock_serialization_column);
        this.serializationCombo = new Combo(parent, 2048);
        ModelSerializationRegistry modelSerializationRegistry = ModelRegistryEnvironment.getInstance().getModelSerializationRegistry();
        Collection serializationsList = modelSerializationRegistry.getSerializations();
        Object[] serializationsArray = serializationsList.toArray(new String[serializationsList.size()]);
        Arrays.sort(serializationsArray);
        this.serializationCombo.setItems((String[])serializationsArray);
        this.serializationCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.serializationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegistrationDialog.this.doValidation();
            }
        });
        ModelRegistryHelper.setHelp((Control)serializationLabel, ModelRegistryHelpIds.General.SERIALIZATION);
        ModelRegistryHelper.setHelp((Control)this.serializationCombo, ModelRegistryHelpIds.General.SERIALIZATION);
    }

    protected void doValidation() {
        Control contents;
        MultiStatus status = new MultiStatus("org.eclipse.qvt.declarative.modelregistry.ui", 0, "no message", null){

            public String getMessage() {
                IStatus[] statuses = this.getChildren();
                if (statuses.length <= 0) {
                    return super.getMessage();
                }
                if (statuses.length == 1) {
                    return statuses[0].getMessage();
                }
                StringBuffer s = new StringBuffer(statuses[0].getMessage());
                int i = 1;
                while (i < statuses.length) {
                    s.append("\n");
                    s.append(statuses[i].getMessage());
                    ++i;
                }
                return s.toString();
            }
        };
        this.accessorName = this.accessorNameText.getText();
        if (this.accessorName == null || this.accessorName.length() == 0) {
            status.add((IStatus)new StatusInfo(4, PreferencesMessages.RegistrationDialog_error_enterName));
        } else if (Character.isWhitespace(this.accessorName.charAt(0)) || Character.isWhitespace(this.accessorName.charAt(this.accessorName.length() - 1))) {
            status.add((IStatus)new StatusInfo(4, PreferencesMessages.RegistrationDialog_error_noSpace));
        } else {
            for (Registration<?> currentRegistration : this.currentRegistrationModel) {
                if (currentRegistration == null || currentRegistration.equals(this.registration) || !this.accessorName.equals(currentRegistration.getAccessorName()) || currentRegistration.getFileHandleRegistry().getDepth() != this.accessorRegistry.getFileHandleRegistry().getDepth()) continue;
                status.add((IStatus)new StatusInfo(2, PreferencesMessages.RegistrationDialog_error_entryExists));
            }
        }
        this.resourceURI = this.modelURIText.getText();
        if (this.resourceURI == null || this.resourceURI.length() == 0) {
            status.add((IStatus)new StatusInfo(4, PreferencesMessages.RegistrationDialog_error_enterURI));
        } else {
            try {
                URI ecoreURI = URI.createURI((String)this.resourceURI);
                File file = ModelRegistryEnvironment.getInstance().getFile(ecoreURI);
                if (file == null || !file.exists()) {
                    status.add((IStatus)new StatusInfo(2, PreferencesMessages.RegistrationDialog_error_resource_exists));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                status.add((IStatus)new StatusInfo(2, PreferencesMessages.RegistrationDialog_error_validURI));
            }
            catch (IOException iOException) {
                status.add((IStatus)new StatusInfo(2, PreferencesMessages.RegistrationDialog_error_resource_exists));
            }
        }
        this.serialization = this.serializationCombo.getText();
        ModelSerializationRegistry modelSerializationRegistry = ModelRegistryEnvironment.getInstance().getModelSerializationRegistry();
        if (modelSerializationRegistry.getSerialization(this.serialization) == null) {
            status.add((IStatus)new StatusInfo(2, PreferencesMessages.RegistrationDialog_warning_no_serialization));
        }
        this.updateStatus((IStatus)status);
        if (status.getChildren().length > 1 && (contents = this.getContents()) != null) {
            contents.pack(true);
            this.constrainShellSize();
        }
    }

    public Registration<?> getRegistration() {
        if (this.accessorName == null || this.resourceURI == null || this.serialization == null) {
            return null;
        }
        ModelSerializationRegistry modelSerializationRegistry = ModelRegistryEnvironment.getInstance().getModelSerializationRegistry();
        ModelSerialization modelSerialization = modelSerializationRegistry.getSerializationOrCreate(this.serialization);
        return this.accessorRegistry.createRegistration(this.accessorName, this.resourceURI, modelSerialization);
    }

    private void setResourceURI(URI ecoreURI) {
        ResourceSet resourceSet = this.accessorRegistry.getProjectRegistry().getResourceSet();
        URIConverter uriConverter = resourceSet.getURIConverter();
        try {
            InputStream inputStream = uriConverter.createInputStream(ecoreURI);
            inputStream.close();
        }
        catch (IOException e) {
            this.showError("Bad resource error", "Selected file '" + ecoreURI.toString() + "' does not exist", e);
            return;
        }
        this.modelURIText.setText(ecoreURI.toString());
        this.doValidation();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    private void showError(String title, String message, Exception e) {
        Status status = new Status(4, "org.eclipse.qvt.declarative.modelregistry.ui", message, (Throwable)e);
        ErrorDialog.openError((Shell)this.getShell(), (String)"Model Registry Error", (String)title, (IStatus)status);
    }
}

