/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.eclipse;

import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.qvt.declarative.modelregistry.eclipse.EclipseProjectHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractProjectHandle;

public class EclipseFileHandle
extends PlatformObject
implements AbstractFileHandle {
    protected final EclipseProjectHandle projectHandle;
    protected final IResource resource;

    protected EclipseFileHandle(IProject project) {
        this.projectHandle = (EclipseProjectHandle)this;
        this.resource = project;
    }

    public EclipseFileHandle(EclipseProjectHandle projectHandle, IResource resource) {
        this.projectHandle = projectHandle;
        this.resource = resource;
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public String getAbsoluteName() {
        if (this.resource == null) {
            return null;
        }
        IPath path = this.resource.getRawLocation();
        if (path == null) {
            path = this.resource.getFullPath();
        }
        return String.valueOf(path);
    }

    public InputStream getContents() throws CoreException {
        return ((IFile)this.resource).getContents();
    }

    public String getName() {
        return this.resource.getName();
    }

    public EclipseFileHandle getParentFileHandle() {
        IContainer parent = this.resource.getParent();
        return this.projectHandle.getFileHandle((IResource)parent);
    }

    public AbstractProjectHandle getProjectHandle() {
        return this.projectHandle;
    }

    public String getProjectRelativeName() {
        return this.getProjectRelativePath().toString();
    }

    public IPath getProjectRelativePath() {
        return this.resource.getProjectRelativePath();
    }

    public IResource getResource() {
        return this.resource;
    }

    public URI getURI() {
        return URI.createURI((String)this.resource.getLocationURI().toString());
    }

    public IFile isFile() {
        return this.resource instanceof IFile ? (IFile)this.resource : null;
    }

    public IFolder isFolder() {
        return this.resource instanceof IFolder ? (IFolder)this.resource : null;
    }

    public IProject isProject() {
        return this.resource instanceof IProject ? (IProject)this.resource : null;
    }

    public String toString() {
        return this.getAbsoluteName();
    }
}

