/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.ws;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.net4j.internal.ws.bundle.OM;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.ws.IWSAcceptor;
import org.eclipse.net4j.ws.IWSConnector;

public final class WSUtil {
    public static final String FACTORY_TYPE = "ws";

    private WSUtil() {
    }

    public static void prepareContainer(IManagedContainer container) {
        OM.BUNDLE.prepareContainer(container);
    }

    public static IWSAcceptor getAcceptor(IManagedContainer container, String acceptorName) {
        return (IWSAcceptor)container.getElement("org.eclipse.net4j.acceptors", FACTORY_TYPE, acceptorName);
    }

    public static IWSConnector getConnector(IManagedContainer container, String description) {
        return (IWSConnector)container.getElement("org.eclipse.net4j.connectors", FACTORY_TYPE, description);
    }

    public static IWSConnector getConnector(IManagedContainer container, URI serviceURI, String acceptorName, String ... arguments) {
        String description = WSUtil.getConnectorDescription(serviceURI, acceptorName, arguments);
        return WSUtil.getConnector(container, description);
    }

    public static String getConnectorDescription(String serviceURI, String acceptorName, String ... arguments) throws URISyntaxException {
        return WSUtil.getConnectorDescription(new URI(serviceURI), acceptorName, arguments);
    }

    public static String getConnectorDescription(URI serviceURI, String acceptorName, String ... arguments) {
        Object string = serviceURI.toString();
        if (!((String)string).endsWith("/")) {
            string = (String)string + "/";
            try {
                serviceURI = new URI((String)string);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
        URI uri = serviceURI.resolve("@" + acceptorName);
        StringBuilder description = new StringBuilder();
        description.append(uri.getAuthority()).append(uri.getPath());
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            description.append("\n").append(argument);
            ++n2;
        }
        return description.toString();
    }
}

